/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * Palette.hpp - the palette dialog which holds the past 16 colours used.
 *
 * Version history: 2/2/97  First Version
 *                  9/3/97  Turned into a resizable frame
 *
 */

#ifndef _palette_h
#define _palette_h

#include <JLib.h>
#include <JFrame.hpp>
#include <JVSet.hpp>
#include <JMouseH.hpp>
#include <JSaveDlg.hpp>
#include <JOpenDlg.hpp>

class JColour;
class JCmdEvent;

class Palette;
class Painting;

class PaletteHandler : public JCUAMouseHandler
{
   Palette *palette;

 public:
   PaletteHandler( Palette *p);

   BOOL contextMenu( const JMouseEvent &e);
};

class PVSet : public JValueset
{
   Painting *pic;

 public:
   PVSet( Palette *pal, Painting *p);

   BOOL selected( const JPoint &cel);
   BOOL opened( const JPoint &cel);
};

class Palette : public JFrame, public JSaveDlgClient, public JOpenDlgClient
{
   PVSet    vSet;
   Painting *pic;
   ulong    count, cels;
   JStr     fname;

   PaletteHandler h;
   JMenu          pmenu;

   JBuffer &fillPalette( JBuffer &b);
   void writePalette( char *fname);
   void readPalette( JBuffer *b);
   void readPalette( char *fname);

 public:
   Palette( Painting *p);
  ~Palette();

   // apis
   Palette &addColour( const JColour &c);
   Palette &request();

   // internals
   BOOL closing();
   BOOL command( const JCmdEvent &e);
   BOOL menu();

   // save|open dlg callbacks
   BOOL savingImminent( JVBuffer *b, const JStr &nm, ulong id);
   void savingComplete( JVBuffer *b, ulong id, BOOL cancelled);
   void openedFiles( JSequence<JOpenDlgFile> &list, ulong id);
   void openingError( ulong id);
};

#endif
