/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * ResID.h - defines for resource ids
 *
 * Version history: 26/1/97  First Version
 *
 */

#ifndef _paintresid_h
#define _paintresid_h

#define id_butt_ok     1
#define id_butt_cancel 2
#define id_butt_undo   3
#define id_butt_help   4

// miscellaneous bits; 10 - 99 ------------------------------------------------
#define id_acceltable            10

// dialogs with their controls; start at 100 ----------------------------------
#define dlg_colour_rgb                   100
#define id_slider_red                    101
#define id_slider_green                  102
#define id_slider_blue                   103
#define id_text_red                      104
#define id_text_green                    105
#define id_text_blue                     106
#define id_border_clr                    107
#define id_canvas_clr                    108

#define dlg_settings                     150
#define id_notebook                      151

#define dlg_pal_settings                 200
#define id_chk_disp                      201
#define id_chk_float                     202
#define id_chk_asave                     203
#define id_cbox_cmod                     204

// menus; start at 5000 -------------------------------------------------------
#define idm_toolbar            5000

#define idm_mainmenu           5100

#define idm_file               5110
#define idm_load               5111
#define idm_settings           5112
#define idm_quicksave          5113
#define idm_save               5114
#define idm_rename             5115
#define idm_quit               5116
#define idm_new                5117

#define idm_saveas             5120
#define idm_saveasbmp          5121
#define idm_saveasgif          5122
#define idm_saveasjpeg         5123

#define idm_edit               5150
#define idm_selectall          5151
#define idm_copy               5152
#define idm_cut                5153
#define idm_paste              5154
#define idm_invert             5155
#define idm_flipx              5156
#define idm_flipy              5157
#define idm_fade               5158
#define idm_newpattern         5159
#define idm_newmask            5160
#define idm_examine            5161
#define idm_savesel            5162
#define idm_saveselasbmp       5163
#define idm_saveselasgif       5164
#define idm_saveselasjpeg      5165

#define idm_picture            5170
#define idm_clear              5171
#define idm_zoom               5172
#define idm_toolbox            5173
#define idm_show_palette       5174
#define idm_grid               5175
#define idm_cancel             5176
#define idm_complete           5177

#define idm_pickcolour         5190   // Range for dynamic menu
#define idm_pick_rgb           5191   //
#define idm_pick_cmyk          5192   //
#define idm_pick_colourcube    5193   //
#define idm_pick_frompicture   5194

#define idm_pickcolour_max     5209   // ... up to 5209 max

#define idm_tools              5210
#define idm_line               5211
#define idm_polygon            5212
#define idm_arc                5213
#define idm_curve              5214
#define idm_sketch             5215
#define idm_brush              5216
#define idm_airbrush           5217
#define idm_text               5218
#define idm_select             5219

#define idm_rectangle          5230
#define idm_rect_w             5231
#define idm_rect_s             5232

#define idm_triangle           5250
#define idm_tri_w              5251
#define idm_tri_s              5252

#define idm_parall             5270
#define idm_parall_w           5271
#define idm_parall_s           5272

#define idm_oval               5290
#define idm_oval_w             5291
#define idm_oval_s             5292

#define idm_sector             5310
#define idm_sect_w             5311
#define idm_sect_s             5312

#define idm_fills              5330
#define idm_fill_solid         5331
#define idm_fill_linear        5332
#define idm_fill_radial        5333
#define idm_fill_pattern       5334

#define idm_masks              5350
#define idm_hidemask           5351
#define idm_showmask           5352
#define idm_removemask         5353
#define idm_showmasks          5354

#define idm_style              5370
#define idm_lwidth             5371

#define idm_ljoin              5390
#define idm_lj_square          5391
#define idm_lj_round           5392
#define idm_lj_bevelled        5393
#define idm_lj_mitred          5394

#define idm_lcap               5391
#define idm_lc_flat            5392
#define idm_lc_square          5393
#define idm_lc_round           5394

#define idm_ltype              5410
#define idm_lt_1               5411
#define idm_lt_2               5412
#define idm_lt_3               5413
#define idm_lt_4               5414
#define idm_lt_5               5415
#define idm_lt_6               5416

#define idm_fpattern           5430
#define idm_fp_solid           5431
#define idm_fp_1               5432
#define idm_fp_2               5433
#define idm_fp_3               5434
#define idm_fp_4               5435
#define idm_fp_5               5436
#define idm_fp_6               5437

#define idm_help               5450
#define idm_help_index         5451
#define idm_help_general       5452
#define idm_help_using         5453
#define idm_help_keys          5454
#define idm_prodinfo           5455

#define idm_palette            5470
#define idm_pal_save           5471
#define idm_pal_load           5472
#define idm_pal_default        5473
#define idm_pal_settings       5474
#define idm_pal_float          5475
#define idm_pal_clean          5476

#define idm_context            5490

// bitmaps; start above 10000 -------------------------------------------------
#define id_bmp_save           10001
#define id_bmp_zoom           10002
#define id_bmp_toolbox        10003
#define id_bmp_palette        10004
#define id_bmp_masks          10005
#define id_bmp_complete       10006
#define id_bmp_cancel         10007

// icons; start above 15000 ---------------------------------------------------

#define id_ico_paint          15001
#define id_ico_palette        15002

// stringtable ----------------------------------------------------------------

#endif
