/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * Settings.hpp - settings notebook for the application
 *
 * Version history:  8/2/97  First Version
 *
 */

#ifndef _settings_h
#define _settings_h

#include <JLib.h>
#include <JBuffer.hpp>
#include <JDialog.hpp>
#include <JNoteBk.hpp>
#include <JSelButt.hpp>
#include <JCBox.hpp>

// Dialogs on notebook pages --------------------------------------------------
// ABC to implement a protocol ------------------------------------------------
class Settings;
class SettingsData;

class SettingsDialog : public JDialog
{
 protected:
   Settings *settings;

 public:
   SettingsDialog( const JResID &rid, Settings *s, JNotebook *nb);
   virtual ~SettingsDialog();

   virtual SettingsDialog &initFromData( const SettingsData &s) = 0;
   virtual SettingsDialog &dumpToData( SettingsData &s) = 0;

   BOOL closing();
};

class PaletteSettings : public SettingsDialog
{
   JCheckBox    c1, c2, c3;
   JComboBox    cbox;

 public:
   PaletteSettings( Settings *s, JNotebook *b);

   PaletteSettings &initFromData( const SettingsData &s);
   PaletteSettings &dumpToData( SettingsData &s);

   BOOL command( const JCmdEvent &e);
};

// class for the application settings. Crops up all over the place ------------
struct SettingsData
{
   friend class SettingsData;

   ulong fOne;
   JStr  nmCModel;

 public:
   SettingsData();

   BOOL floatPalette() const;
   BOOL showPalette() const;
   BOOL autosavePalette() const;
   JStr colourModel() const;
   SettingsData &floatPalette( BOOL yn);
   SettingsData &showPalette( BOOL yn);
   SettingsData &autosavePalette( BOOL yn);
   SettingsData &colourModel( char *n);

   SettingsData &saveToProfile( JProfile *);
   SettingsData &loadFromProfile( JProfile *);

   SettingsData &operator = ( const SettingsData &op2);
};

// The Settings dialog window -------------------------------------------------
class SData;

class Settings : public JDialog
{
   JNotebook notebook;
   SData    *data;

   void         insert( ulong i, SettingsDialog *d, char *t, char *a);

   SettingsData backup;
   Settings    &commit();
   Settings    &updateFromData( const SettingsData &s);

 public:
   Settings();
  ~Settings();

   // open if closed, updating from 'good' settings that the mgr has
   Settings &invoke();
   // undo changes (by restoring the old copy)
   Settings &undo();

   // turn to specific pages in the notebook
   Settings &turnToPalettePage();

   BOOL closing();
   BOOL command( const JCmdEvent &e);
   BOOL handleEvents( JEventData *e);
};

#endif
