/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * Tools.hpp - abstract base classes for tool objects
 *
 * Version history: 26/1/97  First Version
 *
 */

#ifndef _tool_h
#define _tool_h

#include <JLib.h>

class JBPSpace;
class JPoint;

class ToolData;

class Tool
{
   ulong id;

 public:
   Tool( ulong id);
   virtual ~Tool();

   // d ought to be NULL. Allocate a data area for an instance and record
   // the presentation space.
   virtual Tool &start( ToolData *&d, JBPSpace *ps) = 0;
   // d will be the data area as allocated. Update the ps as appropriate.
   // Return true to force a window update (ie. if you change the picture)
   virtual BOOL buttonDown( ToolData *&d, const JPoint &p) = 0;
   virtual BOOL buttonUp( ToolData *&d, const JPoint &p) = 0;
   virtual BOOL buttonClick( ToolData *&d, const JPoint &p) = 0;
   virtual BOOL mouseMove( ToolData *&d, const JPoint &p) = 0;
   virtual BOOL complete( ToolData *&d) = 0;
   virtual BOOL cancel( ToolData *&d) = 0;
   // called to finish the instance. Destroy & nullify the d pointer.
   virtual BOOL finish( ToolData *&d) = 0;

   int operator == ( const Tool &op2) const;
   ulong ID() const;
};

struct ToolData
{
   JBPSpace *ps;

   ToolData( JBPSpace *ps);
   virtual ~ToolData();
};

#endif
