// sizing canvas test
// added tests for dlgbox frame extension
// Jlib, started 24/August/1996

#include "Test.hpp"
#include "Test.h"

#include "JPM.hpp"
#include "JColour.hpp"
#include "JExcept.hpp"

#include "JDlgbar.hpp"

#include "JGPrim.hpp"

#include "JResID.hpp"

int main()
{
   JException::debugEnabled = true;

   frame Frame;

   Frame.show().activate();

   JPM::current()->process();

   return 0;
}

frame::frame() : JFrame( "A sizing canvas!"), db( new xtnDialog( this))
{
   sizer = new JViewer( this, &sz , JPoint(), JPoint(), 0);
   setClient( sizer);
   addFrameExtension( &db);
   reshape( JPoint( 20, 40), JSize( 300, 200));
   setMaxClientSize( JSize( 600, 400));
   showInTasklist();
   sizer->scrollTo( JPoint( 100, 200));
}

frame::~frame()
{
   delete sizer;
}

// The canvas class which gets sized -----------
Sizee::Sizee() : JCanvas( &JWindow::theObjectWindow), linePt( 600, 400),
                 ps( this, JWindow::siblings)

{
   resize( JSize( 600, 400));
   attach( &mouseH);
   ps.setColour( JColour::white);
   ps.setMix( JGfx::fgMix::xor);
   setPS( &ps);
}

BOOL Sizee::paint( JPaintEvent &e)
{
   // fill background with white
   ps.fillRect( e.updateRect(), JColour::white);

   // draw a line
   drawLine();
   return true;
}

void Sizee::drawLine( )
{
   ps.render( JMove( 0, 0));
   ps.render( JLine( linePt));
}

// The mouseclick handler -----------
szMouseHandler::szMouseHandler() : JMouseHandler(), tracking( false)
{}

BOOL szMouseHandler::button1down( const JClickEvent &e)
{
   tracking = true;
   e.window()->capturePointer();
   return false;
}

BOOL szMouseHandler::button1up( const JClickEvent &e)
{
   tracking = false;
   e.window()->releasePointer();
   return false;
}

BOOL szMouseHandler::button2up( const JClickEvent &e)
{
   Sizee *wnd = (Sizee *) e.window();
   JViewer *viewer = (JViewer *) wnd->parent();
   frame *fr = (frame *) viewer->parent();

   JSize sz( fr->db.window()->size());
   sz.y *= 2;
   fr->db.window()->resize( sz);
   fr->updateFrameExtensions();

   return false;
}

BOOL szMouseHandler::mouseMove( const JMouseEvent &e)
{
   if( tracking) {
      Sizee *wnd = (Sizee *) e.window();
      JViewer *viewer = (JViewer *) wnd->parent();

      if( viewer->view().contains( e.pos())) {
         wnd->drawLine();    // erase the current line
         wnd->linePt = e.pos();  // update the end point
         wnd->drawLine();    // draw the new line
      }
   }
   return false;
}

// The frame extension dialog ------------
xtnDialog::xtnDialog( JWindow *w) : JDialog( w, dlg_extn, w),
                                    spin( this, id_spin),
                                    checkbox( this, id_chkbox)
{}

BOOL xtnDialog::closing()
{ return false; }
