// Spline investigator program
// Also test JLib graphics drawing and correlating functions
//  MJF Christmas 1996

#include <JLib.h>
#include <JDC.hpp>

// handler to manage mouseclicks ----------------------------------------------
#include <JMouseH.hpp>

class splineCanvas;

class splineHandler : public JMouseHandler
{
   splineCanvas *cvs;
 public:
   splineHandler( splineCanvas *canvas);

   BOOL button2down( const JClickEvent &e);
   BOOL button2up( const JClickEvent &e);
   BOOL mouseMove( const JMouseEvent &e);
};


// canvas which has the doodles in --------------------------------------------
#include <JCanvas.hpp>
#include <JCoord.hpp>
#include <JPSpace.hpp>
#include <JBitmap.hpp>
#include <JEvSem.hpp>
#include <JThread.hpp>

class splineDlg;

class splineCanvas : public JCanvas
{
   splineHandler handler;
   JPoint        pts[ 4];
   long          tracking;

   JMemoryDC     dc;
   JPSpace       memPS;
   JBitmap       bmp;

   BOOL          quit;
   JEventSem     sem, semTwo;
   JMemberThread<splineCanvas> thread;

   ulong         drawingThread();

 public:
   splineCanvas( splineDlg *dlg);
  ~splineCanvas();

   void buttonDown( const JPoint &p);
   void buttonUp( const JPoint &p);
   void mouseMove( const JPoint &p);

   BOOL paint( JPaintEvent &e);
};

// Class to be the dialog -----------------------------------------------------
#include <JDialog.hpp>

class splineDlg : public JDialog
{
   splineCanvas canvas;
 public:
   splineDlg();
   BOOL closing();
};
