// Test the split control & the graphic button
//
// MJF 9th June 1998

#include <Jlib.h>
#include <JPM.hpp>
#include <JFrame.hpp>
#include <JSplit.hpp>
#include <JPushBut.hpp>
#include <JExcept.hpp>
#include <JSystem.hpp>
#include <JCanvas.hpp>
#include <JColour.hpp>

#define button_one 1

class FlatCanvas : public JCanvas
{
 public:
   FlatCanvas( JFrame *f) : JCanvas( f) {}

   BOOL paint( JPaintEvent &e)
   {
      e.ps().fillRect( e.updateRect(), JColour::yellow);
      return true;
   }
};

class SplitFrame : public JFrame
{
   JSplitWindow split;
   JPushButton  pbut;
   FlatCanvas   cvs;

 public:
   SplitFrame() : JFrame( "A split frame"),
                  split( this, JPoint(), JSize(), 42),
                  pbut( &split, JPoint(), JSize(), button_one),
                  cvs( this)
   {
      pbut.setText( "Push");
      pbut.setOwner( this);
      cvs.setOwner( this);

      setClient( &split);
      split.setLeftWindow( &pbut);
      split.setRightWindow( &cvs);

      showInTasklist();
   }

   BOOL command( const JCmdEvent &ev)
   {
      BOOL rc = false;
      JSystem::beep( 40, 40);
      return rc;
   }
};

int main()
{
   JException::debugEnabled = true;

   SplitFrame frame;

   frame.show().activate();

   JPM::current()->process();

   return 0;
}
