# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is MessageBoard version 1.0.
#
# The Initial Owner of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Cornel Nitu, Rares Vernica Finsiel Romania
#

from AccessControl import ClassSecurityInfo
from OFS import SimpleItem, ObjectManager, PropertyManager
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Utils import setFormError, isEmailValid, CreateEmail
from Acquisition import Implicit
import Globals
from OFS import Folder
import Products
from time import time
from DateTime import DateTime

manage_addMessageForm=Globals.DTMLFile('dtml/Message_addForm', globals())
def manage_addMessage(self, title='', text='', attachment='', author='', email='', notify=0, date='', REQUEST=None, RESPONSE=None):
    """Add a new Message object"""

    id = str(int(time()))
    if not title:
        return getattr(self,REQUEST['form_name'])(setFormError(REQUEST, 'title', 'Please enter a subject!'))
    if not text:
        return getattr(self,REQUEST['form_name'])(setFormError(REQUEST, 'text', 'Please enter the message!'))
    if not author:
        return getattr(self,REQUEST['form_name'])(setFormError(REQUEST, 'author', 'Please enter your name!'))
    if not email:
        return getattr(self,REQUEST['form_name'])(setFormError(REQUEST, 'email', 'Please enter your email address!'))
    if email and not isEmailValid(email):
        return getattr(self,REQUEST['form_name'])(setFormError(REQUEST, 'email', 'Your email address is invalid!'))

    if attachment.filename and len(attachment.read(self.filesize + 1)) > self.filesize:
        return getattr(self,REQUEST['form_name'])(setFormError(REQUEST, 'file', 'Your file is too big!'))

    ob=Message(id, title, text, author, email, notify, date)
    ob.id = id

    self._setObject(id, ob)

    if attachment.filename:
        ob.manage_addFile(id='', file=attachment, title='')

    obj = self._getOb(id)
    old=self.aq_parent
    if hasattr(old,'notify') and old.notify:
        for attach in obj.objectValues('File'):
            email_text  = obj.text + '\n\rDownload attachment: ' + str(attach.absolute_url(0))
        self.SendEmail(email_text, old.author+' <'+old.email+'>', author+' <'+email+'>', 'Reply to your message "'+old.title+'" ("'+title+'")')

    if REQUEST.has_key('destinationURL'):
        return RESPONSE.redirect(REQUEST['destinationURL'])

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)


addMessageForm = Globals.DTMLFile('dtml/MessageBoard_add_message', globals())
def addMessage(self, title='', text='', attachment='', author='', email='', notify=0, REQUEST=None):
    """add message (Front)"""
    id = str(int(time()))
    if not title:
        return getattr(self, 'addMessageForm')(setFormError(REQUEST, 'title', 'Please enter a subject!'))
    if not text:
        return getattr(self, 'addMessageForm')(setFormError(REQUEST, 'text', 'Please enter the message!'))
    if not author:
        return getattr(self, 'addMessageForm')(setFormError(REQUEST, 'author', 'Please enter your name!'))
    if not email:
        return getattr(self, 'addMessageForm')(setFormError(REQUEST, 'email', 'Please enter your email address!'))
    if email and not isEmailValid(email):
        return getattr(self, 'addMessageForm')(setFormError(REQUEST, 'email', 'Your email address is invalid!'))

    if attachment.filename and len(attachment.read(self.filesize + 1)) > self.filesize:
        return getattr(self, 'addMessageForm')(setFormError(REQUEST, 'file', 'Your file is too big!'))

    ob=Message(id, title, text, author, email, notify, DateTime())
    ob.id = id
    self._setObject(id, ob)

    if attachment.filename:
        ob.manage_addFile(id='', file=attachment, title='')

    old=self.aq_parent
    if hasattr(old,'notify') and old.notify:
        self.SendEmail(text, old.author+' <'+old.email+'>', author+' <'+email+'>', 'Reply to your message "'+old.title+'" ("'+title+'")')
    if REQUEST is not None:
        REQUEST.RESPONSE.redirect(self.getMPAbsolutePath() + '/index_html')


class Message(CatalogAware,Implicit,Folder.Folder,PropertyManager.PropertyManager):
    """The Message class """

    meta_type       = "Message"
    product_name    = "MessageBoard"

    _properties=(
            {'id':'title',          'type':'string',        'mode':'w'},
            {'id':'text',           'type':'text',          'mode':'w'},
            {'id':'author',         'type':'string',        'mode':'w'},
            {'id':'email',          'type':'string',        'mode':'w'},
            {'id':'notify',         'type':'boolean',       'mode':'w'},
            {'id':'date',           'type':'date',          'mode':'w'},
    )

    security = ClassSecurityInfo()
    
    manage_options = (ObjectManager.ObjectManager.manage_options[0],) + (
            PropertyManager.PropertyManager.manage_options + (
                    {'label' : 'View',              'action' : 'index_html'},
                    {'label' : 'Reply',             'action' : 'reply_Message'},))

    # Create a SecurityInfo for this class. We will use this 
    # in the rest of our class definition to make security 
    # assertions.
    security = ClassSecurityInfo()
    
    security.setPermissionDefault('Send direct email', ('Anonymous',))
    
    #security.setPermissionDefault('Add Message', ('Anonymous',)) # !!! nu functioneaza !!!

    def __str__(self): return self.index_html()
    def __len__(self): return 1

    security.declarePublic('index_html')
    index_html    = Globals.DTMLFile("dtml/viewMessage", globals())

    security.declareProtected('Add Message', 'reply_Message')
    reply_Message = Globals.DTMLFile("dtml/replyMessage", globals())

    security.declareProtected('Add Message','manage_addMessageForm')
    manage_addMessageForm = manage_addMessageForm

    security.declarePublic('emailMessageCopy')
    emailMessageCopy = Globals.DTMLFile("dtml/emailMessageCopy", globals())

    security.declareProtected('Send direct email','emailMessageAuthor')
    emailMessageAuthor = Globals.DTMLFile("dtml/emailMessageAuthor", globals())

    security.declareProtected('View management screens', 'all_meta_types')
    def all_meta_types(self):
        """return a filtered list of meta types"""

        f = lambda x: x['name'] in ('File','Image', 'Message')
        return filter(f, Products.meta_types)

    def __init__(self, id, title, text, author, email, notify, date):
        """ initialize a new instance of Message"""
        self.id = id
        self.title =title
        self.text = text
        self.author = author
        self.email = email
        self.notify = notify
        self.date = date

    security.declarePublic('sendEmailMessageCopy')
    def sendEmailMessageCopy(self, email='', REQUEST=None):
        """Send a copy of current message to a given email address"""
        if not email:
            return getattr(self, 'emailMessageCopy')(setFormError(REQUEST, 'email', 'Please enter user\'s email address!'))
        if email and not isEmailValid(email):
            return getattr(self, 'emailMessageCopy')(setFormError(REQUEST, 'email', 'User\'s email address is invalid!'))
        for attach in self.objectValues('File'):
            email_text  = self.text + '\n\rDownload attachment: ' + str(attach.absolute_url(0))
        self.SendEmail(email_text, self.author + ' <' + email + '>', self.author + ' <' + self.email + '>', 'Copy of message "' + self.title + '"')
        REQUEST.RESPONSE.redirect(self.getMPAbsolutePath() + '/index_html')

    security.declarePublic('sendEmailMessageAuthor')
    def sendEmailMessageAuthor(self, email='', content='', REQUEST=None):
        """Send an email to current message's author"""
        if not email:
            return getattr(self, 'emailMessageAuthor')(setFormError(REQUEST, 'email', 'Please enter an email address!'))
        if email and not isEmailValid(email):
            return getattr(self, 'emailMessageAuthor')(setFormError(REQUEST, 'email', 'Please enter a valid email address!'))
        if not content:
            return getattr(self, 'emailMessageAuthor')(setFormError(REQUEST, 'content', 'Please enter some comments!'))
        self.SendEmail(content, self.author + ' <' + self.email + '>', '<' + email + '>', 'Comments for message "' + self.title + '"')
        REQUEST.RESPONSE.redirect(self.getMPAbsolutePath() + '/index_html')

    security.declarePublic('SendEmail')
    def SendEmail(self, eContent, eTo, eFrom, eSubject):
        """Sends an email (works with 'notify')"""
        import smtplib
        message = CreateEmail(eContent, eTo, eFrom, eSubject)
        mailhost=self.unrestrictedTraverse(self.superValues('Message Board')[0].mailhost)
        #print mailhost.id
        host=mailhost.smtp_host
        port=int(mailhost.smtp_port)
        server = smtplib.SMTP(host, port)
        server.sendmail(eFrom, eTo, message)
        server.quit()
        return 1

Globals.InitializeClass(Message)
