/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CDocument {
    private JTable table;
    private JTextArea textarea;
    private JTree tree;
    private DefaultTreeModel treemodel;
    private DefaultMutableTreeNode top;
    private CElement currentelement;
    private DefaultMutableTreeNode currentnode;
    private final TableModel cleartable = new DefaultTableModel();
    private final Frame hidenframe = new Frame();
    private JOptionPane elnamepanel;
    private JDialog elnamedialog;
    private File file;

    public CDocument() {
        this(null, null);
    }

    public CDocument(File file, Object[] objectArray) {
        this.file = file;
        this.createTree(this.toString());
        if (objectArray == null) {
            this.currentelement = new CElement("Body");
        }
        this.table = new CJTable(this.currentelement);
        this.table.setModel(this.cleartable);
        this.textarea = new CJTextArea();
        if (objectArray == null) {
            this.addElement(this.currentelement);
        }
        if (objectArray != null) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.currentelement = (CElement)objectArray[n2];
                this.addElement(this.currentelement);
                ++n2;
            }
        }
        this.tree.expandRow(0);
        this.tree.revalidate();
        ((CJTable)this.table).getCComboEditor().setChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CDocument.this.updateTextArea(CDocument.this.currentelement.toText());
            }
        });
    }

    public CDocument(Object[] objectArray) {
        this(null, objectArray);
    }

    static /* synthetic */ DefaultMutableTreeNode access$2(CDocument cDocument) {
        return cDocument.currentnode;
    }

    public void addElement(CElement cElement) {
        Enumeration<TreeNode> enumeration = this.top.children();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = ((CElement)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject()).toString();
            if (cElement.toString().compareToIgnoreCase(string) != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.treemodel.insertNodeInto(new DefaultMutableTreeNode(cElement), this.top, this.treemodel.getChildCount(this.top));
        }
    }

    String askElValue(Frame frame) {
        AddDialog addDialog = new AddDialog(frame);
        String string = addDialog.ask();
        return string;
    }

    void createTree(String string) {
        this.top = new DefaultMutableTreeNode(this.toString());
        this.treemodel = new DefaultTreeModel(this.top);
        this.tree = new JTree(this.treemodel);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CDocument.this.tree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null) {
                    CDocument.this.currentnode = defaultMutableTreeNode;
                    CDocument.this.treeSelectionChanged();
                }
            }
        });
        this.treemodel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                CDocument.this.treeSelectionChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                CDocument.this.treeSelectionChanged();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        this.tree.setCellRenderer(new CTreeRenderer());
        this.tree.setCellEditor(new CTreeEditor(this.tree, (DefaultTreeCellRenderer)this.tree.getCellRenderer()));
        this.tree.setEditable(true);
        this.setupPopupMenu();
    }

    public boolean delElement(String string) {
        Enumeration<TreeNode> enumeration = this.top.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            String string2 = ((CElement)defaultMutableTreeNode.getUserObject()).toString();
            if (string.compareToIgnoreCase(string2) != 0) continue;
            this.deleteNode(defaultMutableTreeNode);
            return true;
        }
        return false;
    }

    public int delSelectedElements() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        int n = -1;
        if (treePathArray == null) {
            return 0;
        }
        n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.deleteNode((MutableTreeNode)treePathArray[n2].getLastPathComponent());
            ++n2;
        }
        if (this.tree.getRowCount() > 1) {
            this.tree.setSelectionRow(1);
        } else {
            this.tree.setSelectionRow(0);
        }
        return n;
    }

    void deleteNode(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode.isLeaf() && mutableTreeNode != this.top) {
            this.treemodel.removeNodeFromParent(mutableTreeNode);
        }
    }

    protected void finalize() {
    }

    public File getAssocFile() {
        return this.file;
    }

    public JTable getTable() {
        return this.table;
    }

    public JTextArea getTextArea() {
        return this.textarea;
    }

    public JTree getTree() {
        this.tree.setBorder(null);
        return this.tree;
    }

    public void renameSelectedElement() {
        this.tree.startEditingAtPath(this.tree.getSelectionPath());
    }

    public void setAssocFile(File file) {
        this.file = file;
        this.top.setUserObject(file.getName());
    }

    private void setupPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CDocument.this.renameSelectedElement();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CDocument.this.delSelectedElements();
            }
        });
        jPopupMenu.add(jMenuItem);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem("Add Element");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CDocument.this.askElValue(CDocument.this.hidenframe);
                if (string != null && string.length() > 0) {
                    CDocument.this.addElement(new CElement(string));
                }
            }
        });
        jPopupMenu2.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Select all");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CDocument.this.tree.getRowCount();
                CDocument.this.tree.setSelectionInterval(0, n);
            }
        });
        jPopupMenu2.add(jMenuItem2);
        this.tree.addMouseListener(new TreePopupListener(jPopupMenu, jPopupMenu2, this.tree));
    }

    public String toString() {
        try {
            return this.file.getName();
        }
        catch (NullPointerException nullPointerException) {
            return "Untitled";
        }
    }

    public String toText() {
        Enumeration<TreeNode> enumeration = this.top.children();
        String string = "";
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            string = String.valueOf(string) + ((CElement)defaultMutableTreeNode.getUserObject()).toText();
            string = String.valueOf(string) + "\r\n";
        }
        return string;
    }

    void treeSelectionChanged() {
        if (this.currentnode != this.top) {
            CElement cElement = this.currentelement;
            if (this.currentnode != null) {
                cElement = (CElement)this.currentnode.getUserObject();
            }
            this.table.setModel(cElement);
            this.table.sizeColumnsToFit(-1);
            this.currentelement = cElement;
            this.updateTextArea(this.currentelement.toText());
        } else {
            this.table.setModel(this.cleartable);
            this.updateTextArea(this.toText());
        }
    }

    public void updateTextArea(String string) {
        this.textarea.setText(string);
        this.textarea.setCaretPosition(0);
    }
}

