/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CfgReader
extends HashMap {
    File fn;

    public CfgReader(String string) {
        this.fn = new File(string);
        if (!this.fn.exists()) {
            try {
                this.fn.getParentFile().mkdirs();
                this.fn.createNewFile();
            }
            catch (SecurityException securityException) {
                System.out.println("Can't create configuration file: " + securityException.toString());
            }
            catch (IOException iOException) {
                System.out.println("Can't create configuration file: " + iOException.toString());
            }
        }
        this.run();
    }

    public String commentOff(String string) {
        int n = string.lastIndexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.length() > 0) {
            return string;
        }
        return null;
    }

    public String data() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(objectArray[n]);
            stringBuffer.append("=");
            if (this.get(objectArray[n]) != null) {
                stringBuffer.append(this.get(objectArray[n]));
            } else {
                stringBuffer.append("");
            }
            stringBuffer.append("\r\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String[] getRule(String string) {
        String[] stringArray = new String[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.hasMoreTokens()) {
            stringArray[0] = stringTokenizer.nextToken().trim().toUpperCase();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringArray[1] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        CfgReader cfgReader = new CfgReader(stringArray[0]);
    }

    public void run() {
        try {
            int n;
            FileReader fileReader = new FileReader(this.fn);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[512];
            while ((n = fileReader.read(cArray)) != -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
            ((Reader)fileReader).close();
            StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                String string = this.commentOff(stringTokenizer.nextToken());
                if (string == null) continue;
                String[] stringArray = this.getRule(string);
                this.put(stringArray[0], stringArray[1]);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println();
            System.err.println(fileNotFoundException.toString());
            System.err.println("Configuration file will be created on exit.");
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }

    public void write() {
        try {
            FileWriter fileWriter = new FileWriter(this.fn);
            String string = this.data();
            ((Writer)fileWriter).write(string, 0, string.length());
            ((Writer)fileWriter).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }
}

