/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DialogTextIn
extends JTextField {
    public DialogTextIn() {
        super(32);
        this.setDoubleBuffered(true);
        DialogTextIn.ctrlKeysForText(this);
        DialogTextIn.popupForText(this);
    }

    public static void ctrlKeysForText(final JTextComponent jTextComponent) {
        jTextComponent.addKeyListener(new KeyAdapter(){

            private void ins() {
                if (jTextComponent.isEditable()) {
                    jTextComponent.paste();
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isShiftDown()) {
                    switch (keyEvent.getKeyCode()) {
                        case 155: {
                            this.ins();
                        }
                    }
                }
            }
        });
    }

    protected void finalize() {
    }

    public static void popupForText(final JTextComponent jTextComponent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.copy();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Paste");
        if (jTextComponent.isEditable()) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jTextComponent.paste();
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Cut");
        if (jTextComponent.isEditable()) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jTextComponent.cut();
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Select all");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.requestFocus();
                jTextComponent.selectAll();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Copy all");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.requestFocus();
                jTextComponent.selectAll();
                jTextComponent.copy();
                jTextComponent.select(0, 0);
            }
        });
        jPopupMenu.add(jMenuItem);
        jTextComponent.addMouseListener(new PopupListener(jPopupMenu));
    }
}

