/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class Manager
extends JPanel {
    private static ResourceBundle resources;
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    private Hashtable commands = new Hashtable();
    private Hashtable menuitems = new Hashtable();
    private Hashtable toolitems = new Hashtable();
    private JToolBar toolbar;
    private JMenuBar menubar;
    private JSplitPane splitpane;
    private JSplitPane intsplitpane;
    private JDialog aboutdialog;
    private JOptionPane aboutpane;
    private CDocument document;
    protected FileDialog fileDialog;
    private Settings settings;
    JustStyle js;
    JFrame frame;

    static {
        try {
            resources = ResourceBundle.getBundle("resources.Manager", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("resources/Manager.properties not found");
            System.exit(1);
        }
    }

    public Manager(JustStyle justStyle) {
        this.js = justStyle;
        this.settings = new Settings();
        this.setLayout(new BorderLayout());
        this.setupAction();
        this.setupMenu();
        this.add((Component)this.getToolBar(), "North");
        this.setDoubleBuffered(true);
        this.setupDocument();
    }

    public String RegistredTo() {
        if (this.check(this.getSettings().getString("REGC", ""))) {
            return "         " + this.getSettings().getString("REGN", "");
        }
        return "UNREGISTERED";
    }

    public String Serial() {
        if (this.check(this.getSettings().getString("REGC", ""))) {
            return "         " + this.getSettings().getString("REGC", "") + " (1 license)";
        }
        return "";
    }

    static /* synthetic */ JOptionPane access$2(Manager manager) {
        return manager.aboutpane;
    }

    private boolean check(String string) {
        List<Object> list = Arrays.asList(CHeap.o);
        HashFunc hashFunc = new HashFunc(string);
        return list.contains(hashFunc.asHex());
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public Action[] createActions() {
        Action[] actionArray = new Action[]{new OpenAction(), new AddAction(), new ExitAction(), new AboutAction(), new DelAction(), new NewDocAction(), new GcAction(), new RenAction(), new SaveAction(), new SaveasAction(), new RegAction(), new HelpAction(), new NIAction()};
        return actionArray;
    }

    public CDocument createDocument() {
        return new CDocument();
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize(this.getResourceString(string));
        JMenu jMenu = new JMenu(this.getResourceString(String.valueOf(string) + labelSuffix));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = this.createMenuItem(stringArray[n]);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        return jMenu;
    }

    protected JMenuItem createMenuItem(String string) {
        String string2;
        JMenuItem jMenuItem = new JMenuItem(this.getResourceString(String.valueOf(string) + labelSuffix));
        URL uRL = this.getResource(String.valueOf(string) + imageSuffix);
        if (uRL != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(new ImageIcon(uRL));
        }
        if ((string2 = this.getResourceString(String.valueOf(string) + actionSuffix)) == null) {
            string2 = string;
        }
        jMenuItem.setActionCommand(string2);
        Action action = this.getAction(string2);
        if (action != null) {
            jMenuItem.addActionListener(action);
            action.addPropertyChangeListener(this.createActionChangeListener(jMenuItem));
            jMenuItem.setEnabled(action.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        this.menuitems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = this.tokenize(this.getResourceString("menubar"));
        int n = 0;
        while (n < stringArray.length) {
            JMenu jMenu = this.createMenu(stringArray[n]);
            if (jMenu != null) {
                jMenuBar.add(jMenu);
            }
            ++n;
        }
        return jMenuBar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = this.tokenize(this.getResourceString("toolbar"));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
            } else {
                this.toolbar.add(this.createTool(stringArray[n]));
            }
            ++n;
        }
        this.toolbar.add(Box.createHorizontalStrut(5));
        return this.toolbar;
    }

    protected JButton createToolbarButton(String string) {
        Action action;
        URL uRL = this.getResource(String.valueOf(string) + imageSuffix);
        JButton jButton = new JButton(new ImageIcon(uRL)){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        String string2 = this.getResourceString(String.valueOf(string) + actionSuffix);
        if (string2 == null) {
            string2 = string;
        }
        if ((action = this.getAction(string2)) != null) {
            jButton.setActionCommand(string2);
            jButton.addActionListener(action);
        } else {
            jButton.setEnabled(false);
        }
        String string3 = this.getResourceString(String.valueOf(string) + tipSuffix);
        if (string3 != null) {
            jButton.setToolTipText(string3);
        }
        this.toolitems.put(string2, jButton);
        return jButton;
    }

    protected void documentChanged() {
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.document.getTree()), new JScrollPane(this.document.getTable()));
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, new JScrollPane(this.document.getTextArea()));
        jSplitPane.setDividerLocation(this.getSettings().getInt("D2", 250));
        jSplitPane.setDividerSize(3);
        jSplitPane.setBorder(null);
        jSplitPane2.setDividerLocation(this.getSettings().getInt("D1", 150));
        jSplitPane2.setDividerSize(3);
        jSplitPane2.setBorder(null);
        if (this.splitpane != null) {
            this.remove(this.splitpane);
        }
        this.splitpane = jSplitPane2;
        this.intsplitpane = jSplitPane;
        this.add((Component)this.splitpane, "Center");
        this.revalidate();
    }

    void exit(int n) {
        this.settings.put("WIDTH", String.valueOf((int)this.getFrame().getSize().getWidth()));
        this.settings.put("HEIGHT", String.valueOf((int)this.getFrame().getSize().getHeight()));
        this.settings.put("X", String.valueOf((int)this.getFrame().getLocationOnScreen().getX()));
        this.settings.put("Y", String.valueOf((int)this.getFrame().getLocationOnScreen().getY()));
        this.settings.put("D1", String.valueOf(this.splitpane.getDividerLocation()));
        this.settings.put("D2", String.valueOf(this.intsplitpane.getDividerLocation()));
        this.settings.write();
        this.frame.dispose();
        this.js.managerRemoved();
    }

    public ResourceBundle gerResources() {
        return resources;
    }

    protected Action getAction(String string) {
        if (this.commands.get(string) != null) {
            return (Action)this.commands.get(string);
        }
        return null;
    }

    public CDocument getDocument() {
        return this.document;
    }

    protected Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    protected URL getResource(String string) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            URL uRL = this.getClass().getResource(string2);
            return uRL;
        }
        return null;
    }

    protected String getResourceString(String string) {
        String string2;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = null;
        }
        return string2;
    }

    public Settings getSettings() {
        return this.settings;
    }

    JToolBar getToolBar() {
        return (JToolBar)this.createToolbar();
    }

    private void oh() {
        JOptionPane.showMessageDialog(null, "Program is UNREGISTERED!\nPlease read 'How to Register' section in the 'Help -> Help Topics'.", "Reminder", 2);
    }

    public Component parentComponent() {
        return this;
    }

    public JFrame podporka() {
        JFrame jFrame = new JFrame(this.gerResources().getString("Title"));
        int n = this.getSettings().getInt("WIDTH", 680);
        int n2 = this.getSettings().getInt("HEIGHT", 460);
        ((Component)jFrame).setSize(n, n2);
        Point point = ComponentTools.setPos(jFrame);
        ((Component)jFrame).setLocation(this.getSettings().getInt("X", point.x), this.getSettings().getInt("Y", point.y));
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Manager.this.exit(0);
            }
        });
        jFrame.setJMenuBar(this.getMenuBar());
        jFrame.setContentPane(this);
        jFrame.getInputContext().selectInputMethod(Locale.US);
        this.frame = jFrame;
        this.updateTitle();
        return jFrame;
    }

    public void setDocument(CDocument cDocument) {
        this.document = cDocument;
        this.document.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Manager.this.document.getTree().getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null) {
                    if (!defaultMutableTreeNode.isRoot()) {
                        Manager.this.toolStateChanged("del", true);
                        Manager.this.toolStateChanged("ren", true);
                    } else {
                        Manager.this.toolStateChanged("del", false);
                        Manager.this.toolStateChanged("ren", false);
                    }
                } else {
                    Manager.this.toolStateChanged("del", false);
                    Manager.this.toolStateChanged("ren", false);
                }
            }
        });
        if (this.document.getTree().getRowCount() > 1) {
            this.document.getTree().setSelectionRow(1);
            this.toolStateChanged("del", true);
            this.toolStateChanged("ren", true);
        } else {
            this.document.getTree().setSelectionRow(0);
            this.toolStateChanged("del", false);
            this.toolStateChanged("ren", false);
        }
        this.updateTitle();
        this.documentChanged();
    }

    protected void setupAction() {
        Action[] actionArray = this.createActions();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            this.commands.put(action.getValue("Name"), action);
            ++n;
        }
    }

    protected void setupDocument() {
        this.setDocument(this.createDocument());
    }

    protected void setupMenu() {
        this.menubar = this.createMenubar();
    }

    public void sheckReg() {
        if (!this.check(this.getSettings().getString("REGC", ""))) {
            this.oh();
        }
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public void toolStateChanged(String string, boolean bl) {
        JButton jButton = (JButton)this.toolitems.get(string);
        if (jButton != null) {
            jButton.setEnabled(bl);
        }
    }

    public void updateTitle() {
        if (this.frame != null) {
            this.frame.setTitle(String.valueOf(this.gerResources().getString("Title")) + " - " + this.getDocument().toString());
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("open");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Manager.this.fileDialog == null) {
                Manager.this.fileDialog = new FileDialog(Manager.this.getFrame());
            }
            Manager.this.fileDialog.setMode(0);
            Manager.this.fileDialog.show();
            String string = Manager.this.fileDialog.getFile();
            String string2 = Manager.this.fileDialog.getDirectory();
            if (string == null) {
                return;
            }
            FileLoader fileLoader = new FileLoader(new File(string2, string));
            fileLoader.run();
            if (fileLoader.getDoc() != null) {
                Manager.this.setDocument(fileLoader.getDoc());
            }
            Manager.this.updateTitle();
        }
    }

    class SaveasAction
    extends AbstractAction {
        SaveasAction() {
            super("saveas");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Manager.this.fileDialog == null) {
                Manager.this.fileDialog = new FileDialog(Manager.this.getFrame());
            }
            Manager.this.fileDialog.setMode(1);
            Manager.this.fileDialog.show();
            String string = Manager.this.fileDialog.getFile();
            String string2 = Manager.this.fileDialog.getDirectory();
            if (string == null) {
                return;
            }
            FileSaver fileSaver = new FileSaver(new File(string2, string), Manager.this.getDocument().toText());
            fileSaver.run();
            Manager.this.getDocument().setAssocFile(new File(string2, string));
            Manager.this.updateTitle();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("save");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            String string2 = null;
            File file = Manager.this.getDocument().getAssocFile();
            if (file != null) {
                string = file.getName();
                string2 = file.getParent();
            }
            if (string == null) {
                SaveasAction saveasAction = new SaveasAction();
                saveasAction.actionPerformed(actionEvent);
            } else {
                FileSaver fileSaver = new FileSaver(file, Manager.this.getDocument().toText());
                fileSaver.run();
            }
            Manager.this.updateTitle();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.exit(0);
        }
    }

    class NIAction
    extends AbstractAction {
        NIAction() {
            super("ni");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.js.newManager();
        }
    }

    class GcAction
    extends AbstractAction {
        GcAction() {
            super("gc");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
        }
    }

    class NewDocAction
    extends AbstractAction {
        NewDocAction() {
            super("new");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.setDocument(Manager.this.createDocument());
        }
    }

    class AddAction
    extends AbstractAction {
        AddAction() {
            super("add");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Manager.this.document.askElValue(Manager.this.getFrame());
            if (string != null && string.length() > 0) {
                Manager.this.document.addElement(new CElement(string));
            }
        }
    }

    class RenAction
    extends AbstractAction {
        RenAction() {
            super("ren");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.document.renameSelectedElement();
        }
    }

    class DelAction
    extends AbstractAction {
        DelAction() {
            super("del");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Manager.this.document.delSelectedElements();
        }
    }

    class AboutAction
    extends AbstractAction {
        AboutAction() {
            super("about");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = new String("\nJustStyle Cascade Style Sheets Editor\nVersion 1.0\nCopyright (c) UCWare Group, 2001\n\nWeb:\n         http://juststyle.mastak.com  \nSupport:\n         juststyle@zworg.com\n\nRegistred to: \n" + Manager.this.RegistredTo() + "\n" + "S/N: \n" + Manager.this.Serial() + "\n\n" + "Configuration file:\n" + "         " + System.getProperties().getProperty("user.home") + System.getProperties().getProperty("file.separator") + "juststyle\\juststyle  \n" + "JRE Version:\n" + "         " + System.getProperties().getProperty("java.version") + " " + System.getProperties().getProperty("java.vendor") + "\n");
            new AboutDialog(Manager.this.getFrame(), string).show();
        }
    }

    class RegAction
    extends AbstractAction {
        RegAction() {
            super("reg");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RegDialog regDialog = new RegDialog(Manager.this.getFrame());
            String[] stringArray = regDialog.ask();
            if (stringArray[0] != null || stringArray[1] != null) {
                if (Manager.this.check(stringArray[1])) {
                    Manager.this.getSettings().put("REGN", stringArray[0]);
                    Manager.this.getSettings().put("REGC", stringArray[1]);
                    Manager.this.aboutpane = null;
                    new AboutAction().actionPerformed(null);
                } else {
                    Manager.this.oh();
                }
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            super("help");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HtmlHelp htmlHelp = new HtmlHelp("index.htm");
            JFrame jFrame = new JFrame("JustStyle Help");
            jFrame.getContentPane().add(htmlHelp);
            jFrame.pack();
            ((Component)jFrame).setSize(310, 400);
            ComponentTools.setPos(jFrame);
            jFrame.show();
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            }
        }
    }
}

