/**
 * Add / Edit Muck/MUD Addresses
 * $Id: AddEdit.java 1.4 2001/08/20 03:28:06 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import java.awt.*;
import java.awt.event.*;

import anecho.gui.PosTools;
import anecho.gui.ResReader;

	/**
	 * A class to Add or Edit names, addresses and Ports for MUCKs/MUDs
         * @version $Id: AddEdit.java 1.4 2001/08/20 03:28:06 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class AddEdit extends Dialog implements ActionListener{
    // protected Button okay, cancel;
    // protected static Frame editMuck;
    private Button okay, cancel;
    private GridBagLayout addEditLayout;
    private GridBagConstraints constraints;
    private Label gLabel;
    private TextField editName, editAddy, editPort;
    private boolean okayStatus;

    public AddEdit(Frame frameParent, String boxLabel) {
            super(frameParent, "JamochaMUD - " + boxLabel, true);

            editName = new TextField("");
            editAddy = new TextField("");
            editPort = new TextField("");

            addEditLayout = new GridBagLayout();
            constraints = new GridBagConstraints();

            // Set new layout

            this.setLayout(addEditLayout);

            // Add elements to the layout
            // MU* name
            gLabel = new Label(RB("MUname"));
            constraints.gridwidth = GridBagConstraints.RELATIVE;
            constraints.gridheight = 1;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 2;
            constraints.weighty = 0;
            constraints.insets = new Insets(7, 7, 2, 2);
            constraints.fill = GridBagConstraints.NONE;
            constraints.anchor = GridBagConstraints.WEST;
            addEditLayout.setConstraints(gLabel, constraints);
            add(gLabel);

            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.gridheight = 1;
            constraints.gridx = 2;
            constraints.gridy = 0;
            constraints.weightx = 3;
            constraints.weighty = 0;
            constraints.insets = new Insets(7, 2, 2, 7);
            constraints.fill = GridBagConstraints.BOTH;
            constraints.anchor = GridBagConstraints.WEST;
            addEditLayout.setConstraints(editName, constraints);
            add(editName);

            // MU* address
            gLabel = new Label(RB("MUaddress"));
            constraints.gridwidth = GridBagConstraints.RELATIVE;
            constraints.gridheight = 1;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.weightx = 2;
            constraints.weighty = 0;
            constraints.insets = new Insets(2, 7, 2, 2);
            constraints.fill = GridBagConstraints.NONE;
            constraints.anchor = GridBagConstraints.WEST;
            addEditLayout.setConstraints(gLabel, constraints);
            add(gLabel);

            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.gridheight = 1;
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.weightx = 3;
            constraints.weighty = 0;
            constraints.insets = new Insets(2, 2, 2, 7);
            constraints.fill = GridBagConstraints.BOTH;
            constraints.anchor = GridBagConstraints.WEST;
            addEditLayout.setConstraints(editAddy, constraints);
            add(editAddy);

            // MU* port
            gLabel = new Label(RB("MUport"));
            constraints.gridwidth = GridBagConstraints.RELATIVE;
            constraints.gridheight = 1;
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.weightx = 2;
            constraints.weighty = 0;
            constraints.insets = new Insets(2, 7, 2, 2);
            constraints.fill = GridBagConstraints.NONE;
            constraints.anchor = GridBagConstraints.WEST;
            addEditLayout.setConstraints(gLabel, constraints);
            add(gLabel);

            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.gridheight = 1;
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.weightx = 3;
            constraints.weighty = 0;
            constraints.insets = new Insets(2, 2, 2, 7);
            constraints.fill = GridBagConstraints.BOTH;
            constraints.anchor = GridBagConstraints.WEST;
            addEditLayout.setConstraints(editPort, constraints);
            add(editPort);

            okay = new Button(RB("OK"));
            constraints.gridwidth = GridBagConstraints.RELATIVE;
            constraints.gridheight = 1;
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.weightx = 2;
            constraints.weighty = 0;
            constraints.insets = new Insets(2, 7, 7, 2);
            constraints.fill = GridBagConstraints.NONE;
            constraints.anchor = GridBagConstraints.CENTER;
            addEditLayout.setConstraints(okay, constraints);
            add(okay);
            okay.addActionListener(this);

            cancel = new Button(RB("cancel"));
            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.gridheight = 1;
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.weightx = 3;
            constraints.weighty = 0;
            constraints.insets = new Insets(2, 2, 7, 7);
            constraints.fill = GridBagConstraints.NONE;
            constraints.anchor = GridBagConstraints.CENTER;
            addEditLayout.setConstraints(cancel, constraints);
            add(cancel);
            cancel.addActionListener(this);

            pack();
        }

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		// Check for the 'cancel Button'
		if (arg.equals(cancel.getLabel())) {
                    setVisible(false);
                    dispose();
		}

		// Check for the 'okay button'
		if (arg.equals(okay.getLabel())) {
                    okayStatus = true;
                    setVisible(false);
                    dispose();
		}
	}

        /** Set all our variables at once **/
        public void setAll(String name, String address, String port) {
            setName(name);
            setAddress(address);
            setPort(port);
        }

        /** Set the name of the MU* to appear in the dialogue */
        public void setName(String name) {
            editName.setText(name);
        }

        /** Set the name of the MU*'s address */
        public void setAddress(String address) {
            editAddy.setText(address);
        }

        /** Set the port of the MU* */
        public void setPort(String port) {
            editPort.setText(port);
        }

        public String getName() {
            return editName.getText();
        }

        public String getAddress() {
            return editAddy.getText();
        }

        public String getPort() {
            return editPort.getText();
        }

    /** Return a true is "Okay" was selected,
     * otherwise return a false */
    public boolean isOkay() {
        return okayStatus;
    }

    /**
     * This is a generic bit to access the
     * ResReader.class, for localization
     * (Multi-language support)
     */
    private static String RB(String itemTarget) {
        ResReader reader = new ResReader();
        // return reader.LangString("JamochaMUDBundle", itemTarget);
        return reader.LangString(JMConfig.BUNDLEBASE, itemTarget);
    }

}
