/**
 * Allows the designation of external programs for
 * extension of JamochaMUD's capabilities
 * $Id: ExternalProgs.java 1.5 2001/12/23 21:18:05 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import java.awt.*;
import java.awt.event.*;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import java.util.Vector;

import anecho.gui.SyncFrame;
import anecho.gui.ResReader;
import anecho.gui.OKBox;

import anecho.extranet.Bowsah;

	/**
	 * Allows the designation of external programs for
	 * extension of JamochaMUD's capabilities
         * @version $Id: ExternalProgs.java 1.5 2001/12/23 21:18:05 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class ExternalProgs extends Dialog implements ActionListener, MouseListener{

	private Button browser1B, browser2B, fTPClientB, eMailClientB, pictureViewerB, okayButton, cancelButton;
	static private Checkbox browser1CB, browser2CB, fTPClientCB, eMailClientCB, pictureViewerCB;
	private FileDialog progDialogue;	
	private Label ePLabel;
	private TextField browser1, browser2, fTPClient, eMailClient, pictureViewer;
	private boolean returnText;
	
	private static ExternalProgs eProg;
        private Frame ePFrame;
	
	// Private processes for the different 'browsers'
        static Process browser1P, browser2P, ftpP, eMailP, pictureViewerP;
        private static Bowsah bp1;
        private static boolean uniqueLaunch = false;		// launch a separate instance?
        private JMConfig settings;
	

	public ExternalProgs(Frame frameParent, JMConfig mainSettings){

            super(frameParent, "JamochaMUD - " + RB("title"), true);
            ePFrame = frameParent;
            this.settings = mainSettings;
		
		// Set Gridbag layout
		GridBagLayout ePLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		this.setLayout(ePLayout);
		
		// Add dialogue components	
		Label ePLabel = new Label(RB("primaryWebBrowser"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.NONE;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

		browser1CB = new Checkbox(RB("separateInstance"), false);
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.NONE;
                ePLayout.setConstraints(browser1CB, constraints);
                browser1CB.setState(settings.getBrowserInstance(settings.BROWSER1));
                add(browser1CB);
                browser1CB.setState(false);
                browser1CB.setEnabled(false);

		browser1 = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser1, constraints);
		add(browser1);
                browser1.setText(settings.getBrowser(settings.BROWSER1));
                // System.out.println("Browser 1 set from Hashtable");

		browser1B = new Button(RB("locate"));
		browser1B.setActionCommand("Browser1");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser1B, constraints);
		browser1B.addActionListener(this);
		add(browser1B);

		ePLabel = new Label(RB("secondaryWebBrowser"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 3;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

		browser2CB = new Checkbox(RB("separateInstance"), false);
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 3;
		constraints.fill = GridBagConstraints.NONE;
		ePLayout.setConstraints(browser2CB, constraints);
                browser2CB.setState(settings.getBrowserInstance(settings.BROWSER2));
                add(browser2CB);
                browser2CB.setState(false);
                browser2CB.setEnabled(false);

		browser2 = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 4;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser2, constraints);
		add(browser2);
                browser2.setText(settings.getBrowser(settings.BROWSER2));

		browser2B = new Button(RB("locate"));
		browser2B.setActionCommand("Browser2");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 4;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(browser2B, constraints);
		browser2B.addActionListener(this);
		add(browser2B);

		ePLabel = new Label(RB("fTPClient"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 7;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

//		fTPClientCB = new Checkbox(RB("separateInstance"), false);
//		constraints.gridwidth = 2;
//		constraints.gridheight = 1;
//		constraints.gridx = 3;
//		constraints.gridy = 7;
//		constraints.fill = GridBagConstraints.NONE;
//		ePLayout.setConstraints(fTPClientCB, constraints);
//		add(fTPClientCB);

		fTPClient = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 8;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(fTPClient, constraints);
		add(fTPClient);
                fTPClient.setText(settings.getBrowser(settings.FTPCLIENT));

		fTPClientB = new Button(RB("locate"));
		fTPClientB.setActionCommand("FTPClient");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 8;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(fTPClientB, constraints);
		fTPClientB.addActionListener(this);
		add(fTPClientB);

		ePLabel = new Label(RB("eMailClient"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 10;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(ePLabel, constraints);
		add(ePLabel);

//		eMailClientCB = new Checkbox(RB("separateInstance"), false);
//		constraints.gridwidth = 2;
//		constraints.gridheight = 1;
//		constraints.gridx = 3;
//		constraints.gridy = 10;
//		constraints.fill = GridBagConstraints.NONE;
//		ePLayout.setConstraints(eMailClientCB, constraints);
//		add(eMailClientCB);

		eMailClient = new TextField("", 30);
		constraints.gridwidth = 4;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 11;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(eMailClient, constraints);
		add(eMailClient);
                eMailClient.setText(settings.getBrowser(settings.EMAILCLIENT));

		eMailClientB = new Button(RB("locate"));
		eMailClientB.setActionCommand("E-mail");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 4;
		constraints.gridy = 11;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(eMailClientB, constraints);
		eMailClientB.addActionListener(this);
		add(eMailClientB);

		// Add the 'okay' and 'cancel' buttons at the end.
		okayButton = new Button(RB("okay"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 1;
		constraints.gridy = 12;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(okayButton, constraints);
		okayButton.addActionListener(this);
		add(okayButton);

		cancelButton = new Button(RB("cancel"));
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 12;
		constraints.fill = GridBagConstraints.BOTH;
		ePLayout.setConstraints(cancelButton, constraints);
		cancelButton.addActionListener(this);
		add(cancelButton);

		pack();

                // Set the location sometime, okay?
                // this.setLocation();
                setSize(350, 250);
                setResizable(false);
        }

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
	 */
        private static String RB(String itemTarget) {
            ResReader reader = new ResReader();
            // return reader.LangString("JamochaMUDBundle", itemTarget);
            return reader.LangString(JMConfig.BUNDLEBASE, itemTarget);
        }
        // This supports multi-line messages
        private static Vector RBL(String itemTarget) {
            ResReader reader = new ResReader();
            // return reader.LangVector("JamochaMUDBundle", itemTarget);
            return reader.LangVector(JMConfig.BUNDLEBASE, itemTarget);
        }

	/** 
	 * Call the file dialogue so that the user may choose
	 * the appropriate program
	 */
	private void showFileDialogue(String title, TextField affectedItem) {
            // Create the dialogue

            progDialogue = new FileDialog(ePFrame, title);
            this.setVisible(false);
            progDialogue.setVisible(true);

		// Check to see if a file was selected
		try {
			String directoryName = new String(progDialogue.getDirectory());
			String fileName = new String(progDialogue.getFile());
			affectedItem.setText(directoryName + fileName);
		} catch (Exception e) {
			System.out.println("ExternalProgs (file selected exception) " + e);
                }

                this.setVisible(true);
		
	}

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();
		
		if (arg.equals(okayButton.getLabel())) {
                    // Save new choices
                    settings.setBrowser(settings.BROWSER1, browser1.getText());
                    settings.setBrowserInstance(settings.BROWSER1, browser1CB.getState());
                    settings.setBrowser(settings.BROWSER2, browser2.getText());
                    settings.setBrowserInstance(settings.BROWSER2, browser2CB.getState());

                    settings.setBrowser(settings.FTPCLIENT, fTPClient.getText());
                    settings.setBrowser(settings.EMAILCLIENT, eMailClient.getText());

                    // Fix this XXX
                    // JMWriteRC.Content();
                    setVisible(false);
                    dispose();
		}

		if (arg.equals(cancelButton.getLabel())) {
                    // discard any changes
                    setVisible(false);
                    dispose();
		}

		if (arg.equals("Browser1")) {
			showFileDialogue(RB("primaryWebBrowser"), browser1);	
		}

		if (arg.equals("Browser2")) {
			showFileDialogue(RB("secondaryWebBrowser"), browser2);
		}

		if (arg.equals("FTPClient")) {
			showFileDialogue(RB("fTPClient"), fTPClient);
		}

		if (arg.equals("E-mail")) {
			showFileDialogue(RB("eMailClient"), eMailClient);
		}

	}

	// Mouse events
	public void mousePressed(MouseEvent e) {}

	public void mouseReleased(MouseEvent e) {}

        public void mouseClicked(MouseEvent e) {}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}

	/**
	 * A method to launch external programs from JamochaMUD
	 */
//	public static void LaunchProgram(CloseableFrame workingFrame, StringBuffer //tentativeURL) {
//	public static void LaunchProgram(SyncFrame workingFrame, StringBuffer tentativeURL) {
	public void LaunchProgram(SyncFrame workingFrame, StringBuffer tentativeURL) {

		// Let's do some sanity checks first.
		if (tentativeURL == null || tentativeURL.toString() == "" || tentativeURL.toString().length() <= 0) return;
	
		// First, determine if it is a valid URL
		String uRLToUse = new String("");
		uRLToUse = testURL(tentativeURL);	

		// Now determine correct program to launch
		String progName = new String("null");	
		progName = whichProgram(uRLToUse.trim());
		
		// Check to see if the response is a valid type
		if (progName.toLowerCase().equals("null")) {
			System.out.println("No viewer configured");
		} else {
			// Launch the selected program
			
			try {
				if (uniqueLaunch) {
                                    Process p = Runtime.getRuntime().exec(progName + " " + uRLToUse.trim());
                                    System.out.println("Unique launch.");
				} else {
                                    // if (browser1P == null) {
                                    if (bp1 == null) {
                                        // browser1P = Runtime.getRuntime().exec(progName + " " + uRLToUse.trim());
                                        bp1 = new Bowsah(progName, uRLToUse.trim());
                                        System.out.println("Starting new 'browser'");
                                    } else {
                                        System.out.println("This would've fed information to an already executed program.");
                                        // UsePreviousInstance(browser1P, progName, uRLToUse);
                                        //browser1P.exec(uRLToUse.trim());
                                        bp1.DisplayURL(uRLToUse.trim());
                                    }
				}
			
			} catch (IOException ioe) {
				System.out.println("ExternalProgs: Doing IOException");
				// There was an IO Exception, most likely
				// generated due to no program being
				// assigned to this 'URL' type
				Vector tempVector = new Vector(0, 1);

                                // Fix this XXX
/*                                OKBox.RunOkay(workingFrame, null, null, false, false, null, null, true, RBL("noProgramConfigured"), "Configure external programs?", 250, 200);

                                if (((String)MuckConn.jmVars.get("Okay")).equals("true")) {
                                    // Yes was chosen, set the programs
                                    // Content(workingFrame);
                                    }
                                    */

                                OKBox check = new OKBox(workingFrame, RB("configureExternalProgram"), true);

                                check.show();
                        } catch (Exception e) {
                            System.out.println("ExternalProgs -> warning: " + e);
                        }

		uniqueLaunch = false;	// Reset this variable for next time

		}
	}

	/**
	 * Test the URL to see if it is in fact a *valid* URL
	 * First, test for superfluous characters
	 * such as . , " and perhaps others
	 */
	private static String testURL(StringBuffer tentativeURL) {
		boolean testResult;
		
		// Test beginning of the string
		for (int i = 0; i<=tentativeURL.length(); i++) {
			
			// A result of true means that it is a valid character
			if (characterCheck(tentativeURL.charAt(i))) {
				// End loop
				break;
			} else {
				// The result is false, change that char
				// into a blank space
				tentativeURL.setCharAt(i, ' ');
			}
		}		

		// Now check from the back end of the StringBuffer
		for (int i = (tentativeURL.length() - 1); i>=1; i--) {
			// Call a generic routine to test
			
			// A result of true means that it is a valid character
			if (characterCheck(tentativeURL.charAt(i))) {
				// End the loop
				break;
			} else {
				// The result if false, change that
				// char into a blank space
				tentativeURL.setCharAt(i, ' ');
			}	
		}
		String finalURL = tentativeURL.toString();
		finalURL.trim();
		
		// temporary return to allow compiling
		return finalURL;
	
	}

	/** Check characters to see if they are 'legal', either
	 * a letter or a digit
	 */
	private static boolean characterCheck(char testChar) {
		boolean result = true;
		
		// See if the character is "legal"
		if (!Character.isLetterOrDigit(testChar)) {
			System.out.println("The character is not a letter or digit");
			result = false;
		}
		return result;
	}

	/**
	 * This class attempts to call the correct program by using the
	 * file extension of the string passed to it.  Not perfect by
	 * any stretch of the imagination
	 */
        //	private static String whichProgram(String tU) {
        private String whichProgram(String tU) {
	// private String whichProgram(String tU) {
		String fileType = new String("null");
		String browserPath = new String("null");
	
		// Hopefully, this will be replaced with user
		// defined file-browser associations in the future

		// Check for tell-tale signs of which program to use
		// Do HTML first, being probably the most common
		if (tU.toLowerCase().endsWith("html") || tU.toLowerCase().startsWith("www") || tU.toLowerCase().startsWith("http")) {
			fileType = "HTML";
		}
	
		// Check for E-mail address
		if (tU.indexOf("@") >= 0) {
			fileType = "E-mail";
		}

		if (tU.startsWith("ftp")) {
			fileType = "FTP";
		}

		if (tU.endsWith("jpeg") || tU.endsWith("jpg") || tU.endsWith("gif")) {
			fileType = "Image";
		}

		// Find a more efficient way of doing this, too?
		if (fileType.equals("HTML")) {
                    browserPath = settings.getBrowser(settings.BROWSER1);
			if (browser1CB.getState()) uniqueLaunch = true;
		}
                if (fileType.equals("E-mail")) {
                    try {
                        browserPath = settings.getBrowser(settings.BROWSER2);
                        if (browser2CB.getState()) uniqueLaunch = true;
                    } catch (Exception e) {
                        System.out.println("E-mail exception: " + e);
                    }
		}
		if (fileType.equals("FTP")) {
                    browserPath = settings.getBrowser(settings.FTPCLIENT);
			if (fTPClientCB.getState()) uniqueLaunch = true;
		}
		if (fileType.equals("Image")) {
                    browserPath = settings.getBrowser(settings.EMAILCLIENT);
			if (eMailClientCB.getState()) uniqueLaunch = true;
		}
		
		  
		// This returns fileType for now.  Later it will return
		// program location, etc.
		return browserPath;
	}

        /** This method determines the proper way to pass a new
         * URL or something like that to the chosen "browser" that
         * already has a running instance */
        static void UsePreviousInstance(Process browser, String progName, String uRLToUse) {
            //            browser.exec(uRLToUse);
            OutputStream oStream = browser.getOutputStream();
            OutputStreamWriter oSWriter = new OutputStreamWriter(oStream);

            try {
                oSWriter.write(uRLToUse);
            } catch (Exception e) {
                System.out.println("We caught an exception when we went to write to the Stream (UsePreviousInstance) " + e);
            }
        }

}
