/**
 * FontFace (allows changing of colours and font faces)
 * $Id: FontFace.java 1.4 2001/08/20 03:28:06 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import java.awt.*;
import java.awt.event.*;

import java.util.Hashtable;

import anecho.gui.PosTools;
import anecho.gui.ResReader;
import anecho.gui.SyncFrame;

/**
 * FontFace (allows changing of colours and font faces)
 * @version $Id: FontFace.java 1.4 2001/08/20 03:28:06 jeffnik Exp $
 * @author Jeff Robinson
 */
public class FontFace extends Dialog implements ActionListener, MouseListener{
	private Button okayButton, cancelButton, fontColourButton, backgroundColourButton;
        private Color backgroundColour, fontColour;
        private Font currentFont;
	private Choice fontBody, fontStyle, fontSize;
	private Frame parentFrame;
	private int a;
	private Panel fFPanel, fFsubPanel1, fFsubPanel2, fFsubPanel3, fFsubPanel4, 			fFsubPanel5;

	static FontFace editIt;
						
        // public FontFace(Frame frameParent){
        // public FontFace(SyncFrame frameParent) {
        public FontFace(Frame frameParent, Color foreGround, Color backGround, Font mainFontFace) {
            super(frameParent, "JamochaMUD - "+ RB("FontFace.title"), true);

            this.parentFrame = frameParent;       // Needed to call other dialogues
            this.backgroundColour = backGround;
            this.fontColour = foreGround;
            this.currentFont = mainFontFace;

		fFPanel = new Panel();
		fFsubPanel1 = new Panel();
		fFsubPanel2 = new Panel();
		fFsubPanel3 = new Panel();
		fFsubPanel4 = new Panel();
		fFsubPanel5 = new Panel();
		fontBody = new Choice();
		fontStyle = new Choice();
                fontSize = new Choice();
                // Fix this XXX
                // backgroundColour = MuckMain.mainText.getBackground();
                // fontColour = MuckMain.mainText.getForeground();

		// Set Gridbag layout
		GridBagLayout fFLayout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		this.setLayout(fFLayout);
		
		// Add dialogue components	
		Label fFLabel = new Label(RB("font"));
		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 7, 2, 2);
		constraints.fill = GridBagConstraints.BOTH;
		fFLayout.setConstraints(fFLabel, constraints);
		add(fFLabel);

		fontBody = new Choice();
			fontBody.add("Serif");
			fontBody.add("SansSerif");
			fontBody.add("Monospaced");
			fontBody.add("Dialog");
                        // Determine existing name style, and make that default choice
                        // Fix this XXX
                        // fontBody.select(MuckMain.mainText.getFont().getName());
                        fontBody.select(currentFont.getName());

		constraints.gridwidth = 2;
		constraints.gridheight = 1;
		constraints.gridx = 2;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 2, 2, 2);
		constraints.fill = GridBagConstraints.BOTH;
		fFLayout.setConstraints(fontBody, constraints);
		add(fontBody);
		fontBody.addMouseListener(this);

		fontStyle = new Choice();
			fontStyle.add(RB("plain"));
			fontStyle.add(RB("bold"));
			fontStyle.add(RB("italic"));
			fontStyle.add(RB("bold&italic"));
                        // Determine existing font style, and make it the default choice
                        // Fix this XXX
                        // fontStyle.select(MuckMain.mainText.getFont().getStyle());
                        fontStyle.select(currentFont.getStyle());
			fFsubPanel1.add(fontStyle);
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fontStyle, constraints);
		add(fontStyle);		
		fontStyle.addMouseListener(this);

		fFLabel = new Label(RB("fontSize"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 1;
			constraints.gridy = 1;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			// constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fFLabel, constraints);
		add(fFLabel);
		
		fontSize = new Choice();
			for (int fs = 6; fs < 41; fs++) {
				fontSize.add(fs + "");
			}
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 3;
			constraints.gridy = 1;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.anchor = GridBagConstraints.WEST;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
                        fFLayout.setConstraints(fontSize, constraints);
                        // Fix this XXX
                        // fontSize.select((MuckMain.mainText.getFont().getSize()) - 6);
                        fontSize.select(currentFont.getSize() - 6);
		add(fontSize);

		fFLabel = new Label(RB("change"));
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 2;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(fFLabel, constraints);
			add(fFLabel);		

		fontColourButton = new Button(RB("fontColour"));
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 3;
			constraints.gridy = 2;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fontColourButton, constraints);
			fontColourButton.addActionListener(this);
			add(fontColourButton);

		fFLabel = new Label(RB("change"));
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 3;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(fFLabel, constraints);
			add(fFLabel);

		backgroundColourButton = new Button(RB("backgroundColour"));
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 3;
			constraints.gridy = 3;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(backgroundColourButton, constraints);
			add(backgroundColourButton);
			backgroundColourButton.addActionListener(this);

		fFLabel = new Label("");
			constraints.gridwidth = 6;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 4;
			constraints.fill = GridBagConstraints.BOTH;
			constraints.gridwidth = GridBagConstraints.RELATIVE;
			fFLayout.setConstraints(fFLabel, constraints);

		okayButton = new Button(RB("okay"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 1;
			constraints.gridy = 5;
			constraints.insets = new Insets(7, 7, 7, 7);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(okayButton, constraints);
			add(okayButton);
			okayButton.addActionListener(this);

		cancelButton = new Button(RB("cancel"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 5;
			constraints.insets = new Insets(7, 7, 7, 7);
			constraints.fill = GridBagConstraints.BOTH;
			fFLayout.setConstraints(cancelButton, constraints);
			add(cancelButton);
			cancelButton.addActionListener(this);

		pack();
	}

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
         */
        private static String RB(String itemTarget) {
            ResReader reader = new ResReader();
            // return reader.LangString("JamochaMUDBundle", itemTarget);
            return reader.LangString(JMConfig.BUNDLEBASE, itemTarget);
        }

	public void actionPerformed(ActionEvent event){
		String arg = event.getActionCommand();

		if (arg.equals(fontColourButton.getLabel())) {
                    // ColourPicker picker = new ColourPicker(fFFrame, "Font Colour", fontColour);
//                    this.setModal(false);
                    ColourPicker picker = new ColourPicker(parentFrame, "Font Colour", fontColour);
//                    this.setVisible(false);
                    picker.setVisible(true);

//                    this.setModal(true);          // set modal before visible, so no weirdness can happen
//                    this.setVisible(true);

                    Color tempColour = picker.getColour();

                    if (tempColour != null) {
                        fontColour = tempColour;
                    }
		}

		if (arg.equals(backgroundColourButton.getLabel())) {
			ColourPicker picker = new ColourPicker(parentFrame, "Background Colour", backgroundColour);
			picker.setVisible(true);

			Color tempColour = picker.getColour();

			if (tempColour != null) {
				backgroundColour = tempColour;
			}
		}

		if (arg.equals(okayButton.getLabel())){
                    // Okay was selected, get the information
                    JMSetNewColour();
                    // Get information from fontBody and fontStyle, and apply them
                    setVisible(false);

                    // Write to the .jamocha.rc file
                    // Fix this XXX
                    // JMWriteRC.Content();

                    dispose();
		}
                if (arg.equals(cancelButton.getLabel())){
                    JMSetCancelledColour();
                    setVisible(false);
                    dispose();
		}
		repaint();
	}

	// Mouse events
	public void mousePressed(MouseEvent e) {}

	public void mouseReleased(MouseEvent e) {
		repaint();
	}

        public void mouseClicked(MouseEvent e) {
		repaint();
	}

	public void mouseEntered(MouseEvent e) {}

	public void mouseExited(MouseEvent e) {}

	/**
	 * Update the sample text
	 */
	public void paint(Graphics g) {
		g.setColor(backgroundColour);
		g.fill3DRect(25, 210, 250, 30, true);
		g.setColor(fontColour);
		g.setFont(new 	Font((fontBody.getItem(fontBody.getSelectedIndex())), 					(fontStyle.getSelectedIndex()), 12));
		g.drawString(RB("thePleasingRedFoxSipped"), 40, 230);
	}

	/** 
	 * Apply the new colour and face as chosen by the user
	 */
	private void JMSetNewColour() {
		// Get information from fontBody and fontStyle, and apply them
            int a = fontStyle.getSelectedIndex();
            // Fix this XXX
            // MuckMain.mainText.setFont(new Font((fontBody.getItem(fontBody.getSelectedIndex())), 					(fontStyle.getSelectedIndex()), ((fontSize.getSelectedIndex()) + 6)));
            // MuckConn.typeHere.setFont(new Font((fontBody.getItem(fontBody.getSelectedIndex())), (fontStyle.getSelectedIndex()), ((fontSize.getSelectedIndex()) + 6)));
            // MuckMain.mainText.setForeground(fontColour);
            // MuckMain.mainText.setBackground(backgroundColour);
            // MuckConn.typeHere.setForeground(fontColour);
            // MuckConn.typeHere.setBackground(backgroundColour);
            // to make this component reusable, we'll set our "inetrnal"
            // variables to our user's selection
            int body = fontBody.getSelectedIndex();
            int style = fontStyle.getSelectedIndex();
            int size = fontSize.getSelectedIndex() + 6;

            currentFont = new Font(fontBody.getItem(body), style, size);
        }

        /** Set our currentFont to null, so we know the user
         * cancelled any changes that were made */
        private void JMSetCancelledColour() {
            currentFont = null;
        }

        /** Return our font */
        public Font getFontStyle() {
            return currentFont;
        }

        public Color getForegroundColour() {
            return fontColour;
        }

        public Color getBackgroundColour() {
            return backgroundColour;
        }
		
}
