/**
 * JMConfig.java, an object to keep and share
 * JamochaMUD settings between classes
 * $Id: JMConfig.java 1.13 2002/02/02 02:59:13 jeffnik Exp jeffnik $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2001  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * vesion 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import anecho.JamochaMUD.DataIn;
import anecho.JamochaMUD.CHandler;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;

import java.util.Hashtable;
import java.util.Vector;

public class JMConfig {

    // This hashtable will contain all the values we should need
    private Hashtable vars;
    public static final String AUTOFOCUSINPUT = "AutoFocusInput";
    public static final String BACKGROUNDCOLOUR = "BackgroundColour";
    public static final String BROWSER1 = "Browser1";
    public static final String BROWSER2 = "Browser2";
    public static final String CONNECTIONHANDLER = "ConnectionHandler";
    public static final String CONNMUCK = "ConnMuck";
    public static final String CONNPORT = "ConnPort";
    public static final String DATABAR = "DataBar";
    public static final String DATAINVARIABLE = "DataInVariable";
    public static final String DOUBLEBUFFER = "DoubleBuffer";
    public static final String EMAILCLIENT = "EMailClient";
    public static final String ENUMERATOR = "Enumerator";
    public static final String FONTFACE = "FontFace";
    public static final String FOREGROUNDCOLOUR = "ForegroundColour";
    public static final String FTPCLIENT = "FTPClient";
    public static final String ICONIMAGE = "IconImage";
    public static final String JMUDCORE = "JamochaMUDCore";
    public static final String LOCALECHO = "LocalEcho";
    public static final String MACROFRAME = "MacroFrame";
    public static final String MACRODEFS = "MacroDefs";
    public static final String MACROLABELS = "MacroLabels";
    public static final String MACROVISIBLE = "MacroVisible";
    public static final String MAINWINDOW = "MainWindow";
    public static final String MAINWINDOWICONIFIED = "MainWindowIconified";
    public static final String MAINWINDOWVARIABLE = "MainWindowVariable";
    public static final String MUCKMAINTITLE = "MuckMainTitle";
    public static final String MUCKNAME = "MuckName";
    public static final String MUCKADDY = "MuckAddy";
    public static final String MUCKPORT = "MuckPort";
    public static final String OSNAME = "OSName";
    public static final String PATHSEPARATOR = "PathSeparator";
    public static final String PLUGENUMERATOR = "PluginEnumerator";
    public static final String PLUGINNAME = "PlugInName";
    public static final String PLUGINSTATUS = "PlugInStatus";
    public static final String PROXY = "ProxyEnabled";
    public static final String PROXYHOST = "ProxyHost";
    public static final String PROXYPORT = "ProxyPort";
    public static final String RELEASEPAUSE = "ReleasePause";
    public static final String SCREENSIZE = "ScreenSize";
    public static final String SPLITVIEW = "SplitView";
    public static final String SYNCWINDOWS = "SyncWindows";
    public static final String TFKEYEMU = "TFKeyEmu";
    public static final String TIMERS = "Timers";
    public static final String TIMERSVISIBLE = "TimersVisible";
    public static final String UNICODE = "UseUnicode";
    public static final String USERDIRECTORY = "UserDirectory";
    public static final String USERPLUGINDIR = "UserPlugInDir";
    public static final String WORKINGDIRECTORY = "WorkingDirectory";
    public static final String BUNDLEBASE = "anecho.JamochaMUD.JamochaMUDBundle";

    /** Our constructor is empty, and we like it that way!
     * Well, actually, all our variables should have some base value
     * straight &quot;out of the box".  There would be far too many
     * to do in the constructor... without falling asleep */
    public JMConfig() {
        vars = new Hashtable(101, .75f);
    }

    /** Check our hashtable for the existance
     * of key &quot;String"
     */
    private boolean checkKey(String key) {
        if (vars.containsKey(key)) {
            return true;
        }
        return false;
    }

    /** Convert a string value to a boolean */
    private boolean StringToboolean(String key) {
        String workString = (String)vars.get(key);
        if (workString.toLowerCase().equals("true")) {
            return true;
        }
        return false;
    }

    /* Convert a boolean value to a string */
    private String booleanToString(boolean status) {
        if (status) {
            return "true";
        }

        return "false";
    }


    public void setJMboolean(String item, String setting) {
        String value = "false";
        if (setting.toLowerCase().equals("true")) {
            // setAutoFocusInput(true);
            value = "true";
        }
        vars.put(item, value);
    }

    public void setJMObject(String item, Object value) {
        vars.put(item, value);
    }

    public Object getJMObject(String item) {
        if (checkKey(item)) {
            return (Object)vars.get(item);
        }
        return null;
    }

    public String getJMString(String item) {
        if (checkKey(item)) {
            return (String)vars.get(item);
        }
        return null;
    }

    public boolean getJMboolean(String item) {
        if (checkKey(item)) {
            return StringToboolean(item);
        }
        return false;
    }

    /* All our happy little methods */
    public void setAutoFocusInput(boolean setting) {
        setAutoFocusInput(setting + "");
    }

    public void setAutoFocusInput(String setting) {
        setJMboolean(AUTOFOCUSINPUT, setting);
    }

    public boolean getAutoFocusInput() {
        return getJMboolean(AUTOFOCUSINPUT);
    }

    public void setForegroundColour(Color fgColor) {
        vars.put(FOREGROUNDCOLOUR, fgColor);
    }

    public Color getForegroundColour() {
        return (Color)getJMObject(FOREGROUNDCOLOUR);
    }




    public void setBackgroundColour(Color bgColor) {
        vars.put(BACKGROUNDCOLOUR, bgColor);
    }

    public Color getBackgroundColour() {
        return (Color)getJMObject(BACKGROUNDCOLOUR);
    }

    public void setFontFace(Font fFace) {
        vars.put(FONTFACE, fFace);
    }

    public Font getFontFace() {
        return (Font)getJMObject(FONTFACE);
    }

    /** Set the stat for our browser, as indicated by
     * <TT>String browser</TT>.  The path to the
     * executable will be <TT>String program</TT>
     */
    public void setBrowser(String browser, String program) {
        vars.put(browser, program);
    }

    /** Return the path of the executable for the
     * requested browser.
     */
    public String getBrowser(String browser) {
        return getJMString(browser);
    }

    public void setBrowserInstance(String browser, String status) {
        vars.put(browser + "Instance", status);
    }

    public void setBrowserInstance(String browser, boolean status) {
//        if (status) {
//            setBrowserInstance(browser, "true");
//        } else {
//            setBrowserInstance(browser, "false");
        //        }
        setBrowserInstance(browser, booleanToString(status));
    }

    public boolean getBrowserInstance(String browser) {
        return getJMboolean(browser + "Instance");
    }

    public void setSyncWindows(String status) {
        vars.put(SYNCWINDOWS, status);
    }

    public void setSyncWindows(boolean status) {
//        if (status) {
//            setSyncWindows("true");
//        } else {
//            setSyncWindows("false");
        //        }
        setSyncWindows(booleanToString(status));
    }

    public boolean getSyncWindows() {
        return getJMboolean(SYNCWINDOWS);
    }

    public void setTFKeyEmu(boolean status) {
//        if (status) {
//            setTFKeyEmu("true");
//        } else {
//            setTFKeyEmu("false");
        //        }
        setTFKeyEmu(booleanToString(status));
    }

    public void setTFKeyEmu(String status) {
        vars.put(TFKEYEMU, status);
    }

    public boolean getTFKeyEmu() {
        return getJMboolean(TFKEYEMU);
    }

    public void setDoubleBuffer(String status) {
        vars.put(DOUBLEBUFFER, status);
    }

    public void setDoubleBuffer(boolean status) {
//        if (status) {
//            setDoubleBuffer("true");
//        } else {
//            setDoubleBuffer("false");
        //        }
        setDoubleBuffer(booleanToString(status));
    }

    public boolean getDoubleBuffer() {
        return getJMboolean(DOUBLEBUFFER);
    }

    public void setUseUnicode(String status) {
        vars.put(UNICODE, status);
    }

    public void setUseUnicode(boolean status) {
//        if (status) {
//            setUseUnicode("true");
//        } else {
//            setUseUnicode("false");
        //        }
        setUseUnicode(booleanToString(status));
    }

    public boolean getUseUnicode() {
        return getJMboolean(UNICODE);
    }

    public void setMacroVisible(String status) {
        vars.put(MACROVISIBLE, status);
    }

    public void setMacroVisible(boolean status) {
//        if (status) {
//            setMacroVisible("true");
//        } else {
//            setMacroVisible("false");
        //        }
        setMacroVisible(booleanToString(status));
    }

    public boolean getMacroVisible() {
        return getJMboolean(MACROVISIBLE);
    }

    public void setMacroFrame(Rectangle mf) {
        vars.put(MACROFRAME, mf);
    }

    public Rectangle getMacroFrame() {
        return (Rectangle)getJMObject(MACROFRAME);
    }

    public void setTimersVisible(String status) {
        vars.put(TIMERSVISIBLE, status);
    }

    public void setTimersVisible(boolean status) {
//        if (status) {
//            setTimersVisible("true");
//        } else {
//            setTimersVisible("false");
        //        }
        setTimersVisible(booleanToString(status));
    }

    public boolean getTimersVisible() {
        return getJMboolean(TIMERSVISIBLE);
    }

    public void setMacroLabels(String[] labels) {
        vars.put(MACROLABELS, labels);
    }

    public String[] getMacroLabels() {
        return (String[])vars.get(MACROLABELS);
    }

    public void setMacroDefs(String[] defs) {
        vars.put(MACRODEFS, defs);
    }

    public String[] getMacroDefs() {
        return (String[])vars.get(MACRODEFS);
    }

    public void setUserDirectory(String dir) {
        vars.put(USERDIRECTORY, dir);
    }

    public String getUserDirectory() {
        return getJMString(USERDIRECTORY);
    }

    public void setUserPlugInDir(String dir) {
        vars.put(USERPLUGINDIR, dir);
    }

    public String getUserPlugInDir() {
        return getJMString(USERPLUGINDIR);
    }

    public void setPathSeparator(String sep) {
        vars.put(PATHSEPARATOR, sep);
    }

    public String getPathSeparator() {
        return getJMString(PATHSEPARATOR);
    }

    public void setWorkingDirectory(String dir) {
        vars.put(WORKINGDIRECTORY, dir);
    }

    public String getWorkingDirectory() {
        return getJMString(WORKINGDIRECTORY);
    }

    public void setConnMuck(String muck) {
        vars.put(CONNMUCK, muck);
    }

    public String getConnMuck() {
        return getJMString(CONNMUCK);
    }

    public void setMainWindow(Rectangle main) {
        vars.put(MAINWINDOW, main);
    }

    public Rectangle getMainWindow() {
        return (Rectangle)getJMObject(MAINWINDOW);
    }

    public void setDataBar(Rectangle bar) {
        vars.put(DATABAR, bar);
    }

    public Rectangle getDataBar() {
        return (Rectangle)getJMObject(DATABAR);
    }

    public void setTimers(Rectangle bar) {
        vars.put(TIMERS, bar);
    }

    public Rectangle getTimers() {
        return (Rectangle)getJMObject(TIMERS);
    }

    public synchronized void setIconImage(Image icon) {
        vars.put(ICONIMAGE, icon);
    }

    public synchronized Image getIconImage() {
        return (Image)getJMObject(ICONIMAGE);
    }

    public void setPlugInName(Vector names) {
        vars.put(PLUGINNAME, names);
    }

    public Vector getPlugInName() {
        return (Vector)getJMObject(PLUGINNAME);
    }

    public void setPlugInStatus(Vector status) {
        vars.put(PLUGINSTATUS, status);
    }

    public Vector getPlugInStatus() {
        return (Vector)getJMObject(PLUGINSTATUS);
    }

    public void setConnPort(int port) {
        vars.put(CONNPORT, port + "");
    }

    public int getConnPort() {
        if (checkKey(CONNPORT)) {
            return Integer.parseInt((String)vars.get(CONNPORT));
        }
        return 0;
    }

    public void setMuckName(Vector name) {
        vars.put(MUCKNAME, name);
    }

    public Vector getMuckName() {
        return (Vector)getJMObject(MUCKNAME);
    }

    public void setMuckAddy(Vector addy) {
        vars.put(MUCKADDY, addy);
    }

    public Vector getMuckAddy() {
        return (Vector)getJMObject(MUCKADDY);
    }

    public void setMuckPort(Vector port) {
        vars.put(MUCKPORT, port);
    }

    public Vector getMuckPort() {
        return (Vector)getJMObject(MUCKPORT);
    }

    public void setScreenSize(Dimension screen) {
        vars.put(SCREENSIZE, screen);
    }

    public Dimension getScreenSize() {
        return (Dimension)getJMObject(SCREENSIZE);
    }

    public void setConnectionHandler(CHandler connection) {
        vars.put(CONNECTIONHANDLER, connection);
    }

    public CHandler getConnectionHandler() {
        return (CHandler)getJMObject(CONNECTIONHANDLER);
    }

    public void setProxy(boolean status) {
//        if (status) {
//            setProxy("true");
//        } else {
//            setProxy("false");
        //        }
        setProxy(booleanToString(status));
    }

    public void setProxy(String status) {
        vars.put(PROXY, status);
    }

    public boolean getProxy() {
        return getJMboolean(PROXY);
    }

    public void setProxyHost(String host) {
        vars.put(PROXYHOST, host);
    }

    public String getProxyHost() {
        if (checkKey(PROXYHOST)) {
            return (String)vars.get(PROXYHOST);
        }
        return "";
    }

    public void setProxyPort(int port) {
        setProxyPort(port + "");
    }

    public void setProxyPort(String port) {
        vars.put(PROXYPORT, port);
    }

    public int getProxyPort() {
        if (checkKey(PROXYPORT)) {
            try {
                int port = Integer.parseInt((String)vars.get(PROXYPORT));
                return port;
            } catch(Exception e) {
                // return Integer.parseInt((String)vars.get(PROXYPORT));
                System.out.println("Our proxyport is: " + (String)vars.get(PROXYPORT));
            }
        }
        return 0;
    }

    public void setEnumerator(EnumPlugIns enum) {
        vars.put(ENUMERATOR, enum);
    }

    public EnumPlugIns getEnumerator() {
        return (EnumPlugIns)getJMObject(ENUMERATOR);
    }

    public void setJMCore(JMUD core) {
        vars.put(JMUDCORE, core);
    }

    public JMUD getJMCore() {
        return (JMUD)getJMObject(JMUDCORE);
    }

    public void setDataInVariable(DataIn variable) {
        vars.put(DATAINVARIABLE, variable);
    }

    public DataIn getDataInVariable() {
        return (DataIn)getJMObject(DATAINVARIABLE);
    }

    public void setMainWindowVariable(MuckMain variable) {
        vars.put(MAINWINDOWVARIABLE, variable);
    }

    public MuckMain getMainWindowVariable() {
        return (MuckMain)getJMObject(MAINWINDOWVARIABLE);
    }

    public void setMuckMainTitle(String title) {
        vars.put(MUCKMAINTITLE, title);
    }

    public String getMuckMainTitle() {
        if (checkKey(MUCKMAINTITLE)) {
            return (String)vars.get(MUCKMAINTITLE);
        }
        return "";
    }

    public void setPlugEnumerator(EnumPlugIns enum) {
        vars.put(PLUGENUMERATOR, enum);
    }

    public String getPlugEnumerator() {
        if (checkKey(PLUGENUMERATOR)) {
            return (String)vars.get(PLUGENUMERATOR);
        }
        return "";
    }

    public void setSplitView(boolean status) {
//        if (status) {
//            setSplitView("true");
//        } else {
//            setSplitView("false");
        //        }
        setSplitView(booleanToString(status));
    }

    public void setSplitView(String status) {
        vars.put(SPLITVIEW, status);
    }

    public boolean getSplitView() {
        return getJMboolean(SPLITVIEW);
    }

    public void setReleasePause(boolean status) {
//        if (status) {
//            setReleasePause("true");
//        } else {
//            setReleasePause("false");
        //        }
        setReleasePause(booleanToString(status));
    }

    public void setReleasePause(String status) {
        vars.put(RELEASEPAUSE, status);
    }

    public boolean getReleasePause() {
        return getJMboolean(RELEASEPAUSE);
    }
    /** This returns the base path to our language resource bundles */
    public String getBundleBase() {
        return "anecho.JamochaMUD.JamochaMUDBundle";
    }

    public void setMainWindowIconified(boolean status) {
//        if (iconified) {
//            setMainWindowIconified("true");
//        } else {
//            setMainWindowIconified("false");
        //        }
        setMainWindowIconified(booleanToString(status));
    }

    public void setMainWindowIconified(String iconified) {
        vars.put(MAINWINDOWICONIFIED, iconified);
    }

    public boolean isMainWindowIconified() {
        return getJMboolean(MAINWINDOWICONIFIED);
    }

    public void setLocalEcho(boolean status) {
//        if (state) {
//            setLocalEcho("true");
//        } else {
//            setLocalEcho("false");
        //        }
        setLocalEcho(booleanToString(status));
    }

    public void setLocalEcho(String state) {
        vars.put(LOCALECHO, state);
    }

    public boolean isLocalEchoEnabled() {
        return getJMboolean(LOCALECHO);
    }

    public void setOSName(String os) {
        vars.put(OSNAME, os);
    }

    public String getOSName() {
        return getJMString(OSNAME);
    }

}