/**
 * JMParseRC replaces the deprecated ParseINI file
 * Reads in the settings for the user's environment
 * $Id: JMParseRC.java 1.10 2002/02/02 02:59:13 jeffnik Exp jeffnik $
 */


/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import java.awt.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

import anecho.gui.OKBox;
import anecho.gui.ResReader;

	/**
	 * JMParseRC replaces the deprecated ParseINI file
	 * Reads in the settings for the user's environment
         * @version $Id: JMParseRC.java 1.10 2002/02/02 02:59:13 jeffnik Exp jeffnik $
         * @author Jeff Robinson
	 */
public class JMParseRC{

	/**
	 * Read .jamocha.rc and make an
	 * array of available MU*s, window positions, etc.
	 */
	
	private boolean stillLines, readLoop;
	private Hashtable jmSections;
	private FileOutputStream outFile;
	private int sectionFlag;
        private int t1, t2, t3;
        private PrintWriter out;
	public RandomAccessFile file;
	private String str, temp1, temp2, temp3, temp4;
        private Frame workingFrame;
        public JMConfig settings;

	Vector muckName = new Vector(0, 1);
	Vector muckAddy = new Vector(0, 1);
	Vector muckPort = new Vector(0, 1);

        //	public JMParseRC() {
        public JMParseRC(JMConfig mainSettings) {
            this.settings = mainSettings;

            // Set INI-field flags to 0
            jmSections = new Hashtable();
            // workingFrame = new Frame("Loading...."); 	// This frame is created
            // so that the dialogue
            // box has a parent

            // Set SectionFlag to 0, which indicates a non-valid INI group
            sectionFlag = 0;

		// Initialise other variables
		temp1 = new String("");
		temp2 = new String("");
		temp3 = new String("");
		temp4 = new String("");
	
		// First, set 'stillLines' to True.  
		// When 'stillLines' is false, end reading the file
		
		stillLines = true;

		// Open the file to allow subroutine to read
		
                try {
                    file = new RandomAccessFile(settings.getUserDirectory() + ".jamocha.rc", "r");

                    // Start a WHILE loop, using 'stillLines'

                    while (stillLines) {
                        // Read in a line of the ini file
                        str = readParse();

                        // Is this a new INI section flag?
                        if ((str.substring(0, 1)).equals("[")) {
                            if (str.equalsIgnoreCase("[worlds]")) {
                                sectionFlag = 1;
                            }

                            if (str.equalsIgnoreCase("[FGColour]")) {
                                sectionFlag = 2;
                                SetColours(readParse());
                            }

                            if (str.equalsIgnoreCase("[BGColour]")) {
                                sectionFlag = 3;
                                SetColours(readParse());
                            }

                            if (str.equalsIgnoreCase("[mainwindow]")) {
                                sectionFlag = 4;
                                MainWindow(readParse());
                            }

                            if (str.equalsIgnoreCase("[databar]")) {
                                sectionFlag = 5;
                                MainWindow(readParse());
                            }
                            if (str.equalsIgnoreCase("[macrobar]")) {
                                MacroWindow(readParse());
                            }

                            if (str.equalsIgnoreCase("[fontface]")) {
                                FontFace(readParse());
                            }

                            if (str.equalsIgnoreCase("[macros]")) {
                                sectionFlag = 8;
                            }

                            if (str.equalsIgnoreCase("[browser1]")) {
                                sectionFlag = 9;
                                Browser(readParse());
                            }

                            if (str.toLowerCase().equals("[browser2]")) {
                                sectionFlag = 10;
                                Browser(readParse());
                            }

                            if (str.toLowerCase().equals("[ftp client]")) {
                                FTPClient(readParse());
                            }

                            if (str.toLowerCase().equals("[e-mail client]")) {
                                sectionFlag = 12;
                                EMailClient(readParse());

                            }

                            if (str.toLowerCase().equals("[timers]")) {
                                JMTimers(readParse());
                            }

                            if (str.toLowerCase().equals("[autofocusinput]")) {
                                // sectionFlag = 13;
                                AutoFocusInput(readParse());
                            }

                            if (str.toLowerCase().equals("[localecho]")) {
                                LocalEcho(readParse());
                            }

                            if (str.toLowerCase().equals("[syncwindows]")) {
                                JMSyncWindows(readParse());
                            }

                            if (str.toLowerCase().equals("[unicode]")) {
                                JMUseUnicode(readParse());
                            }

                            if (str.toLowerCase().equals("[tfkeyemu]")) {
                                JMTFKeyEmu(readParse());
                            }

                            if (str.toLowerCase().equals("[proxy]")) {
                                JMSetProxy(readParse());
                            }

                            if (str.toLowerCase().equals("[doublebuffer]")) {
                                JMSetDoubleBuffer(readParse());
                            }

                            if (str.toLowerCase().equals("[splitview]")) {
                                JMSetSplitView(readParse());
                            }

                            if (str.toLowerCase().equals("[releasepause]")) {
                                JMSetReleasePause(readParse());
                            }

                        } else {
                            // INI Section flag
                            if (sectionFlag == 1) {
                                MuckWorld(str);
                            }
                            if (sectionFlag == 8) {
                                // Macros(str);
                            }

					if (sectionFlag != 1) {
						sectionFlag = 0;
					}
				} 		
				
			} // end WHILE loop

		} catch (IOException e) {
			// No .jamocha.rc available, create a new one
			CreateRC();
		} catch (NullPointerException e) {
			// Run out of file to parse
		} catch (Exception e) {
			// This is the catchall exception, just to end JMParseRC
                        // System.out.println("JMParseRC Exception " + e);
                        // should really work on a better mechanism to end this, huh?
		}
		
		// Check section flags, to see if important information is missing,
		// perhaps from using an older version of .jamocha.rc
		
		// Open file for any subsequent output
                try {
                    outFile = new FileOutputStream(settings.getUserDirectory() + ".jamocha.rc", true);

			out = new PrintWriter(outFile, true);
			
			if (!jmSections.containsKey("MUWorlds")) {
				NewWorlds();
			}

			if (!jmSections.containsKey("MainWindow")) {
				NewMainWindow();
			}

			if (!jmSections.containsKey(settings.MACROFRAME)) {
				NewMacroBar();
			}

			if (!jmSections.containsKey("DataBar")) {
				NewDataBar();
			}

			if (!jmSections.containsKey(settings.FOREGROUNDCOLOUR)) {
                            NewFGColour();
			}

			if (!jmSections.containsKey(settings.BACKGROUNDCOLOUR)) {
				NewBGColour();
			}

			if (!jmSections.containsKey(settings.FONTFACE)) {
				NewFontFace();
			}

			if (!jmSections.containsKey(settings.MACRODEFS)) {
				ReadSerialisedMacros();
			}

			if (!jmSections.containsKey("Timers")) {
                            // JMTimers("false");
                            NewTimers();
			}

			if (!jmSections.containsKey(settings.AUTOFOCUSINPUT)) {
                            AutoFocusInput("true");
			}	

                        if (!jmSections.containsKey(settings.LOCALECHO)) {
                            LocalEcho("false");
                        }

			if (!jmSections.containsKey(settings.SYNCWINDOWS)) {
                            JMSyncWindows("true");
			}

			if (!jmSections.containsKey(settings.UNICODE)) {
                            JMUseUnicode("false");
			}

			if (!jmSections.containsKey(settings.TFKEYEMU)) {
                            JMTFKeyEmu("true");
			}

			if (!jmSections.containsKey(settings.PROXY)) {
                            NewProxy();
                        }

                        if (!jmSections.containsKey(settings.DOUBLEBUFFER)) {
                            // NewDoubleBuffer();
                            JMSetDoubleBuffer("false");
                        }

                        if (!jmSections.containsKey(settings.SPLITVIEW)) {
                            // NewSplitView();
                            JMSetSplitView("true");
                        }

                        if (!jmSections.containsKey(settings.RELEASEPAUSE)) {
                            // NewReleasePause();
                            JMSetReleasePause("true");
                        }

			try {
				outFile.close();
			} catch (Exception oc) {
				System.out.println("JMParseRC: outFile.close error");
			}

		} catch (Exception e) {
			System.out.println("JMParseRC: An exception was caught " + e);
		}		

		// Add the worlds to the hashtable
                settings.setMuckName(muckName);
                settings.setMuckAddy(muckAddy);
                settings.setMuckPort(muckPort);

	}

	/**
	 * Section to read line and parse out remarks and/or blank lines
	 */
	public String readParse() {
		readLoop = true;

		while (readLoop) {
			try {
				// Read in the line from the file, and trim extra characters
				str = (file.readLine()).trim();
				
				// Check for relevant information
				if (str.equals(null)) {
					// We've run out of lines to read
					readLoop = false;
					stillLines = false;
				}
				if (str.equals("")) {
					// Blank line, disregard
				} else {
					if ((str.substring(0, 1)).equals("#")) {
						// Disregard as comment
					} else {
						// This line is a keeper!
						readLoop = false;  // This terminates the loop
					}
				}
			} catch (NullPointerException ex) {
				// End of the file
				readLoop = false;
				stillLines = false;
			} catch (StringIndexOutOfBoundsException ex) {
				// Hmmm...
			} catch (Exception ex) {
				// Mark for exception... probably no lines left
				System.out.println("JMParseRC: Exception... " + ex);
				readLoop = false;
				stillLines = false;
			}
		}
			
		return str;
	} 

//	public static void Content() {
//		JMParseRC a = new JMParseRC();
//	}

	/**
	 * Set the status of Auto-Focus Input
	 */
	public void AutoFocusInput(String temp1) {
            settings.setAutoFocusInput(temp1);
		jmSections.put("AutoFocusInput", "true");
	}

        /** The status of our Local Echo setting */
        public void LocalEcho(String temp1) {
            settings.setLocalEcho(temp1);
            jmSections.put(settings.LOCALECHO, "true");
        }

	/**
	 * Read in the names of the 'worlds'
	 */
	public void MuckWorld(String temp1) {

		// Parse the remaining 2 required MuckWorld lines, checking for section flags
		temp2 = readParse();
		temp3 = readParse();
		if ((temp2.substring(0, 1)).equals("[") || (temp3.substring(0, 1)).equals("[")) {
			System.out.println("Improperly formatted world.");
			sectionFlag = 0;
		} else {
			muckName.addElement(temp1);
			muckAddy.addElement(temp2);
			muckPort.addElement(temp3);
			jmSections.put("MUWorlds", "true");
		}					
	}
	
	/**
	 * Set the foreground and background colours for JamochaMUD
	 */
	public void SetColours(String temp1) {
		// Set either the foreground or the background colours
		temp2 = readParse();
		temp3 = readParse();
		if (temp2.startsWith("[") || temp3.startsWith("[")) {
			System.out.println("Improperly formatted colour section");
			sectionFlag = 0;
		}
		try {
			t1 = Integer.parseInt(temp1.trim());
			t2 = Integer.parseInt(temp2.trim());
			t3 = Integer.parseInt(temp3.trim());
			
			// Section 2 represents the foreground (font) colour
			if (sectionFlag == 2) {
                            settings.setForegroundColour(new Color(t1, t2, t3));
				
				jmSections.put("ForegroundColour", "true");
			} else {

                            // Section 3 represents the background Colour
                            settings.setBackgroundColour(new Color(t1, t2, t3));

				jmSections.put("BackgroundColour", "true");
			}
			sectionFlag = 0;
		} catch (Exception e) {
			System.out.println("Your colours are buggered." + e);
		}
	}

	/**
	 * Set location of the Main Output window
	 * and Data Bar (input window) location and size
	 */
	public void MainWindow(String temp1) {
		// Set the location of the main text window
		try {
			temp2 = readParse();
			temp3 = readParse();
			temp4 = readParse();

			// Check to see if any of of these values contain flags
			if (temp2.startsWith("[") || temp3.startsWith("[") || temp4.startsWith("[")) {
				// Improperly formatted main text area window
				sectionFlag = 0;
			} else {
                            if (sectionFlag == 5) {
                                // Set the variables for the databar's
                                // initial position and size


                                settings.setDataBar(new Rectangle(Integer.parseInt(temp1.trim()),
                                                                  Integer.parseInt(temp2.trim()),
                                                                  Integer.parseInt(temp3.trim()),
                                                                  Integer.parseInt(temp4.trim())
                                                                 )
                                                   );

                                jmSections.put("DataBar", "true");
                                sectionFlag = 0;
                            } else {
                                // Set the variables for the window's
                                // initial position and size
                                Rectangle tempD = new Rectangle(Integer.parseInt(temp1.trim()), Integer.parseInt(temp2.trim()), Integer.parseInt(temp3.trim()), Integer.parseInt(temp4.trim()));

                                settings.setMainWindow(tempD);
                                jmSections.put("MainWindow", "true");
                                sectionFlag = 0;
                            }
                        }
		} catch (Exception mwe) {
			System.out.println("Main window error" + mwe);
		}
	}

	/**
	 * Read in Macro Window's position and size
	 */
	public void MacroWindow(String str) {
		// Determine the size of the macro-window, and if visible.
		temp1 = readParse();
		temp2 = readParse();
		temp3 = readParse();
		temp4 = readParse();
		
		if (str.startsWith("[") || temp1.startsWith("[") || temp2.startsWith("[") || temp3.startsWith("[") || temp4.startsWith("[")) {
			// Macro information
			sectionFlag = 0;
		} else {
                    settings.setMacroFrame(new Rectangle(Integer.parseInt(temp1.trim()),
                                                                  Integer.parseInt(temp2.trim()),
                                                                  Integer.parseInt(temp3.trim()),
                                                                  Integer.parseInt(temp4.trim())));
						

			jmSections.put(settings.MACROFRAME, "true");
			sectionFlag = 0;
		}					

		// Determine macroVisible boolean
                settings.setMacroVisible(str.toLowerCase());

	}

	/**
	 * Set the Font Face for both the input and output windows
	 */
	public void FontFace(String temp1) {
		temp2 = readParse();
		temp3 = readParse();

		// Try and cast the second two variables into ints
		// temp2 and temp3 are font style and font size respectively

		try {
			int tempInt2 = Integer.parseInt(temp2);
			int tempInt3 = Integer.parseInt(temp3);
			
			// Transfer this information into the font
                        settings.setFontFace(new Font(temp1, tempInt2, tempInt3));
			
		} catch (Exception e) {
			// The font section is corrupt
			System.out.println("Font section corrupt " + e);
			// This section will be expanded for multiple exception types
		}

		jmSections.put("FontFace", "true");

	}

	/**
	 * Read in the selected external browers/viewers
	 * to deal with special file formats, etc.
	 */
	public void Browser(String temp1) {
		// Assign the browser
            // This section does not check to see if the location is valid or not
            String status = "false";
		if (temp1.equals("empty")) {
                    temp1 = new String("");
                } else {
                    // separate the browser from it's "separate instance" tag
                    if (temp1.endsWith("true")) {
                        status = new String("true");
                    }
                    try {
                        temp1 = temp1.substring(0, temp1.lastIndexOf('*'));
                    } catch(Exception z) {
                        System.out.println("Uh-oh: " + z);
                    }

                }
		if (temp1.startsWith("[")) {
			// This is a faulty entry
		} else {
			// Determine if this is to be the 
			// primary browser, or the secondary
			if (sectionFlag == 9) {
                            settings.setBrowser("Browser1", temp1);
                            settings.setBrowserInstance("Browser1", status);
			} else {
                            settings.setBrowser("Browser2", temp1);
                            settings.setBrowserInstance("Browser2", status);
			}
		}
	}

	public void FTPClient(String temp1) {
		// Set the FTP client location
		if (temp1.equals("empty")) {
			temp1 = new String("");
		}

                settings.setBrowser("FTPClient", temp1);
	}

	public void EMailClient(String temp1) {
		// Set E-Mail Client location
		if (temp1.equals("empty")) {
			temp1 = new String("");
		}

                settings.setBrowser("EMailClient", temp1);
	}	

	/** Set the Timers key */
	/** This was all wrong!  We need the size of the timer window!!! */
	public synchronized void JMTimers(String temp1) {
            settings.setTimersVisible(temp1.toLowerCase());
            temp1 = readParse();
            temp2 = readParse();
            temp3 = readParse();
            temp4 = readParse();

            // Check to see if any of of these values contain flags
            if (temp1.startsWith("[") || temp2.startsWith("[") || temp3.startsWith("[") || temp4.startsWith("[")) {
				// Improperly formatted main text area window
				sectionFlag = 0;
				return;
			}

		// We will only get here if there is indeed a 'Timers' section
            settings.setTimers(new Rectangle(Integer.parseInt(temp1),
                                                      Integer.parseInt(temp2),
                                                      Integer.parseInt(temp3),
                                                      Integer.parseInt(temp4)));
            jmSections.put("Timers", "true");
	}

	/** Set the SyncWindows key */
	public synchronized void JMSyncWindows(String temp1) {
            settings.setSyncWindows(temp1);
            jmSections.put(settings.TFKEYEMU, "true");
	}

	/** Set the TinyFugue Key Emulation item */
	public void JMTFKeyEmu(String temp1) {
            settings.setTFKeyEmu(temp1);
            jmSections.put(settings.TFKEYEMU, "true");
	}

	/**
	 * Determine whether JamochaMUD should use Unicode or ASCII
	 * to send strings to the MUD/MUCK Server
	 */
	public void JMUseUnicode(String temp1) {
            settings.setUseUnicode(temp1);
            jmSections.put(settings.UNICODE, "true");
	}	

        /** Set the DoubleBuffer item */
        public void JMSetDoubleBuffer(String temp1) {
            settings.setDoubleBuffer(temp1);
            jmSections.put(settings.DOUBLEBUFFER, "true");
        }

        /** Are we using the consolidated view, or the split view? */
        public void JMSetSplitView(String temp1) {
            settings.setSplitView(temp1);
            jmSections.put(settings.SPLITVIEW, "true");
        }

        public void JMSetReleasePause(String temp1) {
            settings.setReleasePause(temp1);
            jmSections.put(settings.RELEASEPAUSE, "true");
        }

	/**
	 * Read in and configure proxy support for JamochaMUD
	 */
	public void JMSetProxy(String temp1) {

            // Properties sP = System.getProperties();
            if (temp1.toLowerCase().equals("true")) {
                // sP.put("proxySet", "true");
                settings.setProxy(true);
            } else {
                // sP.put("proxySet", "false");
                settings.setProxy(false);
            }

            temp2 = readParse();
            if (temp2.toLowerCase().equals("null")) {
                // sP.put("proxySet", "false");
                settings.setProxy(false);
            } else {
                // sP.put("proxyHost", temp2);
                settings.setProxyHost(temp2);
                temp3 = readParse();
                // sP.put("proxyPort", temp3);
                settings.setProxyPort(temp3);
            }
            jmSections.put(settings.PROXY, "done");

        }

	/**
	 * Section to create .jamocha.rc if one doesn't exist.
	 * Prompt user to make sure this is okay, if not
	 * program will end (can't think of anything else to do, otherwise, hee!)
	 */
	public void CreateRC() {
            // Prompt user that a .jamocha.rc file will be created
            // Fix this XXX
            // MuckConn.jmVars.put("Okay", "true");
            // MuckConn.jmVars.put("Cancel", "true");
            // MuckConn.jmVars.put("Ignore", "false");
            Vector tempVector = new Vector();
            // OKBox.RunOkay(workingFrame, null, null, false, false, null, null, true, RBL("createSettingsFile"), "Create file .jamocha.rc (settings file) ?", 300, 250);
				
            // if (((String)MuckConn.jmVars.get("Okay")).equals("true")) {
            // Fix this XXX
            // boolean sayYes = true;

            // This is a hack to give the dialogue a "frame" to float above
            workingFrame = new Frame();

            OKBox check = new OKBox(workingFrame, "Create file .jamocha.rc (settings file) ?", true);
            // Add in some other settings here

            Vector tempText = RBL("createSettingsFile");
            for (int j = 0; j < tempText.size(); j++) {
                check.append((String)tempText.elementAt(j) + '\n');
            }

            check.addButton(check.OKAY);
            check.addButton(check.CANCEL);

            check.show();

            if (check.getResult().equals(check.OKAY)) {
                File rcFile = new File(settings.getUserDirectory());

                // First, we see if the directory exists
                if (!rcFile.exists()) {
                    // Create a new user directory
                    rcFile.mkdir();
                }

                // The user has okay'd the creation of the file
                try {
                    outFile = new FileOutputStream(settings.getUserDirectory() + ".jamocha.rc", false);
                    out = new PrintWriter(outFile, true);
                    out.println("# JamochaMUD INI file version 1.0");
                    out.println("# Format is MU* name, MU* address (either name or IP), MU* port");
                    out.println("");
                    outFile.close();
                } catch (Exception e) {
                    System.out.println("Error in initial creation of .jamocha.rc");
                    System.out.println(e);
                }
            } else {
                System.exit(0);
            }
        }

	/**
	 * Create a new Worlds section in the .jamocha.rc file
	 */
	public void NewWorlds() {
		out.println("[Worlds]");
		out.println("FurryMuck");
		out.println("muck.furry.com");
		out.println("8888");
		out.println("");
		muckName.addElement("FurryMuck");
		muckAddy.addElement("muck.furry.com");
		muckPort.addElement("8888");

	}

	/** 
	 * Create a new ForeGround Colour section in .jamocha.rc file
	 */	
	public void NewFGColour() {
		out.println("# Foreground colour, format of Red, Green, Blue");
		out.println("# Maximum values of 255, minimum of 0, each");
		out.println("[FGColour]");
		out.println("0");
		out.println("255");
		out.println("85");
		out.println("");
                settings.setForegroundColour(new Color(0, 255, 85));
		
	}

	/**
	 * Set a new background colour in the .jamocha.rc file
	 */
	public void NewBGColour() {				
		out.println("#Background colour, format of Red, Green, Blue");
		out.println("# Maximum values of 255, minimum of 0, each");
		out.println("[BGColour]");
		out.println("0");
		out.println("0");
		out.println("0");
		out.println("");
                settings.setBackgroundColour(new Color(0, 0, 0));
				
	}
	
	/**
	 * Set up a new Main Window (output) section in .jamocha.rc
	 */
	public void NewMainWindow() {
		out.println("# Format of X location, Y location, Width, and height");
		out.println("[MainWindow]");
		out.println("0");
		out.println("10");
		out.println("600");
		out.println("355");
		out.println("");
                settings.setMainWindow(new Rectangle(0, 10, 600, 355));

	}

	/** 
	 * Create a new Data Bar (input window) section in .jamocha.rc
	 */
	public void NewDataBar() {
		out.println("# Format of X location, Y location, Width, and height");
		out.println("[databar]");
		out.println("0");  // Left edge of databar
		out.println("385");  // Top edge of databar
		out.println("600");  // Width of databar
		out.println("60");  // Height of databar
		out.println("");
                settings.setDataBar(new Rectangle(0, 385, 600, 60));
	}

        public void NewTimers() {
            out.println("[timers]");
            out.println("true");
            out.println("500");       // Left edge of timers
            out.println("300");
            out.println("120");
            out.println("100");
            settings.setTimers(new Rectangle(500, 300, 120, 100));
        }

	/**
	 * Create a new Macro Bar section in .jamocha.rc
	 */
	public void NewMacroBar() {
		out.println("# Format of (boolean) window visible, X location, Y location, Width, and height");
		out.println("[macrobar]");
		out.println("true");
		out.println("445");
		out.println("30");
		out.println("175");
		out.println("165");
		out.println("");
                settings.setMacroVisible(true);
                settings.setMacroFrame(new Rectangle(445, 30, 175, 165));
			
	}

	/**
	 * Create a new Font section in .jamocha.rc
	 */
	public void NewFontFace() {
		out.println("# Format of Font Type, Font Style, and Font Size");
		out.println("[FontFace]");
		out.println("Monospaced");
		out.println("0");
		out.println("12");
		out.println("");
                settings.setFontFace(new Font("Monospaced", 0, 12));
        }

//        public void NewSplitView() {
//            out.println("# the view is split (true) or consolidated (false)");
//            out.println("[SplitView]");
//            out.println("true");
//            out.println("");
//            settings.setSplitView(true);
//        }

	/**
	 * Add a new Macros section to .jamocha.rc
	 */	
	public void NewMacros() {
		
		String mLabel[] = new String[8];
		String mDef[] = new String[8];
	
		for (int i = 0; i < 8; i++) {
			mLabel[i] = ("Macro" + (i + 1));
			mDef[i] = ("");
		}
                settings.setMacroLabels(mLabel);
                settings.setMacroDefs(mDef);

		// As of 12/09/98, this method has been altered to serialise
		// macros in the .macros.rc file, instead of placing them in
		// the basic .jamocha.rc file
		try {
                    FileOutputStream outputFile = new FileOutputStream(settings.getUserDirectory() + ".macros.rc");
                    ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
                    serializeStream.writeObject(mLabel);
                    serializeStream.writeObject(mDef);
                    serializeStream.flush();
                } catch (Exception e) {
                    System.out.println("Macro serialization error " + e);
                }

	}

	/**
	 * Read in the serialised macros.  This method, as of 98/12/09 replaces
	 * the older method of storing macros in the .jamocha.rc file
	 */
	public void ReadSerialisedMacros() {

		try {
                    FileInputStream inputFile = new FileInputStream(settings.getUserDirectory() + ".macros.rc");
                    ObjectInputStream serializeStream = new ObjectInputStream(inputFile);

                        settings.setMacroLabels((String[]) serializeStream.readObject());
                        settings.setMacroDefs((String[]) serializeStream.readObject());

		} catch (FileNotFoundException e) {
			// The file does not exist, but will be written later
			// This is not a bad thing
			// We'll create the info needed now:
			NewMacros();
				
			return;	
		} catch (Exception e) {
			System.out.println("Error during serialization " + e);
			// The file probably does not exist
			// We'll create the info needed now:
			NewMacros();
			return;
		}

	}

	/**
	 * Add a new proxy section to .jamocha.rc
	 */
        public void NewProxy() {
            out.println("[Proxy]");
            out.println("false");
            out.println("null");
            out.println("");
	}

        /** Add a new DoubleBuffer section to .jamocha.rc */
//        public void NewDoubleBuffer() {
//            out.println("[DoubleBuffer]");
//            out.println("true");
//            out.println("");
//            settings.setDoubleBuffer(true);
//        }

	/**
	 * This is a generic bit to access the
	 * ResReader.class, for localization
	 * (Multi-language support)
         */
        private static String RB(String itemTarget) {
            ResReader reader = new ResReader();
            // return reader.LangString("JamochaMUDBundle", itemTarget);
            return reader.LangString(JMConfig.BUNDLEBASE, itemTarget);
        }
        // This supports multi-line messages
        private static Vector RBL(String itemTarget) {
            ResReader reader = new ResReader();
            // return reader.LangVector("JamochaMUDBundle", itemTarget);
            return reader.LangVector(JMConfig.BUNDLEBASE, itemTarget);
        }

}

