/**
 * JMUD for JamochaMUD is the "main" section for JamochaMUD
 * $Id: JMUD.java 1.7 2001/07/11 05:02:33 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2001 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

import anecho.gui.JMText;
import anecho.gui.SyncFrame;
import anecho.gui.SyncFrameGroup;

public class JMUD {

    public static CHandler connections;  // This class will handle all our connections
    public static JMConfig settings;  // This class contains all our settings
    public MuckMain mainFrame;          // Our main text window
    // public SyncFrame inputFrame;        // A Frame to hold our DataIn class
    public DataIn inputFrame;
    public EnumPlugIns enum;
    public SyncFrameGroup frameGroup;   // Our SyncFrame group

    /** The main method for JamochaMUD.  This is where it all begins! */
    public static void main(String[] args) {
        // Create a new instance of our program for your running pleasure!
        JMUD proggy = new JMUD();
        // Bye-bye
    }

    // public void run() {
    public JMUD() {
        // Create our "settings" container
        settings = new JMConfig();

        // Let's put ourselves in the settings, so we're accessable for a QUIT or somethin'
        settings.setJMCore(this);

        // Get our system information
        getSysInfo();

        // Read in our "profile"
        getSettings();

//        // Create a connection handler
        //        connections = new CHandler(this, settings);
        // Read in our plugins
        // enum = new EnumPlugIns(settings);
        // loadPlugins();

        frameGroup = new SyncFrameGroup();
        // Create the frame/frames for JamochaMUD
        mainFrame = new MuckMain(settings);
        frameGroup.add(mainFrame);
        settings.setMainWindowVariable(mainFrame);

        // inputFrame = new SyncFrame("Fix this XXX", true, null);
        // inputFrame = new DataIn("Fix this XXX", true, null, settings);
        inputFrame = new DataIn(settings);
        frameGroup.add(inputFrame);
        settings.setDataInVariable(inputFrame);

        // Create a connection handler
        connections = new CHandler(settings, mainFrame);
        settings.setConnectionHandler(connections);

        // Set the visual state of our components
        setupFrames();

        loadPlugins();

        // mainFrame.setVisible(true);
        // inputFrame.setVisible(true);

        // Present the Muck Connector the first time

        // Do any necessary clean-up
    }

    /** Read in our settings.  We make this a separate method
     * in hopes that it will fall out of scope and destroy our
     * JMParseRC class when it is done... */
    private void getSettings() {
        // We'll pass our 'settings' variable to get things set up correctly
        new JMParseRC(settings);
    }

    /** Gather system-specific information about the platform
     * we're running on */
    private void getSysInfo() {
        new SysInfo(settings);
    }

    /** Setup the visual elements for the user */
    private void setupFrames() {
        // Get our name.  Fix this XXX
        settings.setMuckMainTitle("JamochaMUD");

        // Set the size of our windows
        mainFrame.setBounds(settings.getMainWindow());
        inputFrame.setBounds(settings.getDataBar());

        boolean sync = settings.getSyncWindows();
        // Do this for now, but fix the setGroupSynx function in SyncFrame/SyncGroup!!!
        // Fix me XXX
        mainFrame.setSyncFrameGroup(frameGroup);
        inputFrame.setSyncFrameGroup(frameGroup);
        mainFrame.setSync(sync);
        inputFrame.setSync(sync);

        // Set the "exit" function on the main window
        // mainFrame.setCloseState(true);
    }

    private void loadPlugins() {
        enum = new EnumPlugIns(settings);
        settings.setPlugEnumerator(enum);
        enum.LoadPlugIns();
    }

    /** This method collects all the data needed to write
     * a new .rc file of the user's settings, and do
     * any other necessary clean-up */
    public void quitJamochaMUD() {
        // Gather all our settings that remain.
        Rectangle test;

        test = mainFrame.getBounds();
        if (checkVisible(test)) {
            settings.setMainWindow(test);
        }

        test = inputFrame.getBounds();
        if (checkVisible(test)) {
            settings.setDataBar(test);
        }

        JMWriteRC done = new JMWriteRC(settings);
        done.writeRCToFile();
        System.exit(0);
    }

    /** Check the bounds of our rectangle to see if it is visible
     * or not.  This is basically a hack, but better'n nothing.
     */
    private boolean checkVisible(Rectangle testRect) {
        int x, y;   // Our location on the screen
        x = testRect.x;
        y = testRect.y;

        if (x < 0 || y < 0) {
            // Our object is probably minimised, so use the settings from JMConfig
            return false;
        }

        // Our object is probably visible on-screen, so we'll return true
        return true;
    }

    /** Change our fonts globally across all windows */
    public void setAllFonts(Font newStyle) {
        // Change the font style of all our connections
        connections.setAllFonts(newStyle);

        // Change the font style of the input bar
        inputFrame.setFont(newStyle);
    }

    /** Change our colours globally across all windows */
    public void setAllColours(Color fg, Color bg) {
        // Change the colours of our connections
        connections.setAllColours(fg, bg);

        // set the colour of our input frame
        inputFrame.setBackgroundColour(bg);
        inputFrame.setForegroundColour(fg);
    }

    /** Change the synchronisation status of our windows */
    public void setAllSync(boolean sync) {
        settings.setSyncWindows(sync);
        mainFrame.setSync(sync);
        inputFrame.setSync(sync);
    }

    /** Change the main title */
    public void setMainWindowTitle() {
        // settings.setMuckMainTitle(title);
        mainFrame.setWindowTitle();
        inputFrame.setWindowTitle();
    }
}
