/**
 * WriteRC, a replacement for WriteINI (January 17, 1999)
 * Write .jamocha.rc from all information available
 * $Id: JMWriteRC.java 1.7 2002/02/02 02:59:13 jeffnik Exp jeffnik $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Font;
import java.awt.Rectangle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

	/**
	 * WriteRC, a replacement for WriteINI (January 17, 1999)
	 * Write .jamocha.rc and from all
	 * from all information available
         * @version $Id: JMWriteRC.java 1.7 2002/02/02 02:59:13 jeffnik Exp jeffnik $
         * @author Jeff Robinson
	 */
public class JMWriteRC{

	private boolean readLoop;
	private File oldFile, renamedFile;
	private FileOutputStream outFile;
	private Hashtable jmSections;
	private PrintWriter out;
	private String str;
	private RandomAccessFile file;
        private Vector oldRC, newFile;
        private JMConfig settings;
	

        public JMWriteRC(JMConfig mainSettings){
            this.settings = mainSettings;
        }

        public synchronized void writeRCToFile() {
            jmSections = new Hashtable();

            readLoop = true;
            oldRC = new Vector(0, 1);
            newFile = new Vector(0, 1);

            // Read the existing INI file into a vector
            // adding the new information when applicable
            try {
                // First make sure the vector is empty
                newFile.removeAllElements();

                // Now try to open the file
                file = new RandomAccessFile(settings.getUserDirectory() + ".jamocha.rc", "r");
                while (readLoop) {
                    str = (file.readLine()).trim();

                    // Check to see if it's a comment, blank space
                    // or a flag.
                    try {
                        if (str.startsWith("#") || str.startsWith("[")) {
                            // The string starts with # or [, so we keep it!
                            oldRC.addElement(str);
                        }

                    } catch (Exception ns) {
                        // Null string.  Replace with a blank line
                    }
                }
            } catch (Exception e) {
                // End of file
                readLoop = false;
            }

            try {
                // close .jamocha.rc
                file.close();
            } catch (Exception e) {
                // File is already closed?
            }

            // Add the new information to the new vector
            JMBuildNewRC();

            // Now it is time to write this information to a new temp file
            try {
                outFile = new FileOutputStream(settings.getUserDirectory() + ".jamocha.rc.temp", false);
                out = new PrintWriter(outFile, true);

                // Loop through until all the information is written out
                for (int i = 0; i<newFile.size(); i++) {
                    out.println(newFile.elementAt(i).toString());
                }
                outFile.close();
            } catch (Exception e) {
                System.out.println("JMWriteRC: (outFile) Exception generated : " + e);
                e.printStackTrace();
            }

            // We've written the temporary file.
            // now copy this file onto the original

            try {
                RandomAccessFile from = new RandomAccessFile(settings.getUserDirectory() + ".jamocha.rc.temp", "r");
                RandomAccessFile to = new RandomAccessFile(settings.getUserDirectory() + ".jamocha.rc", "rw");
                int b;
                while((b = from.read()) >= 0){
                    to.write(b);
                }

                try {
                    to.close();
                } catch (Exception ce) {
                    System.out.println("JMWriteRC: to.close exception");
                }

                try {
                    from.close();
                } catch (Exception ce) {
                    System.out.println("JMWriteRC: from.close exception");
                }

            } catch (Exception e) {
                System.out.println("JMWriteRC: Renaming file exception : " + e);
            }

            // We have successfully written the .rc file
            // and it is now safe to delete the temp file
            try {
                File tempFile = new File(settings.getUserDirectory() + ".jamocha.rc.temp");
                tempFile.delete();
            } catch (Exception de) {
                System.out.println("Temp file delete exception " + de);
            }

            // Last but not least, lets serialise the macros
            SerialiseMacros();

        }

	// These section will each write the data for their relevant area
	/**
	 * Write the list of worlds out to .jamocha.rc
	 */
	private void WriteWorlds() {
		newFile.addElement("[Worlds]");

		Vector muckName = new Vector(0, 1);
		Vector muckAddy = new Vector(0, 1);
		Vector muckPort = new Vector(0, 1);
                muckName = settings.getMuckName();
                muckAddy = settings.getMuckAddy();
                muckPort = settings.getMuckPort();

		// loop through until all worlds are gone		
		for (int i = 0; i < muckName.size(); i++) {
			// Add all the world elements to the vector

			try {
				Add(muckName.elementAt(i));
				Add(muckAddy.elementAt(i));			
				Add(muckPort.elementAt(i));
			} catch (Exception e) {
				System.out.println("JMWriteRC: Exception writing worlds " + e);
			}

			newFile.addElement("");
		}

		jmSections.put("MUWorlds", "false");
	}

	/**
	 * Write the foreground colour of the text areas out to .jamocha.rc
	 */
	private void WriteForegroundColour() {
            // Get the colour of the font from the window
            // Color tempColour = MuckMain.mainText.getForeground();
            Color tempColour = settings.getForegroundColour();
		
		Add("[FGColour]");
		Add(tempColour.getRed());
		Add(tempColour.getGreen());
		Add(tempColour.getBlue());
		Add("");
		jmSections.put("ForegroundColour", "false");
	}
	
	/**
	 * Write out the text area's background colours to .jamocha.rc
	 */
	private void WriteBackgroundColour() {
            // Get the colour of the font from the window
            //Color tempColour = MuckMain.mainText.getBackground();
            Color tempColour = settings.getBackgroundColour();
		
		Add("[BGColour]");
		Add(tempColour.getRed());
		Add(tempColour.getGreen());
		Add(tempColour.getBlue());
		Add("");
		jmSections.put("BackgroundColour", "false");
	}

	/**
	 * Write out the dimension and location of the Main (output) window
	 */
	private void WriteMainWindow() {
		newFile.addElement("[MainWindow]");
		
                writeRect(settings.getMainWindow());

		Add("");
		jmSections.put("MainWindow", "false");
	}

	/**
	 * Write the size and location of the databar (input) window to .jamocha.rc
	 */
	private void WriteDataBar() {
		Add("[DataBar]");

                writeRect(settings.getDataBar());
		Add("");
		jmSections.put("DataBar", "false");
	}

	/**
	 * Write the size and position of the Macro Window out to .jamocha.rc
	 */
	private void WriteMacroWindow() {
	
		// These two lines will be correct regardless
		Add("[Macrobar]");
			
                // if (MuckConn.jmMacros.getActiveState()) {
//                if (settings.getMacroVisible()) {
//			// Take the variables from the hashtable, the frame isn't visible
//			Add("true");
//			writeRect(MuckConn.jmMacros.getBounds());
//		} else {
//			// Take the variables from the frame, since it is visible
//			Add("false");
//                        writeRect(settings.getMacroFrame());
                //		}
                if (settings.getMacroVisible()) {
                    Add("true");
                } else {
                    Add("false");
                }
                writeRect(settings.getMacroFrame());
		// MacroBar isn't visible, so use the
		// information provided from the
		// static variables
		Add("");
		jmSections.put("MacroWindow", "false");				
	}

	/**
	 * Write the style of font used in the text areas to .jamocha.rc
	 */
	private void WriteFontFace() {
		Add("[FontFace]");
                Font temp = settings.getFontFace();
                Add(temp.getName());
                Add(temp.getStyle());
                Add(temp.getSize());
                Add("");
                jmSections.put("FontFace", "false");
	}

	/**
	 * Stub from the old version of .jamocha.rc, since macros are no longer
	 * contained with the .jamocha.rc, instead having their own .plugins.rc
	 */
	private void WriteMacros() {
	}

	/** 
	 * Write the browser locations to the .jamocha.rc file
	 */
	public void WriteBrowser(String number) {
		if (number.equals("1")) {
			Add("[Browser1]");
			try {
                            String temp1 = settings.getBrowser("Browser1");
                            if (temp1.equals("")) {
                                Add("empty");
                            } else {
                                // String status = new String();
                                if (settings.getBrowserInstance("Browser1")) {
                                    // status = "true";
                                    Add(temp1 + "*true");
                                } else {
                                    // status = "false";
                                    Add(temp1 + "*false");
                                }
                                // Add(temp1 + "*" + status);
                            }
                        } catch (Exception e) {
                            Add("empty");
                        }
			
                } else {
                    Add("[Browser2]");
                    try {
                        String temp1 = new String(settings.getBrowser("Browser2"));
                        if (temp1.equals("")) {
                            // temp1 = new String("empty");
                            Add("empty");
                        } else {
                            // String status = new String();
                            if (settings.getBrowserInstance("Browser2")) {
                                // status = "true";
                                Add(temp1 + "*true");
                            } else {
                                // status = "false";
                                Add(temp1 + "*false");
                            }
                            // Add(temp1 + "*" + status);
                        }
                    } catch (Exception e) {
                        Add("empty");
                        }
		}

		Add("");
	}

	/**
	 * Write the FTP Client location out to .jamocha.rc
	 */
	public void WriteFTPClient() {
		Add("[FTP Client]");
		
			// Add the configured client
			try {
                            String temp1 = new String(settings.getBrowser("FTPClient"));
                            if (temp1.equals("")) {
                                temp1 = new String("empty");
                            }
                            Add(temp1);
                        } catch (Exception e) {
                            Add("empty");
                        }

                        Add(" ");

        }

	/**
	 * Write the location of the E-mail client out to .jamocha.rc
	 */
	public void WriteEMailClient() {
		Add("[E-Mail Client]");
		
			try {
                            String temp1 = settings.getBrowser("EMailClient");
				if (temp1.equals("")) {
					temp1 = new String("empty");
				}
				Add(temp1);
			} catch (Exception e) {
				Add("empty");
			}

		Add(" ");

	}

	public void JMTimers() {
            Add("[Timers]");
            // Fix this XXX
            // if (MuckMain.timerThread.getActiveState()) {
            if (settings.getTimersVisible()) {
                Add("true");
                // writeRect(Timers.timerFrame.getBounds());
            } else {
                Add("false");
                // writeRect(settings.getTimers());
            }
            writeRect(settings.getTimers());
            Add(" ");
	}

	public void JMSyncWindows() {
		Add("[SyncWindows]");
                Add(settings.getSyncWindows() + "");
		Add(" ");
	}

	public void JMTFKeyEmu() {
		Add("[TFKeyEmu]");
                Add(settings.getTFKeyEmu() + "");
		Add(" ");
	}

	/**
	 * Write the user's preference to using Unicode or ASCII to .jamocha.rc
	 */
	public void JMUseUnicode() {
		Add("[Unicode]");
                Add(settings.getUseUnicode() + "");
		Add(" ");
	}

        /** Write the double-buffer setting */
        public void JMDoubleBuffer() {
            Add("[DoubleBuffer]");
            Add(settings.getDoubleBuffer() + "");
            Add(" ");
        }

        /** Write out the view state, split (true) or combined (false) */
        public void JMSplitView() {
            Add("[SplitView]");
            Add(settings.getSplitView() + "");
            Add(" ");
        }

        /** Write out the &quot;Release pause on copy" option */
        public void JMReleasePause() {
            Add("[ReleasePause]");
            Add(settings.getReleasePause() + "");
            Add(" ");
        }

	/**
	 * Serialise the user's macros to the .macros.rc file.
	 * This replaces the old method of WriteMacros
	 */
	public void SerialiseMacros() {
		// This new method (as of 12/09/98) will serialise the macro
		// labels and their associated actions
		try {
                    FileOutputStream outputFile = new FileOutputStream(settings.getUserDirectory() + ".macros.rc");
			ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
                        serializeStream.writeObject(settings.getMacroLabels());
                        serializeStream.writeObject(settings.getMacroDefs());
			serializeStream.flush();
		} catch (Exception e) {
			System.out.println("(JMWriteRC) Macro serialization error " + e);
		}

	}

	/**
	 * Write out the user's preference to Auto Focus Input (the MUD client
	 * automagicall shifting focus to the input box (Databar) when they type
	 */
	private void JMWriteAutoFocusInput() {
		Add("[AutoFocusInput]");
                Add(settings.getAutoFocusInput() + "");
		Add("");
		jmSections.put("AutoFocusInput", "false");
	}

        /** Write out our Local Echo variable */
        private void JMWriteLocalEcho() {
            Add("[LocalEcho]");
            Add(settings.isLocalEchoEnabled() + "");
            Add("");
            jmSections.put(settings.LOCALECHO, "false");
        }

	/** 
	 * Write out the proxy information to the .jamocha.rc file
	 */
        private void JMWriteProxy() {
		Add("[Proxy]");

                if (settings.getProxy()) {
                    Add("true");
                } else {
                    Add("false");
                }
                if (settings.getProxyHost() == "null" || settings.getProxyHost().equals("")) {
                    Add("null");
                } else {
                    Add(settings.getProxyHost());
                    Add(settings.getProxyPort() + "");
                }

		Add("");
                jmSections.put(settings.PROXY, "false");
	}

	/**
	 * Sorts the tags, making sure that the 
	 * current tag has not been already filled
	 */
	private void JMSortTags(String str) {
		if (str.equalsIgnoreCase("[worlds]") && !jmSections.containsKey("MUWorlds")) {
			WriteWorlds();
		}

		if (str.equalsIgnoreCase("[FGColour]") && !jmSections.containsKey(settings.FOREGROUNDCOLOUR)) {
			WriteForegroundColour();
		}

		if (str.equalsIgnoreCase("[BGColour]") && !jmSections.containsKey(settings.BACKGROUNDCOLOUR)) {
			WriteBackgroundColour();
		}

		if (str.equalsIgnoreCase("[mainwindow]") && !jmSections.containsKey("MainWindow")) {
			WriteMainWindow();
		}

		if (str.equalsIgnoreCase("[databar]") && !jmSections.containsKey("DataBar")) {
			WriteDataBar();
		}

		if (str.equalsIgnoreCase("[macrobar]") && !jmSections.containsKey("MacroWindow")) {
			WriteMacroWindow();
		}

		if (str.equalsIgnoreCase("[fontface]") && !jmSections.containsKey(settings.FONTFACE)) {
			WriteFontFace();
		}

		if (str.equalsIgnoreCase("[proxy]") && !jmSections.containsKey(settings.PROXY)) {
			JMWriteProxy();
		}

	}

	/**
	 * Build the new .jamocha.rc file, first filling a vector with
	 * the necessary information sections, and then writing
	 * it out to the actual file
	 */
	private void JMBuildNewRC() {
		// Build the new .rc vector
		// First, empty the newFile vector
		newFile.removeAllElements();
		String str;

		// Now loop through oldRC, and insert proper information when needed
		for (int i = 0; i < oldRC.size(); i++) {

			str = oldRC.elementAt(i).toString();
			if (str.startsWith("[")) {
				// This is a world tag... we'll see if it is valid
				JMSortTags(str);
			} else {
				// Check to see if this is a comment.
				// If not, discard the line.  (Double-checking never hurts)
				if (str.startsWith("#")) {
					Add(str);
				}
			}
		}
		// Add "constant" items
		JMTimers();
                JMWriteAutoFocusInput();
                JMWriteLocalEcho();
		JMSyncWindows();
		JMUseUnicode();
                JMTFKeyEmu();
                JMDoubleBuffer();
                JMSplitView();
                JMReleasePause();

		// now add the External programs
		WriteBrowser("1");
		WriteBrowser("2");
		WriteFTPClient();
		WriteEMailClient();
	}

	/** A method to add Objects (as strings) to the newFile vector */
	private void Add(Object newForVector) {
		newFile.addElement(newForVector.toString());
	}

	/** Any primitive integers must first be wrappered and then sent to 'Add(Object)' */
	private void Add(int convertInt) {
		Add(new Integer(convertInt));
	}

	/** A common method to write 'rectangles' to the .rc file */
	private void writeRect(Rectangle source) {
		Add((source.getLocation()).x);
		Add((source.getLocation()).y);
		Add(source.getSize().width);
		Add(source.getSize().height);
	}
}


