/**
 * ManagePlugins.java - A dialogue for managing plugins
 * $Id: ManagePlugins.java 1.9 2001/12/23 21:18:05 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import java.awt.*;
import java.awt.event.*;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

import java.util.Vector;

import anecho.gui.PosTools;
import anecho.gui.ResReader;

import anecho.JamochaMUD.plugins.PlugInterface;


	/**
	 * ManagePlugins.java - A dialogue for managing plugins
         * @version $Id: ManagePlugins.java 1.9 2001/12/23 21:18:05 jeffnik Exp $
         * @author Jeff Robinson
	 */
class ManagePlugins extends Dialog implements ActionListener, ItemListener{

	private Button gButton;
	private GridBagLayout managePluginsLayout;
	private GridBagConstraints constraints;
	private Label gLabel;
        // private static List activeList, inactiveList, fullList;
	private List activeList, inactiveList;
        private TextArea desc;
        private Dialog mPDialog;
        // private static ManagePlugins managePluginsFrame;
        private ManagePlugins managePluginsFrame;
        private JMConfig settings;
        private EnumPlugIns enum;       // Our "private" plug-in enumerator

        private String selectedPlugIn = new String();

        public ManagePlugins(Frame frameParent, JMConfig mainSettings) {
            // Create the dialog
		
            super(frameParent, "JamochaMUD - " + RB("ManagePlugins.title"), true);

            this.settings = mainSettings;
            this.enum = settings.getEnumerator(); // a pointer to our plugin enumerator

            managePluginsLayout = new GridBagLayout();
            constraints = new GridBagConstraints();
		
		// Set new layout
		
		setLayout(managePluginsLayout);

		// Display the list of selected pictures
		gLabel = new Label(RB("activePlugins"));
                    // constraints.gridwidth = 2;
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

		gLabel = new Label(RB("inactivePlugins"));
			// constraints.gridwidth = 2;
			constraints.gridwidth = 3;
			constraints.gridheight = 1;
			// constraints.gridx = 2;
			constraints.gridx = 3;
                        constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
		add(gLabel);

                // Fix this XXX
                /*
		gLabel = new Label(RB("allPlugins"));
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 0;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.SOUTHWEST;
			managePluginsLayout.setConstraints(gLabel, constraints);
                        add(gLabel);
                        */

		// Add the 3 list items
		activeList = new List();
			// constraints.gridwidth = 2;
			constraints.gridwidth = 3;
			constraints.gridheight = 8;
			constraints.gridx = 0;
			constraints.gridy = 1;
			constraints.weightx = 3;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(activeList, constraints);
                        activeList.addItemListener(this);
		add(activeList);

		inactiveList = new List();
			// constraints.gridwidth = 2;
			constraints.gridwidth = 3;
			constraints.gridheight = 8;
			// constraints.gridx = 2;
			constraints.gridx = 3;
			constraints.gridy = 1;
			constraints.weightx = 3;
			constraints.weighty = 0;
//			constraints.insets = new Insets(2, 2, 2, 2);
                        constraints.insets = new Insets(2, 2, 2, 7);
                        constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(inactiveList, constraints);
                        inactiveList.addItemListener(this);
		add(inactiveList);

                // Fix me XXX (probably remove fullList in the future, but right
                // now it is intermingled with a lot of other code
                // fullList = new List();
                /*
                constraints.gridwidth = 2;
			constraints.gridheight = 8;
			constraints.gridx = 4;
			constraints.gridy = 1;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.BOTH;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(fullList, constraints);
			fullList.addItemListener(this);
                        add(fullList);
                        */

		// Add the button for each column
		gButton = new Button(RB("removeWithArrows"));
		gButton.setActionCommand("remove");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);


		gButton = new Button(RB("addWithArrows"));
		gButton.setActionCommand("add");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("refresh"));
		gButton.setActionCommand("refresh");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 9;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(7, 2, 2, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
                        managePluginsLayout.setConstraints(gButton, constraints);
                        gButton.setEnabled(false);
		add(gButton);
		gButton.addActionListener(this);

		// Add the Okay and Cancel buttons
		gButton = new Button(RB("okay"));
		gButton.setActionCommand("okay");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 0;
			constraints.gridy = 10;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("cancel"));
		gButton.setActionCommand("cancel");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 2;
			constraints.gridy = 10;
			constraints.weightx = 0;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 2, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		gButton = new Button(RB("properties"));
		gButton.setActionCommand("properties");
			constraints.gridwidth = 2;
			constraints.gridheight = 1;
			constraints.gridx = 4;
			constraints.gridy = 10;
			constraints.weightx = 2;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 2, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(gButton, constraints);
		add(gButton);
		gButton.addActionListener(this);

		desc = new TextArea("", 4, 80, TextArea.SCROLLBARS_VERTICAL_ONLY);
                // constraints.gridwidth = GridBagConstraints.REMAINDER;
                // constraints.gridheight = GridBagConstraints.REMAINDER;
			constraints.gridwidth = 6;
			constraints.gridheight = GridBagConstraints.REMAINDER;
			constraints.gridx = 0;
			constraints.gridy = 11;
			constraints.weightx = 6;
			constraints.weighty = 1;
			constraints.insets = new Insets(2, 7, 7, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
			managePluginsLayout.setConstraints(desc, constraints);
                        add(desc);
                        desc.setEditable(false);

		pack();
	}

        /**
         * This is a generic bit to access the
         * ResReader.class, for localization
         * (Multi-language support)
         */
        private static String RB(String itemTarget) {
            ResReader reader = new ResReader();
            // return reader.LangString("JamochaMUDBundle", itemTarget);
            return reader.LangString(JMConfig.BUNDLEBASE, itemTarget);
        }
        // This supports multi-line messages
        private Vector RBL(String itemTarget) {
            ResReader reader = new ResReader();
            // return reader.LangVector("JamochaMUDBundle", itemTarget);
            return reader.LangVector(JMConfig.BUNDLEBASE, itemTarget);
        }

        public void actionPerformed(ActionEvent event){
            String arg = event.getActionCommand();

            if (arg.equals("remove")) {
                // Removed selected from list
                // Check to see if an item is selected first
                if (activeList.getSelectedItem() != null) {
                    inactiveList.add(activeList.getSelectedItem());
                    activeList.remove(activeList.getSelectedItem());
                }
            }

            if (arg.equals("add")) {
                // Add selected from list
                // Check to see if an item is selected first
                if (inactiveList.getSelectedItem() != null) {
                    activeList.add(inactiveList.getSelectedItem());
                    inactiveList.remove(inactiveList.getSelectedItem());
                }
            }

            if (arg.equals("okay")) {
                // Change active plugins

                // Write changes to the .plugins.rc file
                SetPlugInStatus();

                // managePluginsFrame.setVisible(false);
                this.setVisible(false);
                dispose();
            }

            if (arg.equals("cancel")) {
                // Close dialogue, make no changes
                this.setVisible(false);
                dispose();
            }

            if (arg.equals("properties")) {
                // Check to see if there is a selected plugin
                if (selectedPlugIn.equals("")) {
                    return;
                }
                // Call the properties menu for the selected plugin
                try {
                    // This is sloppy.  Fix this XXX!!
                    Object plugClass = EnumPlugIns.classByName(selectedPlugIn);
                    ((PlugInterface)plugClass).PlugInProperties();

                } catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("(ManagePlugins) Out of bounds exception");
                    // The array index was out of bounds
                    // Chances are no plugin was selected
                    // for properties to be viewed
                } catch (Exception e) {
                    System.out.println("(ManagePlugins) Plugin Property Exception " + e);
                    e.printStackTrace();
                }
            }

            if (arg.equals("refresh")) {
                // Call the refresh plugins method
                JMRefreshPlugIns();
            }

        }

        public void itemStateChanged(ItemEvent e) {
            String plugName;
            int choice = 0;

            // Make certain only one item is selected at a time
            if (e.getSource() == activeList) {
                inactiveList.deselect(inactiveList.getSelectedIndex());
                selectedPlugIn = activeList.getItem(activeList.getSelectedIndex());
            } else {
                activeList.deselect(activeList.getSelectedIndex());
                selectedPlugIn = inactiveList.getItem(inactiveList.getSelectedIndex());
            }

            // List list = e.getItem();
            // System.out.println(list + " " + '\n' + " "+ e);

            try {
                // We'll see if anything useful was selected
                // Fix this XXX!
                // choice = fullList.getSelectedIndex();
            } catch (Exception err) {
                System.out.println("ItemStateChanged exception " + err);
            }

            // Now that we have a selected item, we can continue
            // Fix this XXX!
            // String description = EnumPlugIns.Description(fullList.getItem(choice));
            String description = EnumPlugIns.Description(selectedPlugIn);

            // Set the description
            desc.setText(description);
            desc.setCaretPosition(0); // Just to make sure we can see the beginning
        }

	/**
	 * This reads in all the plugins and their settings (whether active/inactive)
	 * and then formats them to be displayed in the appropriate columns
	 */
        // private static void ListPlugins() {
        public void ListPlugins() {
            // This will fill the 3 lists with the appropriate info
            String tempName = new String();
            Vector plugInStatus = settings.getPlugInStatus();
            Vector plugInName = settings.getPlugInName();

            // First, we empty the existing lists
            activeList.removeAll();
            inactiveList.removeAll();
            // fullList.removeAll();

            // Now, loop through the names and fill the lists
            if (plugInName == null) return;

            for (int i = 0; i < plugInName.size(); i++) {
                // tempName = (String)EnumPlugIns.plugInName.elementAt(i);
                tempName = (String)plugInName.elementAt(i);
                // fullList.add(tempName);

                String temp = ((String)plugInStatus.elementAt(i)).toLowerCase();
                if (temp.equals("true")) {
                    // Plugin is active
                    activeList.add(tempName);
                } else {
                    // Plugin is inactive
                    inactiveList.add(tempName);
                }
            }

        }

        /**
         * Write the changes to the plugins to the .plugins.rc file
         */
        private void SetPlugInStatus() {
            // Make sure the plugInStatus vector is up to date
            String tempName;
            Vector plugInName = new Vector(0, 1);
            Vector plugInStatus = new Vector(0, 1);
            Vector activeListName = new Vector(0, 1);

            // Vector plugInStatus = settings.getPlugInStatus();
            Vector fullList = settings.getPlugInName();

            // Fix this XXX!!
            // for (int i = 0; i < fullList.getItemCount(); i++) {
            for (int i = 0; i < fullList.size(); i++) {
                // tempName = fullList.getItem(i);
                tempName = (String)fullList.elementAt(i);
                plugInName.addElement(tempName);
                plugInStatus.addElement("false");
                EnumPlugIns.plugInStatus.setElementAt("false", i);

                for (int j = 0; j < activeList.getItemCount(); j++) {
                    if (activeList.getItem(j).equals(tempName)) {
                        activeListName.addElement(tempName);
                        plugInStatus.setElementAt("true", i);
                        EnumPlugIns.plugInStatus.setElementAt("true", i);
                    }
                }

            }

            // Now write the changes to the .plugins.rc file
            try {
                FileOutputStream outputFile = new FileOutputStream(settings.getUserDirectory() + ".plugins.rc");
                ObjectOutputStream serializeStream = new ObjectOutputStream(outputFile);
                // serializeStream.writeObject(activeList);
                serializeStream.writeObject(activeListName);
                serializeStream.flush();
            } catch (Exception e) {
                System.out.println("Serialization error " + e);
            }

            // Now write the status to the hashtable
            settings.setPlugInName(plugInName);
            settings.setPlugInStatus(plugInStatus);
        }

        /**
         * Refresh the list of plugins to show any changes that may have
         * occured (adding, removing, etc).
         */
        private void JMRefreshPlugIns() {
            ListPlugins();
        }

}
