/** MuckConn - Muck Connector version 3
 * Handles the different muck addresses
 * and characters, and physical connection
 * Now as a separate class callable from other parts of JMUD
 * $Id: MuckConn.java 1.9 2001/12/23 02:07:39 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2001  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD;

import java.awt.*;
import java.awt.event.*;

import java.util.Hashtable;
import java.util.Vector;

import anecho.gui.SyncFrame;
import anecho.gui.SyncFrameGroup;
import anecho.gui.PosTools;
import anecho.gui.ResReader;

// import plugins.*;

	/** MuckConn - Muck Connector version 2
	 * Handles the different muck addresses
	 * and characters, and physical connection
         * @version $Id: MuckConn.java 1.9 2001/12/23 02:07:39 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class MuckConn implements ActionListener, WindowListener {

    private Vector editName = new Vector(0, 1);
    private Vector editAddy = new Vector(0, 1);
    private Vector editPort = new Vector(0, 1);

    private static Button connectButton;
    private static Choice jmMUNames;
    private SyncFrame jmMCFrame;
    private int minimizedLineCount;
    // Fix this legacy (public) junk!!! XXX
    public static Hashtable jmVars;
    private SyncFrameGroup syncGroup;
    private GridBagLayout muckConnLayout;
    private GridBagConstraints constraints;
    private Image jamochaMUDImage;
    private JMConfig settings;
    private CHandler connHandler;
    private String chosenName = null;
    private String chosenAddress = null;
    private int chosenPort;

    public MuckConn(CHandler callBack, JMConfig settings){
        this.connHandler = callBack;
        this.settings = settings;

        syncGroup = new SyncFrameGroup();
        muckConnLayout = new GridBagLayout();
        constraints = new GridBagConstraints();

        editName = settings.getMuckName();
        editAddy = settings.getMuckAddy();
        editPort = settings.getMuckPort();

        // Set new layout
        jmMCFrame = new SyncFrame("JamochaMUD (Connector)");
        jmMCFrame.addWindowListener(this);
        jmMCFrame.setCloseState(true);

        jmMCFrame.setLayout(muckConnLayout);

        jmMUNames = new Choice();
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1;
        constraints.weighty = 0;
        constraints.insets = new Insets(7, 7, 2, 7);
        constraints.fill = GridBagConstraints.BOTH;
        constraints.anchor = GridBagConstraints.CENTER;
        muckConnLayout.setConstraints(jmMUNames, constraints);
        jmMCFrame.add(jmMUNames);

        connectButton = new Button(RB("connect"));
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1;
        constraints.weighty = 0;
        constraints.insets = new Insets(2, 7, 2, 2);
        constraints.fill = GridBagConstraints.BOTH;
        constraints.anchor = GridBagConstraints.CENTER;
        muckConnLayout.setConstraints(connectButton, constraints);
        jmMCFrame.add(connectButton);
        connectButton.addActionListener(this);
        connectButton.setActionCommand("ConnectToMU");

        Button b = new Button(RB("addMU"));
        constraints.gridwidth = GridBagConstraints.RELATIVE;
        constraints.gridheight = 1;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.weightx = 1;
        constraints.weighty = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.fill = GridBagConstraints.BOTH;
        constraints.anchor = GridBagConstraints.CENTER;
        muckConnLayout.setConstraints(b, constraints);
        jmMCFrame.add(b);
        b.addActionListener(this);
        b.setActionCommand("AddMU");

        b = new Button(RB("removeMU"));
        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.gridheight = 1;
        constraints.gridx = 4;
        constraints.gridy = 1;
        constraints.weightx = 1;
        constraints.weighty = 0;
        constraints.insets = new Insets(2, 2, 2, 7);
        constraints.fill = GridBagConstraints.BOTH;
        constraints.anchor = GridBagConstraints.CENTER;
        muckConnLayout.setConstraints(b, constraints);
        jmMCFrame.add(b);
        b.addActionListener(this);
        b.setActionCommand("RemoveMU");

		b = new Button(RB("editMU"));
			constraints.gridx = 0;
			constraints.gridy = 2;
                        constraints.gridwidth = GridBagConstraints.RELATIVE;
			constraints.gridheight = 1;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 7, 7, 2);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
		jmMCFrame.add(b);
			muckConnLayout.setConstraints(b, constraints);
		b.addActionListener(this);
		b.setActionCommand("EditMU");

		b = new Button(RB("pingMU"));
                        constraints.gridwidth = GridBagConstraints.REMAINDER;
			constraints.gridheight = GridBagConstraints.REMAINDER;
			constraints.gridx = 3;
			constraints.gridy = 2;
			constraints.weightx = 1;
			constraints.weighty = 0;
			constraints.insets = new Insets(2, 2, 7, 7);
			constraints.fill = GridBagConstraints.NONE;
			constraints.anchor = GridBagConstraints.CENTER;
		jmMCFrame.add(b);
			muckConnLayout.setConstraints(b, constraints);
		b.setActionCommand("PingMU");
		b.addActionListener(this);
		b.setEnabled(false);

                Point sp = PosTools.findCentre();
                jmMCFrame.setLocation(sp.x - 237, sp.y - 185);
                jmMCFrame.setSize(475, 370);

                jmMCFrame.pack();

                // Add the list of MU*s, set the icon, etc.
                JMStartUp();
                jmMCFrame.setVisible(true);

	}

    public void actionPerformed(ActionEvent event){

        String arg = event.getActionCommand();

        if (arg.equals("ConnectToMU")) {
            // Connect to the MU* displayed
            JMConnectToMU();
        }

        if (arg.equals("EditMU")) {
            // Edit the MU*
            JMEditMU();
        }

        if (arg.equals("RemoveMU")) {
            // Remove the MU*
            JMRemoveMU();
        }

        if (arg.equals("AddMU")) {
            // Add MU*
            JMAddMU();
        }

        if (arg.equals("PingMU")) {
            // Ping the MU*
        }

    }

    public void windowActivated(WindowEvent event) {}

    public void windowClosed(WindowEvent event) {}

    public void windowClosing(WindowEvent event) {
        // If there are active connections then we'll just close this
        // dialogue and return to the action!  Otherwise, we'll
        // shut down the entire program

        // There may be a better way of doing this.  Fix Me XXX
        CHandler connHandler = settings.getConnectionHandler();
        if (connHandler.totalConnections() > 0) {
            jmMCFrame.setCloseState(false);
            jmMCFrame.setVisible(false);
            jmMCFrame.dispose();
            // event.consume();
            return;
        }
    }

    public void windowDeactivated(WindowEvent event) {}

    public void windowDeiconified(WindowEvent event) {}

    public void windowIconified(WindowEvent event) {}

    public void windowOpened(WindowEvent event) {}
    /**
     * This is a generic bit to access the
     * ResReader.class, for localization
     * (Multi-language support)
     */
    private static String RB(String itemTarget) {
        ResReader reader = new ResReader();
        // return reader.LangString("JamochaMUDBundle", itemTarget);
        return reader.LangString(JMConfig.BUNDLEBASE, itemTarget);
    }

    /**
     * Call the methods necessary for the user to add
     * a new MUD/MUCK to the list of worlds
     */
    private void JMAddMU() {

        int i = jmMUNames.getSelectedIndex();

        // Call the AddEdit box
        AddEdit addMU = new AddEdit(jmMCFrame, RB("addMU"));
        addMU.setSize(280, 160);
        addMU.setLocation(PosTools.findCentre(jmMCFrame, addMU));
        addMU.setVisible(true);

        if (addMU.isOkay()) {
            String jmEditName = addMU.getName();
            String jmEditAddy = addMU.getAddress();
            String jmEditPort = addMU.getPort();

            jmEditName.trim();
            jmEditAddy.trim();
            jmEditPort.trim();

            if (!jmEditName.equals("") && !jmEditAddy.equals("") && !jmEditPort.equals("")) {
                // Check to see if the first entry is a 'valid'
                // MU*, or just a place-marker
                if (editName.elementAt(0).equals("None") & editAddy.elementAt(0).equals("----")) {
                    jmMUNames.removeAll();
                }

                // Add the new entry to the list of available MU*s
                editName.addElement(jmEditName);
                editAddy.addElement(jmEditAddy);
                editPort.addElement(jmEditPort);
                jmMUNames.addItem(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")");
                // Put new vector into the hashtable
                settings.setMuckName(editName);
                settings.setMuckAddy(editAddy);
                settings.setMuckPort(editPort);

                // Display new MU* in choice
                jmMUNames.select(jmMUNames.getItemCount() - 1);
                connectButton.requestFocus();

            }
        }

    }

    /**
     * Remove the currently selected MUD/MUCK from the list
     * of available worlds (and the .jamocha.rc file).
     */
    private void JMRemoveMU() {
        // Remove MU* from list
        Vector muckName = new Vector(0, 1);
        Vector muckAddy = new Vector(0, 1);
        Vector muckPort = new Vector(0, 1);
        muckName = settings.getMuckName();
        muckAddy = settings.getMuckAddy();
        muckPort = settings.getMuckPort();

        muckName.removeElementAt(jmMUNames.getSelectedIndex());
        muckAddy.removeElementAt(jmMUNames.getSelectedIndex());
        muckPort.removeElementAt(jmMUNames.getSelectedIndex());

        if (muckName.size() < 1) {
            jmMUNames.removeAll();
            muckName.addElement("None");
            muckAddy.addElement("----");
            muckPort.addElement("----");
            jmMUNames.addItem("None" + " (" + "----" + " Port: " + 					"----" + ")");
        } else {
            jmMUNames.remove(jmMUNames.getSelectedIndex());
        }

        // Now place the vectors back in the Hashtable
        settings.setMuckName(muckName);
        settings.setMuckAddy(muckAddy);
        settings.setMuckPort(muckPort);

    }

    /**
     * The user has opted to connect to the currently selected
     * MUD/MUCK, so we honour their wishes here!
     */
    private void JMConnectToMU() {

        Vector tempAddy = new Vector(0, 1);
        Vector tempPort = new Vector(0, 1);

        tempAddy = settings.getMuckAddy();
        tempPort = settings.getMuckPort();

        jmMCFrame.setVisible(false);

        MuckMain mm = settings.getMainWindowVariable();
        if (!mm.isVisible()) {
            mm.setVisible(true);
        }
        settings.setConnMuck(tempAddy.elementAt(jmMUNames.getSelectedIndex()).toString());
        settings.setConnPort(Integer.parseInt(tempPort.elementAt(jmMUNames.getSelectedIndex()).toString()));

        // chosenName = "Hmmm.";
        chosenName = editName.elementAt(jmMUNames.getSelectedIndex()).toString();
        chosenAddress = tempAddy.elementAt(jmMUNames.getSelectedIndex()).toString();
        chosenPort = (Integer.parseInt(tempPort.elementAt(jmMUNames.getSelectedIndex()).toString()));

        // Fix this XXX
        connHandler.OpenSocket(chosenName, chosenAddress, chosenPort);

        // Send the focus to out main program... just a nice thing to do
        settings.getMainWindowVariable().requestFocus();

        }

        /**
	 * Call the methods to allow the user to edit the MUD/MUCK
	 * Name/address/port of the currently selected world
	 */
	private void JMEditMU() {
            // edit current MU* entry
            AddEdit editBox = new AddEdit(jmMCFrame, RB("editMU"));

            int i = jmMUNames.getSelectedIndex();
            editBox.setName((String)editName.elementAt(i));
            editBox.setAddress((String)editAddy.elementAt(i));
            editBox.setPort((String)editPort.elementAt(i));
            editBox.setSize(280, 160);
            editBox.setLocation(PosTools.findCentre(jmMCFrame, editBox));
            editBox.setVisible(true);

            // Call the AddEdit box

            if (editBox.isOkay()) {
                String jmEditName = editBox.getName();
                String jmEditAddy = editBox.getAddress();
                String jmEditPort = editBox.getPort();

                jmEditName.trim();
                jmEditAddy.trim();
                jmEditPort.trim();

                if (!jmEditName.equals("") && !jmEditAddy.equals("") && !jmEditPort.equals("")) {
                    // Replace the edited MU* info
                    editName.removeElementAt(i);
                    editAddy.removeElementAt(i);
                    editPort.removeElementAt(i);

                    editName.insertElementAt(jmEditName, i);
                    editAddy.insertElementAt(jmEditAddy, i);
                    editPort.insertElementAt(jmEditPort, i);

                    // Put new vector into the hashtable
                    settings.setMuckName(editName);
                    settings.setMuckAddy(editAddy);
                    settings.setMuckPort(editPort);

                    // Replace the choice entry
                    jmMUNames.remove(i);
                    jmMUNames.insert(jmEditName + " (" + jmEditAddy + " Port: " + jmEditPort + ")", i);
                    jmMUNames.select(i);
                    connectButton.requestFocus();

                }
            }
        }

    /** Initialise all the starting windows and such
     *
     */
    private void JMStartUp() {

        // Read in the environmental variables
        MediaTracker tracker = new MediaTracker(jmMCFrame);
        jamochaMUDImage = Toolkit.getDefaultToolkit().getImage("kehza.gif");
        tracker.addImage(jamochaMUDImage, 0, 16, 16);
        try {
            tracker.waitForAll();
        } catch (Exception e) {
            System.out.println("Icon load error.  Exception " + e);
        }

        settings.setIconImage(jamochaMUDImage);

        jmMCFrame.setIconImage(jamochaMUDImage);

        // set up the Muck Name variables
        JMCompileNames();

    }

    /**
     * Gather system dependent variables
     * Such as screen size, user directories, etc.
     */
    /*
    private void JMSystem() {
        // Set screen size
        settings.setScreenSize(jmMCFrame.getToolkit().getScreenSize());

        // Set directory variables
        String userDirectory = new String("");
        java.util.Properties systemData = System.getProperties();
        String osName = new String(systemData.getProperty("os.name"));

        String pathSeparator = new String(java.io.File.separator);
        String sCurrentWorkingDir = new String(systemData.getProperty("user.dir") + pathSeparator);

        if (osName.toLowerCase().startsWith("windows") || osName.toLowerCase().startsWith("os/2") || osName.toLowerCase().startsWith("os/2") || osName.toLowerCase().startsWith("mac")) {
            // This is a single user environment
            System.out.println("JamochaMUD, single user configuration.");
            userDirectory = new String(systemData.getProperty("user.dir") + pathSeparator);
        } else {
            // This is a multi-user environment, put the
            // rc file in the user's home directory
            System.out.println("JamochaMUD... going multiuser");
            // Fix this XXX!  This may not work well
            // userDirectory = new String(systemData.getProperty("user.home") + pathSeparator + "JamochaMUD" + pathSeparator);
            userDirectory = new String(systemData.getProperty("user.home") + pathSeparator);
        }

        System.out.println("OS name: " + systemData.getProperty("os.name"));
        System.out.println("OS architecture: " + systemData.getProperty("os.arch"));
        System.out.println("OS version: " + systemData.getProperty("os.version"));
        System.out.println("User name: " + systemData.getProperty("user.name"));
        System.out.println("User home: " + systemData.getProperty("user.home"));
        System.out.println("User dir: " + systemData.getProperty("user.dir"));

        // Now stick all this data into the hashtable
        settings.setPathSeparator(pathSeparator);
        settings.setWorkingDirectory(sCurrentWorkingDir);
        settings.setUserDirectory(userDirectory);
        settings.setOSName(systemData.getProperty("os.name"));
        }
        */

    /**
     * Compile the MU* names
     * and then write them into the
     * choice of jmMCFrame
     */
    private void JMCompileNames() {
        // First grab the vectors
        Vector muckAddy = new Vector(0, 1);
        Vector muckName = new Vector(0, 1);
        Vector muckPort = new Vector(0, 1);

        muckName = settings.getMuckName();
        muckAddy = settings.getMuckAddy();
        muckPort = settings.getMuckPort();

        for (int i=0; i < muckName.size(); i++) {
            jmMUNames.addItem(muckName.elementAt(i) + " (" + muckAddy.elementAt(i) + " Port: " + muckPort.elementAt(i) + ")");
        }

    }

    public String getName() {
        return chosenName;
    }

    public String getAddress() {
        return chosenAddress;
    }

    public int getPort() {
        return chosenPort;
    }
}
