/**
 * Main Muck Output Window
 * $Id: MuckMain.java 1.22 2002/02/02 02:59:13 jeffnik Exp jeffnik $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2001  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.awt.event.ActionListener;
import java.net.*;
import java.io.*;
import java.util.*;

import anecho.gui.SyncFrame;
import anecho.gui.JMText;
import anecho.gui.ResReader;
import anecho.gui.PosTools;

import anecho.JamochaMUD.plugins.PlugInterface;

	/**
	 * Main Muck Output Window, heart of the program, containing
	 * most of the menus and logistics of JamochaMUD
         * @version $Id: MuckMain.java 1.22 2002/02/02 02:59:13 jeffnik Exp jeffnik $
         * @author Jeff Robinson
	 */
public class MuckMain extends SyncFrame implements ActionListener, ComponentListener, KeyListener, MouseListener, ItemListener, WindowListener{

    private CheckboxMenuItem tWMacro, tWSyncWindowsItem, tWUseUnicodeItem, tWTFKeysItem, tWLocalEchoItem, tWDoubleBufferItem, splitFramesItem;
    private CheckboxMenuItem tWAutoFocus, tWTimers, tWReleasePauseItem;

    static boolean pauseStatus, textWindowStatus;
    static BufferedReader input;
    public static MuckMain z;
    private Menu tWMUListMenu;
    private MenuItem cTM, dFM, rTM, closeMU;
    static Socket serverSock;
    private String muckMainTitle;
    private Vector tempVector;
    private MenuItem dumpOutputItem, quitItem;
    private MenuItem pingMUItem;
    private MenuItem copyItem, pasteItem, findItem;
    private MenuItem coloursItem, editOptionsItem, externalProgramsItem, managePlugIn, serverOptionsItem, showTimersItem, showMacroBarItem;
    private MenuItem contentsItem, troubleshootingItem, aboutJamochaMUDItem;
    protected static Menu tWPlugInMenu;
    public static final int COMBINED = 0;     // Combined frame style
    public static final int SPLIT = 1;        // Split frame style
    private int viewStyle = COMBINED;         // the current style of our display
    private GridBagLayout mainBagLayout;
    private GridBagConstraints constraints;
    private CardLayout textCardLayout;              // The layout manage that contains the MU* output
    private Panel textPanel;                  // A panel to hold our text-area (for use with the layout managers)
    private JMConfig settings;                // Our settings
    private static final int NEXT = 1;
    private static final int PREVIOUS = 0;

    public MuckMain(JMConfig mainSettings) {
        // Fix this XXX
        super("Main Window: Fix me XXX");

        this.settings = mainSettings;
        // Create the windows
        muckMainTitle = new String(RB("MuckMain.title"));
        boolean sync;
        textCardLayout = new CardLayout();
        textPanel = new Panel();
        textPanel.setLayout(textCardLayout);
        addComponentListener(this);
        addWindowListener(this);
        addKeyListener(this);
        // textPanel.addKeyListener(this);

        pauseStatus = false;
        tempVector = new Vector(0, 1);

        // Create a timer
        // Fix this XXX
        // timerThread = new Timers();

        // Create macros
        // Fix this XXX
        // MuckConn.jmMacros = new MuMacros();

        // Add Menu Bar and items to textWindow
        MenuBar tWMenuBar = new MenuBar();
        this.setMenuBar(tWMenuBar);
        Menu tWFileMenu = new Menu(RB("file"));
        tWMenuBar.add(tWFileMenu);
        tWFileMenu.add(dumpOutputItem = new MenuItem(RB("dumpOutput"), new MenuShortcut(KeyEvent.VK_D, false)));
        dumpOutputItem.setActionCommand(dumpOutputItem.getLabel());

        tWFileMenu.addSeparator();
        tWFileMenu.add(quitItem = new MenuItem(RB("quit"), new MenuShortcut(KeyEvent.VK_Q, true)));
        quitItem.setActionCommand(quitItem.getLabel());
        tWFileMenu.addActionListener(this);

        // Add the Edit menu items
        Menu tWEditMenu = new Menu(RB("edit"));
        tWMenuBar.add(tWEditMenu);
        // I'm making it the right key for OS/2, damn't!
        if (settings.getOSName().equals("OS/2")) {
        // if (settings.getJMString(settings.OSNAME).equals("OS/2")) {
            copyItem = new MenuItem(RB("copyFromMainWindow"), new MenuShortcut(KeyEvent.VK_INSERT, false));
        } else {
            copyItem = new MenuItem(RB("copyFromMainWindow"), new MenuShortcut(KeyEvent.VK_C, false));
        }
        copyItem.setActionCommand(copyItem.getLabel());
        tWEditMenu.add(copyItem);

        pasteItem = new MenuItem(RB("paste"), new MenuShortcut(KeyEvent.VK_V, false));
        pasteItem.setActionCommand(pasteItem.getLabel());
        tWEditMenu.add(pasteItem);

        tWEditMenu.addSeparator();

        findItem = new MenuItem(RB("find"), new MenuShortcut(KeyEvent.VK_F, false));
        findItem.setActionCommand(findItem.getLabel());
        findItem.setEnabled(false);
        tWEditMenu.add(findItem);
        tWEditMenu.addActionListener(this);


        // Add CONNECTION menu items
        Menu tWConnectMenu = new Menu(RB("connection"));
        tWMenuBar.add(tWConnectMenu);
        cTM = new MenuItem(RB("connectToMU"), new MenuShortcut(KeyEvent.VK_C, true)); // enable/disable functionality
        cTM.setActionCommand(cTM.getLabel());
        tWConnectMenu.add(cTM);

        rTM = new MenuItem(RB("reconnectToMU"), new MenuShortcut(KeyEvent.VK_R, true));
        rTM.setActionCommand(rTM.getLabel());
        tWConnectMenu.add(rTM);

        dFM = new MenuItem(RB("disconnectFromMU"), new MenuShortcut(KeyEvent.VK_D, true));  // enable/disable functionality
        dFM.setActionCommand(dFM.getLabel());
        dFM.setEnabled(false);
        tWConnectMenu.add(dFM);

        closeMU = new MenuItem(RB("closeThisView"));
        closeMU.setEnabled(false);
        tWConnectMenu.add(closeMU);

        tWConnectMenu.add(pingMUItem = new MenuItem(RB("pingMU")));
        pingMUItem.setEnabled(false);
        tWConnectMenu.addActionListener(this);

        Menu tWOptionMenu = new Menu(RB("options"));
        tWMenuBar.add(tWOptionMenu);

        // Add ****Edit Options**** Submenu
        Menu tWEditOptionsMenu = new Menu(RB("editOptions"));
        tWOptionMenu.add(tWEditOptionsMenu);
        tWEditOptionsMenu.add(externalProgramsItem = new MenuItem(RB("externalPrograms"), new MenuShortcut(KeyEvent.VK_E, false)));
        externalProgramsItem.setActionCommand(externalProgramsItem.getLabel());
        externalProgramsItem.setEnabled(false);

        tWEditOptionsMenu.add(managePlugIn = new MenuItem(RB("ManagePlugins.title"), new MenuShortcut(KeyEvent.VK_M, false)));
        managePlugIn.setActionCommand(managePlugIn.getLabel());
        tWEditOptionsMenu.add(serverOptionsItem = new MenuItem(RB("serverOptions")));
        tWEditOptionsMenu.addActionListener(this);

        tWOptionMenu.add(coloursItem = new MenuItem(RB("fontsAndColours"), new MenuShortcut(KeyEvent.VK_F, true)));
        coloursItem.setActionCommand(coloursItem.getLabel());

        // Continue with normal option menu
        tWOptionMenu.addSeparator();

        tWMacro = new CheckboxMenuItem(RB("showMacroBar"), false);
        tWOptionMenu.add(tWMacro);
        tWMacro.addItemListener(this);
        tWMacro.setEnabled(false);

        tWTimers = new CheckboxMenuItem(RB("showTimers"), false);
        tWTimers.setShortcut(new MenuShortcut(KeyEvent.VK_T, false));
        tWTimers.setActionCommand(tWTimers.getLabel());
        tWOptionMenu.add(tWTimers);
        tWTimers.addItemListener(this);
        tWTimers.addActionListener(this);
        // Fix this XXX!!
        tWTimers.setEnabled(false);

        splitFramesItem = new CheckboxMenuItem(RB("splitFrames"), false);
        tWOptionMenu.add(splitFramesItem);
        if (settings.getSplitView()) {
            viewStyle = SPLIT;
            splitFramesItem.setState(true);
        } else {
            viewStyle = COMBINED;
        }
        splitFramesItem.addItemListener(this);

        tWSyncWindowsItem = new CheckboxMenuItem(RB("syncWindows"), true);
        tWOptionMenu.add(tWSyncWindowsItem);
        tWSyncWindowsItem.addItemListener(this);
        tWSyncWindowsItem.setState(settings.getSyncWindows());

        tWOptionMenu.addSeparator();

        tWAutoFocus = new CheckboxMenuItem(RB("autoFocusInput"), true);
        tWOptionMenu.add(tWAutoFocus);
        tWAutoFocus.addItemListener(this);
        tWAutoFocus.setState(settings.getAutoFocusInput());

        tWLocalEchoItem = new CheckboxMenuItem(RB("localEcho"), true);
        tWOptionMenu.add(tWLocalEchoItem);
        tWLocalEchoItem.addItemListener(this);
        tWLocalEchoItem.setState(settings.isLocalEchoEnabled());

        tWDoubleBufferItem = new CheckboxMenuItem(RB("doubleBuffer"), true);
        tWOptionMenu.add(tWDoubleBufferItem);
        tWDoubleBufferItem.addItemListener(this);
        tWDoubleBufferItem.setState(settings.getDoubleBuffer());

        tWReleasePauseItem = new CheckboxMenuItem(RB("releasePause"), true);
        tWOptionMenu.add(tWReleasePauseItem);
        tWReleasePauseItem.addItemListener(this);
        tWReleasePauseItem.setState(settings.getReleasePause());

        tWTFKeysItem = new CheckboxMenuItem(RB("tinyFugueKeys"), true);
        tWOptionMenu.add(tWTFKeysItem);
        tWTFKeysItem.addItemListener(this);
        tWTFKeysItem.setState(settings.getTFKeyEmu());

        tWUseUnicodeItem = new CheckboxMenuItem(RB("useUnicode"), false);
        tWOptionMenu.add(tWUseUnicodeItem);
        tWUseUnicodeItem.addItemListener(this);
        tWUseUnicodeItem.setState(settings.getUseUnicode());

        // Add the ActionListener to this menu
        tWOptionMenu.addActionListener(this);


        // Add the Plug-in menu items
        tWPlugInMenu = new Menu(RB("plugIn"));
        tWMenuBar.add(tWPlugInMenu);
        tWPlugInMenu.addActionListener(this);

        // List for our active MU*s
        tWMUListMenu = new Menu(RB("MUList"));
        tWMenuBar.add(tWMUListMenu);
        tWMUListMenu.addActionListener(this);

        //Add HELP menu items
        Menu tWHelpMenu = new Menu(RB("help"));
        tWMenuBar.setHelpMenu(tWHelpMenu);
        tWHelpMenu.add(contentsItem = new MenuItem(RB("contents"), new MenuShortcut(KeyEvent.VK_H)));
        contentsItem.setActionCommand(contentsItem.getLabel());
        tWHelpMenu.add(troubleshootingItem = new MenuItem(RB("troubleshooting")));
        tWHelpMenu.addSeparator();
        tWHelpMenu.add(aboutJamochaMUDItem = new MenuItem(RB("aboutJamochaMUD")));
        tWHelpMenu.addActionListener(this);

        MediaTracker tracker = new MediaTracker(this);
        Image jamochaMUDImage = Toolkit.getDefaultToolkit().getImage("kehza.gif");
        tracker.addImage(jamochaMUDImage, 0);
        try {
            tracker.waitForAll();
        } catch (Exception e) {
            System.out.println("Icon load error.  Exception " + e);
        }
        this.setIconImage(jamochaMUDImage);

    }

    /**
     * This is a generic bit to access the
     * ResReader.class, for localization
     * (Multi-language support)
     */
    private static String RB(String itemTarget) {
        ResReader reader = new ResReader();
        // return reader.LangString("JamochaMUDBundle", itemTarget);
        return reader.LangString(JMConfig.BUNDLEBASE, itemTarget);
    }
    // This supports multi-line messages
    private static Vector RBL(String itemTarget) {
        ResReader reader = new ResReader();
        // return reader.LangVector("JamochaMUDBundle", itemTarget);
        return reader.LangVector(JMConfig.BUNDLEBASE, itemTarget);
    }

    public void actionPerformed(ActionEvent event){

        String arg = event.getActionCommand();

        if (arg.equals(RB("nextMU"))) {
            AdvanceMU(NEXT);
        }

        if (arg.equals(RB("previousMU"))) {
            AdvanceMU(PREVIOUS);
        }

            // Arguments for the ***FILE**** menu

            // Check for 'Dump Output'
            if (arg.equals(dumpOutputItem.getLabel())) {
                DumpOutput();
            }

            if (arg.equals(quitItem.getLabel())) {
                // Do the proper exit proceedure
                quitJamochaMUD();

                // Close the JVM
                System.exit(1);  // Probably an ugly exit
            }

            // Arguments for the **EDIT** menu

            /** Copy */
            if (arg.equals(copyItem.getLabel())) {
                copyToClipboard();
            }

            /** Paste */
            if (arg.equals(pasteItem.getLabel())) {
                pasteFromClipboard();
            }

            /** Find */

            // Arguments for the **CONNECTION**** menu

            /** Connect to MU* */
            if (arg.equals(cTM.getLabel())) {
                JMConnectToMU();
            }

            /** Reconnect to MU* */
            if (arg.equals(rTM.getLabel())) {
                JMReconnectToMU();
            }

            /** Disconnect from MU* */
            if (arg.equals(dFM.getLabel())) {
                JMDisconnectFromMU();
            }

            /** Close the visible MU "window" */
            if (arg.equals(closeMU.getLabel())) {
                closeActiveWindow();
            }

            /** Ping MU* */
            if (arg.equals(pingMUItem.getLabel())) {

            }

            // Arguments for ****OPTIONS**** menu

            if (arg.equals(coloursItem.getLabel())) {
                setColours();
                return;
            }

            if (arg.equals(externalProgramsItem.getLabel())) {
                showExtProgDialogue();
            }

            if (arg.equals(serverOptionsItem.getLabel())) {
                showProxyDialogue();
            }

            if (arg.equals(managePlugIn.getLabel())) {
                showPluginsDialogue();
            }

            // Arguments for ****HELP**** menu
            if (arg.equals(contentsItem.getLabel())) {
                StringBuffer tentativeURL = new StringBuffer(RB("jamochaMUDPages"));
                // FIx this XXX
                // ExternalProgs.LaunchProgram(textWindow, tentativeURL);
            }

            if (arg.equals(troubleshootingItem.getLabel())) {

				JMTroubleShooting();
            }

            if (arg.equals(aboutJamochaMUDItem.getLabel())) {
                ShowAboutBox();
            }

            // Check to see if we've had a request on the plugins menu
            if (event.getSource() == tWPlugInMenu) {
                // a request for the properties of a plugin has been made
                try {
                    // Fix the XXX
                    int selected = EnumPlugIns.plugInName.indexOf(event.getActionCommand());
                    Object plugClass = EnumPlugIns.plugInClass.elementAt(selected);
                    ((PlugInterface)plugClass).PlugInProperties();
                } catch (ArrayIndexOutOfBoundsException e) {
                    // No properties dialogue for this plugin
                    // MuckConn.jmVars.put("Okay", "true");
                    // MuckConn.jmVars.put("Cancel", "false");
                    // MuckConn.jmVars.put("Ignore", "false");
                    Vector tempVector = new Vector();
                    // OKBox.RunOkay(textWindow, null, null, false, false, null, null, true, RBL("noPlugInProperties"), "Mental Note...", 300, 250);
                }
            }

            // if (event.getSource() == tWMUListMenu) {
            if (event.getActionCommand().startsWith("ChangeMU:")) {
                // Make sure we tell the ConnHandler we're changing MU*s
                setActiveMU(event.getActionCommand());

                // This will show our active MU*
                setVisibleMU();

                // Update our connection menu
                updateConnectionMenu();

                // Update the Frame's title
                setWindowTitle();

                // Make sure the info shows up!
                validate();
            }

            return;
        }

        /**
         * Show a dialogue box to allow users to select a file
	 * to dump all of the output to for logging/archiving, etc...
	 */
	private void DumpOutput() {
		
		// Show the system dump dialogue
		// This will dump *all* the output to the selected file

            try {
                FileDialog dumpDialogue = new FileDialog(this, "Dump Output to file", 1);
                dumpDialogue.show();

                try {
                    String fileName = new String(dumpDialogue.getFile());

                    // File has been selected
                    // now write the output contents to it
                    try {
                        String filePath = new String(dumpDialogue.getDirectory());
                        FileOutputStream outFile = new FileOutputStream((filePath + fileName), false);
                        PrintWriter out = new PrintWriter(outFile, true);
                        CHandler connHandler = settings.getConnectionHandler();
                        JMText activeMU = connHandler.getActiveMUDText();
                        out.println(activeMU.getText());
                        out.flush();
                        outFile.close();
                    } catch (Exception fo) {
                        System.out.println("File output error " + fo);
                    }
                } catch (Exception e) {
                    // This occurs when there is a 'cancel' instead of a file selection
                    // We'll just gracefully fall through
                }

            } catch (Exception e) {
                // This occurs if the user hits 'cancel'
                // so we'll just end this sequence.
                System.out.println("MuckMain, final exception");
            }

        }

    // Check for mouse actions
    public void mousePressed(MouseEvent e) {
        PauseText();
    }

    public void mouseReleased(MouseEvent e) {
    }
    public void mouseClicked(MouseEvent e) {
        // Determine number of mouse clicks
        int a = e.getClickCount();

        if (a >= 2) {
            // Call outside routines (plug-ins) to handle the selected text
            e.consume();
            // Fix this XXX
            // MuckConn.typeHere.SpoolText();

            // grab the 'selected' URL
            // Fix this XXX
            // StringBuffer tentativeURL = new StringBuffer((mainText.getSelectedText()).trim());
            // System.out.println("Muckmain... using " + tentativeURL + " for external program.");

            // The frame is sent to anchor any potential dialogues
            // send the 'URL' to launch the correct program
            // Fix this XXX
            // ExternalProgs.LaunchProgram(textWindow, tentativeURL);

            // Deselect the text
            System.out.println("MuckMain: Deselect text?");
        } else {
            // A single click signals a pause
            // This will pause the output window,
            // the incoming lines held in queue
            PauseText();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent event){
        int arg = event.getKeyCode();
        if (!event.isAltDown() && !event.isControlDown()) {
            // Check to see if the user wants AutoFocus shift
            if (!tWAutoFocus.getState()) {
                event.consume();
            } else {
                transferFocus(event);

                // First we'll send the focus to the dataIn.dataText
                // Fix this XXX
                // MuckConn.typeHere.requestFocus();

                // if (event.getKeyCode() == KeyEvent.VK_ENTER) {
                // The user hit 'ENTER', send the text out
                // Fix this XXX
                // MuckConn.typeHere.JMSendText();
                // }

                // Slight problem with this tactic, as X-Windows does
                // not (always) allow focus traversal between frames, so
                // we'll just try sending the event directly as well.
                // String osName = MuckConn.settings.getOSName();
                // if (osName.toLowerCase().startsWith("windows") ||  osName.toLowerCase().startsWith("os/2")) {
                // Bleah!!
                //} else {
                // We'll do this all kludgy until
                // a better way can be found
                // We just append the text to DataIn.dataText, because
                // we cannot change focus.  If we can, the
                // 'requestFocus' from above will handle it

                // DataIn.dataText.append(event.getKeyChar() + "");
                // if (event.getKeyCode() != KeyEvent.VK_SHIFT && event.getKeyCode() != KeyEvent.VK_CONTROL) {
                // if (!event.isControlDown() && !event.isShiftDown()) {
                // Fix this XXX
                // MuckConn.typeHere.append(event.getKeyChar() + "");
                // }
                //    event.consume();
                //}
            }
        }
        return;
    }

    public void keyTyped(KeyEvent event){}

    public void keyReleased(KeyEvent event){}

    public void itemStateChanged(ItemEvent event) {
        String arg = (String) event.getItem();

        if (arg.equals(RB("autoFocusInput"))) {
            settings.setAutoFocusInput(tWAutoFocus.getState());
        }

        if (arg.equals(RB("showMacroBar"))) {
            settings.setMacroVisible(tWMacro.getState());
            // Hide/Show the macro bars
            // FIx this XXX
            // MuckConn.settings.setMacroVisible(tWMacro.getState());
            // MuckConn.jmMacros.setVisible(tWMacro.getState());
            if (tWMacro.getState()) {
                // Make the frame visible
                // MuckConn.jmMacros.setActiveState(true);

                if (tWSyncWindowsItem.getState()) {
                    // Fix this XXX
                    // MuckConn.jmMacros.setSync(true);
                } else {
                    // Fix this XXX
                    // MuckConn.jmMacros.setSync(false);
                }
            }
            // else {
            // // Try and call the subroutine from MuMacros
            //    MuckConn.jmMacros.setActiveState(false);
            //    MuckConn.jmMacros.setVisible(false);
            //}
        }

        if (arg.equals(tWLocalEchoItem.getLabel())) {
            settings.setLocalEcho(tWLocalEchoItem.getState());
        }

        if (arg.equals(tWDoubleBufferItem.getLabel())) {
            setDoubleBuffer(tWDoubleBufferItem.getState());
            // settings.setDoubleBuffer(tWDoubleBufferItem.getState());
            // settings.getConnectionHandler().setDoubleBuffer(tWDoubleBufferItem.getState());
        }

        if (arg.equals(splitFramesItem.getLabel())) {
            settings.setSplitView(splitFramesItem.getState());
            // Toggle our layout
            if (viewStyle == SPLIT) {
                viewStyle = COMBINED;
                splitFramesItem.setState(false);
            } else {
                viewStyle = SPLIT;
                splitFramesItem.setState(true);
            }

            // Call for new layout
            setMainLayout();
        }

        if (arg.equals(tWSyncWindowsItem.getLabel())) {
            settings.setSyncWindows(tWSyncWindowsItem.getState());
            setAllSync(tWSyncWindowsItem.getState());
        }

        if (arg.equals(RB("showTimers"))) {
            settings.setTimersVisible(tWTimers.getState());
            // Changed the status of the timers
            // Fix this XXX
            // if (tWTimers.getState()) {
            // The timers have been enabled, start the timer thread
            // timerThread.setActiveState(true);
            // } else {
            // timerThread.setActiveState(false);
            // }
        }

        if (arg.equals(RB("useUnicode"))) {
            // Changed the Unicode option
            settings.setUseUnicode(tWUseUnicodeItem.getState());
        }

        if (arg.equals(RB("releasePause"))) {
            settings.setReleasePause(tWReleasePauseItem.getState());
        }

        if (arg.equals(RB("tinyFugueKeys"))) {
            settings.setTFKeyEmu(tWTFKeysItem.getState());
        }
    }



    public void windowActivated(WindowEvent event) {
        // System.out.println("Window activated.");
        // Restore the original title to the window
        // iconified = false;
        settings.setMainWindowIconified(false);
        setWindowTitle();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        // Do a proper shutdown proceedure
        quitJamochaMUD();
    }

    public void windowDeactivated(WindowEvent event) {}

    public void windowDeiconified(WindowEvent event) {
        // System.out.println("Window deiconified.");
        // Just as a test
        CHandler target = settings.getConnectionHandler();
        MuSocket mSock = target.getActiveMUHandle();
        if (mSock.isPaused()) {
            // System.out.println("Window deiconified shows mSock is paused...");
            // This spools out any paused text
            mSock.SpoolText();
        }

        // The text window is visible
        textWindowStatus = true;
        // iconified = false;
        settings.setMainWindowIconified(false);
        setWindowTitle();

        // Check to see if we have any pending text
        // Fix this XXX
        // MuckConn.minimizedLineCount = 0;
    }

    public void windowIconified(WindowEvent event) {
        // Write the frame to a the Hashtable
        settings.setMainWindowIconified(true);
        settings.setMainWindow(this.getBounds());

        // iconified = true;
        // textWindowStatus = false;
        // FIx this XXX
        // MuckConn.settings.setMainWindow(textWindow.getBounds());
    }

    public void windowOpened(WindowEvent event) {}

    // We'll track the movements of our window for when we have to
    // write it out to our .rc file  Each window for himself!!
    //        public void processComponentEvent(ComponentEvent event) {
    //            super.processComponentEvent(event); // Handle listeners
    //
    //            if (event.getID() == ComponentEvent.COMPONENT_MOVED || event.getID() == ComponentEvent.COMPONENT_RESIZED) {
    //                settings.setMainWindow(this.getBounds());
    //                System.out.println("Set new bounds.");
    //            }
    //
    //        }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
        settings.setMainWindow(this.getBounds());
    }

    public void componentMoved(ComponentEvent event) {
        settings.setMainWindow(this.getBounds());
    }

    public void componentShown(ComponentEvent event) {
    }

    public synchronized void setWindowTitle() {
        // This resets the window's title, depending if the                                    setWindowTitle();

        // client is connected to a MU* or not
        CHandler connection = settings.getConnectionHandler();
        boolean active = connection.isActiveMUDConnected();

        if (active) {
            this.setTitle(connection.getActiveTitle());
        } else {
            // Connection is inactive, just have program's title
            this.setTitle("JamochaMUD - Not connected");
        }
    }

    /** A specific instance of setting the MU* title if
     * the MU* is minimised
     */
    public synchronized void setWindowTitle(String title) {
        this.setTitle(title);
    }


    /**
     * Methods called when disconnected from the MUD/MUCK
     * Here, we reset some of the menu flags to the appropriate status
     * and give the user visual notification that they have been disconnected
     * (This is not always called just by the user's 'Disconnect' action)
     */
    public void DisconnectMenu() {
        // This changes the flags on the MuckMain menu to 'disconnected'
        cTM.setEnabled(true);
        dFM.setEnabled(false);
        rTM.setEnabled(true);
    }

    /**
     * We've received notification from one of our connections that it
     * has either terminated.  We'll query the mu* and see if it is
     * the active one.  If so, we'll update our connection menu.
     */
    public void CheckDisconnectMenu() {
        CHandler connHandler = settings.getConnectionHandler();
        MuSocket mu = connHandler.getActiveMUHandle();

        // System.out.println("Checking active MU*");
        // If our active MU* is not connected, change the connection menu
        if (!connHandler.isActiveMUDConnected()) {
            // System.out.println("Disconnecting active MU* menu");
            DisconnectMenu();
        }
    }

    /**
     * The user has chosen to connect to a MUD/MUCK, so we
     * set the menu items as appropriate, and give the a visual
     * identifier that we are actually trying to make the connection
     */
    public void ConnectMenu() {
        // This changes the flags on the MuckMain menu to 'connected'
        cTM.setEnabled(true);
        dFM.setEnabled(true);
        rTM.setEnabled(false);
    }

    /**
     * Set the 'pause' status on the Main window.
     * Usually done by a single mouse-click, it will stop the
     * text from scrolling, and set the DataBar's title to alert
     * the user that the text is paused
     */
    public static void PauseText() {
        // A single click signals a pause
        // This will pause the output window,
        // the incoming lines held in queue
        pauseStatus = true;
    }

    public static void RefreshPlugInListener() {
        // First, remove the old listener
        // tWPlugInMenu.removeActionListener();

        // Now add the Listener to the new list
        // tWPlugInMenu.addActionListener();
    }

    /**
     * The user has chosen to connect to a MU*, so we hide all the
     * active windows and show the MuckConn again
     */
    private void JMConnectToMU() {
        CHandler connHandler = settings.getConnectionHandler();
        connHandler.connectToNewMU();
    }

    /**
     * Disconnect from the MU, closing the socket and stopping
     * the thread that listens to that IP address
     */
    private void JMDisconnectFromMU() {
        CHandler connHandler = settings.getConnectionHandler();
        connHandler.closeActiveMU();
        checkCloseMenuState();
    }

    /** Reconnect to the MU* we were just connected to! */
    private void JMReconnectToMU() {
        // We'll remove the current MU* after we grab the name and address
        // It's important to recycle
        CHandler connHandler = settings.getConnectionHandler();
        MuSocket handle = connHandler.getActiveMUHandle();
        String name = handle.getMUName();
        String address = handle.getAddress();
        int port = handle.getPort();

        // Get rid of the currently displayed MU*
        closeActiveWindow();

        // Open a new connection
        connHandler.OpenSocket(name, address, port);
    }

    /**
     * Call the help specific to troubleshooting problems with JamochaMUD
     */
    private void JMTroubleShooting() {
        // Fix this XXX
        // MuckConn.jmVars.put("Okay", "true");
        // MuckConn.jmVars.put("Cancel", "false");
        // MuckConn.jmVars.put("Ignore", "false");

        tempVector.removeAllElements();
        tempVector.addElement("This option is not available yet");
        // FIx this XXX
        // OKBox.RunOkay(textWindow, null, null, false, false, null, null, true, tempVector, "Troubleshooting", 200, 100);
    }

    /** Change the shown MU* to our new selection */
    public void setVisibleMU() {

        // Check to make certain there are MU*'s to show
        CHandler connHandler = settings.getConnectionHandler();
        if (connHandler.totalConnections() < 1) {
            // There are no windows left to show.
            System.out.println("There are no MU*'s left to display.  Fix this XXX");
            return;
        }

        // setup the cardLayout to show the proper MU*
        MuSocket sock = connHandler.getActiveMUHandle();
        String stamp = sock.getTimeStamp() + "";
        textCardLayout.show(textPanel, stamp);
        textPanel.invalidate();

        MuSocket mu = connHandler.getActiveMUHandle();

        // Update the menu to show the appropriate MU* as being active
        updateConnectionMenu();

        // Make certain that our connection menu is up to date for this MU*
        setConnectionMenu();

        // Change the title on our data-entry window
        DataIn inWindow = settings.getDataInVariable();
        inWindow.setWindowTitle();
    }

    /** Set the colouring for our components */
    private void setColours() {
        // Grab our settings for the current MU*
        Color fg = settings.getForegroundColour();
        Color bg = settings.getBackgroundColour();
        Font ourFont = settings.getFontFace();

        // Set up our dialogue and display it
        FontFace ff = new FontFace(this, fg, bg, ourFont);
        ff.setSize(300, 250);
        ff.setLocation(anecho.gui.PosTools.findCentre(this, ff));
        ff.setResizable(false);
        ff.setVisible(true);
        // Now querry our dialogue and get our new settings
        Font newStyle = ff.getFontStyle();
        if (newStyle == null) {
            // The user cancelled, no changes made
            return;
        }

        fg = ff.getForegroundColour();
        bg = ff.getBackgroundColour();

        // Set up the other components with the proper colour
        // Change the colour/style in our settings
        settings.setFontFace(newStyle);
        settings.setForegroundColour(fg);
        settings.setBackgroundColour(bg);

        // Change the colours/styles of our input window
        JMUD core = settings.getJMCore();
        core.setAllFonts(newStyle);
        core.setAllColours(fg, bg);
    }

    private void ShowAboutBox() {
        AboutBox temp = new AboutBox(this, settings);
        temp.setVisible(true);
    }

    private void showExtProgDialogue() {
        ExternalProgs eP = new ExternalProgs(this, settings);
        eP.setVisible(true);
    }

    private void showProxyDialogue() {
        ProxyBox proxySettings = new ProxyBox(this, settings);
        proxySettings.setSize(400, 200);
        proxySettings.show();
    }

    /** Perform all the necessary steps to shut down JamochaMUD,
     * most importantly being to save the settings from this session */
    private synchronized void quitJamochaMUD() {
        // "Shut down" and save the details of our other components
        JMUD master = settings.getJMCore();
        master.quitJamochaMUD();
    }

    private void showPluginsDialogue() {
        ManagePlugins plug = new ManagePlugins(this, settings);
        plug.setSize(450, 300);
        plug.setLocation(PosTools.findCentre(this, plug));
        plug.ListPlugins();
        plug.show();
    }

    private void setAllSync(boolean state) {
        JMUD core = settings.getJMCore();
        core.setAllSync(state);
    }

    /** transfer focus to our data entry window, taking into consideration
     * an special events that may also need to be passed along. */
    private void transferFocus(KeyEvent event) {
        DataIn target = settings.getDataInVariable();

        if (event.getKeyCode() == KeyEvent.VK_ENTER) {
            // The user hit 'ENTER', send the text out
            target.JMSendText();
        }

        target.requestFocus();

        if (event.getKeyCode() != KeyEvent.VK_SHIFT && event.getKeyCode() != KeyEvent.VK_CONTROL) {
            if (!event.isControlDown() && !event.isShiftDown()) {
                target.append(event.getKeyChar() + "");
                // Using keyTyped instead of keyPressed checks our "spool" condition
                target.keyTyped(event);
            }
            event.consume();
        }
    }

    /** Copy the selected text from our active MU
     * to the system clipboard */
    private void copyToClipboard() {
        Clipboard c = this.getToolkit().getSystemClipboard();

        try {
            CHandler connHandler = settings.getConnectionHandler();
            JMText text = connHandler.getActiveMUDText();
            String str = text.getSelectedText();
            StringSelection s = new StringSelection(str);
            c.setContents(s, s);

            // After a copy we should make certain to "unhighlight" our copied area
            text.select(0, 0);

            if (tWReleasePauseItem.getState()) {
                // Release the paused state on the JMText area if applicable
                pauseStatus = false;
            }
        } catch (Exception e) {
            System.out.println("Copy exception in MuckMain." + e);
        }

    }

    /** Paste the contents of our system clipboard
     * into the data-entry window */
    private void pasteFromClipboard() {
        Clipboard c = this.getToolkit().getSystemClipboard();
        try {
            Transferable contents = c.getContents(this);
            String str = (String)contents.getTransferData(DataFlavor.stringFlavor);

            // Now we'll stick it into the dataText-thing
            DataIn db = settings.getDataInVariable();
            StringBuffer buff = new StringBuffer(db.getText());
            int caretPos = db.getCaretPosition();
            buff.insert(caretPos, str);
            db.setText(buff.toString());
        } catch (Exception e) {
            System.out.println("Paste exception in MuckMain " + e);
        }
    }

    /** Update the connection menu with the proper
     * number of MU's, indicating connected and disconnected
     * status in addition to which is our active MU*
     */
    private void updateConnectionMenu() {
        // First, check to see if we have any connections.
        // If not, then we don't need to do any more here
        CHandler connHandler = settings.getConnectionHandler();
        if (connHandler.totalConnections() < 1) {
            return;
        }

        // Clear the current list of MU*'s
        tWMUListMenu.removeActionListener(this);
        tWMUListMenu.removeAll();

        // Add the two generic entries... the next and previous choices
        StringBuffer tempName;
        MenuItem tempMenu;
        MenuShortcut shortCut;

        tempMenu = new MenuItem(RB("previousMU"));
        shortCut = new MenuShortcut(KeyEvent.VK_PAGE_DOWN, false);
        tempMenu.setShortcut(shortCut);
        tempMenu.setActionCommand(RB("previousMU"));
        if (connHandler.totalConnections() < 2) {
            tempMenu.setEnabled(false);
        }
        tWMUListMenu.add(tempMenu);

        tempMenu = new MenuItem(RB("nextMU"));
        shortCut = new MenuShortcut(KeyEvent.VK_PAGE_UP, false);
        tempMenu.setShortcut(shortCut);
        tempMenu.setActionCommand(RB("nextMU"));
        if (connHandler.totalConnections() < 2) {
            tempMenu.setEnabled(false);
        }
        tWMUListMenu.add(tempMenu);

        tWMUListMenu.addSeparator();

        // Build a new list of MU*'s
        MuSocket active = connHandler.getActiveMUHandle();
        MuSocket tempSocket;
        int tc = connHandler.totalConnections() - 1;

        // Loop through our connections and build a new menu
        for (int i = 0; i <= tc; i++) {
            tempSocket = connHandler.getMUHandle(i);
            tempName = new StringBuffer(tempSocket.getTitle());
            if (active.getTimeStamp() == tempSocket.getTimeStamp()) {
                // This is our active MU*
                // We'll just differentiate with a check beside it's name
                tWMUListMenu.add(new CheckboxMenuItem(tempName.toString(), true));
            } else {
                tempMenu = new MenuItem(tempName.toString());
                // tempMenu.setShortCut(new MenuShortcut(, false));
                // KeyEvent.VK_Q
                switch(i) {
                case 0:
                    shortCut = new MenuShortcut(KeyEvent.VK_1, false);
                    break;
                case 1:
                    shortCut = new MenuShortcut(KeyEvent.VK_2, false);
                    break;
                case 2:
                    shortCut = new MenuShortcut(KeyEvent.VK_3, false);
                    break;
                case 3:
                    shortCut = new MenuShortcut(KeyEvent.VK_4, false);
                    break;
                case 4:
                    shortCut = new MenuShortcut(KeyEvent.VK_5, false);
                    break;
                case 5:
                    shortCut = new MenuShortcut(KeyEvent.VK_6, false);
                    break;
                case 6:
                    shortCut = new MenuShortcut(KeyEvent.VK_7, false);
                    break;
                case 7:
                    shortCut = new MenuShortcut(KeyEvent.VK_8, false);
                    break;
                case 8:
                    shortCut = new MenuShortcut(KeyEvent.VK_9, false);
                    break;
                case 9:
                    shortCut = new MenuShortcut(KeyEvent.VK_0, false);
                    break;
                }

                tempMenu.setShortcut(shortCut);

                tempMenu.setActionCommand("ChangeMU:" + i);
                tempMenu.addActionListener(this);
                // tWMUListMenu.add(new MenuItem(tempName.toString()));
                tWMUListMenu.add(tempMenu);
            }
        }

        tWMUListMenu.addActionListener(this);

    }

    /**  Set the state of our connection menu
     * based on our active MU*'s condition
     */
    public void setConnectionMenu() {
        CHandler connection = settings.getConnectionHandler();

        if (connection.isActiveMUDConnected()) {
            ConnectMenu();
        } else {
            DisconnectMenu();
        }

        // Update the list of active/inactive MU*s
        updateConnectionMenu();
    }

    /** Clear all the plugins from our current menu
     */
    public void removeAllPlugins() {
        tWPlugInMenu.removeAll();
    }

    /** Add a new plugin to our plugins menu
     */
    public void addPlugin(String name) {
        tWPlugInMenu.add(name);
    }

    /** Add a new MU* to our cardlayout */
    public synchronized void addNewMU(MuSocket mu) {
        String stamp = mu.getTimeStamp() + "";
        JMText text = mu.getTextWindow();

        textPanel.add(text, stamp);

        // We'll switch focus to the last connection we've added
        textCardLayout.first(textPanel);

        // Make certain our connection menu is up-to-date
        updateConnectionMenu();
        checkCloseMenuState();

        textPanel.invalidate();
    }

    /** This method is used to make sure all the classes
     * properly identify the active MU*
     */
    public void setActiveMU(String mu) {
        // First we take apart our String to get the MU number
        int muNum, split;
        split = mu.indexOf(':');
        split++;
        muNum = Integer.parseInt(mu.substring(split));

        CHandler connHandler = settings.getConnectionHandler();
        connHandler.setActiveMU(muNum);

        // Now make our MU visible
        setVisibleMU();
    }

    public void setMainLayout() {

        this.setLayout(null);
        int style = viewStyle;

        if (style == COMBINED) {
            // get rid of the existing layout
            mainBagLayout = new GridBagLayout();
            constraints = new GridBagConstraints();
            this.setLayout(mainBagLayout);

            // Set the style for the combined window
            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.gridheight = 5;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1;
            constraints.weighty = 5;
            constraints.insets = new Insets(0, 0, 2, 0);
            constraints.fill = GridBagConstraints.BOTH;
            constraints.anchor = GridBagConstraints.CENTER;
            mainBagLayout.setConstraints(textPanel, constraints);
            add(textPanel);

            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.gridheight = GridBagConstraints.REMAINDER;
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.weightx = 1;
            constraints.weighty = 2;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.fill = GridBagConstraints.BOTH;
            constraints.anchor = GridBagConstraints.CENTER;
            DataIn in = settings.getDataInVariable();
            TextArea tempText = in.exportText();
            mainBagLayout.setConstraints(tempText, constraints);
            add(tempText);

        } else {
            mainBagLayout = new GridBagLayout();
            constraints = new GridBagConstraints();
            this.setLayout(mainBagLayout);
            // Set the style for the combined window
            constraints.gridwidth = GridBagConstraints.REMAINDER;
            constraints.gridheight = GridBagConstraints.REMAINDER;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1;
            constraints.weighty = 5;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.fill = GridBagConstraints.BOTH;
            constraints.anchor = GridBagConstraints.CENTER;
            mainBagLayout.setConstraints(textPanel, constraints);
            add(textPanel);

            // Now make our input bar visible again
            DataIn in = settings.getDataInVariable();
            in.restoreText();

        }

        // Update our interal "style" reference
        validate();
        textPanel.validate();
        // pack();

        viewStyle = style;

        updateConnectionMenu();

    }

    /** Remove the active view from our list of MU*s */
    private void closeActiveWindow() {
        // remove the MU from our Cardlayout
        CHandler connHandler = settings.getConnectionHandler();
        MuSocket mu = connHandler.getActiveMUHandle();
        JMText text = connHandler.getActiveMUDText();

        // As a cosmetic concern, lets turn this component black first
        textCardLayout.removeLayoutComponent(text);

        // If we are still connected to this MU*, run the disconnect
        if (connHandler.isActiveMUDConnected()) {
            connHandler.closeActiveMU();
        }

        // update our CHandler
        connHandler.removeActiveMU();

        // Now we should change our view to the next active MU*
        setVisibleMU();

        checkCloseMenuState();
    }

    private void checkPause() {
        CHandler target = settings.getConnectionHandler();
        MuSocket mSock = target.getActiveMUHandle();
        if (mSock.isPaused()) {
            // This spools out any paused text
            mSock.SpoolText();
        }
    }

    /** This method checks to see if the &quot;Close current view"
     * Menu item should be active or not
     */
    private void checkCloseMenuState() {
        CHandler connHandler = settings.getConnectionHandler();
        if (connHandler.totalConnections() > 1) {
            closeMU.setEnabled(true);
        } else {
            closeMU.setEnabled(false);
        }
    }

    /** display the next or previous MU, depending on
     * the direction given
     */
    private void AdvanceMU(int direction) {
        CHandler handler = settings.getConnectionHandler();

        // change the active MU*
        if (direction == NEXT) {
            handler.nextMU();
        } else {
            handler.previousMU();
        }

        // now update our display
        setVisibleMU();
    }

    private void setDoubleBuffer(boolean state) {
        settings.setDoubleBuffer(state);
        CHandler handler = settings.getConnectionHandler();
        handler.setDoubleBuffer(state);
    }
}