/**
 * Used to gather and report system information for JamochaMUD
 * $Id: SysInfo.java 1.5 2002/01/30 04:34:40 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2001 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package anecho.JamochaMUD;

import java.awt.Frame;

public class SysInfo {

    JMConfig settings;

    /** Read in our system configuration (machine specific stuff)
     * and update any applicable settings */
    public SysInfo(JMConfig mainSettings) {
        this.settings = mainSettings;

        // Fix this XXX
        // this is a terrible hack, methinks
        Frame dudFrame = new Frame();
        settings.setScreenSize(dudFrame.getToolkit().getScreenSize());

        // Set directory variables
        String userDirectory = new String("");
        String userPlugInDir = new String("");
        java.util.Properties systemData = System.getProperties();
        String osName = new String(systemData.getProperty("os.name"));

        String pathSeparator = new String(java.io.File.separator);
        String sCurrentWorkingDir = new String(systemData.getProperty("user.dir") + pathSeparator);

        if (osName.toLowerCase().startsWith("windows") || osName.toLowerCase().startsWith("os/2") || osName.toLowerCase().startsWith("mac")) {
            // This is a single user environment
            System.out.println("JamochaMUD, single user configuration.");
            userDirectory = new String(systemData.getProperty("user.dir") + pathSeparator);
            userPlugInDir = new String(systemData.getProperty("user.dir") + pathSeparator + "plugins");
        } else {
            // This is a multi-user environment, put the
            // rc file in the user's home directory
            System.out.println("JamochaMUD... going multiuser");
            userDirectory = new String(systemData.getProperty("user.home") + pathSeparator + "anecho" + pathSeparator + "JamochaMUD" + pathSeparator);
            userPlugInDir = new String(userDirectory + "plugins");
        }

        System.out.println("OS name: " + systemData.getProperty("os.name"));
        System.out.println("OS architecture: " + systemData.getProperty("os.arch"));
        System.out.println("OS version: " + systemData.getProperty("os.version"));
        System.out.println("User name: " + systemData.getProperty("user.name"));
        System.out.println("User home: " + systemData.getProperty("user.home"));
        System.out.println("User dir: " + systemData.getProperty("user.dir"));
        System.out.println("User PlugIn dir: " + userPlugInDir);

        // Now stick all this data into the hashtable
        settings.setPathSeparator(pathSeparator);
        settings.setWorkingDirectory(sCurrentWorkingDir);
        settings.setUserDirectory(userDirectory);
        settings.setOSName(systemData.getProperty("os.name"));
        // settings.setJMObject(settings.OSNAME, systemData.getProperty("os.name"));
        settings.setUserPlugInDir(userPlugInDir);

    }
}
