/* Setup the JamochaMUD Icon on the OS/2 desktop */
/* This script will create an icon on the user's desktop which */
/* in turn calls a REXX CMD file to set up the environment and */
/* launch JamochaMUD.  The big thing is to ensure that our     */
/* classpath is setup right in the .cmd file                   */

obID = '<JamochaMUDBeta>'	/* The object ID */
title = 'JamochaMUD beta'	/* Title for the desktop icon */
startFile = 'anecho.JamochaMUD.JMUD'		/* Name of the file JavaPM has to run */
iconFile = 'Jamocha1.ico'	/* JamochaMUD icon file */
cmdFile = 'JMUD.cmd'            /* The .cmd file to start JamochaMUD */

rc = RxFuncAdd("SysCreateObject", "RexxUtil", "SysCreateObject")
rc = RxFuncAdd("SysSearchPath", "RexxUtil", "SysSearchPath")

javaLocation = SysSearchPath('PATH', 'javapm.exe')
JMUDLocation = directory()  /* The directory where JamochaMUD "lives" */
cd '..\..'
/* javaClassPath = filespec("PATH", currentLocation||'\..\..') */
javaClassPath = directory() /* This is the directory that must be added to the CLASSPATH */

/* Return to where we started */
cd JMUDLocation

say "Is this our classpath for anecho.*? "||javaClasspath

If(s = "") Then
  Do
    Say "unable to find javapm.exe"
    Say ""
    Exit(1)
  End

/* Try to write out a startup .cmd file */
rc = LINEOUT(cmdFile, "/* Launch JamochaMUD after setting the proper path */", 1)
rc = LINEOUT(cmdFile, "'set CLASSPATH=%CLASSPATH%;"||javaClassPath||"'")
rc = LINEOUT(cmdFile, "/* Attempt to run JamochaMUD via javapm.exe */")
rc = LINEOUT(cmdFile, "'"||javaLocation||' '||startFile||"'")
/* Now close the file */
rc = LINEOUT(cmdFile)

/* Set up the parameters for the program */
params = "OBJECTID="||obID||";EXENAME=" || JMUDLocation || "\" || cmdFile || ";PROGTYPE=PM;STARTUPDIR=" || Directory() || ";PARAMETERS="||startFile||";ICONFILE="||Directory()||"\"||iconFile

/* Create the desktop icon */
rc = SysCreateObject("WPProgram", title, "<WP_DESKTOP>", params, "R");

If(rc = 0) Then
  Do
    Say "unable to create the JamochaMUD program object"
    Say ""
  End
