/* This PlugIn strips the [fmcl] indicators
 * from FurryMUCK locations, and places them
 * as the window's title
 */

package anecho.JamochaMUD.plugins;

import anecho.JamochaMUD.JMConfig;
import anecho.JamochaMUD.JMUD;
import anecho.JamochaMUD.MuSocket;

import java.util.*;

// These import statements are specific to this plug-in
// import MuckConn;
// import MuckMain;

/** This PlugIn strips the [fmcl] indicators
 * from FurryMUCK locations, and places them
 * as the window's title
 * @version $Id: FBLocationPlugIn.java 1.5 2001/07/13 04:56:19 jeffnik Exp $
 * @author Jeff Robinson
 */

public class FBLocationPlugIn implements PlugInterface {

    // public void setLoader(Object o) {
    // }

    JMConfig settings;

    public void setSettings(JMConfig mainSettings) {
        this.settings = mainSettings;
    }

    public String PlugInName() {
        return "FurryMUCK Location Plug-in";
    }

    public String PlugInDescription() {
        return "This PlugIn strips the [fmcl] indicators from FurryMUCK locations, and places them as the window's title.";
    }

    public String PlugInType() {
        return "Output";
    }

    public String PlugMain(String jamochaString, MuSocket mu) {
        // When we receive a string beginning with [fmcl],
        // we'll parse it down to get the location's name
        // and then use that as the title for the main window

        if (jamochaString.startsWith("[fmcl")) {
            // We have a qualifying string

            // Tokenize the string
            StringTokenizer mainString = new StringTokenizer(jamochaString);
            StringBuffer newTitle = new StringBuffer("");
            String finalTitle;

            // Discard the first two tokens
            mainString.nextToken();
            mainString.nextToken();

            while (mainString.hasMoreTokens()) {
                newTitle.append(mainString.nextToken());
                newTitle.append(" ");
            }

            // Now remove any nasty 'escapes' that may be in there
            int s, f;
            String temp;
            while ((newTitle.toString()).indexOf('\u001b') > 0) {
                // Remove the escape
                temp = new String(newTitle.toString());
                s = temp.indexOf('\u001b');
                f = temp.indexOf("m", s);
                newTitle = new StringBuffer(temp.substring(0, s) + temp.substring(f));
                System.out.println(" " + newTitle);
            }

            // Fix this XXX
            // MuckMain.muckMainTitle = new String(newTitle.toString());
            // MuckMain.muckMainTitle.trim();

            // MuckMain.setWindowTitle();
            finalTitle = new String(newTitle.toString());
            finalTitle.trim();

            // JMUD core = settings.getJMCore();
            // core.setMainWindowTitle(finalTitle);

            // return "<JamochaMUDTitle>";
            // return settings.JamochaMUDTitle + jamochaString;
            mu.setTitle(finalTitle);
            return "";
        } else {
            return jamochaString;
        }
    }

    public void PlugInProperties() {
    }

    public void InitialiseAtLoad(){
    }

    public void SetAtHalt(){
        // We'll restore the title of the main window
        // back to 'JamochaMUD' again.
        // Fix this XXX
        // MuckMain.muckMainTitle = new String("JamochaMUD");
        // MuckMain.setWindowTitle();
    }

}
