// 
/* PlugInterface.java
 * Creates an interface that all plug-ins declare
 * to interact with JamochaMUD
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD.plugins;

/** Creates an interface used by all JamochaMUD plugins
 * @version $Id: PlugInterface.java 1.5 2001/07/13 04:56:19 jeffnik Exp $
 * @author Jeff Robinson
 */

import anecho.JamochaMUD.JMConfig;
import anecho.JamochaMUD.MuSocket;

public interface PlugInterface {
    // This lists the methods that can be called by JamochaMUD
    /**
     * Set the loader of the module. This is necessary to know if you want to
     * contact the modules parent.
     * @param loader The object that has loaded this module.
     */
    // public void setLoader(Object loader);
    public void setSettings(JMConfig settings);

    /** Returns the plugin's proper name */
    public String PlugInName();

    /** Returns a description, eg. author, date, build... */
    public String PlugInDescription();

    /** Returns a type of either input, output, or other */
    public String PlugInType();

    /** the core of the plugin */
    public String PlugMain(String jamochaString, MuSocket mu);

    /** Any user configurable options for the plugin */
    public void PlugInProperties();

    /** This function is called at load-up, in case
     * properties are needed... eg. lists, settings */
    public void InitialiseAtLoad();

    /** This function is called when the plugin is
     *	disabled, and can be used to do any
     *	"clean-up" that may be necessary */
    public void SetAtHalt();

}
