/* This is a test plug-in.
 * It mainly contains stubs
 * for the functions the plug-ins
 * look for
 */

package anecho.JamochaMUD.plugins;

import anecho.JamochaMUD.JMConfig;
import anecho.JamochaMUD.MuSocket;

import java.util.*;

/* We have to import EnumPlugIns if we want to interact
 * with the MU* itself, as EnumPlugIns contains the
 * API to do so.  It is possible for you to interact
 * with EnumPlugIns directly, but hopefully by using
 * the Loader object, all plugins would not need to be
 * substantially rewritten incase this changes in the future */
// import EnumPlugIns;

public class TestPlugIn implements PlugInterface {

    JMConfig settings;

    public void setSettings(JMConfig mainSettings) {
        this.settings = mainSettings;
    }

    public String PlugInName() {
        // Nothin'
        return "Test Plug-in";
    }

    public String PlugInDescription() {
        return "TestPlugIn -> PlugInDescription";
    }

    public String PlugInType() {
        return "TestPlugIn -> PlugInType";
    }

    public String PlugMain(String jamochaString, MuSocket mu) {
        System.out.println("TestPlugIn received: " + jamochaString);
        return jamochaString;
    }

    public void PlugInProperties() {
        System.out.println("Called the properties");
        // We'll make a test-call to the MU*
        // The "carraige return" is already implied
        /** ((EnumPlugIns)loader).SendToMU("WHO"); */

        // Now we can try writing directly to the screen, too
        // Here, the "carraige return" is not done automatically, because
        // there is no way to be certain when one would be required.
        /** ((EnumPlugIns)loader).Write("We just sent the WHO command." + '\n'); */
        /** ((EnumPlugIns)loader).Write("Simply amazing, isn't it? *Snicker*" + '\n'); */

    }

    public void InitialiseAtLoad(){
    }

    public void SetAtHalt(){
    }

}
