/* This PlugIn will be responsible for handling user
 * defined triggers and gags, configurable 
 * $Id: Trigger.java 1.10 2001/12/23 02:09:48 jeffnik Exp jeffnik $
 */

/* The trigger plug-in and JamochaMUD are
 * Copyright (C) 1998-2000 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.JamochaMUD.plugins;

// These import statements are specific to this plug-in
// import MuckConn;
// import MuckMain;
import anecho.JamochaMUD.JMConfig;
import anecho.JamochaMUD.MuSocket;

// import java.applet.Applet;
// import java.applet.AudioClip;
import sun.audio.*;

import java.awt.*;
import java.awt.event.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;

import java.util.Vector;

/* This PlugIn will be responsible for handling user
 * defined triggers and gags, configurable 
 * @version $Id: Trigger.java 1.10 2001/12/23 02:09:48 jeffnik Exp jeffnik $
 * @author Jeff Robinson
 */

public class Trigger implements PlugInterface, ActionListener, ItemListener {

    // Variables
    // Frame parentFrame;// The parent of our main frame
	Dialog ruleFrame;
	boolean inProcess = false;	// this stops multiple instances of the dialogue box
	Choice ruleName = new Choice();
	Vector mainRules = new Vector(0, 1);


        // Variables for rule editing dialogue
        // private Dialog ruleBox = new Dialog(MuckMain.textWindow, "Edit Rule", true);
        private Dialog ruleBox;
        private TextField ruleSetName = new TextField();
        private String theRules;
        private List ruleList;
        private Button tempButton, mediaButton;
        private Label tempLabel;
        private JMConfig settings;
        private Choice ruleOption;
        private TextField ruleWord = new TextField();
        private Choice colourSample;
        private Checkbox gagCheck, colourCheck, launchCheck, mediaCheck;
        private TextField launchPath = new TextField();
        private TextField mediaPath = new TextField();

        // File locations and paths
        String pathSeparator = new String(java.io.File.separator);
        // Fix this XXX
        // String userDirectory = MuckConn.settings.getUserDirectory();
        // String plugIns = new String(userDirectory + "plugins");
	// String triggerDir = new String(plugIns + pathSeparator + "TriggerDir");
        // File triggerFile = new File(triggerDir + pathSeparator + ".trigger.rc");
        String plugIns;       // our plugins directory
        String triggerDir;    // the directory where we keep our trigger rules
        File triggerFile;     // the file where we keep our trigger rules


	private static final String RULES = "$RULES:";
	private static final String RULENAME = "$NAME:";
        private static final String COLOUR = "$COLOUR:";
        private static final String LAUNCH = "$LAUNCH:";
        private static final String MEDIA = "$MEDIA:";

        public void setSettings(JMConfig mainSettings) {
            this.settings = mainSettings;
            // plugIns = new String(settings.getUserDirectory() + "plugins");
            plugIns = new String(settings.getUserPlugInDir());
            triggerDir = new String(plugIns + pathSeparator + "TriggerDir");
            triggerFile = new File(triggerDir + pathSeparator + ".trigger.rc");
	}

        /** The human-readable name of our plugin */
	public String PlugInName() {
		return "Gags & Triggers";
	}

        /** A human readable description of our plugin */
	public String PlugInDescription() {
		return "A plug-in for user-defined gags (hiding unwanted output) and triggers (highlighting input in a number of ways, including sound or colours).";
	}

        /** The type of plug-in that this will be.
         * The current types supported are Output and Input */
	public String PlugInType() {
		return "Output";
	}

	/** The main method of Trigger.  Here we are passed a string from 
	 * main program, will parse it for triggers, and then return whatever
	 * has been dictated the the plugins, or lack thereof
	 */
        public String PlugMain(String jamochaString, MuSocket mu) {
		String finalString = new String(ParseGags(jamochaString));
		return finalString;
	}

	public void PlugInProperties() {
		// We'll call the configuration dialogue for this plugin.
		// Since it is rather extensive, we've put it into its own
		// package.  (That way we can store the user configs there, too).
		if (!inProcess) {
			inProcess = true;
			SelectRule();
		}
	}

	public void InitialiseAtLoad(){
		// We'll call a class in the TriggerDir to scoop any existing .trigger.rc info
		ReadTriggers();
	}

	public void SetAtHalt(){
	}

	/** Do an "installation check", and read in triggers	
	 * if they already exist.  If not, create the proper space
	 */
	private void ReadTriggers() {
		File tD = new File(triggerDir);

		// First, check to see if the Trigger directory exists
		if (!tD.exists()) {
			// There is no TriggerDir, so we'll create one
			tD.mkdir();
			// Obviously there will be no .trigger.rc file, so we can stop here.
			return;
		}
		// Check to see if the .trigger.rc file exists
		if (!triggerFile.exists()) return;	// No trigger file, no need to continue

                // mainRules = new Vector(0, 1);
		// We'll open the .trigger.rc file and read in the rulesets
		RandomAccessFile reader;
		boolean loop = true;

                try {
			reader = new RandomAccessFile(triggerFile.toString(), "r");

			String line;
			StringBuffer fullLine = new StringBuffer("");
                        while (loop) {
                            try {
                                line = new String(reader.readLine());
                            } catch (Exception e) {
                                // We're all out of lines
                                break;
                            }

				if (line == null || line.trim().equals("")) {
					loop = false;
					break;
				}

				line.trim();
				fullLine.append(line);

				if (line != null && line.indexOf("$DONE") > 0) {
					mainRules.addElement(fullLine.toString());
					fullLine = new StringBuffer("");
				}

			}

                        reader.close();

		} catch(Exception e) {
                    System.out.println("Trigger plugin could not access " + triggerFile + ", exception " + e);
                    e.printStackTrace();
			return;
		}
		SetChoices();
	}

	/** This displays a list of available rules, allowing the
	 * user to add, edit, or delete rules. */
        private void SelectRule() {
            // FIx this XXX
            // ruleFrame = new Dialog(MuckMain.textWindow, "Select a rule", false);
            ruleFrame = new Dialog(settings.getMainWindowVariable(), "Select a rule", false);
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		ruleFrame.setLayout(layout);

		tempLabel = new Label("Rule name:");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 7, 2, 2);
		constraints.fill = GridBagConstraints.BOTH;
		layout.setConstraints(tempLabel, constraints);
		ruleFrame.add(tempLabel);

		// ruleName = new Choice();
		constraints.gridwidth = 3;
		constraints.gridheight = 1;
		constraints.gridx = 1;
		constraints.gridy = 0;
		constraints.insets = new Insets(7, 2, 2, 7);
		constraints.fill = GridBagConstraints.BOTH;
		layout.setConstraints(ruleName, constraints);
		ruleFrame.add(ruleName);

		tempButton = new Button("Add a rule");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 1;
		constraints.gridy = 1;
		constraints.insets = new Insets(2, 2, 20, 2);
		constraints.fill = GridBagConstraints.BOTH;
		tempButton.setActionCommand("AddNewRule");
		tempButton.addActionListener(this);
		layout.setConstraints(tempButton, constraints);
		ruleFrame.add(tempButton);

		tempButton = new Button("Edit this rule");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 2;
		constraints.gridy = 1;
		constraints.insets = new Insets(2, 2, 20, 2);
		constraints.fill = GridBagConstraints.BOTH;
		tempButton.setActionCommand("EditThisRule");
		tempButton.addActionListener(this);
		layout.setConstraints(tempButton, constraints);
		ruleFrame.add(tempButton);

		tempButton = new Button("Remove this rule");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 1;
		constraints.insets = new Insets(2, 2, 20, 7);
		constraints.fill = GridBagConstraints.BOTH;
		tempButton.setActionCommand("RemoveThisRule");
		tempButton.addActionListener(this);
		layout.setConstraints(tempButton, constraints);
		ruleFrame.add(tempButton);

		tempButton = new Button("Accept changes");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 0;
		constraints.gridy = 3;
		constraints.insets = new Insets(2, 7, 7, 2);
		constraints.fill = GridBagConstraints.BOTH;
		tempButton.setActionCommand("AcceptChanges");
		tempButton.addActionListener(this);
		layout.setConstraints(tempButton, constraints);
		ruleFrame.add(tempButton);

		tempButton = new Button("Cancel changes");
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.gridx = 3;
		constraints.gridy = 3;
		constraints.insets = new Insets(2, 2, 7, 7);
		constraints.fill = GridBagConstraints.BOTH;
		tempButton.setActionCommand("CancelChanges");
		tempButton.addActionListener(this);
		layout.setConstraints(tempButton, constraints);
		ruleFrame.add(tempButton);

		// Set the size of the dialogue
                ruleFrame.pack();
                // Set the frame visible here so there is no visible pause while
                // we are packing the next frame
                ruleFrame.setVisible(true);

                // And now our little sub-frame
                // Fix this XXX
                // ruleBox = new Dialog(MuckMain.textWindow, "Edit Rule", true);
                ruleBox = new Dialog(settings.getMainWindowVariable(), "Edit Rule", true);
                GridBagLayout stuffBag = new GridBagLayout();
                constraints = new GridBagConstraints();
                ruleBox.setLayout(stuffBag);

                // Time to set up the dialog
                tempLabel = new Label("Name:");
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.insets = new Insets(7, 7, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempLabel, constraints);
                ruleBox.add(tempLabel);

                constraints.gridwidth = GridBagConstraints.REMAINDER;
                constraints.gridheight = 1;
                constraints.gridx = 1;
                constraints.gridy = 0;
                constraints.insets = new Insets(7, 2, 2, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(ruleSetName, constraints);
                ruleBox.add(ruleSetName);

                ruleList = new List(); // This way we know it is already empty
                ruleList.addItemListener(this);
                constraints.gridwidth = 4;
                constraints.gridheight = 7;
                constraints.weightx = 4;
                constraints.weighty = 7;
                constraints.gridx = 0;
                constraints.gridy = 1;
                constraints.insets = new Insets(2, 7, 2, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(ruleList, constraints);
                ruleBox.add(ruleList);

                tempButton = new Button("Move Rule Up");
                tempButton.setActionCommand("MoveRuleUp");
                tempButton.addActionListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weighty = 1;
                constraints.weightx = 1;
                constraints.gridx = 0;
                constraints.gridy = 9;
                constraints.insets = new Insets(2, 7, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);

                tempButton = new Button("Move Rule Down");
                tempButton.setActionCommand("MoveRuleDown");
                tempButton.addActionListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 1;
                constraints.gridy = 9;
                constraints.insets = new Insets(2, 2, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);

                tempButton = new Button("New Rule");
                tempButton.setActionCommand("NewRule");
                tempButton.addActionListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 2;
                constraints.gridy = 9;
                constraints.insets = new Insets(2, 2, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);

                tempButton = new Button("Delete Rule");
                tempButton.setActionCommand("DeleteRule");
                tempButton.addActionListener(this);
//                constraints.gridwidth = GridBagConstraints.REMAINDER;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 3;
                constraints.gridy = 9;
                constraints.insets = new Insets(2, 2, 2, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);

                ruleOption = new Choice();
                ruleOption.add("AND");
                ruleOption.add("NOT");
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 0;
                constraints.gridy = 10;
                constraints.insets = new Insets(2, 7, 8, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(ruleOption, constraints);
                ruleBox.add(ruleOption);

                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.gridx = 1;
                constraints.gridy = 10;
                constraints.insets = new Insets(2, 2, 8, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(ruleWord, constraints);
                ruleBox.add(ruleWord);

                tempButton = new Button("Update Rule");
                tempButton.setActionCommand("UpdateRule");
                tempButton.addActionListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 3;
                constraints.gridy = 10;
                constraints.insets = new Insets(2, 2, 8, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);

                gagCheck = new Checkbox("Gag", false);
                gagCheck.addItemListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 0;
                constraints.gridy = 11;
                constraints.insets = new Insets(2, 7, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(gagCheck, constraints);
                ruleBox.add(gagCheck);

                colourCheck = new Checkbox("Colour", false);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 1;
                constraints.gridy = 11;
                constraints.insets = new Insets(2, 2, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(colourCheck, constraints);
                ruleBox.add(colourCheck);

                //            colourSample = new Button("");
                colourSample = new Choice();
                colourSample.add("black");
                colourSample.add("blue");
                colourSample.add("cyan");
                colourSample.add("dark gray");
                colourSample.add("gray");
                colourSample.add("green");
                colourSample.add("light gray");
                colourSample.add("magenta");
                colourSample.add("orange");
                colourSample.add("pink");
                colourSample.add("red");
                colourSample.add("white");
                colourSample.add("yellow");
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.gridx = 2;
                constraints.gridy = 11;
                constraints.insets = new Insets(2, 2, 2, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(colourSample, constraints);
                ruleBox.add(colourSample);

                launchCheck = new Checkbox("Launch", false);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 0;
                constraints.gridy = 12;
                constraints.insets = new Insets(2, 7, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(launchCheck, constraints);
                ruleBox.add(launchCheck);
                launchCheck.setEnabled(false);

                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.gridx = 1;
                constraints.gridy = 12;
                constraints.insets = new Insets(2, 2, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(launchPath, constraints);
                ruleBox.add(launchPath);
                launchPath.setEnabled(false);

                tempButton = new Button("Browse...");
                tempButton.setActionCommand("BrowseLaunchPath");
                tempButton.addActionListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 3;
                constraints.gridy = 12;
                constraints.insets = new Insets(2, 2, 2, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);
                tempButton.setEnabled(false);

                mediaCheck = new Checkbox("Media", false);
                mediaCheck.addItemListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 0;
                constraints.gridy = 13;
                constraints.insets = new Insets(2, 7, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(mediaCheck, constraints);
                ruleBox.add(mediaCheck);
                mediaCheck.setEnabled(true);

                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.gridx = 1;
                constraints.gridy = 13;
                constraints.insets = new Insets(2, 2, 2, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(mediaPath, constraints);
                ruleBox.add(mediaPath);
                mediaPath.setEnabled(false);

                mediaButton = new Button("Browse...");
                mediaButton.setActionCommand("BrowseMediaPath");
                mediaButton.addActionListener(this);
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.gridx = 3;
                constraints.gridy = 13;
                constraints.insets = new Insets(2, 2, 2, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(mediaButton, constraints);
                ruleBox.add(mediaButton);
                mediaButton.setEnabled(false);

                tempButton = new Button("Okay");
                tempButton.setActionCommand("OkayRule");
                tempButton.addActionListener(this);
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.gridx = 0;
                constraints.gridy = 14;
                constraints.insets = new Insets(2, 7, 7, 2);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);

                tempButton = new Button("Cancel");
                tempButton.setActionCommand("CancelRule");
                tempButton.addActionListener(this);
//                constraints.gridwidth = GridBagConstraints.REMAINDER;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                constraints.gridx = 2;
                constraints.gridy = 14;
                constraints.insets = new Insets(2, 2, 7, 7);
                constraints.fill = GridBagConstraints.BOTH;
                stuffBag.setConstraints(tempButton, constraints);
                ruleBox.add(tempButton);

                ruleBox.pack();

	}

	public void actionPerformed(ActionEvent e) {
		String cmd = new String(e.getActionCommand());

                if (cmd.equals("AcceptChanges")) {
                    WriteRulesToFile();
                    ruleFrame.setVisible(false);
                    ruleFrame.dispose();
                    ruleBox.dispose();
                    inProcess = false;
                }

		if (cmd.equals("CancelChanges")) {
			// User has opted out of changes
			ruleFrame.setVisible(false);
                        ruleFrame.dispose();
                        ruleBox.dispose();
                        inProcess = false;
                        ReadTriggers(); // This ensures we get the same rules we had before
		}

                if (cmd.equals("RemoveThisRule")) {
                    // Remove this rule from the list
                    if (ruleName.getItemCount() < 1) return; // No rules to remove

                    int rule = ruleName.getSelectedIndex();
                    ruleName.remove(rule);
                    mainRules.removeElementAt(rule);
                    return;
                }

                if (cmd.equals("AddNewRule")) {
                    mainRules.addElement("$RULES:1$0:AND:Blank$COLOUR:red$LAUNCH:None$MEDIA:None$NAME:Blank$DONE");
                    ruleName.add("Blank");
                    ruleName.select(mainRules.size() - 1);
                    EditAddRule(mainRules.size() - 1);
                    return;
                }

                if (cmd.equals("EditThisRule")) {
                    EditAddRule(ruleName.getSelectedIndex());
                    return;
                }

                // Commands from the "sub-dialog" box
                if (cmd.equals("OkayRule")) {
                    WriteNewRule();
                    ruleBox.setVisible(false);
                    ruleBox.dispose();
                    ruleFrame.setVisible(true);
                    return;
                }

                if (cmd.equals("CancelRule")) {
                    ruleBox.setVisible(false);
                    ruleBox.setLayout(null);
                    ruleBox.dispose();
                    ruleFrame.setVisible(true);
                    return;
                }

                if (cmd.equals("UpdateRule")) {
                    // UpdateRule(ruleName.getSelectedIndex());
                    UpdateRule();
                    return;
                }

                if (cmd.equals("MoveRuleUp")) {
                    if (ruleList.getSelectedItem() != null && ruleList.getSelectedIndex() > 0) {
                        MoveRule(ruleList.getSelectedIndex(), -1);
                    }

                    return;
                }

                if (cmd.equals("MoveRuleDown")) {
                    if (ruleList.getSelectedItem() != null & ruleList.getSelectedIndex() < (ruleList.getItemCount() - 1)) {
                        MoveRule(ruleList.getSelectedIndex(), 1);
                    }
                    return;
                }

                if (cmd.equals("NewRule")) {
                    AddNewSubRule();
                    return;
                }

                if (cmd.equals("DeleteRule")) {
                    if (ruleList.getSelectedItem() != null) {
                        DeleteSubRule(ruleList.getSelectedIndex());
                    }
                    return;
                }

                if (cmd.equals("BrowseMediaPath")) {
                    ruleBox.setVisible(false);
                    selectFile(mediaPath, mediaPath.getText());
                    ruleBox.setVisible(true);
                }
        }

        /** Our item state changed.  If it was the checkbox on the
         * &quot;Gag" feature then we toggle the rest of the
         * trigger actions on or off, accordinly.
         */
        public void itemStateChanged(ItemEvent event) {
            if (event.getItem() == gagCheck.getLabel()) {
                if (gagCheck.getState()) {
                    // All other options are disabled as the "GAG" has been selected
                    SetRuleOptions(false);
                    // setMediaState(false);
                } else {
                    // Make all options available as the "GAG" has been deselected
                    SetRuleOptions(true);
                    // setMediaState(true);
                }
                return;
            }

            if (event.getItem() == mediaCheck.getLabel()) {
                // mediaPath.setEnabled(mediaCheck.getState());
                // mediaButton.setEnabled(mediaCheck.getState());
                setMediaState(mediaCheck.getState());
            }

            // Since we have no other items to listen to,
            // and I can't figure out a better way, we'll
            // default to checking if the list was altered
            if (ruleList.getSelectedItem() != null) {
                // We've selected a new item, lets put its values
                // in the appropriate areas
                int selected = ruleList.getSelectedIndex();
                ShowRuleWord(selected);
                return;
            }

        }

        /** read the new vector into the choices
         * for our main dialogue
         */
	private void SetChoices() {
            // ruleName = new Choice();
            ruleName.removeAll();
		String tempName;
		for (int i = 0; i < mainRules.size(); i++) {
                    // tempName = new String(RuleName((String)mainRules.elementAt(i)));
                    tempName = new String(PullRule(mainRules.elementAt(i), RULENAME));


                    if (tempName != null) {
                        ruleName.add(tempName);
                    }
                }
	}

	/** Go through the rules and see if have anything that matches */
        private String ParseGags(String input) {

            if (mainRules == null || mainRules.size() < 1) {
                // We have no rules yet
                return input;
            }

            StringBuffer grinder = new StringBuffer(input);

            // Loop through all the rules...
            int numRules = 0;
            boolean gag = false;
            for (int set = 0; set < mainRules.size(); set++) {

                // How many rules are in this rule set?
                numRules = Integer.parseInt(PullRule(mainRules.elementAt(set), RULES));

                for (int j = 0; j < numRules; j++) {
                    if (CheckRule(input, set, j)) {
                        gag = true;
                    } else {
                        gag = false;
                        break;
                    }
                }

                // We'll see if this gag is appropriate...
                if (gag) {
                    grinder = new StringBuffer(ApplyGag(grinder, set));

                    // If audio is applicable, we'll call that as well!
                    String rule = PullRule(mainRules.elementAt(set), MEDIA);
                    if (!rule.equals("None")) {
                        playMedia(PullRule(mainRules.elementAt(set), MEDIA));
                    }

                }

            }

            return grinder.toString();
        }

        private boolean CheckRule(String input, int set, int rule) {
		String chkRule = new String(PullRule(mainRules.elementAt(set), "$" + rule + ":"));
		String match = (chkRule.substring(chkRule.indexOf(":") + 1)).toLowerCase();
		input = input.toLowerCase();
		// match.toLowerCase();
		boolean state = false;
		if (chkRule.startsWith("AND") && (input.indexOf(match) > 0 || input.startsWith(match))) state = true;
		if (chkRule.startsWith("OR") && (input.indexOf(match) > 0 || input.startsWith(match))) state = true;
		if (chkRule.startsWith("NOT") && input.indexOf(match) < 1) state = true;
	
		return state;
	}

	/** Apply the Gag to the String we were passed from the main program */
	private String ApplyGag(StringBuffer sb, int set) {
		String colour = PullRule(mainRules.elementAt(set), COLOUR);
		colour = new String(colour.toLowerCase());
		String colourCode = new String();
		if (colour.equals("gag")) return "";	// Not a colour, but a gag!
		if (colour.equals("black")) colourCode = '\u001b' + "[30m";
		if (colour.equals("red")) colourCode = '\u001b' + "[31m";
		if (colour.equals("green")) colourCode = '\u001b' + "[32m";
		if (colour.equals("yellow")) colourCode = '\u001b' + "[33m";
		if (colour.equals("blue")) colourCode = '\u001b' + "[34m";
		if (colour.equals("magenta")) colourCode = '\u001b' + "[35m";
		if (colour.equals("cyan")) colourCode = '\u001b' + "[36m";
		if (colour.equals("white")) colourCode = '\u001b' + "[37m";

		if (sb.charAt(0) != '\u001b') {
			sb.insert(0, colourCode);
			sb.append('\u001b' + "[0m");
                }

                return sb.toString();
        }

	/** Search through the string for the rule name,
	 * and extract its information
	 */
	private String PullRule(Object ruleObj, String ruleName) {
		String rule = ruleObj.toString();
		int start, end;
		start = rule.indexOf(ruleName);
		start = start + ruleName.length();
		end = rule.indexOf("$", start + 1);

		return rule.substring(start, end);
	}

        /** Modify a given rule.*/
        private void ChangeRule(int item, String option, String ruleWord) {
            int rules = Integer.parseInt(PullRule(theRules, RULES));
            StringBuffer workString = new StringBuffer("$RULES:" + rules);

            for (int i = 0; i < rules; i++) {
                if (i == item) {
                    // This is the rule we change
                    workString.append("$" + i + ":" + option + ":" + ruleWord);
                } else {
                    workString.append("$" + i + ":" + (PullRule(theRules, "$" + i + ":")));
                }
            }

            workString.append("$COLOUR:" + (PullRule(theRules, COLOUR)));
            workString.append("$LAUNCH:" + (PullRule(theRules, LAUNCH)));
            workString.append("$MEDIA:" + (PullRule(theRules, MEDIA)));
            workString.append("$NAME:" + (PullRule(theRules, RULENAME)));
            workString.append("$DONE");

            // Copy this as our new working rule, and then update the display
            theRules = new String(workString.toString());
            // RefreshRules();
        }

        /** Add a new rule or edit an existing rule
         * -1 indicates that we'll be dealing with a
         * new rule, otherwise we'll edit the rule
         * number passed by the int.
         */
        private void EditAddRule(int rule) {
            theRules = new String((String)mainRules.elementAt(rule));

            if (rule == -1) {
                ruleBox.setTitle("Add Rule");
            }

            if (rule >= 0) {
                ruleSetName.setText(PullRule(theRules, RULENAME));
                SetupRules(); // Fill in the appropriate rule areas
            }

            ruleFrame.setVisible(false); // Hide the 'parent'
            ruleBox.setVisible(true);
        }

        /** This will read in a rule, breaking it up
         * for nice display in our little rule-mangler!
         */
        private void SetupRules() {
            // First, we'll check to see if this is a GAG,
            // and if so, we'll disable half our options now
            if (PullRule(theRules, COLOUR).equalsIgnoreCase("GAG")) {
                gagCheck.setState(true);
                SetRuleOptions(false);
//                RefreshRules();
            } else {
                // Better safe than sorry, no?
                gagCheck.setState(false);
                SetRuleOptions(true);
                // Set colour information
                colourSample.select(PullRule(theRules, COLOUR).toLowerCase());
                colourCheck.setState(true);
            }

            // Fill in the media information
            String text = PullRule(theRules, MEDIA);
            if (text.equals("None")) {
                mediaPath.setText("");
                mediaCheck.setState(false);
                setMediaState(false);
            } else {
                mediaPath.setText(text);
                mediaCheck.setState(true);
                setMediaState(true);
            }

            RefreshRules();
        }

        /** Set up our ruleWord textArea and associated "choice"
         */
        private void ShowRuleWord(int selected) {
            String ruleType, tag;
            // int rule = ruleName.getSelectedIndex();
            // ruleType = new String(PullRule(mainRules.elementAt(rule), "$" + selected + ":"));
            ruleType = new String(PullRule(theRules, "$" + selected + ":"));
            tag = (ruleType.substring(ruleType.indexOf(":") + 1));

            ruleOption.select(ruleType.substring(0, ruleType.indexOf(":")));
            ruleWord.setText(tag);
        }
        /** This enables or disables options available,
         * depending on the boolean passed
         */
        private void SetRuleOptions(boolean stat) {
            colourCheck.setEnabled(stat);
            launchCheck.setEnabled(stat);
            launchPath.setEnabled(stat);

            mediaCheck.setEnabled(stat);
            setMediaState(mediaCheck.getState());
            /**
             if (stat) {
             mediaPath.setEnabled(mediaCheck.getState());
             mediaButton.setEnabled(mediaCheck.getState());
             } else {
             mediaPath.setEnabled(stat);
             mediaButton.setEnabled(stat);
             }
             */
        }

        /** Parse the set of rules, writing it out
         * to our list
         */
        private void RefreshRules() {
            // Get the number of rules that we're dealing with
            String ruleType, tag;
            int start;
            // int num = Integer.parseInt(PullRule(mainRules.elementAt(rule), RULES));
            int num = Integer.parseInt(PullRule(theRules, RULES));
            if (num < 1) return;// This shouldn't happen... but y'never know

            ruleList.removeAll();
            for (int i = 0; i < num; i++) {
                // ruleType = new String(PullRule(mainRules.elementAt(rule), "$" + i + ":"));
                ruleType = new String(PullRule(theRules, "$" + i + ":"));
                tag = (ruleType.substring(ruleType.indexOf(":") + 1));
                ruleList.add(ruleType.substring(0, ruleType.indexOf(":")) + " -> " + tag);
            }
        }

        /** Modify an existing rule */
        //        private void UpdateRule(int rule) {
        private void UpdateRule() {
            if (ruleList.getSelectedItem() == null || ruleWord.getText().equals("")) return;

            int item = ruleList.getSelectedIndex();
            ChangeRule(item, ruleOption.getSelectedItem(), ruleWord.getText());
            RefreshRules();
        }

        private void MoveRule(int item, int direction) {
            int size = ruleList.getItemCount();
            Vector tempItem = new Vector(0, 1);
//            Vector tempRule = new Vector(0, 1);
//            String rule = new String(PullRule(theRules, "$" + item + ":"));
            String itemString;

            for (int i = 0; i < size; i++) {
                tempItem.addElement(PullRule(theRules, "$" + i + ":"));
            }

            itemString = new String((String)tempItem.elementAt(item));
            tempItem.removeElementAt(item);
            tempItem.insertElementAt(itemString, item + direction);

            int colon;
            for (int i = 0; i < size; i++) {
                itemString = new String((String)tempItem.elementAt(i));
                colon = itemString.indexOf(":");
                ChangeRule(i, itemString.substring(0, colon), itemString.substring(colon + 1));
            }
            RefreshRules();
            ruleList.select(item + direction);
        }

        /** Write out our new rule in the proper format and
         * then update the main window */
        private void WriteNewRule() {
            int rules = Integer.parseInt(PullRule(theRules, RULES));
            StringBuffer workString = new StringBuffer("$RULES:" + rules);

            for (int i = 0; i < rules; i++) {
                    workString.append("$" + i + ":" + (PullRule(theRules, "$" + i + ":")));
            }

            // Now, glean the rest of the info from out dialogues
            workString.append("$COLOUR:");
            if (gagCheck.getState()) {
                workString.append("GAG");
            } else {
                workString.append(colourSample.getSelectedItem());
            }
            workString.append("$LAUNCH:");
            if (launchCheck.getState() && !launchPath.getText().equals("")) {
                workString.append(launchPath.getText());
            } else {
                workString.append("None");
            }
            workString.append("$MEDIA:");
            if (mediaCheck.getState() && !mediaPath.getText().equals("")) {
                workString.append(mediaPath.getText());
            } else {
                workString.append("None");
            }
            workString.append("$NAME:");
            workString.append(ruleSetName.getText());
            workString.append("$DONE");

            // Finished building the new rule, now we'll put it back in
            // into the "main array"
            mainRules.setElementAt(workString.toString(), ruleName.getSelectedIndex());
            SetChoices();
            ruleName.select(PullRule(workString.toString(), RULENAME));
        }

        /** Upon approval by the user, we'll write the rules back to the file */
        private void WriteRulesToFile() {
            File tD = new File(triggerDir);

            // First, check to see if the Trigger directory exists
            if (!tD.exists()) {
                // There is no TriggerDir, so we'll create one
                tD.mkdir();
                // Obviously there will be no .trigger.rc file, so we can stop here.
                return;
            }

            if (triggerFile.exists()) {
                triggerFile.delete();
            }

            String writeOut;
            // We'll open the .trigger.rc file and read in the rulesets
            RandomAccessFile writer;

            try {
                writer = new RandomAccessFile(triggerFile.toString(), "rw");

                for (int i = 0; i < mainRules.size(); i++) {
                    writeOut = new String((String)mainRules.elementAt(i));
                    writer.writeBytes(writeOut.trim() + '\n');
                }

                writer.close();

            } catch (Exception e) {
                System.out.println("Some sort've error while writing out plugins" + e);
            }

        }

        /** Add an additional subrule to an existing rule */
        private void AddNewSubRule() {
            int rules = Integer.parseInt(PullRule(theRules, RULES));
            StringBuffer workString = new StringBuffer("$RULES:" + (rules + 1));

            for (int i = 0; i < rules; i++) {
                    workString.append("$" + i + ":" + (PullRule(theRules, "$" + i + ":")));
            }

            workString.append("$" + (rules) + ":" + "AND:blank");

            // Now, glean the rest of the info from out dialogues
            workString.append("$COLOUR:");
            workString.append(PullRule(theRules, COLOUR));
            workString.append("$LAUNCH:");
            workString.append(PullRule(theRules, LAUNCH));
            workString.append("$MEDIA:");
            workString.append(PullRule(theRules, MEDIA));
            workString.append("$NAME:");
            workString.append(PullRule(theRules, RULENAME));
            workString.append("$DONE");

            theRules = new String(workString.toString());
            RefreshRules();
            ruleList.select(rules);
            ShowRuleWord(rules);
        }

        /** Delete a subrule from our current set of working rules. */
        private void DeleteSubRule(int ruleIndex) {
            int count = 0;
            int rules = Integer.parseInt(PullRule(theRules, RULES));
            StringBuffer workString = new StringBuffer("$RULES:" + (rules - 1));

            for (int i = 0; i < rules; i++) {
                if (i != ruleIndex) {
                    workString.append("$" + count + ":" + (PullRule(theRules, "$" + i + ":")));
                    count++;
                }
            }

            // Now, glean the rest of the info from out dialogues
            workString.append("$COLOUR:");
            workString.append(PullRule(theRules, COLOUR));
            workString.append("$LAUNCH:");
            workString.append(PullRule(theRules, LAUNCH));
            workString.append("$MEDIA:");
            workString.append(PullRule(theRules, MEDIA));
            workString.append("$NAME:");
            workString.append(PullRule(theRules, RULENAME));
            workString.append("$DONE");

            // Finished building the new rule, now we'll put it back in
            // into the "main array"
            theRules = new String(workString.toString());
            RefreshRules();
        }

        /** Show a file-selection dialogue and the insert the results
         * from the selection into the proper location
         */
        private void selectFile(TextField text, String oldPath) {
            FileDialog fd = new FileDialog(settings.getMainWindowVariable(),
                                           "Select a file",
                                           FileDialog.LOAD);
            // An ugly kludge, but we set our main dialogue as not visible
            // and then show the file-selection dialogue, otherwise users
            // can run amuck!
            // ruleBox.setVisible(false);
            if (!oldPath.equals("")) {
                fd.setFile(oldPath);
            }

            fd.setVisible(true);

            if (fd.getFile() != null && fd.getFile() != "") {
                text.setText(fd.getDirectory() + fd.getFile());
            }

            return;
            // Return the main dialogue to its former elegance
            // ruleBox.setVisible(true);

            // System.out.println("Directory: " + fd.getDirectory());
            // System.out.println("File: " + fd.getFile());
        }

        /** Toggle the state of the "media"-related widgets.  This
         * would generally be a simple matter but for the fact that
         * they are also controlled by the "GAG" checkbox
         */
        private void setMediaState(boolean stat) {
            if (gagCheck.getState()) {
                mediaCheck.setEnabled(false);
                mediaPath.setEnabled(false);
                mediaButton.setEnabled(false);
            } else {
                mediaCheck.setEnabled(true);
                mediaPath.setEnabled(stat);
                mediaButton.setEnabled(stat);
            }
        }

        /** Play media is triggered, so let's make some noise! */
        private void playMedia(String audioFileName) {
            // This stuff is drawn from the Applet.AudioClip class.  Yuckyweird.
            // try {
            // AudioClip myClip = getAudioClip(new URL(getCodeBase(), "clip.au"));
            // } catch (Exception e) {
            // }
            try {
                AudioDataStream audioDataStream;
                AudioPlayer audioPlayer = AudioPlayer.player;
                FileInputStream fis = new FileInputStream( new File(audioFileName) );
                AudioStream as = new AudioStream( fis ); // header plus audio data
                AudioData ad = as.getData(); // audio data only, no header
                audioDataStream = new AudioDataStream( ad );
                audioPlayer.start( audioDataStream );
            } catch (Exception e) {
                System.out.println("An exception occured trying to play this file:");
                System.out.println(e);
            }

        }
}
