/**
 * Bowsah is a small API to allow "platform independant"
 * control of web browsers.
 * $Id: Bowsah.java 1.2 2001/05/26 18:00:03 jeffnik Exp $
 */


/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.extranet;

public class Bowsah {

    // Our variables
    Process bProc;            // The browser process
    boolean newBrowser;       // whether to create a new browser process
    String browser;           // our chosen web browser

    // Our constructors
    public Bowsah(String browser) {
        this(browser, "");
    }

    public Bowsah(String browser, boolean newBrowser) {
        this(browser, "", newBrowser);
    }

    public Bowsah(String browser, String URL) {
        this(browser, URL, true);
    }

    public Bowsah(String browser, String URL, boolean newBrowser) {
        this.browser = browser;
        this.newBrowser = newBrowser;
        DisplayURL(URL);
    }

    // Our methods (and our madness)!
    /** Display this new &quot;Location" in our browser */
    public void DisplayURL(String URL) {
        // check to see if our browser is currently running
        if (bProc == null) {
            // if it is not running, make sure we are allowed to start it.
            if (newBrowser) {
                // Yay!  Let's start a new browser first!!
                StartNewBrowser(URL);
                return;
            } else {
                System.out.println("We need to start a new browser, but are not allowed to.");
                return;  // Since we're not allowed to start a browser, we quit
            }
        }

        // We we can go about displaying our chosen URL
        System.out.println("Display URL in existing browser.");
        String userDirectory = new String("");
        java.util.Properties systemData = System.getProperties();
        String osName = new String(systemData.getProperty("os.name"));

        String pathSeparator = new String(java.io.File.separator);
        String sCurrentWorkingDir = new String(systemData.getProperty("user.dir") + pathSeparator);
        if ((osName.toLowerCase()).startsWith("windows")) {
            System.out.println("We have a windows machine.  There is a generic way of doing this.");
            try {
                Process p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + URL);
            } catch(Exception e) {
                System.out.println("Bowsah: There was a problem with the Windows method " + e);
            }
            return;

        } else {
            // This is where the fun comes in, differentiating between systems
            // end then finding the way *they* implement this feature
            if (osName.startsWith("OS/2")) {
                System.out.println("This is hard-coded for netscdde.  Anyone know a better way?");
                try {
                    // -q starts netscdde in quiet mode
                    // -X starts Netscape without prompting, if necessary
                    Process p = Runtime.getRuntime().exec("netscdde.exe -q -X " + URL);
                } catch(Exception e) {
                    System.out.println("Bowsah... OS/2 can't find netscdde or something. " + e);
                }
                return;
            }

            // if the system is a Unix/Linux system, well do it this
            // way... the problem is right now we'll assume they're using Netscape
            StartNewBrowser("-remote \"openURL(" + URL + ")\"");

        }


    }

    /** Start a new browser because we ain't got one yet */
    private void StartNewBrowser(String URL) {
        System.out.println("Attempting to start new browser.");
        try {
            bProc = Runtime.getRuntime().exec(browser + " " + URL);
        } catch (Exception e) {
            System.out.println("Bowsah.StartNewBrowser failed.  Error: " + e);
        }
    }

    /** This will return the Process that
     * we are using for our browser */
    public Process GetProcess() {
        return bProc;
    }

    /** Toggle whether a request will start a new browser
     * if one doesn't exist */
    public void NewBrowser(boolean newBrowser) {
        this.newBrowser = newBrowser;
    }

}