/**
 * The Reusable dialogue box:
 * OKBox.java displays program messages to the user with the possibility
 * of including icons, text, and/or response buttons
 * $Id: OKBox.java 1.7 2001/12/23 21:18:20 jeffnik Exp $
*/

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.gui;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

import java.net.*;

import java.util.StringTokenizer;
import java.util.Vector;

	/*
	 * The Reusable dialogue box:
	 * OKBox.java displays program messages to the user with the possibility
	 * of including icons, text, and/or response buttons
         * @version $Id: OKBox.java 1.7 2001/12/23 21:18:20 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class OKBox extends Dialog implements ActionListener {

	// Variables
	Image icon;		// The icon for the OKBox (if applicable)
	String buttonChoice;	// The label of button that was chosen by the user
        // Vector buttonLabels;	// List of the labels to be applied to the buttons
	public static final int NO_ICON = 0;
	public static final int CUSTOM_ICON = 1;
	public static final int QUESTION_ICON = 2;
	public static final int ALERT_ICON = 3;
        public static final int INFORMATION_ICON = 4;

        // A couple generic defaults for folks
        public static final String OKAY = "Okay";
        public static final String CANCEL = "Cancel";
	
	private	BorderLayout layout = new BorderLayout(5, 5); // Our layout manager for the OKBox
	private Canvas iconCanvas;	// The canvas that will contain our icon (if applicable)
	private Canvas textCanvas;	// The canvas that will contain our user-message
	private Panel buttonPanel;	// This panel will contain the buttons in a flow-layout 
                                        // type of fashion
        private TextArea messageText = new TextArea();   // a text area to contain the user-message
	private Vector readyMessage = new Vector(0, 1);	// Message ready for output
        private Vector userMessage = new Vector(0, 1);	// Message before preparation for output
        private Vector buttonLabels = new Vector(0, 1);      // Vector of the button labels

        private Button tempButton;
        private String finalChoice;

	// Constructor(s)
	public OKBox(Frame parent) {
		this(parent, "");
	}

	public OKBox(Frame parent, boolean modalBox) {
		this(parent, "", modalBox);
	}

	public OKBox(Frame parent, String title) {
		this(parent, title, false);
	}

	public OKBox(Frame parent, String title, boolean modalBox) {
		this(parent, title, modalBox, "");
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage) {
		this(parent, title, modalBox, boxMessage, NO_ICON);
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage, int iconType) {
		this(parent, title, modalBox, boxMessage, iconType, "");
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage, String buttons) {
		this(parent, title, modalBox, boxMessage, NO_ICON, buttons);
	}

	public OKBox(Frame parent, String title, boolean modalBox, String boxMessage, int iconType, String buttons) {
            // Because Dialog does not have a parameter-less constructor,
            // we have to call its basic constructor ourselves, or we get
            // a compiling error of &quot;No constructor matching Dialog()"
            super(parent, title, modalBox);

            // Time to set up our new OKBox
            this.setLayout(layout);

            iconCanvas = new Canvas();
            Panel iconPanel = new Panel();
            textCanvas = new Canvas();
            Panel textPanel = new Panel();
            // Panel buttonPanel = new Panel();
            buttonPanel = new Panel();
            add(iconPanel, BorderLayout.WEST);
            // To get things up and running we'll just use a TextArea for now.
            // Fix this XXX
            // add(textPanel, BorderLayout.CENTER);
            add(messageText, BorderLayout.CENTER);
            add(buttonPanel, BorderLayout.SOUTH);

            if (iconType > 0) {
                // We'll nab the icon and use it to help use determine the default size
                icon = getBoxIcon(iconType);
            }

            // Layout text if we have any
            layoutText();

            // Now pack everything nice and snug!
            pack();
        }


        // Handle the events
        public void actionPerformed(ActionEvent e) {
            // We record the button that is pressed and then dismiss this dialogue
            setResult(e.getActionCommand());
            this.setVisible(false);

        }

	/** We'll pull the icon (from wherever it is supposed to be)
	 * and write it onto the correct canvas (also keeping a copy in memory)
	 */
	private synchronized Image getBoxIcon(int type) {
		Image image = Toolkit.getDefaultToolkit().getImage("kehza.gif");

		return image;
	}

        // Draw the contents to the screen
        public void paint(Graphics g) {
            if (icon != null) {
                g.drawImage(icon, 5, 25, this);
            }
        }

	/** We'll do a virtual run-through of the text available so that we'll
	 * be able to size the window before we try to print to it. 
	 * By doing this we can set up our vector so it neatly parses the message
	 */
	private void formatText() {
            if (userMessage.size() < 1) {
                return;
            }

            messageText.setText("");

            for (int i = 0; i < userMessage.size(); i++) {
                messageText.append((String)userMessage.elementAt(i));
            }

            messageText.setEditable(false);
	}

	/** Set the text for the message (erasing any previous contents) */
	public synchronized void setText(String text) {
		if (userMessage.size() > 0) {
			userMessage.removeAllElements();
		}
		append(text);
	}

        /** Format the buttons for display */
        private void formatButtons() {
            // Clear the button panel
            if (buttonPanel != null) {
                buttonPanel.removeAll();
            }

            // if (buttons.equals("")) {
            if (buttonLabels.size() < 1) {
                // We weren't passed a string of buttons, so we'll default to 'OK'
                buttonLabels.addElement(OKAY);
            }

            for (int i = 0; i < buttonLabels.size(); i++) {
                tempButton = new Button((buttonLabels.elementAt(i)).toString());
                buttonPanel.add(tempButton);
                tempButton.addActionListener(this);
            }
        }

        /** Add a button to the list of buttons to be displayed */
        public void addButton(String name) {
            if (!name.equals("")) {
                buttonLabels.addElement(name);
            }
        }

        /** Append a line of text to a message, or create a
         * new message if one does not exist */
	public synchronized void append(String text) {
		userMessage.addElement(text);
        }

        private synchronized void layoutText() {

        }

        /** Return the user's selection.  This may be a little tricky as
         * We are not necessarily confined to simply having &quot;Okay" and
         * &quot;Cancel" buttons.  This dialogue is extensible!
         */
        public String getResult() {
            return finalChoice;
        }

        /** Override Dialog's 'show' command so that we can format text first!
         */
        public void show() {
            formatText();
            formatButtons();
            super.show();
        }

        private void setResult(String choice) {
            finalChoice = new String(choice);
        }

}
