/**
 * PosTools, a JamochaMUD class to determine the centre "Point"
 * of the desktop or passed object
 * $Id: PosTools.java 1.6 2001/05/26 17:59:48 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-1999 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;

/** A set of tools to help ease finding the centre and corner points
 * of existing objects and/or the screen.
 * @version $Id: PosTools.java 1.6 2001/05/26 17:59:48 jeffnik Exp $
 * @author Jeff Robinson
 */

public abstract class PosTools {

	// Static variables
	private final static int NW = 0;	// NorthWest corner of object
	private final static int NE = 1;	// NorthEast corner of object
	private final static int SW = 3;	// SouthWest corner of object
	private final static int SE = 4;	// SouthEast corner of object
        private final static int CENTRE = 5;	// Centre of the object (default)
        private final static int CENTER = 5;    // for all the people that spell like this!

	// other variables
	private static Dimension screen = java.awt.Toolkit.getDefaultToolkit().getScreenSize(); // Screen size

	/** Without arguements, we will return the centre of the 'desktop' */
	public static Point findCentre() {

		// Take half of the width and half of the height of the screen
		int xCentre = (int)screen.width / 2;
		int yCentre = (int)screen.height / 2;

		return new Point(xCentre, yCentre);
	}

	/** Find the centre of the object that we have been passed */
	public static Point findCentre(Component c) {
		// this.findCentre(c, CENTRE);
		return findCentre(c, CENTRE);
	}

	/** Returns the specified corner of the object which we have been passed */
	public static Point findCentre(Component c, int corner) {
		// First, determine information about the object
		int cXPos = 0;		// X axis of component
		int cYPos = 0;		// Y axis of component

		try {
			cXPos = c.getLocationOnScreen().x;
			cYPos = c.getLocationOnScreen().y;
		} catch (Exception e) {
			// System.out.println("PosTools.findCentre(Component, int) " + c + " " + e);
		}

		int cWidth = c.getSize().width;		// Width of the component
		int cHeight = c.getSize().height;		// Height of the component
		int cXCentre = cWidth / 2;	// Horizontal centre of the component (relative)
		int cYCentre = cHeight / 2;	// Vertical centre of the component (relative)

		Point centre = new Point(0, 0);	// create a Point to contain the return info

		// Now do the calculations based on the 'corner' chosen
		switch (corner) {
			case NW:
				centre.setLocation(cXPos, cYPos);
				break;
			case NE:
				centre.setLocation(cXPos + cWidth, cYPos);
				break;
			case SW:
				centre.setLocation(cXPos, cYPos + cHeight);
				break;
			case SE:
				centre.setLocation(cXPos + cWidth, cYPos + cHeight);
				break;
			default: 
				centre.setLocation(cXPos + cXCentre, cYPos + cYCentre);
		}
		
		return centre;
	}

	/** return the point to centre the child component on the parent component */
	public static Point findCentre(Component parent, Component child) {
		return findCentre(parent, CENTRE, child);
	}

	/** return the Point to centre the child component over the given axis of the parent */
	public static Point findCentre(Component parent, int corner, Component child) {
		// get the "centre" of the parent
		Point centre = findCentre(parent, corner);
		int parentX = centre.x;
		int parentY = centre.y;
		int childWidth = (int)child.getSize().width / 2;
		int childHeight = (int)child.getSize().height /2;

		return new Point(parentX - childWidth, parentY - childHeight);
		

	}
}
