/**
 * The JamochaMUD Frame synchroniser:
 * SyncFrameGroup.java manages (obviously) groups of SyncFrames
 * $Id: SyncFrameGroup.java 1.9 2001/06/27 23:52:54 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2000  Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package anecho.gui;

import java.awt.Component;
import java.awt.Point;

import java.util.Vector;

import anecho.gui.SyncFrame;

	/**
	 * The JamochaMUD Frame Group handler:
	 * SyncFrame.java handles the synchronising of
	 * frame minimize/maximize, and potentially, movement events.
	 * This class coordinates the SyncFrames in each group.
         * @version $Id: SyncFrameGroup.java 1.9 2001/06/27 23:52:54 jeffnik Exp $
         * @author Jeff Robinson
	 */
public class SyncFrameGroup{

	// VARIABLES
	private Vector groupFrames = new Vector(0, 1);	// The vector of all the frames in this group
	public static final int SHOW = 0;
	public static final int HIDE = 1;
	public static final int SET_ALL_TRUE = 2;
	public static final int SET_ALL_FALSE = 3;

	private boolean locked = false;	// Set the lock false.  When true, this group
						// of frames will not respond to movement, etc.

	// CONSTRUCTORS
	/** Create a SyncFrameGroup and assign it the provided name */
	public SyncFrameGroup() {
	}

	// METHODS
	/** Add a new SyncFrame to the group */
	public void add(SyncFrame newFrame) {
		groupFrames.addElement(newFrame);
		// groupFrames.addElement(newFrame.paramString());
	}

	/** Remove a SyncFrame from the group */
	public void remove(SyncFrame origin) {
		try {
			groupFrames.removeElement(origin);
		} catch (Exception e) {
			System.out.println("SyncFrameGroup.remove error " + e);
		}
	}
        /** Move all the frames in this group with the exception of the "origin" frame */
        public void moveFrames(SyncFrame origin, int xMove, int yMove) {
            String tempName;
            int length = groupFrames.size();

            for (int i = 0; i < length; i++) {
                tempName = new String(((SyncFrame)groupFrames.elementAt(i)).paramString());
                // System.out.println("Attempt to move " + tempName);

                if (!origin.paramString().equals(tempName) && ((SyncFrame)groupFrames.elementAt(i)).isSynced()) {
                    try {
                        // We'll move this component
                        Point pos = ((SyncFrame)groupFrames.elementAt(i)).getLocationOnScreen();
                        ((SyncFrame)groupFrames.elementAt(i)).setLocation(pos.x + xMove, pos.y + yMove);
                        ((SyncFrame)groupFrames.elementAt(i)).setLock(true);
                        // System.out.println("Move a success for " + tempName);
                    } catch (Exception e) {
                        // System.out.println("SyncFrameGroup exception in moving " + e);
                    }
                }
            }

        }

        //	/** Hide all the frames that have not already been hidden/minimised */
//	public synchronized void hideFrames(SyncFrame origin) {
//		System.out.println("Our origin frame is " + origin);
//		String tempName;
//		int length = groupFrames.size();
//
//		for (int i = 0; i < length; i++) {
//			tempName = new String(((SyncFrame)groupFrames.elementAt(i)).paramString());
//			if (!origin.paramString().equals(tempName) && ((SyncFrame)groupFrames.elementAt(i)).isSynced()) {
//				System.out.println("Hiding: " + tempName);
//				((SyncFrame)groupFrames.elementAt(i)).setVisible(false);
//			}
//		}
//	}

	/** A common loop using switches */
	public synchronized void changeState(SyncFrame origin, int action) {
		String tempName;
		int length = groupFrames.size();

		for (int i = 0; i < length; i++) {
			tempName = new String(((SyncFrame)groupFrames.elementAt(i)).paramString());
			// if (!origin.paramString().equals(tempName) && ((SyncFrame)groupFrames.elementAt(i)).isSynced()) {
			if (!origin.paramString().equals(tempName)) {
				try {
				((SyncFrame)groupFrames.elementAt(i)).setLock(true);
				switch (action) {
					case SHOW: {
						if (((SyncFrame)groupFrames.elementAt(i)).isSynced()) {
							((SyncFrame)groupFrames.elementAt(i)).setVisible(true);
						}
						break;
					}
					case HIDE: {
						if (((SyncFrame)groupFrames.elementAt(i)).isSynced()) {
							((SyncFrame)groupFrames.elementAt(i)).setVisible(false);
						}
						break;
					}
					case SET_ALL_TRUE: {
						((SyncFrame)groupFrames.elementAt(i)).setSync(true);
						break;
					}
					case SET_ALL_FALSE: {
						((SyncFrame)groupFrames.elementAt(i)).setSync(false);
					}
				} // end "switch"
				} catch (Exception e) {
					System.out.println("Errant class... must.... destroy...!" + e);
				}
			} // end "if"
		} // end "for" loop

		ClearLocks();
	}

	/** This clears the 'lock' status from all our frames, but
	 * to my way of thinking, this method should be removed
	 * in favour of actually finding the 'lock-bug' */
	private synchronized void ClearLocks() {
		String tempName;
		int length = groupFrames.size();

		for (int i = 0; i < length; i++) {
			//tempName = new String(((SyncFrame)groupFrames.elementAt(i)).paramString());
			((SyncFrame)groupFrames.elementAt(i)).setLock(false);
		}
	}
}
