/*
 * Decompiled with CFR 0.152.
 */
package samples.CdfEditor;

import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import samples.CdfEditor.Gateway;
import samples.CdfEditor.PropertyBox;
import samples.CdfEditor.Transform;
import samples.CdfEditor.XMLComponent;
import samples.CdfEditor.XMLComponentEdt;
import samples.CdfEditor.XMLComponentM;
import samples.SiteOutliner.SiteOutliner;
import samples.SiteOutliner.SiteOutlinerUI;

public class CdfEditor
extends Frame
implements ActionListener {
    static final String PROCPACKAGE = "samples.CdfEditor.Proc";
    Frame f = new Frame("TRL CDF Editor Version 1.0");
    ScrollPane sp;
    XMLComponent xc;
    public PropertyBox pbox;
    SiteOutlinerUI ui;
    SiteOutliner so;

    public CdfEditor(String string) throws FileNotFoundException, IOException {
        try {
            Object object;
            if (!string.equals("")) {
                FileInputStream fileInputStream = new FileInputStream(string);
                object = new Transform(string, PROCPACKAGE);
                this.xc = ((Transform)object).readStream(fileInputStream);
                fileInputStream.close();
            }
            this.f.setLayout(new BorderLayout());
            ((Component)this.f).setBackground(new Color(255, 255, 255));
            if (this.xc != null) {
                object = new Gateway();
                ((XMLComponentM)this.xc).setGateway((Gateway)object);
                this.f.add((Component)object, "South");
            }
            this.sp = new ScrollPane();
            this.f.add((Component)this.sp, "Center");
            object = new MenuBar();
            this.f.setMenuBar((MenuBar)object);
            Menu menu = new Menu("File");
            menu.setFont(new Font("Helvetica", 0, 14));
            MenuItem menuItem = new MenuItem("Open");
            menu.add(menuItem);
            menuItem.addActionListener(this);
            menuItem = new MenuItem("Scan");
            menu.add(menuItem);
            menuItem.addActionListener(this);
            menuItem = new MenuItem("Save");
            menu.add(menuItem);
            menuItem.addActionListener(this);
            menuItem = new MenuItem("Quit");
            menu.add(menuItem);
            menuItem.addActionListener(this);
            ((MenuBar)object).add(menu);
            if (this.xc != null) {
                this.sp.add(this.xc);
            }
            this.f.pack();
            ((Component)this.f).setSize(600, 600);
            this.f.show();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            if (stringArray.length == 1) {
                new CdfEditor(stringArray[0]);
                return;
            }
            new CdfEditor("");
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Cursor cursor = new Cursor(3);
        ((Component)this.f).setCursor(cursor);
        if (actionEvent.getActionCommand().equals("Quit")) {
            System.exit(0);
        } else if (actionEvent.getActionCommand().equals("Scan")) {
            Frame frame = new Frame("Site Outliner");
            ((Component)frame).setSize(300, 300);
            this.ui = new SiteOutlinerUI(frame);
            this.ui.show();
            this.so = new SiteOutliner(this.ui);
            TXDocument tXDocument = this.so.getDocument();
            Gateway gateway = new Gateway();
            this.f.add((Component)gateway, "South");
            Transform transform = new Transform("", PROCPACKAGE);
            this.xc = transform.makeComponent((TXElement)tXDocument.getDocumentElement());
            ((XMLComponentM)this.xc).setGateway(gateway);
            ((XMLComponentM)this.xc).setGateway(((XMLComponentM)this.xc).getGateway());
            this.sp.add(this.xc);
            this.f.pack();
            this.f.show();
        } else if (actionEvent.getActionCommand().equals("Open")) {
            Frame frame = new Frame("Open CDF File");
            FileDialog fileDialog = new FileDialog(frame, "Select CDF File");
            fileDialog.show();
            String string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            try {
                this.xc = null;
                FileInputStream fileInputStream = new FileInputStream(String.valueOf(string) + string2);
                Transform transform = new Transform(string2, PROCPACKAGE);
                this.xc = transform.readStream(fileInputStream);
                fileInputStream.close();
                if (this.xc != null) {
                    Gateway gateway = new Gateway();
                    ((XMLComponentM)this.xc).setGateway(gateway);
                    this.f.add((Component)gateway, "South");
                    this.sp.add(this.xc);
                    this.f.pack();
                    this.f.show();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else if (actionEvent.getActionCommand().equals("Save")) {
            Frame frame = new Frame("Save CDF File");
            FileDialog fileDialog = new FileDialog(frame, "Select CDF File", 1);
            fileDialog.show();
            String string = fileDialog.getDirectory();
            String string3 = fileDialog.getFile();
            try {
                TXElement tXElement;
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string) + string3);
                if (this.xc != null && (tXElement = ((XMLComponentEdt)this.xc).getElement()).getParentNode() instanceof TXDocument) {
                    TXDocument tXDocument = (TXDocument)tXElement.getParentNode();
                    tXDocument.print((Writer)new PrintWriter(new OutputStreamWriter(fileOutputStream)));
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        ((Component)this.f).setCursor(new Cursor(0));
    }
}

