/*
 * Decompiled with CFR 0.152.
 */
package samples.Miscellaneous;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.FormatPrintVisitor;
import com.ibm.xml.parser.InsertableElement;
import com.ibm.xml.parser.NonRecursivePreorderTreeTraversal;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.Visitor;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeneratingSample
extends WindowAdapter
implements Runnable {
    static final String S_EOC = "******* End of content *******";
    static final String S_TEXT = "**** any text ****";
    DTD m_dtd;
    Hashtable m_hash;
    Frame m_frame;
    Vector m_allel;
    TextArea m_text;
    TXElement m_root;

    public static void main(String[] stringArray) {
        new GeneratingSample(stringArray);
    }

    GeneratingSample(String[] stringArray) {
        try {
            Object object;
            String string = null;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].charAt(0) != '-') {
                    string = stringArray[n];
                } else {
                    System.err.println("Warning: Unknown option: " + stringArray[n]);
                }
                ++n;
            }
            Parser parser = new Parser(string);
            this.m_dtd = parser.readDTDStream(parser.getInputStream(string, null, Stderr.file2URL((String)string).toString()));
            if (this.m_dtd == null) {
                System.err.println("no DTD");
                return;
            }
            this.m_allel = new Vector();
            Enumeration enumeration = this.m_dtd.getElementDeclarations();
            while (enumeration.hasMoreElements()) {
                object = (ElementDecl)enumeration.nextElement();
                this.m_allel.addElement(object.getName());
            }
            this.m_hash = this.m_dtd.prepareTable((String)this.m_allel.elementAt(0));
            enumeration = this.m_allel.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.m_hash.put(object, new InsertableElement((String)object));
            }
            this.m_frame = new Frame("Generating Sample");
            this.m_frame.addWindowListener(this);
            this.m_text = new TextArea();
            this.m_frame.add((Component)this.m_text, "Center");
            this.m_frame.pack();
            object = this.m_frame;
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)object).setSize(384, 512);
            ((Component)object).setLocation((dimension.width - 384) / 2, (dimension.height - 512) / 2);
            this.m_frame.show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void centerComponent(Component component, int n, int n2, Dimension dimension) {
        component.setSize(n, n2);
        component.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
    }

    public static void centerComponentInScreen(Component component, int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize(n, n2);
        component.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
    }

    public void windowOpened(WindowEvent windowEvent) {
        new Thread(this).start();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.m_frame.dispose();
        System.exit(0);
    }

    void out() {
        try {
            StringWriter stringWriter = new StringWriter();
            new NonRecursivePreorderTreeTraversal((Visitor)new FormatPrintVisitor((Writer)stringWriter)).traverse((Node)this.m_root);
            stringWriter.close();
            this.m_text.setText(stringWriter.toString());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void run() {
        this.m_text.setText("Select root element name from the list on the dialog.");
        String string = GeneratingSample.choice(this.m_frame, "Select root element", GeneratingSample.sortStringVector(this.m_allel));
        this.m_root = new TXElement(string);
        this.out();
        this.construct(this.m_root);
        System.err.println("Complete.");
    }

    void construct(TXElement tXElement) {
        switch (this.m_dtd.getContentType(tXElement.getNodeName())) {
            case -1: {
                System.err.println("This element " + tXElement.getNodeName() + " is not declared.");
                return;
            }
            case 1: {
                System.err.println("This element " + tXElement.getNodeName() + " is declared as EMPTY.");
                return;
            }
            case 2: {
                System.err.println("This element " + tXElement.getNodeName() + " is declared as ANY.");
                return;
            }
            case 4: {
                Vector vector;
                while (!((vector = GeneratingSample.makeAvailables(this.m_dtd, tXElement, this.m_hash)).size() == 0 || vector.size() == 1 && S_EOC.equals((String)vector.elementAt(0)))) {
                    vector = GeneratingSample.sortNames(this.m_dtd.makeContentElementList(tXElement.getNodeName()), vector);
                    String string = GeneratingSample.choice(this.m_frame, "Select next child of " + tXElement.getNodeName(), vector);
                    if (string.equals("#PCDATA") || string.equals(S_TEXT)) {
                        tXElement.appendChild((Node)new TXText("Some text"));
                        this.out();
                        continue;
                    }
                    if (string.equals(S_EOC)) {
                        return;
                    }
                    TXElement tXElement2 = new TXElement(string);
                    tXElement.appendChild((Node)tXElement2);
                    this.out();
                    this.construct(tXElement2);
                }
                return;
            }
        }
        System.err.println("Internal Error.");
    }

    static Vector makeAvailables(DTD dTD, TXElement tXElement, Hashtable hashtable) {
        Vector<String> vector = new Vector<String>();
        dTD.getAppendableElements((Element)tXElement, hashtable);
        if (((InsertableElement)hashtable.get((Object)" *ERROR* ")).status) {
            System.err.println("Element has wrong structure.");
        } else {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                InsertableElement insertableElement = (InsertableElement)enumeration.nextElement();
                if (insertableElement.name.equals(" *ERROR* ") || !insertableElement.status) continue;
                if (insertableElement.name.equals(" *EOC* ")) {
                    vector.addElement(S_EOC);
                    continue;
                }
                vector.addElement(insertableElement.name);
            }
        }
        return vector;
    }

    static String choice(Frame frame, String string, Vector vector) {
        Object object;
        Dialog dialog = new Dialog(frame, string, true);
        List list = new List();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            list.add((String)(((String)object).equals("#PCDATA") ? S_TEXT : object));
        }
        object = new Button("OK");
        dialog.add((Component)list, "Center");
        dialog.add((Component)object, "South");
        ((Button)object).addActionListener(new 1(dialog, list));
        dialog.pack();
        Object object2 = dialog;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)object2).setSize(256, 384);
        ((Component)object2).setLocation((dimension.width - 256) / 2, (dimension.height - 384) / 2);
        dialog.show();
        object2 = list.getSelectedItem();
        dialog.dispose();
        System.err.println("SELECTED: " + (String)object2);
        return object2;
    }

    private static void fall(String[] stringArray, int n, int n2) {
        int n3 = 2 * n2 + 1;
        if (n3 < n) {
            if (n3 + 1 < n && stringArray[n3].compareTo(stringArray[n3 + 1]) < 0) {
                n3 = 2 * n2 + 2;
            }
            if (stringArray[n2].compareTo(stringArray[n3]) < 0) {
                String string = stringArray[n2];
                stringArray[n2] = stringArray[n3];
                stringArray[n3] = string;
                GeneratingSample.fall(stringArray, n, n3);
            }
        }
    }

    static void heapSort(String[] stringArray) {
        int n = stringArray.length / 2;
        while (n >= 0) {
            GeneratingSample.fall(stringArray, stringArray.length, n);
            --n;
        }
        n = stringArray.length - 1;
        while (n > 0) {
            String string = stringArray[0];
            stringArray[0] = stringArray[n];
            stringArray[n] = string;
            GeneratingSample.fall(stringArray, n, 0);
            --n;
        }
    }

    static Vector sortStringVector(Vector vector) {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        GeneratingSample.heapSort((String[])objectArray);
        vector.removeAllElements();
        vector.ensureCapacity(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    static Vector sortNames(Vector vector, Vector vector2) {
        if (vector == null) {
            return GeneratingSample.sortStringVector(vector2);
        }
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            int n2 = vector2.indexOf(string);
            if (n2 >= 0) {
                vector3.addElement(string);
                vector2.removeElementAt(n2);
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < vector2.size()) {
            vector3.addElement((String)vector2.elementAt(n3));
            ++n3;
        }
        return vector3;
    }

    private static final class 1
    implements ActionListener {
        private final /* synthetic */ Dialog val$f;
        private final /* synthetic */ List val$list;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.val$list.getSelectedItem() != null) {
                ((Component)this.val$f).setVisible(false);
                return;
            }
            System.err.println("Select 1 item!");
        }

        /* synthetic */ 1(Dialog dialog, List list) {
            this.val$f = dialog;
            this.val$list = list;
        }
    }
}

