/*
 * Decompiled with CFR 0.152.
 */
package samples.Miscellaneous;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.TagHandler;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Positioning {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Require 1 filename.");
            System.exit(1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            Parser parser = new Parser(stringArray[0]);
            MyFactory myFactory = new MyFactory();
            parser.setElementFactory((TXDocument)myFactory);
            parser.setTagHandler((TagHandler)myFactory);
            parser.readStream((InputStream)fileInputStream);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static interface Position {
        public int getPosition();

        public void setPosition(int var1);

        public int getPositionByType();

        public void setPositionByType(int var1);
    }

    static class EXElement
    extends TXElement
    implements Position {
        int m_childposition = -1;
        int m_typeposition = -1;
        int m_nodecount_start = -1;
        int m_nodecount_end = -1;

        public int getPosition() {
            return this.m_childposition;
        }

        public void setPosition(int n) {
            this.m_childposition = n;
        }

        public int getPositionByType() {
            return this.m_typeposition;
        }

        public void setPositionByType(int n) {
            this.m_typeposition = n;
        }

        int getStartCount() {
            return this.m_nodecount_start;
        }

        void setStartCount(int n) {
            this.m_nodecount_start = n;
        }

        int getEndCount() {
            return this.m_nodecount_end;
        }

        void setEndCount(int n) {
            this.m_nodecount_end = n;
        }

        boolean isInside(EXElement eXElement) {
            return this.m_nodecount_start < eXElement.getStartCount() && eXElement.getEndCount() < this.m_nodecount_end;
        }

        boolean isInside(EXText eXText) {
            return this.m_nodecount_start < eXText.getCount() && eXText.getCount() < this.m_nodecount_end;
        }

        public EXElement(String string) {
            super(string);
        }
    }

    static class EXText
    extends TXText
    implements Position {
        int m_childposition = -1;
        int m_typeposition = -1;
        int m_nodecount = -1;

        public int getPosition() {
            return this.m_childposition;
        }

        public void setPosition(int n) {
            this.m_childposition = n;
        }

        public int getPositionByType() {
            return this.m_typeposition;
        }

        public void setPositionByType(int n) {
            this.m_typeposition = n;
        }

        int getCount() {
            return this.m_nodecount;
        }

        void setCount(int n) {
            this.m_nodecount = n;
        }

        public EXText(String string) {
            super(string);
        }
    }

    static class MyFactory
    extends TXDocument
    implements TagHandler {
        int m_counter;

        public Element createElement(String string) {
            EXElement eXElement = new EXElement(string);
            eXElement.setFactory(this);
            return eXElement;
        }

        public TXText createTextNode(String string, boolean bl) {
            EXText eXText = new EXText(string);
            eXText.setFactory(this);
            eXText.setIsIgnorableWhitespace(bl);
            return eXText;
        }

        public TXText createTextNode(char[] cArray, int n, int n2, boolean bl) {
            EXText eXText = new EXText(new String(cArray, n, n2));
            eXText.setFactory(this);
            eXText.setIsIgnorableWhitespace(bl);
            eXText.setCount(this.m_counter++);
            return eXText;
        }

        public void handleStartTag(TXElement tXElement, boolean bl) {
            ((EXElement)tXElement).setStartCount(this.m_counter++);
        }

        public void handleEndTag(TXElement tXElement, boolean bl) {
            ((EXElement)tXElement).setEndCount(this.m_counter++);
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            int n = 0;
            Node node = tXElement.getFirstChild();
            while (node != null) {
                if (node instanceof Position) {
                    ((Position)((Object)node)).setPosition(n);
                }
                ++n;
                String string = null;
                if (node instanceof EXText) {
                    string = "#PCDATA";
                } else if (node instanceof EXElement) {
                    string = ((EXElement)((Object)node)).getTagName();
                }
                if (string != null) {
                    Integer n2 = (Integer)hashtable.get(string);
                    int n3 = 0;
                    if (n2 == null) {
                        hashtable.put(string, new Integer(0));
                    } else {
                        n3 = n2 + 1;
                        hashtable.put(string, new Integer(n3));
                    }
                    ((Position)((Object)node)).setPositionByType(n3);
                }
                node = node.getNextSibling();
            }
        }

        MyFactory() {
        }
    }
}

