/*
 * Decompiled with CFR 0.152.
 */
package samples.Miscellaneous;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.util.TreeFactory;
import com.ibm.xml.xpointer.Pointed;
import com.ibm.xml.xpointer.XPointer;
import com.ibm.xml.xpointer.XPointerParseException;
import com.ibm.xml.xpointer.XPointerParser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPointerDemoView
extends JFrame
implements ActionListener {
    UIManager.LookAndFeelInfo[] m_alooks;
    JTree m_tree;
    JScrollPane m_scrollpane;
    JTextField m_text;
    JButton m_button;
    Vector components = new Vector();
    TXDocument m_doc;
    boolean m_byuser = false;

    static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Require 1 filename");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            Parser parser = new Parser(string);
            parser.setElementFactory((TXDocument)new TreeFactory());
            TXDocument tXDocument = parser.readStream(parser.getInputStream(string, null, Stderr.file2URL((String)string).toString()));
            new XPointerDemoView("XPointer demonstration program", tXDocument).show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.m_text || string.equals("Go")) {
            this.m_byuser = true;
            try {
                this.m_tree.clearSelection();
                XPointer xPointer = new XPointerParser().parse(this.m_text.getText());
                Pointed pointed = xPointer.point((Document)this.m_doc);
                if (pointed.size() == 0) {
                    new MessageBox((Frame)this, "Message:", "Can't find such a node.  XML for Java now doesn't support html() origin() string() span().").show();
                } else {
                    Enumeration enumeration = pointed.elements();
                    while (enumeration.hasMoreElements()) {
                        Pointed.Item item = (Pointed.Item)enumeration.nextElement();
                        if (item.type != 0 && item.type != 1) continue;
                        Node node = item.node;
                        Vector<Node> vector = new Vector<Node>();
                        while (node != null) {
                            vector.insertElementAt(node, 0);
                            node = node.getParentNode();
                        }
                        Object[] objectArray = new Object[vector.size()];
                        vector.copyInto(objectArray);
                        this.m_tree.addSelectionPath(new TreePath(objectArray));
                    }
                }
            }
            catch (XPointerParseException xPointerParseException) {
                new MessageBox((Frame)this, "Message:", xPointerParseException.toString()).show();
            }
            this.m_byuser = false;
            return;
        }
        int n = 0;
        while (n < this.m_alooks.length) {
            if (string.equals(this.m_alooks[n].getName())) {
                try {
                    UIManager.setLookAndFeel(this.m_alooks[n].getClassName());
                    int n2 = 0;
                    while (n2 < this.components.size()) {
                        ((JComponent)this.components.elementAt(n2)).updateUI();
                        ++n2;
                    }
                    this.validateTree();
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    return;
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    return;
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    unsupportedLookAndFeelException.printStackTrace();
                    return;
                }
            }
            ++n;
        }
    }

    private static void add(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public XPointerDemoView(String string, TXDocument tXDocument) {
        super(string);
        JComponent jComponent;
        this.m_doc = tXDocument;
        this.addWindowListener(new 1());
        this.m_alooks = UIManager.getInstalledLookAndFeels();
        JMenu jMenu = new JMenu("Look&Feel");
        this.components.addElement(jMenu);
        int n = 0;
        while (n < this.m_alooks.length) {
            jComponent = new JMenuItem(this.m_alooks[n].getName());
            this.components.addElement(jComponent);
            ((AbstractButton)jComponent).addActionListener(this);
            jMenu.add((JMenuItem)jComponent);
            ++n;
        }
        jComponent = new JMenuBar();
        ((JMenuBar)jComponent).add(jMenu);
        this.components.addElement(jComponent);
        this.setJMenuBar((JMenuBar)jComponent);
        this.m_text = new JTextField();
        this.m_text.addActionListener(this);
        this.components.addElement(this.m_text);
        this.m_button = new JButton("Go");
        this.m_button.addActionListener(this);
        this.components.addElement(this.m_button);
        this.m_tree = new JTree((TreeNode)tXDocument);
        this.m_scrollpane = new JScrollPane(this.m_tree);
        this.components.addElement(this.m_scrollpane);
        this.components.addElement(this.m_tree);
        this.m_tree.getSelectionModel().setSelectionMode(4);
        this.m_tree.addTreeSelectionListener(new 2());
        JPanel jPanel = new JPanel();
        this.components.addElement(jPanel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        Serializable serializable = jPanel;
        JComponent jComponent2 = new JLabel("XPointer: ");
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        serializable.add(jComponent2);
        gridBagConstraints.weightx = 1.0;
        serializable = jPanel;
        jComponent2 = this.m_text;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        serializable.add(jComponent2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        serializable = jPanel;
        jComponent2 = this.m_button;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        serializable.add(jComponent2);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.m_scrollpane, "Center");
        ((Component)this).setSize(400, 512);
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((((Dimension)serializable).width - 400) / 2, (((Dimension)serializable).height - 512) / 2);
    }

    static /* synthetic */ void access$0(Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!XPointerDemoView.this.m_byuser) {
                Child child = (Child)treeSelectionEvent.getPath().getLastPathComponent();
                XPointer xPointer = child.makeXPointer();
                XPointerDemoView.this.m_text.setText(xPointer == null ? "" : xPointer.toString());
            }
        }

        /* synthetic */ 2() {
        }
    }

    public static class MessageBox
    extends JDialog
    implements ActionListener {
        JButton okbutton;

        public MessageBox(Frame frame, String string, String string2) {
            super(frame, string, true);
            JLabel jLabel;
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            Serializable serializable = jLabel = new JLabel(string2);
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            container.add((Component)serializable);
            this.okbutton = new JButton("OK");
            this.okbutton.addActionListener(this);
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridheight = 0;
            serializable = this.okbutton;
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            container.add((Component)serializable);
            serializable = jLabel.getPreferredSize();
            Dimension dimension = this.okbutton.getPreferredSize();
            int n = ((Dimension)serializable).width + 32;
            int n2 = ((Dimension)serializable).height + dimension.height + 32;
            ((Component)this).setSize(n, n2);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((dimension2.width - n) / 2, (dimension2.height - n2) / 2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.okbutton) {
                ((Component)this).setVisible(false);
            }
        }
    }
}

