/*
 * Decompiled with CFR 0.152.
 */
package samples.SiteOutliner;

import com.ibm.xml.parser.MIME2Java;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import samples.SiteOutliner.SiteOutlinerUI;

public class SiteOutliner
extends Frame
implements WindowListener {
    static boolean opt_d;
    static DateFormat dateFormat;
    static boolean opt_UI;
    static boolean commandLineMode;
    static Date sinceDate;
    static String[] exList;
    static String[] fTypes;
    static String dir;
    static String url;
    static String gencoding;
    static String goutencoding;
    static int gdepth;
    private String docRootDir;
    private String urlPrefix;
    private File rootDir;
    private Date modifiedSince;
    private String[] fileTypes;
    private String[] excludingPathNames;
    private SiteOutliner me;
    private String encoding;
    private int depth = 10;
    TXDocument doc;
    private SiteOutlinerUI siteOutlinerUI;
    private String outencoding;
    private MenuBar menuBar;
    private Menu fileMenu;
    private Menu optionMenu;
    private Menu helpMenu;
    private MenuItem scanMenuItem;
    private MenuItem saveMenuItem;
    private MenuItem exitMenuItem;
    private MenuItem aboutMenuItem;
    private CheckboxMenuItem debugMenuItem;
    private Dialog aboutDialog;
    private Button aboutDialogOkButton;
    private Label aboutDialogLabel;
    private TextArea textArea;
    private FileDialog saveFileDialog;
    private Dialog processDialog;
    private Label processDialogLabel;
    private Button processDialogCancelButton;

    public static void main(String[] stringArray) {
        SiteOutliner.checkopt(stringArray);
        if (dir == null) {
            SiteOutliner siteOutliner = new SiteOutliner();
            siteOutliner.show();
            return;
        }
        commandLineMode = true;
        if (url == null) {
            SiteOutliner.usage(stringArray);
        }
        System.err.println("Scan starting from " + dir + ", urlPrefix=" + url);
        System.err.println("  Only files modified since " + DateFormat.getDateInstance().format(sinceDate));
        System.err.print("  Looking for files that end with ");
        int n = 0;
        while (n < fTypes.length) {
            System.err.print(String.valueOf(fTypes[n]) + ";");
            ++n;
        }
        System.err.println();
        System.err.print("  Except for ");
        n = 0;
        while (n < exList.length) {
            System.err.print(String.valueOf(exList[n]) + ";");
            ++n;
        }
        System.err.println();
        SiteOutliner siteOutliner = new SiteOutliner(dir, url);
        siteOutliner.modifiedSince = sinceDate;
        siteOutliner.fileTypes = fTypes;
        siteOutliner.excludingPathNames = exList;
        siteOutliner.encoding = gencoding;
        siteOutliner.outencoding = goutencoding;
        siteOutliner.depth = gdepth;
        siteOutliner.doIt();
        siteOutliner.printIt();
    }

    private static void checkopt(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].charAt(0) == '-') {
                String string;
                int n3;
                StringTokenizer stringTokenizer;
                if (stringArray[n2].equals("-debug")) {
                    opt_d = true;
                } else if (stringArray[n2].equals("-since")) {
                    if (++n2 >= stringArray.length) {
                        SiteOutliner.usage(stringArray);
                    }
                    try {
                        sinceDate = DateFormat.getDateInstance().parse(stringArray[n2]);
                    }
                    catch (ParseException parseException) {
                        System.err.println(parseException);
                        System.exit(-1);
                    }
                } else if (stringArray[n2].equals("-filetype")) {
                    if (++n2 >= stringArray.length) {
                        SiteOutliner.usage(stringArray);
                    }
                    stringTokenizer = new StringTokenizer(stringArray[n2], ";", false);
                    fTypes = new String[stringTokenizer.countTokens()];
                    n3 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        SiteOutliner.fTypes[n3] = string = stringTokenizer.nextToken();
                        ++n3;
                    }
                } else if (stringArray[n2].equals("-exclude")) {
                    if (++n2 >= stringArray.length) {
                        SiteOutliner.usage(stringArray);
                    }
                    stringTokenizer = new StringTokenizer(stringArray[n2], ";", false);
                    exList = new String[stringTokenizer.countTokens()];
                    n3 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        SiteOutliner.exList[n3] = string = stringTokenizer.nextToken();
                        ++n3;
                    }
                } else if (stringArray[n2].equals("-encoding")) {
                    if (++n2 >= stringArray.length) {
                        SiteOutliner.usage(stringArray);
                    }
                    gencoding = stringArray[n2];
                } else if (stringArray[n2].equals("-outencoding")) {
                    if (++n2 >= stringArray.length) {
                        SiteOutliner.usage(stringArray);
                    }
                    goutencoding = stringArray[n2];
                } else if (stringArray[n2].equals("-depth")) {
                    if (++n2 >= stringArray.length) {
                        SiteOutliner.usage(stringArray);
                    }
                    gdepth = Integer.parseInt(stringArray[n2]);
                } else if (stringArray[n2].equals("-help")) {
                    SiteOutliner.usage(stringArray);
                } else {
                    SiteOutliner.usage(stringArray);
                }
            } else if (n == 0) {
                dir = stringArray[n2];
                ++n;
            } else if (n == 1) {
                url = stringArray[n2];
                ++n;
            }
            ++n2;
        }
    }

    private static void usage(String[] stringArray) {
        System.err.println("1. Command line version");
        System.err.println("  Usage: java [options..] SiteOutliner dir URLprefix");
        System.err.println("    Example: java SiteOutliner k:/xml http://anego.trl.ibm.com");
        System.err.println("    Option:");
        System.err.println("      -debug: debug mode on");
        System.err.println("      -since <date>: Files only modifined since <date>");
        System.err.println("      -filetype <filetypes>: Files types separated by ';', default='.htm;.html;.HTM;.HTML'");
        System.err.println("      -exclude <filenames>: File/dir names to be excluded, separated by ';', default=''");
        System.err.println("      -encoding <javaencoding>: Specify encoding for input  eg, 'JISAutoDetect'");
        System.err.println("      -outencoding <mimecharset>: Specify encoding for output  eg, 'ISO-2022-JP'");
        System.err.println("      -depth <depth>: Depth limit of directory search");
        System.err.println("2. GUI version");
        System.err.println("  Usage: java [options..] SiteOutliner");
        System.exit(0);
    }

    public SiteOutliner() {
        this.initializeFrame();
        this.me = this;
    }

    public SiteOutliner(SiteOutlinerUI siteOutlinerUI) {
        this.setParameters(siteOutlinerUI);
        this.doIt();
    }

    public SiteOutliner(String string, String string2) {
        this.docRootDir = string;
        this.urlPrefix = string2;
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("URL is invalid, try again. " + malformedURLException);
            System.exit(-1);
        }
        try {
            this.rootDir = new File(this.docRootDir);
            if (!this.rootDir.isDirectory()) {
                System.err.println("Error: " + this.docRootDir + " is not a directory");
                System.exit(-1);
            }
            this.docRootDir = this.rootDir.getAbsolutePath();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Error: " + throwable);
            System.exit(-1);
            return;
        }
    }

    public TXDocument getDocument() {
        return this.doc;
    }

    private void setParameters(SiteOutlinerUI siteOutlinerUI) {
        this.rootDir = siteOutlinerUI.getRootDir();
        this.urlPrefix = siteOutlinerUI.getDocumentBaseURL();
        this.modifiedSince = siteOutlinerUI.getSince();
        this.fileTypes = siteOutlinerUI.getFileTypes();
        this.excludingPathNames = siteOutlinerUI.getExcludingPathNames();
        this.depth = siteOutlinerUI.getSearchDepth();
    }

    private void doIt() {
        if (!commandLineMode) {
            if (this.processDialog == null) {
                this.processDialog = new Dialog(this);
                this.processDialog.setTitle("Processing ...");
                ((Component)this.processDialog).setBounds(50, 50, 400, 100);
                this.processDialogLabel = new Label("");
                this.processDialog.add(this.processDialogLabel);
                this.processDialog.show();
            }
            ((Component)this.processDialog).setVisible(true);
        }
        this.doc = new TXDocument();
        this.doc.setPrintInternalDTD(true);
        this.doc.setVersion("1.0");
        Element element = this.doc.createElement("CHANNEL");
        this.doc.appendChild((Node)element);
        this.processDirectory(element, this.rootDir, this.urlPrefix, this.depth);
        if (!commandLineMode) {
            ((Component)this.processDialog).setVisible(false);
        }
    }

    private int processDirectory(Element element, File file, String string, int n) {
        if (n-- <= 0) {
            return 0;
        }
        if (opt_d) {
            System.err.println("Processing " + file.getAbsolutePath() + "[" + n + "]");
        }
        int n2 = 0;
        String string2 = string;
        File file2 = null;
        try {
            String[] stringArray = file.list();
            if (stringArray != null) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (!this.exclude(stringArray[n3])) {
                        Element element2;
                        file2 = new File(file, stringArray[n3]);
                        String string3 = String.valueOf(string) + "/" + stringArray[n3];
                        if (this.processDialogLabel != null) {
                            this.processDialogLabel.setText("  Processing ...  " + string3);
                        }
                        if (file2.isDirectory()) {
                            element2 = this.doc.createElement("CHANNEL");
                            int n4 = this.processDirectory(element2, file2, string3, n);
                            if (n4 > 0) {
                                element.appendChild(element2);
                                n2 += n4;
                            }
                        } else if (this.filterFile(file2)) {
                            element2 = this.doc.createElement("ITEM");
                            element2.setAttribute("HREF", string3);
                            this.processItem(element2, file2);
                            element.appendChild(element2);
                            ++n2;
                            if (stringArray[n3].startsWith("index.htm")) {
                                string2 = ((TXElement)element2).getElementNamed("TITLE").getText();
                            }
                        } else if (stringArray[n3].startsWith("index.htm")) {
                            string2 = this.getTitle(file2);
                        }
                    }
                    ++n3;
                }
            }
            Element element3 = this.doc.createElement("TITLE");
            element3.appendChild(this.doc.createTextNode(String.valueOf(string2) + " (" + n2 + ")"));
            element.appendChild(element3);
            element.setAttribute("HREF", string);
        }
        catch (Throwable throwable) {
            if (file2 != null) {
                System.err.println("Error in processDirectory():" + throwable + " File=" + file2.getAbsolutePath());
            }
            System.err.println("Error in processDirectory():" + throwable + " Dir=" + file);
        }
        return n2;
    }

    private void processItem(Element element, File file) {
        Element element2 = this.doc.createElement("TITLE");
        element.appendChild(element2);
        String string = this.getTitle(file);
        if (string == null) {
            string = "No title";
        }
        element2.appendChild(this.doc.createTextNode(string));
        Element element3 = this.doc.createElement("ABSTRACT");
        element.appendChild(element3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private String getTitle(File file) {
        String string = "";
        if (opt_d) {
            System.err.println("Processing file " + file.getAbsolutePath() + " with encoding " + this.encoding);
        }
        try {
            int n;
            String string2;
            BufferedReader bufferedReader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding)) : new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                n = string2.indexOf("<title>");
                if (n < 0) {
                    n = string2.indexOf("<TITLE>");
                }
                if (n < 0) {
                    n = string2.indexOf("<Title>");
                }
                if (n < 0) continue;
                string = String.valueOf(string) + string2.substring(n + 7);
                break;
            }
            if ((n = string.indexOf("</title>")) < 0) {
                n = string.indexOf("</TITLE>");
            }
            if (n < 0) {
                n = string.indexOf("</Title>");
            }
            if (n >= 0) {
                if ((string = string.substring(0, n)).length() != 0) return string;
                return null;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                n = string2.indexOf("</title>");
                if (n < 0) {
                    n = string2.indexOf("</TITLE>");
                }
                if (n < 0) {
                    n = string2.indexOf("</Title>");
                }
                if (n >= 0) {
                    string = String.valueOf(string) + string2.substring(0, n);
                    break;
                }
                string = String.valueOf(string) + string2;
            }
        }
        catch (Throwable throwable) {
            System.err.println("Error in getTitle(" + file.getAbsolutePath() + "): " + throwable);
            return "Title could not be processed";
        }
        if (string.length() != 0) return string;
        return null;
    }

    private final String getHREF(File file) {
        return String.valueOf(this.urlPrefix) + file.getAbsolutePath().substring(this.docRootDir.length());
    }

    private boolean filterFile(File file) {
        String string = file.getName();
        if (file.lastModified() < this.modifiedSince.getTime()) {
            return false;
        }
        int n = 0;
        while (n < this.fileTypes.length) {
            if (string.endsWith(this.fileTypes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean exclude(String string) {
        int n = 0;
        while (n < this.excludingPathNames.length) {
            if (string.equals(this.excludingPathNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void printIt() {
        OutputStreamWriter outputStreamWriter = null;
        if (this.outencoding == null || MIME2Java.convert((String)this.outencoding) == null) {
            outputStreamWriter = new OutputStreamWriter(System.out);
            this.doc.setEncoding(MIME2Java.reverse((String)outputStreamWriter.getEncoding()));
        } else {
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, MIME2Java.convert((String)this.outencoding));
                this.doc.setEncoding(this.outencoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        try {
            this.doc.printWithFormat((Writer)outputStreamWriter);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private void initializeFrame() {
        this.setName("SiteOutliner GUI");
        ((Component)this).setSize(600, 400);
        this.setTitle("Site Outliner Version 1.0");
        this.textArea = new TextArea();
        this.add(this.textArea);
        this.menuBar = new MenuBar();
        this.setMenuBar(this.menuBar);
        this.fileMenu = new Menu("File");
        this.menuBar.add(this.fileMenu);
        this.scanMenuItem = new MenuItem("Scan ...");
        this.fileMenu.add(this.scanMenuItem);
        this.scanMenuItem.addActionListener(new 1());
        this.saveMenuItem = new MenuItem("Save ...");
        this.fileMenu.add(this.saveMenuItem);
        this.saveMenuItem.addActionListener(new 2());
        this.exitMenuItem = new MenuItem("Exit");
        this.fileMenu.add(this.exitMenuItem);
        this.exitMenuItem.addActionListener(new 3());
        this.optionMenu = new Menu("Option");
        this.menuBar.add(this.optionMenu);
        this.debugMenuItem = new CheckboxMenuItem();
        this.debugMenuItem.setLabel("Debug");
        this.optionMenu.add(this.debugMenuItem);
        this.debugMenuItem.addActionListener(new 4());
        this.helpMenu = new Menu("Help");
        this.menuBar.add(this.helpMenu);
        this.aboutMenuItem = new MenuItem("About ...");
        this.helpMenu.add(this.aboutMenuItem);
        this.aboutMenuItem.addActionListener(new 5());
        this.aboutDialog = new Dialog((Frame)this, "About SiteOutliner");
        this.aboutDialog.setLayout(null);
        ((Component)this.aboutDialog).setBounds(5, 569, 418, 134);
        this.aboutDialogOkButton = new Button("OK");
        this.aboutDialog.add(this.aboutDialogOkButton);
        this.aboutDialogOkButton.setBounds(230, 100, 60, 30);
        this.aboutDialogOkButton.addActionListener(new 6());
        this.aboutDialogLabel = new Label("SiteOutliner v. 0.1 -- Sample XML application");
        this.aboutDialogLabel.setBounds(21, 22, 362, 30);
        this.aboutDialogLabel.setAlignment(1);
        this.aboutDialog.add(this.aboutDialogLabel);
        this.aboutDialog.addWindowListener(this);
        this.saveFileDialog = new FileDialog((Frame)this, "Save file to ...", 1);
    }

    private void save() {
        this.saveFileDialog.show();
        if (this.saveFileDialog.getFile() == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(String.valueOf(this.saveFileDialog.getDirectory()) + this.saveFileDialog.getFile()));
            printWriter.print(this.textArea.getText());
            printWriter.flush();
            printWriter.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error:" + iOException);
            return;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object instanceof Frame) {
            ((Frame)object).dispose();
        }
        if (object instanceof Dialog) {
            ((Dialog)object).dispose();
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static {
        sinceDate = new Date(new Date().getTime() - 86400000L);
        exList = new String[0];
        fTypes = new String[]{".html", ".htm", ".HTML", ".HTM"};
        dir = null;
        url = null;
        gencoding = null;
        goutencoding = null;
        gdepth = 10;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutliner.this.siteOutlinerUI = new SiteOutlinerUI(SiteOutliner.this.me);
            SiteOutliner.this.siteOutlinerUI.show();
            if (!SiteOutliner.this.siteOutlinerUI.canceled()) {
                SiteOutliner.this.setParameters(SiteOutliner.this.siteOutlinerUI);
                SiteOutliner.this.doIt();
                StringWriter stringWriter = new StringWriter();
                try {
                    SiteOutliner.this.doc.print((Writer)stringWriter);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                SiteOutliner.this.textArea.setText(stringWriter.toString());
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutliner.this.save();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutliner.this.dispose();
            System.exit(0);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            opt_d = ((CheckboxMenuItem)actionEvent.getSource()).getState();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutliner.this.aboutDialog.show();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutliner.this.aboutDialog.dispose();
        }

        /* synthetic */ 6() {
        }
    }
}

