/*
 * Decompiled with CFR 0.152.
 */
package samples.SiteOutliner;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class SiteOutlinerUI
extends Dialog
implements ItemListener,
WindowListener {
    private Frame frame;
    private TextField ivjRootDirectoryField;
    private TextField ivjDocumentBaseURLField;
    private TextField ivjFileTypesField;
    private TextField ivjExcludingField;
    private TextField ivjNewerThanField;
    private TextField ivjSearchDepthField;
    private Button ivjFileTypesDialogButton;
    private Button ivjExcludingDialogButton;
    private Button ivjNewerThanDialogButton;
    private Button ivjDoItButton;
    private Button ivjCancelButton;
    private Dialog ivjFileTypeEntryDialog;
    private Button ivjFileTypeAddButton;
    private TextField ivjFileTypeEntryField;
    private List ivjFileTypeList;
    private Button ivjFileTypeOkButton;
    private Button ivjFileTypeRemoveButton;
    private Dialog ivjExcludingEntryDialog;
    private Button ivjExcludingAddButton;
    private TextField ivjExcludingEntryField;
    private List ivjExcludingList;
    private Button ivjExcludingOkButton;
    private Button ivjExcludingRemoveButton;
    private Dialog ivjNewerThanDialog;
    private CheckboxGroup ivjModifiedSinceCheckboxGroup;
    private Checkbox ivjSinceDateCheckBox;
    private Checkbox ivjSinceFileCheckBox;
    private TextField ivjSinceFileField;
    private TextField ivjSinceDateField;
    private Button ivjSinceFileButton;
    private Button ivjNewerThanDialogOkButton;
    private FileDialog ivjSinceFile;
    private Dialog errorDialog;
    private Button errorDialogOkButton;
    private Label errorDialogLabel;
    private File rootDir;
    private Date since;
    private int depth = 10;
    private boolean canceled = true;

    public SiteOutlinerUI(Frame frame) {
        super(frame);
        this.frame = frame;
        this.initialize();
        try {
            this.rootDir = new File(".");
            ((TextComponent)this.ivjRootDirectoryField).setText(this.rootDir.getCanonicalPath());
        }
        catch (Throwable throwable) {}
        try {
            ((TextComponent)this.ivjDocumentBaseURLField).setText("http://" + InetAddress.getLocalHost().getHostName());
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
        this.getFileTypeList();
        this.ivjFileTypeList.add(".html");
        this.ivjFileTypeList.add(".htm");
        this.ivjFileTypeList.add(".HTML");
        this.ivjFileTypeList.add(".HTM");
        ((TextComponent)this.ivjFileTypesField).setText(this.concatList(this.ivjFileTypeList.getItems()));
        this.getExcludingList();
        ((TextComponent)this.ivjExcludingField).setText(this.concatList(this.ivjExcludingList.getItems()));
        this.since = new Date(new Date().getTime() - 86400000L);
        ((TextComponent)this.ivjNewerThanField).setText(DateFormat.getDateInstance().format(this.since));
        ((TextComponent)this.ivjSearchDepthField).setText(Integer.toString(this.depth));
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public Date getSince() {
        return this.since;
    }

    public String getDocumentBaseURL() {
        return this.getDocumentBaseURLField().getText();
    }

    public String[] getFileTypes() {
        return this.ivjFileTypeList.getItems();
    }

    public String[] getExcludingPathNames() {
        return this.ivjExcludingList.getItems();
    }

    public int getSearchDepth() {
        return this.depth;
    }

    public boolean canceled() {
        return this.canceled;
    }

    private void conn27(ActionEvent actionEvent) {
        try {
            if (this.ivjSinceFileCheckBox.getState()) {
                try {
                    File file = new File(this.ivjSinceFileField.getText());
                    this.since = new Date(file.lastModified());
                }
                catch (Throwable throwable) {
                    this.error(throwable.toString());
                    return;
                }
            }
            if (this.ivjSinceDateCheckBox.getState()) {
                try {
                    this.since = DateFormat.getDateInstance().parse(this.ivjSinceDateField.getText());
                }
                catch (ParseException parseException) {
                    this.error(parseException.toString());
                    return;
                }
            }
            ((TextComponent)this.ivjNewerThanField).setText(DateFormat.getDateInstance().format(this.since));
            this.getNewerThanDialog().dispose();
            return;
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return;
        }
    }

    private void error(String string) {
        this.errorDialogLabel.setText(string);
        this.errorDialog.show();
    }

    private void doIt() {
        URL uRL = null;
        try {
            uRL = new URL(this.getDocumentBaseURL());
        }
        catch (MalformedURLException malformedURLException) {
            this.error("Illegal Base URL ");
            return;
        }
        try {
            this.rootDir = new File(this.getRootDirectoryField().getText());
            if (!this.rootDir.isDirectory()) {
                throw new IOException();
            }
        }
        catch (Throwable throwable) {
            this.error("Please specify Root Directory");
            return;
        }
        try {
            this.depth = Integer.parseInt(this.getSearchDepthField().getText());
        }
        catch (Throwable throwable) {
            this.error("Illegal search depth");
            return;
        }
        System.err.println("Base URL=" + this.getDocumentBaseURL());
        System.err.println("Root Directory=" + this.getRootDir());
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        System.err.println("Since Date=" + dateFormat.format(this.getSince()));
        this.canceled = false;
        this.dispose();
    }

    private TextField getRootDirectoryField() {
        block2: {
            if (this.ivjRootDirectoryField != null) break block2;
            try {
                this.ivjRootDirectoryField = new TextField();
                this.ivjRootDirectoryField.setName("RootDirectoryField");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjRootDirectoryField;
    }

    private TextField getDocumentBaseURLField() {
        block2: {
            if (this.ivjDocumentBaseURLField != null) break block2;
            try {
                this.ivjDocumentBaseURLField = new TextField();
                this.ivjDocumentBaseURLField.setName("DocumentBaseURLField");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDocumentBaseURLField;
    }

    private TextField getFileTypesField() {
        block2: {
            if (this.ivjFileTypesField != null) break block2;
            try {
                this.ivjFileTypesField = new TextField();
                this.ivjFileTypesField.setName("FileTypesField");
                this.ivjFileTypesField.setBounds(169, 225, 269, 24);
                this.ivjFileTypesField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypesField;
    }

    private TextField getExcludingField() {
        block2: {
            if (this.ivjExcludingField != null) break block2;
            try {
                this.ivjExcludingField = new TextField();
                this.ivjExcludingField.setName("ExcludingField");
                this.ivjExcludingField.setBounds(169, 225, 269, 24);
                this.ivjExcludingField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingField;
    }

    private TextField getNewerThanField() {
        block2: {
            if (this.ivjNewerThanField != null) break block2;
            try {
                this.ivjNewerThanField = new TextField();
                this.ivjNewerThanField.setName("NewerThanField");
                this.ivjNewerThanField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjNewerThanField;
    }

    private TextField getSearchDepthField() {
        block2: {
            if (this.ivjSearchDepthField != null) break block2;
            try {
                this.ivjSearchDepthField = new TextField();
                this.ivjSearchDepthField.setName("SearchDepthField");
                this.ivjSearchDepthField.setEditable(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSearchDepthField;
    }

    private Button getFileTypeEntryDialogButton() {
        block2: {
            if (this.ivjFileTypesDialogButton != null) break block2;
            try {
                this.ivjFileTypesDialogButton = new Button();
                this.ivjFileTypesDialogButton.setName("FileTypesDialogButton");
                this.ivjFileTypesDialogButton.setBounds(452, 221, 67, 30);
                this.ivjFileTypesDialogButton.setLabel("Details ...");
                this.ivjFileTypesDialogButton.addActionListener(new 1());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypesDialogButton;
    }

    private Button getExcludingDialogButton() {
        block2: {
            if (this.ivjExcludingDialogButton != null) break block2;
            try {
                this.ivjExcludingDialogButton = new Button();
                this.ivjExcludingDialogButton.setName("ExcludingDialogButton");
                this.ivjExcludingDialogButton.setBounds(452, 221, 67, 30);
                this.ivjExcludingDialogButton.setLabel("Details ...");
                this.ivjExcludingDialogButton.addActionListener(new 2());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingDialogButton;
    }

    private Button getNewerThanDialogButton() {
        block2: {
            if (this.ivjNewerThanDialogButton != null) break block2;
            try {
                this.ivjNewerThanDialogButton = new Button();
                this.ivjNewerThanDialogButton.setName("NewerThanDialogButton");
                this.ivjNewerThanDialogButton.setLabel("Details ...");
                this.ivjNewerThanDialogButton.addActionListener(new 3());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjNewerThanDialogButton;
    }

    private Button getDoItButton() {
        block2: {
            if (this.ivjDoItButton != null) break block2;
            try {
                this.ivjDoItButton = new Button();
                this.ivjDoItButton.setName("DoItButton");
                this.ivjDoItButton.setLabel("DoIt");
                this.ivjDoItButton.addActionListener(new 4());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDoItButton;
    }

    private Dialog getFileTypeEntryDialog() {
        block2: {
            if (this.ivjFileTypeEntryDialog != null) break block2;
            try {
                this.ivjFileTypeEntryDialog = new Dialog(this.frame);
                this.ivjFileTypeEntryDialog.setName("FileTypesDialog");
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(3, 3, 3, 3);
                this.ivjFileTypeEntryDialog.setLayout(gridBagLayout);
                this.ivjFileTypeEntryDialog.setModal(true);
                ((Component)this.ivjFileTypeEntryDialog).setBounds(421, 439, 426, 240);
                this.ivjFileTypeEntryDialog.setTitle("Enter file types to be included in CDF");
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 13;
                this.mb(this.ivjFileTypeEntryDialog, 0, 0, 1, 1, this.getFileTypeEntryField(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjFileTypeEntryDialog, 0, 1, 1, 3, this.getFileTypeList(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjFileTypeEntryDialog, 1, 0, 1, 1, this.getFileTypeAddButton(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjFileTypeEntryDialog, 1, 1, 1, 1, this.getFileTypeRemoveButton(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjFileTypeEntryDialog, 1, 2, 1, 1, this.getFileTypeOkButton(), gridBagLayout, gridBagConstraints);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypeEntryDialog;
    }

    private Button getFileTypeAddButton() {
        block2: {
            if (this.ivjFileTypeAddButton != null) break block2;
            try {
                this.ivjFileTypeAddButton = new Button();
                this.ivjFileTypeAddButton.setName("FileTypeAddButton");
                this.ivjFileTypeAddButton.setBounds(264, 35, 125, 30);
                this.ivjFileTypeAddButton.setLabel("Add");
                this.ivjFileTypeAddButton.addActionListener(new 5());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypeAddButton;
    }

    private TextField getFileTypeEntryField() {
        block2: {
            if (this.ivjFileTypeEntryField != null) break block2;
            try {
                this.ivjFileTypeEntryField = new TextField();
                this.ivjFileTypeEntryField.setName("FileTypeEntryField");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypeEntryField;
    }

    private List getFileTypeList() {
        block2: {
            if (this.ivjFileTypeList != null) break block2;
            try {
                this.ivjFileTypeList = new List();
                this.ivjFileTypeList.setName("FileTypeList");
                this.ivjFileTypeList.setBounds(66, 86, 123, 125);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypeList;
    }

    private Button getFileTypeOkButton() {
        block2: {
            if (this.ivjFileTypeOkButton != null) break block2;
            try {
                this.ivjFileTypeOkButton = new Button();
                this.ivjFileTypeOkButton.setName("FileTypeOkButton");
                this.ivjFileTypeOkButton.setLabel("Ok");
                this.ivjFileTypeOkButton.addActionListener(new 6());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypeOkButton;
    }

    private Button getFileTypeRemoveButton() {
        block2: {
            if (this.ivjFileTypeRemoveButton != null) break block2;
            try {
                this.ivjFileTypeRemoveButton = new Button();
                this.ivjFileTypeRemoveButton.setName("FileTypeRemoveButton");
                this.ivjFileTypeRemoveButton.setBounds(267, 90, 125, 30);
                this.ivjFileTypeRemoveButton.setLabel("Remove");
                this.getFileTypeRemoveButton().addActionListener(new 7());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjFileTypeRemoveButton;
    }

    private Dialog getExcludingEntryDialog() {
        block2: {
            if (this.ivjExcludingEntryDialog != null) break block2;
            try {
                this.ivjExcludingEntryDialog = new Dialog(this.frame);
                this.ivjExcludingEntryDialog.setName("ExcludingsDialog");
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(3, 3, 3, 3);
                this.ivjExcludingEntryDialog.setLayout(gridBagLayout);
                this.ivjExcludingEntryDialog.setModal(true);
                ((Component)this.ivjExcludingEntryDialog).setBounds(421, 439, 426, 240);
                this.ivjExcludingEntryDialog.setTitle("Enter file/directory names to be excluded");
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 13;
                this.mb(this.ivjExcludingEntryDialog, 0, 0, 1, 1, this.getExcludingEntryField(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjExcludingEntryDialog, 0, 1, 1, 3, this.getExcludingList(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjExcludingEntryDialog, 1, 0, 1, 1, this.getExcludingAddButton(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjExcludingEntryDialog, 1, 1, 1, 1, this.getExcludingRemoveButton(), gridBagLayout, gridBagConstraints);
                this.mb(this.ivjExcludingEntryDialog, 1, 2, 1, 1, this.getExcludingOkButton(), gridBagLayout, gridBagConstraints);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingEntryDialog;
    }

    private Button getExcludingAddButton() {
        block2: {
            if (this.ivjExcludingAddButton != null) break block2;
            try {
                this.ivjExcludingAddButton = new Button();
                this.ivjExcludingAddButton.setName("ExcludingAddButton");
                this.ivjExcludingAddButton.setBounds(264, 35, 125, 30);
                this.ivjExcludingAddButton.setLabel("Add");
                this.ivjExcludingAddButton.addActionListener(new 8());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingAddButton;
    }

    private TextField getExcludingEntryField() {
        block2: {
            if (this.ivjExcludingEntryField != null) break block2;
            try {
                this.ivjExcludingEntryField = new TextField();
                this.ivjExcludingEntryField.setName("ExcludingEntryField");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingEntryField;
    }

    private List getExcludingList() {
        block2: {
            if (this.ivjExcludingList != null) break block2;
            try {
                this.ivjExcludingList = new List();
                this.ivjExcludingList.setName("ExcludingList");
                this.ivjExcludingList.setBounds(66, 86, 123, 125);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingList;
    }

    private Button getExcludingOkButton() {
        block2: {
            if (this.ivjExcludingOkButton != null) break block2;
            try {
                this.ivjExcludingOkButton = new Button();
                this.ivjExcludingOkButton.setName("ExcludingOkButton");
                this.ivjExcludingOkButton.setLabel("Ok");
                this.ivjExcludingOkButton.addActionListener(new 9());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingOkButton;
    }

    private Button getExcludingRemoveButton() {
        block2: {
            if (this.ivjExcludingRemoveButton != null) break block2;
            try {
                this.ivjExcludingRemoveButton = new Button();
                this.ivjExcludingRemoveButton.setName("ExcludingRemoveButton");
                this.ivjExcludingRemoveButton.setBounds(267, 90, 125, 30);
                this.ivjExcludingRemoveButton.setLabel("Remove");
                this.getExcludingRemoveButton().addActionListener(new 10());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjExcludingRemoveButton;
    }

    private Button getNewerThanDialogOkButton() {
        block2: {
            if (this.ivjNewerThanDialogOkButton != null) break block2;
            try {
                this.ivjNewerThanDialogOkButton = new Button();
                this.ivjNewerThanDialogOkButton.setName("NewerThanDialogOkButton");
                this.ivjNewerThanDialogOkButton.setBounds(305, 182, 81, 34);
                this.ivjNewerThanDialogOkButton.setLabel("Ok");
                this.ivjNewerThanDialogOkButton.addActionListener(new 11());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjNewerThanDialogOkButton;
    }

    private Dialog getNewerThanDialog() {
        block2: {
            if (this.ivjNewerThanDialog != null) break block2;
            try {
                this.ivjNewerThanDialog = new Dialog(this.frame);
                this.ivjNewerThanDialog.setName("NewerThanDialog");
                this.ivjNewerThanDialog.setLayout(null);
                this.ivjNewerThanDialog.setModal(true);
                ((Component)this.ivjNewerThanDialog).setBounds(385, 200, 426, 240);
                this.ivjNewerThanDialog.setTitle("Inlude files modified since");
                this.ivjNewerThanDialog.add((Component)this.getSinceFileCheckBox(), this.getSinceFileCheckBox().getName());
                this.ivjNewerThanDialog.add((Component)this.getSinceDateCheckBox(), this.getSinceDateCheckBox().getName());
                this.ivjNewerThanDialog.add((Component)this.getNewerThanDialogOkButton(), this.getNewerThanDialogOkButton().getName());
                this.ivjNewerThanDialog.add((Component)this.getSinceFileButton(), this.getSinceFileButton().getName());
                this.ivjNewerThanDialog.add((Component)this.getSinceFileField(), this.getSinceFileField().getName());
                this.ivjNewerThanDialog.add((Component)this.getSinceDateField(), this.getSinceDateField().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjNewerThanDialog;
    }

    private CheckboxGroup getModifiedSinceCheckboxGroup() {
        block2: {
            if (this.ivjModifiedSinceCheckboxGroup != null) break block2;
            try {
                this.ivjModifiedSinceCheckboxGroup = new CheckboxGroup();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjModifiedSinceCheckboxGroup;
    }

    private Checkbox getSinceDateCheckBox() {
        block2: {
            if (this.ivjSinceDateCheckBox != null) break block2;
            try {
                this.ivjSinceDateCheckBox = new Checkbox();
                this.ivjSinceDateCheckBox.setName("SinceDateCheckBox");
                this.ivjSinceDateCheckBox.setBounds(25, 85, 107, 27);
                this.ivjSinceDateCheckBox.setLabel("Since date");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSinceDateCheckBox;
    }

    private TextField getSinceDateField() {
        block2: {
            if (this.ivjSinceDateField != null) break block2;
            try {
                this.ivjSinceDateField = new TextField();
                this.ivjSinceDateField.setName("SinceDateField");
                this.ivjSinceDateField.setBounds(159, 85, 125, 27);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSinceDateField;
    }

    private FileDialog getSinceFile() {
        block2: {
            if (this.ivjSinceFile != null) break block2;
            try {
                this.ivjSinceFile = new FileDialog(this.frame);
                this.ivjSinceFile.setName("SinceFile");
                this.ivjSinceFile.setLayout(null);
                ((Dialog)this.ivjSinceFile).setTitle("Since the following file last modified");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSinceFile;
    }

    private Button getSinceFileButton() {
        block2: {
            if (this.ivjSinceFileButton != null) break block2;
            try {
                this.ivjSinceFileButton = new Button();
                this.ivjSinceFileButton.setName("SinceFileButton");
                this.ivjSinceFileButton.setBounds(309, 35, 77, 27);
                this.ivjSinceFileButton.setLabel("Browse ...");
                this.ivjSinceFileButton.addActionListener(new 12());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSinceFileButton;
    }

    private Checkbox getSinceFileCheckBox() {
        block2: {
            if (this.ivjSinceFileCheckBox != null) break block2;
            try {
                this.ivjSinceFileCheckBox = new Checkbox();
                this.ivjSinceFileCheckBox.setName("SinceFileCheckBox");
                this.ivjSinceFileCheckBox.setBounds(25, 33, 105, 27);
                this.ivjSinceFileCheckBox.setLabel("Newer than file");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSinceFileCheckBox;
    }

    private TextField getSinceFileField() {
        block2: {
            if (this.ivjSinceFileField != null) break block2;
            try {
                this.ivjSinceFileField = new TextField();
                this.ivjSinceFileField.setName("SinceFileField");
                this.ivjSinceFileField.setBounds(159, 33, 125, 27);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSinceFileField;
    }

    private void handleException(Throwable throwable) {
    }

    private void initConnections() {
        this.addWindowListener(this);
        this.getNewerThanDialog().addWindowListener(this);
        this.getSinceFileCheckBox().addItemListener(this);
        this.getSinceDateCheckBox().addItemListener(this);
        this.getSinceFileCheckBox().setCheckboxGroup(this.getModifiedSinceCheckboxGroup());
        this.getSinceDateCheckBox().setCheckboxGroup(this.getModifiedSinceCheckboxGroup());
    }

    private void initialize() {
        this.setName("SiteOutlinerUI");
        this.setModal(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        ((Component)this).setSize(572, 371);
        this.setTitle("SiteOutliner V.0.1");
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.mb(this, 0, 0, 1, 1, new Label("Root Directory"), gridBagLayout, gridBagConstraints);
        this.mb(this, 0, 1, 1, 1, new Label("Document Base URL"), gridBagLayout, gridBagConstraints);
        this.mb(this, 0, 2, 1, 1, new Label("Only files ..."), gridBagLayout, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        this.mb(this, 0, 3, 1, 1, new Label("File types"), gridBagLayout, gridBagConstraints);
        this.mb(this, 0, 4, 1, 1, new Label("Excluding"), gridBagLayout, gridBagConstraints);
        this.mb(this, 0, 5, 1, 1, new Label("Newer than"), gridBagLayout, gridBagConstraints);
        this.mb(this, 0, 6, 1, 1, new Label("Search depth"), gridBagLayout, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.mb(this, 1, 0, 1, 1, this.getRootDirectoryField(), gridBagLayout, gridBagConstraints);
        this.mb(this, 1, 1, 1, 1, this.getDocumentBaseURLField(), gridBagLayout, gridBagConstraints);
        this.mb(this, 1, 3, 1, 1, this.getFileTypesField(), gridBagLayout, gridBagConstraints);
        this.mb(this, 1, 4, 1, 1, this.getExcludingField(), gridBagLayout, gridBagConstraints);
        this.mb(this, 1, 5, 1, 1, this.getNewerThanField(), gridBagLayout, gridBagConstraints);
        this.mb(this, 1, 6, 1, 1, this.getSearchDepthField(), gridBagLayout, gridBagConstraints);
        this.mb(this, 2, 3, 1, 1, this.getFileTypeEntryDialogButton(), gridBagLayout, gridBagConstraints);
        this.mb(this, 2, 4, 1, 1, this.getExcludingDialogButton(), gridBagLayout, gridBagConstraints);
        this.mb(this, 2, 5, 1, 1, this.getNewerThanDialogButton(), gridBagLayout, gridBagConstraints);
        this.mb(this, 2, 7, 1, 1, this.getDoItButton(), gridBagLayout, gridBagConstraints);
        this.ivjCancelButton = new Button();
        this.ivjCancelButton.setLabel("Cancel");
        this.ivjCancelButton.addActionListener(new 13());
        this.mb(this, 2, 8, 1, 1, this.ivjCancelButton, gridBagLayout, gridBagConstraints);
        this.errorDialog = new Dialog(this.frame, "Error");
        this.errorDialog.setLayout(null);
        this.errorDialog.setModal(true);
        ((Component)this.errorDialog).setBounds(5, 300, 418, 134);
        this.errorDialogOkButton = new Button("OK");
        this.errorDialog.add(this.errorDialogOkButton);
        this.errorDialogOkButton.setBounds(230, 100, 60, 30);
        this.errorDialogOkButton.addActionListener(new 14());
        this.errorDialogLabel = new Label();
        this.errorDialogLabel.setBounds(21, 22, 362, 30);
        this.errorDialogLabel.setAlignment(1);
        this.errorDialog.add(this.errorDialogLabel);
        this.errorDialog.addWindowListener(this);
        this.initConnections();
    }

    private void mb(Container container, int n, int n2, int n3, int n4, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.getSinceFileCheckBox()) {
            this.getSinceFileField().setEnabled(true);
        }
        if (itemEvent.getSource() == this.getSinceFileCheckBox()) {
            this.getSinceFileButton().setEnabled(true);
        }
        if (itemEvent.getSource() == this.getSinceDateCheckBox()) {
            this.getSinceFileField().setEnabled(false);
        }
        if (itemEvent.getSource() == this.getSinceDateCheckBox()) {
            this.getSinceDateField().setEnabled(true);
        }
        if (itemEvent.getSource() == this.getSinceFileCheckBox()) {
            this.getSinceDateField().setEnabled(false);
        }
    }

    private String concatList(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n] + ";";
            ++n;
        }
        return string;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object instanceof Frame) {
            ((Frame)object).dispose();
        }
        if (object instanceof Dialog) {
            ((Dialog)object).dispose();
        }
        if (object instanceof SiteOutlinerUI) {
            ((SiteOutlinerUI)object).dispose();
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static /* synthetic */ boolean access$14(SiteOutlinerUI siteOutlinerUI) {
        return siteOutlinerUI.canceled;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.getFileTypeEntryDialog().show();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.getExcludingEntryDialog().show();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.getNewerThanDialog().show();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.doIt();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.getFileTypeList().addItem(SiteOutlinerUI.this.getFileTypeEntryField().getText());
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((TextComponent)SiteOutlinerUI.this.getFileTypesField()).setText(SiteOutlinerUI.this.concatList(SiteOutlinerUI.this.getFileTypeList().getItems()));
            SiteOutlinerUI.this.getFileTypeEntryDialog().dispose();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (SiteOutlinerUI.this.getFileTypeList().getSelectedItem() != null) {
                SiteOutlinerUI.this.getFileTypeList().remove(SiteOutlinerUI.this.getFileTypeList().getSelectedItem());
            }
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.getExcludingList().addItem(SiteOutlinerUI.this.getExcludingEntryField().getText());
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((TextComponent)SiteOutlinerUI.this.getExcludingField()).setText(SiteOutlinerUI.this.concatList(SiteOutlinerUI.this.getExcludingList().getItems()));
            SiteOutlinerUI.this.getExcludingEntryDialog().dispose();
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (SiteOutlinerUI.this.getExcludingList().getSelectedItem() != null) {
                SiteOutlinerUI.this.getExcludingList().remove(SiteOutlinerUI.this.getExcludingList().getSelectedItem());
            }
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.conn27(actionEvent);
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.getSinceFile().show();
            ((TextComponent)SiteOutlinerUI.this.getSinceFileField()).setText(String.valueOf(SiteOutlinerUI.this.getSinceFile().getDirectory()) + SiteOutlinerUI.this.getSinceFile().getFile());
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.canceled = true;
            SiteOutlinerUI.this.dispose();
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SiteOutlinerUI.this.errorDialog.dispose();
        }

        /* synthetic */ 14() {
        }
    }
}

