/*
 * Decompiled with CFR 0.152.
 */
package samples.XMLTreeViewer;

import com.ibm.xml.parser.ErrorListener;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Node;
import samples.XMLTreeViewer.ErrorFlagger;
import samples.XMLTreeViewer.ErrorInParsing;
import samples.XMLTreeViewer.ErrorTreeFactory;

public class XMLTreeView
extends JFrame
implements ActionListener,
TextListener {
    public static final boolean DEBUG = true;
    static final String title = "XMLTreeViewer";
    static final String openString = "Open";
    static final String quitString = "Quit";
    static final String reloadString = "Reload current XML file";
    static final String expandString = "Expand Tree";
    static final String collapseString = "Collapse Tree";
    ErrorFlagger ef;
    String fname;
    JTree m_tree;
    JTextArea sourceText;
    JTextArea messageText;
    Vector textLine;
    FileNameInput fni;

    static void main(String[] stringArray) {
        XMLTreeView xMLTreeView = null;
        xMLTreeView = stringArray.length < 1 ? new XMLTreeView() : new XMLTreeView("XMLTreeViewer: " + stringArray[0], stringArray[0]);
        xMLTreeView.addWindowListener(new 1());
        ((Component)xMLTreeView).setSize(790, 590);
        ((Component)xMLTreeView).setVisible(true);
    }

    public XMLTreeView() {
        this(title, (String)null);
    }

    public XMLTreeView(String string, String string2) {
        super(string);
        this.fname = string2;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem(openString);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem(quitString);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu("Shortcuts");
        jMenuItem = new JMenuItem(expandString);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem(collapseString);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem(reloadString);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add(this.createUI(this.fname));
    }

    JComponent createUI(String string) {
        System.out.println("START createUI:" + string);
        this.messageText = new JTextArea(3, 40);
        this.messageText.setFont(new Font("Helvetica", 0, 18));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new 2(this.messageText), "Center");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Messages"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.sourceText = new JTextArea();
        this.sourceText.setFont(new Font("Courier", 0, 18));
        this.sourceText.setBackground(Color.white);
        this.sourceText.setForeground(Color.black);
        this.sourceText.setSelectedTextColor(Color.black);
        this.sourceText.setSelectionColor(Color.red);
        this.sourceText.setEditable(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new 3(this.sourceText), "Center");
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Source View"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.m_tree = this.createJTree();
        jPanel3.add((Component)new 4(this.m_tree), "Center");
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Tree View"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.refreshUI(string);
        JSplitPane jSplitPane = new JSplitPane(1, true, jPanel3, jPanel2);
        JSplitPane jSplitPane2 = new JSplitPane(0, true, jSplitPane, jPanel);
        System.out.println("END createUI:" + string);
        return jSplitPane2;
    }

    void refreshUI(String string) {
        System.out.println("START refreshUI:" + string);
        this.messageText.selectAll();
        this.messageText.cut();
        if (string == null || string.equals("")) {
            this.messageText.setForeground(Color.red);
            this.messageText.append("No input XML filename specified:" + string + "\n");
            return;
        }
        this.fname = string;
        TreeNode treeNode = this.getRoot(string);
        if (treeNode == null) {
            this.messageText.setForeground(Color.red);
            this.messageText.append("Unable to get new Tree for:" + string + "\n");
            return;
        }
        this.m_tree.setModel(new DefaultTreeModel(treeNode));
        this.sourceText.selectAll();
        this.sourceText.cut();
        this.readXMLFile(this.fname, this.sourceText);
        this.sourceText.select(0, 0);
        this.setTitle("XMLTreeViewer: " + string);
        if (this.m_tree != null) {
            this.expandTree();
        }
        if (this.ef != null && this.ef.getErrorNodes() != null && this.ef.getErrorNodes().size() > 0) {
            this.messageText.setForeground(Color.red);
            this.messageText.append("XML source, " + this.fname + " has errors.\n");
            this.messageText.append("Please click on red Tree View items for details.\n");
        }
        System.out.println("END refreshUI:" + string);
    }

    public TreeNode getRoot(String string) {
        System.out.println("START getRoot:" + string);
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            ErrorTreeFactory errorTreeFactory = new ErrorTreeFactory();
            this.ef = new ErrorFlagger(errorTreeFactory);
            Parser parser = new Parser(this.fname, (ErrorListener)this.ef, null);
            parser.setElementFactory((TXDocument)errorTreeFactory);
            parser.setEndBy1stError(false);
            return (TreeNode)parser.readStream(parser.getInputStream(this.fname, null, Stderr.file2URL((String)this.fname).toString()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    synchronized void readXMLFile(String string, JTextArea jTextArea) {
        System.out.println("START readXMLFile" + string);
        if (string == null || string.equals("")) {
            return;
        }
        File file = new File(string);
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ERROR: XML4J.readXMLFile: " + fileNotFoundException);
            return;
        }
        int n = 0;
        this.textLine = new Vector();
        int n2 = "\n".length();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(String.valueOf(string2) + "\n");
                this.textLine.addElement(new Integer(n));
                n += string2.length() + n2;
            }
            this.textLine.addElement(new Integer(n));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        jTextArea.append(stringBuffer.toString());
        System.out.println("END readXMLFile" + string);
    }

    JTree createJTree() {
        JTree jTree = new JTree();
        if (jTree == null) {
            return null;
        }
        jTree.setCellRenderer(new XMLTreeCellRenderer());
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.addTreeSelectionListener(new 5());
        jTree.setRowHeight(24);
        jTree.setFont(new Font("Helvetica", 0, 18));
        return jTree;
    }

    void nodeSelected(TreeNode treeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        this.messageText.selectAll();
        this.messageText.cut();
        Object object = this.ef.getError((Node)((Object)treeNode));
        if (object != null) {
            this.messageText.setForeground(Color.red);
            ErrorInParsing errorInParsing = (ErrorInParsing)object;
            stringBuffer.append("Error: " + errorInParsing.getMsg() + "\n");
            int n = errorInParsing.getLineNo();
            int n2 = (Integer)this.textLine.elementAt(n - 1);
            int n3 = (Integer)this.textLine.elementAt(n);
            this.sourceText.select(n2, n3);
        } else {
            this.messageText.setForeground(Color.black);
            this.sourceText.select(0, 0);
        }
        if (treeNode instanceof TXElement || treeNode instanceof TXText) {
            stringBuffer.append(treeNode.toString());
        }
        this.messageText.append(stringBuffer.toString());
    }

    public void textValueChanged(TextEvent textEvent) {
        try {
            if (this.fni != null) {
                ((Component)this.fni).setVisible(false);
            }
            this.fname = ((JTextField)textEvent.getSource()).getText();
            System.out.println("textValueChanged:" + this.fname);
            this.refreshUI(this.fname);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.err.println("ACTION: " + actionEvent.getActionCommand() + ", " + actionEvent.paramString());
        if (actionEvent.getActionCommand().equals(quitString)) {
            System.exit(0);
            return;
        }
        if (actionEvent.getActionCommand().equals(openString)) {
            this.fni = new FileNameInput("Open File");
            this.fni.addTextListener(this);
            ((Component)this.fni).setVisible(true);
            return;
        }
        if (actionEvent.getActionCommand().equals(expandString)) {
            this.expandTree();
            return;
        }
        if (actionEvent.getActionCommand().equals(collapseString)) {
            int n = this.m_tree.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                this.m_tree.collapseRow(n2);
                ++n2;
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(reloadString)) {
            this.refreshUI(this.fname);
        }
    }

    void expandTree() {
        int n = 0;
        int n2 = 0;
        while (n2 <= 4) {
            n = this.m_tree.getRowCount();
            int n3 = 0;
            while (n3 < n) {
                this.m_tree.expandRow(n3);
                ++n3;
            }
            ++n2;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends JScrollPane {
        public Dimension getPreferredSize() {
            Dimension dimension = XMLTreeView.this.getSize();
            return new Dimension(dimension.width, dimension.height / 4);
        }

        public Dimension getMinimumSize() {
            return new Dimension(100, 100);
        }

        /* synthetic */ 2(JTextArea jTextArea) {
            super(jTextArea);
        }
    }

    private final class 3
    extends JScrollPane {
        public Dimension getPreferredSize() {
            Dimension dimension = XMLTreeView.this.getSize();
            return new Dimension(dimension.width / 2, dimension.height * 3 / 5);
        }

        public Dimension getMinimumSize() {
            return new Dimension(100, 100);
        }

        /* synthetic */ 3(JTextArea jTextArea) {
            super(jTextArea);
        }
    }

    private final class 4
    extends JScrollPane {
        public Dimension getPreferredSize() {
            Dimension dimension = XMLTreeView.this.getSize();
            return new Dimension(dimension.width / 2, dimension.height * 3 / 5);
        }

        public Dimension getMinimumSize() {
            return new Dimension(100, 100);
        }

        /* synthetic */ 4(JTree jTree) {
            super(jTree);
        }
    }

    private final class 5
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeNode treeNode = (TreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            XMLTreeView.this.nodeSelected(treeNode);
        }

        /* synthetic */ 5() {
        }
    }

    class XMLTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl) {
                component.setBackground(Color.blue);
            }
            if (object != null && object instanceof Node && XMLTreeView.this.ef.getErrorNodes().containsKey((Node)object)) {
                component.setForeground(Color.red);
            }
            if (object != null && object instanceof TXElement) {
                TXElement tXElement = (TXElement)object;
                Enumeration enumeration = tXElement.attributeElements();
                while (enumeration.hasMoreElements()) {
                    TXAttribute tXAttribute = (TXAttribute)enumeration.nextElement();
                    if (!tXAttribute.getName().equals("gender")) continue;
                    if (tXAttribute.getValue().equals("male")) {
                        this.setIcon(new ImageIcon("male.gif"));
                        break;
                    }
                    if (!tXAttribute.getValue().equals("female")) break;
                    this.setIcon(new ImageIcon("female.gif"));
                    break;
                }
            }
            return component;
        }

        XMLTreeCellRenderer() {
            XMLTreeView.this = XMLTreeView.this;
        }
    }

    class FileNameInput
    extends JFrame
    implements ActionListener {
        JLabel fileLabel = new JLabel("Enter XML file name:");
        JTextField textField = new JTextField();
        JButton ok;
        JButton cancel;
        Vector textListeners;

        public FileNameInput() {
            this("");
        }

        public FileNameInput(String string) {
            super(string);
            XMLTreeView.this = XMLTreeView.this;
            this.textField.addActionListener(this);
            this.ok = new JButton("ok");
            this.cancel = new JButton("cancel");
            JPanel jPanel = new JPanel();
            jPanel.add(this.ok);
            jPanel.add(this.cancel);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.getContentPane().add((Component)this.fileLabel, "North");
            this.getContentPane().add((Component)this.textField, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            ((Component)this).setSize(400, 100);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.ok || actionEvent.getSource() == this.textField) {
                System.out.println("FileNameInput: pressed OK");
                TextEvent textEvent = new TextEvent(this.textField, 900);
                this.deliverEvent(textEvent);
                ((Component)this).setVisible(false);
                return;
            }
            if (actionEvent.getSource() == this.cancel) {
                System.out.println("FileNameInput: pressed cancel");
                ((Component)this).setVisible(false);
            }
        }

        public void addTextListener(TextListener textListener) {
            if (textListener == null) {
                return;
            }
            if (this.textListeners == null) {
                this.textListeners = new Vector();
            }
            this.textListeners.addElement(textListener);
        }

        public void removeTextListener(TextListener textListener) {
            if (textListener == null || this.textListeners == null) {
                return;
            }
            this.textListeners.removeElement(textListener);
        }

        protected void deliverEvent(EventObject eventObject) {
            if (eventObject instanceof TextEvent) {
                Vector vector;
                TextEvent textEvent = (TextEvent)eventObject;
                Vector vector2 = this.textListeners;
                synchronized (vector2) {
                    vector = (Vector)this.textListeners.clone();
                }
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    ((TextListener)vector.elementAt(n2)).textValueChanged(textEvent);
                    ++n2;
                }
            }
        }
    }
}

