/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfEditor;

/*
 * History:
 * 19971028: Version 1.0
 * 19980202: changes for new processor API. (Kent)
 *
 */

import com.ibm.xml.parser.*;
import samples.SiteOutliner.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

/**
 *
 * @version Revision: 53 1.4 samples/CdfEditor/CdfEditor.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author URAMOTO Naohiko &lt;uramoto@trl.ibm.co.jp&gt;
 */
public class CdfEditor extends Frame implements ActionListener{
    static final String PROCPACKAGE = "samples.CdfEditor.Proc";

    Frame f;
    ScrollPane sp;
    XMLComponent xc = null;
    public PropertyBox pbox;
    SiteOutlinerUI ui;
    SiteOutliner so;

    public CdfEditor (String cdfFileName) throws FileNotFoundException, IOException {
        FileInputStream is;
        f = new Frame("TRL CDF Editor Version 1.0");

     // PropertyBox
     //    pbox = new PropertyBox("Property Box");
        try {
            if (!cdfFileName.equals("")) {
                is = new FileInputStream(cdfFileName);
                Transform tf = new Transform(cdfFileName, CdfEditor.PROCPACKAGE);
                xc = tf.readStream((InputStream )is);
                is.close();
            }
    //      if (null != xc) {
            if (true) {
                f.setLayout(new BorderLayout());
                f.setBackground(new Color(0xff, 0xff, 0xff));

                if (null != xc) {
                    Gateway g = new Gateway();
                    ((XMLComponentM)xc).setGateway(g);
                    f.add(g, "South");
                }
                sp = new ScrollPane();
                f.add(sp, "Center");

                MenuBar menubar = new MenuBar();
                f.setMenuBar(menubar);
                Menu fileMenu = new Menu("File");
                fileMenu.setFont(new Font("Helvetica", Font.PLAIN, 14));
                MenuItem item;
    
                item = new MenuItem("Open");
                fileMenu.add(item);
                item.addActionListener(this);

                item = new MenuItem("Scan");
                fileMenu.add(item);
                item.addActionListener(this);

                item = new MenuItem("Save");
                fileMenu.add(item);
                item.addActionListener(this);
    
                item = new MenuItem("Quit");
                fileMenu.add(item);
                item.addActionListener(this);

                menubar.add(fileMenu);

                if (xc != null)
                    sp.add(xc);

                f.pack();
                f.setSize(600, 600);
                f.show();
            } else
                System.err.println("Main: xc is null");
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }      
    }

    public static void main(String args[]) throws IOException {
        try {
            if (args.length == 1) {
                new CdfEditor(args[0]);
            } else {
                new CdfEditor("");
            }
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }      
    }

    public void actionPerformed(ActionEvent e) {
        Cursor cursor = new Cursor(Cursor.WAIT_CURSOR);
        f.setCursor(cursor);

        if (e.getActionCommand().equals("Quit")) {
            System.exit(0);
        } else if (e.getActionCommand().equals("Scan")) {

            Frame f2 = new Frame("Site Outliner");
            f2.setSize(300, 300);
            ui = new SiteOutlinerUI(f2);
            ui.show();

            so = new SiteOutliner(ui);
            TXDocument doc = so.getDocument();

            Gateway g = new Gateway();
            f.add(g, "South");

            Transform tf = new Transform("", CdfEditor.PROCPACKAGE);
            xc = tf.makeComponent((TXElement)doc.getDocumentElement());

            ((XMLComponentM)xc).setGateway(g);
            ((XMLComponentM) xc).setGateway( ((XMLComponentM )xc).getGateway());

            sp.add(xc);
            f.pack();
            f.show();

        } else if (e.getActionCommand().equals("Open")) {

            Frame fin = new Frame("Open CDF File");
            FileDialog fd = new FileDialog(fin, "Select CDF File");

            fd.show();

            String cdfFileDir = fd.getDirectory();
            String cdfFileName = fd.getFile();
            try {
          
                FileInputStream is;
                xc = null;
                is = new FileInputStream(cdfFileDir+cdfFileName);
                Transform tf = new Transform(cdfFileName, CdfEditor.PROCPACKAGE);
                xc = tf.readStream((InputStream )is);
                is.close();

                if (null != xc) {
                    Gateway g = new Gateway();
                    ((XMLComponentM)xc).setGateway(g);
                    f.add(g, "South");
                    sp.add(xc);
                    f.pack();
                    f.show();
                }
                //  pbox.pack();
                //pbox.show();
            } catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } 
        else if (e.getActionCommand().equals("Save")) {
            Frame fin = new Frame("Save CDF File");
            FileDialog fd = new FileDialog(fin, "Select CDF File", FileDialog.SAVE);

            fd.show();

            String cdfFileDir = fd.getDirectory();
            String cdfFileName = fd.getFile();

            try {
                FileOutputStream os;
                os = new FileOutputStream(cdfFileDir+cdfFileName);
                if (xc != null) {
                    TXElement el = ((XMLComponentEdt ) xc).getElement();
                    if (el.getParentNode() instanceof TXDocument) {
                        TXDocument doc = (TXDocument )el.getParentNode();
                        doc.print(new PrintWriter(new OutputStreamWriter(os)));
                        os.close();
                    }
                }
            } catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        f.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }
}
