/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfEditor;

import com.ibm.xml.parser.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.awt.event.*;
import org.w3c.dom.Attr;

/*
 * History:
 * 19971020 Version 0.98 
 * 19971028 setEnabled addded
 * 19980202 changes for new processor API (by Kent)
 */

/**
 *
 * @version Revision: 58 1.4 samples/CdfEditor/ProcCHANNEL.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Naohiko Uramoto
 */
public class ProcCHANNEL extends XMLComponentEdt {
  public static XMLComponent newInstance(Transform co, TXElement el) {
    // System.out.println("newinstance of ProcChannel is called");
    // System.out.println("");
    try {
      Attr attr = el.getAttributeNode("HREF");
      String urlstr = null == attr ? "" : attr.getValue();
      URL u = null == attr ? null : new URL(urlstr);
      TXElement ec = (TXElement)el.getElementNamed("TITLE");
      if (null == ec)  return null;
      ProcCHANNEL pc = new ProcCHANNEL(u, ec.getText(), el);
      pc.setChildren(co.makeChildren(el));
      // store the element
      return pc;
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }


  String m_title;


  Dimension m_min;
  LabelEdt m_ltitle;
  boolean m_isopen = false;
  Rectangle m_cb;

  ProcCHANNEL myself;

  // Popup Menus
  public PopupMenu pop;
  MenuItem item1, item2, item3, item4, item5, item6, item7, item8;

  // Store Element
  //  Element element;

  SelectMenu select;
  public ProcCHANNEL(URL u, String tit, TXElement el) {
    super();
    m_url = u;
    m_title = tit;
    //    add(m_ltitle = new LabelEdt(""));
        add(m_ltitle = new LabelEdt(tit));
    m_cb = new Rectangle();

    // It is used for "new channel" without Transform class
    m_children = new XMLComponent[0];

    select = new SelectMenu(m_title, el, (XMLComponentEdt )this);
    //    pbox = new PropertyBox("Property Box");

    // Make Popup Menu
    // Make Popup Menu
    pop = new PopupMenu("Operations");
    /*
    item = new MenuItem("copy");
    item.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item.addActionListener(select);
    pop.add(item);
    */
    pop.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item1 = new MenuItem("cut");
    item1.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item1.addActionListener(select);
    pop.add(item1);
    item2 = new MenuItem("delete");
    item2.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item2.addActionListener(select);
    pop.add(item2);
    item3 = new MenuItem("paste as last child");
    item3.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item3.addActionListener(select);
    pop.add(item2);
    item4 = new MenuItem("paste after");
    item4.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item4.addActionListener(select);
    pop.add(item3);
    item5 = new MenuItem("paste before");
    item5.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item5.addActionListener(select);
    pop.add(item4);
    pop.addSeparator();
    item6 = new MenuItem("view/edit");
    item6.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item6.addActionListener(select);
    pop.add(item5);
    item7 = new MenuItem("new channel");
    item7.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item7.addActionListener(select);
    pop.add(item6);
    item8 = new MenuItem("new item");
    item8.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item8.addActionListener(select);
    pop.add(item7);
    add(pop);

    element = el;

    //setForeground(Color.red);
    //    setBackground(new Color(192, 192, 192));
    setBackground(new Color(255, 255, 255));
    //    setFont(new Font("serif", Font.BOLD, 14));
    //**    setFont(new Font("Helvetica", Font.BOLD, 16));
    removeMouseListener(this);

    m_ltitle.addMouseListener(this);

    // set listeners
    addMouseListener(this);

    //    addMouseListener(select);
  }

  String getTitle() {
    return m_title;
  }

  public void enableBtns (){
    if (cdfeStatus.getStatus() == cdfeStatus.UNSAVED) {
    item3.setEnabled(false);
    item4.setEnabled(false);
    item5.setEnabled(false);
    } else {
    item3.setEnabled(true);
    item4.setEnabled(true);
    item5.setEnabled(true);
    }
  }      
    

  public void setFgLabelColor(Color col) {
    m_ltitle.setForeground(col);
  }

  private void setChildren(XMLComponent[] ax) {
    //System.err.println("CHANNEL#setChildren()");
    //setLayout(null);
    for (int i = 0;  i < ax.length;  i ++)
      add(ax[i]);
    m_children = ax;
    setLayout(null);
  }
  static final int CHILD_OFFSET = 20;
  static final int SWITCH = 16;

  private void calcMinimum() {
    Graphics g = getGraphics();
    if (null == g || null == m_children) {
      System.err.println("g:"+g+" m_children:"+m_children);
    } else {
      FontMetrics fm = g.getFontMetrics();
      int thish = fm.getHeight();
      int w = SWITCH+2+m_ltitle.getPreferredSize().width;
      m_cb.setBounds(0, 0, SWITCH, thish);
      m_ltitle.setBounds(SWITCH+2, 0, m_ltitle.getPreferredSize().width, thish);

      if (m_isopen) {
    for (int i = 0;  i < m_children.length;  i ++) {
      Dimension d = m_children[i].getMinimumSize();
      int h = d.height;
      //      if (m_children[i] instanceof ProcITEM) {
      //        System.out.println("ProcItem will be created" + " " + CHILD_OFFSET  + " " + thish  + " " +  d.width  + " " +  h);
      //      }
      m_children[i].setBounds(CHILD_OFFSET, thish, d.width, h);
      thish += h;
      if (w < CHILD_OFFSET+d.width)  w = CHILD_OFFSET+d.width;
    }
    
      } else {
    for (int i = 0;  i < m_children.length;  i ++) {
      m_children[i].setBounds(0, 0, 0, 0);
      //m_children[i].setBounds(10, 10, 10,10);
    }
      }
      m_min = new Dimension(w, thish);
    }
  }

  public void doLayout() {
    //    System.err.println("CHANNEL#doLayout(): "+m_min);
    calcMinimum();
    repaint();
  }

  public void setLabel(String str) {
    remove(m_ltitle);
    //    m_ltitle.setText("");
    
    m_ltitle = new LabelEdt(str);
    add(m_ltitle);
    m_ltitle.addMouseListener(this);
    m_title = str;
    doLayout();
  }

  public Dimension getMinimumSize() {
    if (null == m_min)  calcMinimum();
    return m_min;
  }
  public Dimension getPreferredSize() {
    return getMinimumSize();
  }

  int getConnectedOffset() {
    return m_cb.getSize().height/2;
  }
  public void paint(Graphics g) {
    // When the channel is open
    if (m_isopen && 0 < m_children.length) {
      Color origc = g.getColor();
      g.setColor(Color.black);
      int h = m_cb.getSize().height;
      Rectangle r = null;
      int ch = 0;
      for (int i = 0;  i < m_children.length;  i ++) {
    r = m_children[i].getBounds();
    ch = ((XMLComponentM)m_children[i]).getConnectedOffset();
    g.drawLine(SWITCH/2, r.y+ch, CHILD_OFFSET, r.y+ch);
      }
      g.drawLine(SWITCH/2, h, SWITCH/2, r.y+ch);
      g.setColor(origc);
    }
    if (m_isopen) {
      g.drawLine(m_cb.x+4, m_cb.y+m_cb.height/2,
         m_cb.x+m_cb.width-4, m_cb.y+m_cb.height/2);
    } else {
      g.drawLine(m_cb.x+4, m_cb.y+m_cb.height/2,
         m_cb.x+m_cb.width-4, m_cb.y+m_cb.height/2);
      g.drawLine(m_cb.x+m_cb.width/2, m_cb.y+4,
         m_cb.x+m_cb.width/2, m_cb.y+m_cb.height-4);
    }
    g.drawOval(m_cb.x+3, m_cb.y+3,
           m_cb.x+m_cb.width-3*2, m_cb.y+m_cb.height-3*2);
  }

  void select(boolean f) {
    super.select(f);
    m_ltitle.setBackground(f ? Color.green : new Color(192, 192, 192));
  }

  public void setTitleFgColor(Color col) {
      m_ltitle.setForeground(col);
  }

  public void mouseReleased(MouseEvent e) {
    // String stat = select.getStatus();
    // System.out.println("hoge2 "+stat);
    if (e.getSource() == this) {
      Container co = getParent();
      doLayout();
      do {
    co.doLayout();
      } while (null != (co = co.getParent()));

      if (m_cb.contains(e.getPoint())) {
    m_isopen = !m_isopen;
    co = getParent();
    doLayout();
    do {
      co.doLayout();
    } while (null != (co = co.getParent()));
      }
    }
  }

  public void mouseEntered(MouseEvent e) {
    if (e.getSource() == m_ltitle) {
      super.mouseEntered(e);
      m_ltitle.setForeground(Color.red);
      repaint();
    }
  }
  public void mouseExited(MouseEvent e) {
    if (e.getSource() == m_ltitle) {
      super.mouseExited(e);
      m_ltitle.setForeground(Color.black);
      repaint();
    }
  }

  public void processMouseEvent(MouseEvent e) {
    if (e.isPopupTrigger()) {
      enableBtns();
      pop.show(this, e.getX(), e.getY());
      
    item1.setEnabled(false);
//      m_ltitle.setForeground(Color.blue);
    }
    else
      super.processMouseEvent(e);
  }

}








