/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfEditor;

import com.ibm.xml.parser.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import org.w3c.dom.Attr;

/**
 *
 * @version Revision: 59 1.4 samples/CdfEditor/ProcITEM.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Naohiko Uramoto
 */
public class ProcITEM extends XMLComponentEdt {
  public static XMLComponent newInstance(Transform co, TXElement el) {
    //    System.out.println("newinstance of ProcItem is called");
    //    System.out.println("");
    try {
      Attr attr = el.getAttributeNode("HREF");
      if (null == attr)  return null;    
      String urlstr = attr.getValue();
      URL u = new URL(urlstr);
      TXElement ec = (TXElement)el.getElementNamed("TITLE");
      if (null == ec)  return null;
      return new ProcITEM(u, ec.getText(), el);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }

  String m_title;
  Dimension m_min;
  //  LabelEdt m_ltitle;
 
  SelectMenu select;

  // Popup Menus
  PopupMenu pop;
  MenuItem item0, item1, item2, item3, item4, item5, item6, item7, item8;

  public ProcITEM(URL u, String tit, TXElement el) {
    super();
    m_url = u;
    m_title = tit;
    //    add(m_ltitle = new LabelEdt(tit));
  
  //setForeground(Color.blue);
    //    setFont(new Font("serif", Font.PLAIN, 12));

    select = new SelectMenu(m_title, el, (XMLComponentEdt )this);

    // Make Popup Menu
    pop = new PopupMenu("Operations");
    pop.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item0 = new MenuItem("copy");
    item0.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item0.addActionListener(select);
    pop.add(item0);
    item1 = new MenuItem("cut");
    item1.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item1.addActionListener(select);
    pop.add(item1);
    item2 = new MenuItem("delete");
    item2.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item2.addActionListener(select);
    pop.add(item2);
    pop.addSeparator();
    item3 = new MenuItem("paste as last child");
    item3.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    // item3.addActionListener(select);
    //    pop.add(item3);
    item4 = new MenuItem("paste after");
    item4.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item4.addActionListener(select);
    pop.add(item4);
    item5 = new MenuItem("paste before");
    item5.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item5.addActionListener(select);
    pop.add(item5);
    pop.addSeparator();
    item6 = new MenuItem("new channel");
    item6.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item6.addActionListener(select);
    pop.add(item6);
    item7 = new MenuItem("new item");
    item7.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item7.addActionListener(select);
    pop.add(item7);
    pop.addSeparator();
    item8 = new MenuItem("view/edit");
    item8.setFont(new Font("Helvetica", Font.BOLD + Font.ITALIC, 14));
    item8.addActionListener(select);
    pop.add(item8);
    add(pop);

    element = el;

    //    setFont(new Font("Helvetica", Font.PLAIN, 16));
    // set listeners
    addMouseListener(this);


  }

  static final int MARGIN = 2;
  public void addNotify() {
    super.addNotify();
    Graphics g = getGraphics();
    if (null == g) {
      System.err.println("Bad");
    } else {
      FontMetrics fm = g.getFontMetrics();
      m_min = new Dimension(MARGIN*2+fm.stringWidth(m_title), fm.getHeight());
    }
  }        

  public String getTitle() {
    return m_title;
  }

  public Dimension getMinimumSize() {
    return m_min;
  }
  public Dimension getPreferredSize() {
    return m_min;
  }

  int getConnectedOffset() {
    return getSize().height/2;
  }

  void select(boolean f) {
    super.select(f);
    //    setBackground(f ? Color.green : new Color(192, 192, 192));
  }
  public void paint(Graphics g) {
    //    System.err.println("Paint from ProcItem title " + m_title);
    g.drawString(m_title, MARGIN, g.getFontMetrics().getAscent());
    //    g.drawString("title", MARGIN, g.getFontMetrics().getAscent());
  }

  public void enableBtns (){
    if (cdfeStatus.getStatus() == cdfeStatus.UNSAVED) {
      //    item3.setEnabled(false);
    item4.setEnabled(false);
    item5.setEnabled(false);
    } else {
      //item3.setEnabled(true);
    item4.setEnabled(true);
    item5.setEnabled(true);
    }
  }      
  public void setStr(String str) {
    Graphics g = getGraphics();
    g.setColor(Color.white);
    g.drawString(m_title, MARGIN, g.getFontMetrics().getAscent());
    g.setColor(Color.black);
    g.drawString(str, MARGIN, g.getFontMetrics().getAscent());
    m_title = str;
  }

  public void mouseReleasd(MouseEvent e) {
    String stat = select.getStatus();
    //    System.out.println("hoge2 "+stat);
    if (stat.equals("done"))
      select.setStatus("null");
    m_gate.showDocument(this, m_url);
  }

  public void mousePressed(MouseEvent e) {
    String stat = select.getStatus();
    //    System.out.println("hoge "+stat);
    if (stat == "move1st") {
      System.out.println("in move in ITEM");
      XMLComponentEdt xcs = select.getSelectedXc();
      //      if (xcs instanceof ProcITEM) {
      if (true) {
    select.setStatus("done");
    // remove 
    // System.out.println("Now in move process");
    Container co = xcs.getParent();
    //  xc.m_isopen = false;

    if (CanMoveToComponentP(xcs)) {
      // remove
      co.remove(xcs);
      XMLComponentEdt xcm = (XMLComponentEdt )co;
      xcm.removeXMLComponent((XMLComponent )xcs);

      // add Childrenlist
      addXMLComponentLast(xcs);
      doLayout();
      do {
        co.doLayout();
      } while (null != (co = co.getParent()));
    }
    // reset string color to black from blue
    if (xcs instanceof ProcCHANNEL) 
      ((ProcCHANNEL )xcs).setFgLabelColor(Color.black);
      }
    }
  }

  public void mouseEntered(MouseEvent e) {
    super.mouseEntered(e);
    setForeground(Color.red);
    //    PropertyBox.etypeTF.setText("ITEM");
    repaint();
  }
  public void mouseExited(MouseEvent e) {
    super.mouseExited(e);
    setForeground(Color.black);
    repaint();
  }
    

  public void processMouseEvent(MouseEvent e) {
    if (e.isPopupTrigger()) {
      enableBtns();
      pop.show(this, e.getX(), e.getY());
      //      select.setSelectedXc((ProcITEM )this);
      setForeground(Color.blue);
    }
    else
      super.processMouseEvent(e);
  }

}
