/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfEditor;

import com.ibm.xml.parser.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.awt.event.*;
import org.w3c.dom.Attr;

/**
 *
 * @version Revision: 60 1.4 samples/CdfEditor/PropertyBox.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Naohiko Uramoto
 */
public class PropertyBox extends Frame implements ActionListener, TextListener {

  Label hrefLabel = new Label();
  TextField titleTF = new TextField();
  Label elementLabel = new Label();
  TextField hrefTF = new TextField();
  TextField etypeTF = new TextField();
  Label titleLabel = new Label();
  Label authorLabel = new Label();
  TextField authorTF = new TextField();
  TextField abstTF = new TextField();
  Label abstLabel = new Label();
  Button applyBtn = new Button();
  Button quitBtn = new Button();
  XMLComponentEdt xmlc;

  boolean author, abst, href, tit;

  public PropertyBox (XMLComponentEdt xc) {

    super("");
    xmlc = xc;
    //    setFont(new Font("Helvetica", Font.PLAIN, 14));
    setLayout(null);
    this.setSize(new Dimension(510, 260));
    this.setBounds(500, 20,510, 260);
    this.setTitle("Property Box");

    hrefLabel.setFont(new Font("Helvetica", 1, 16));
    hrefLabel.setText("HREF");
    // titleTF.setFont(new Font("TimesRoman", 0, 14));
    elementLabel.setFont(new Font("Helvetica", 1, 16));
    elementLabel.setText("ELEMENT");
    //    etypeTF.addActionListener(this);

    hrefTF.setFont(new Font("TimesRoman", 0, 14));
    etypeTF.setForeground(Color.red);
    //    etypeTF.setFont(new Font("Helvetica", 1, 16));
    etypeTF.setText("CHANNEL");
    titleLabel.setFont(new Font("Helvetica", 1, 16));
    titleLabel.setText("TITLE");
    //    authorLabel.setFont(new Font("Helvetica", 1, 16));
    //    authorLabel.setText("AUTHOR");
    //    authorTF.setFont(new Font("TimesRoman", 0, 14));
    //abstTF.setFont(new Font("TimesRoman", 0, 14));
    abstLabel.setFont(new Font("Helvetica", 1, 16));
    abstLabel.setText("ABSTRACT");
    applyBtn.setFont(new Font("SansSerif", 0, 16));
    applyBtn.setLabel("Apply");
    quitBtn.setFont(new Font("SansSerif", 0, 16));
    quitBtn.setLabel("Quit");

    quitBtn.addActionListener(this);
    applyBtn.addActionListener(this);

    add(hrefLabel);
    hrefLabel.setLocation(26, 119);
    hrefLabel.setSize(48,30);

    add(titleTF);
    titleTF.setLocation(120, 78);
    titleTF.setSize(379, 27);

    add(elementLabel);
    elementLabel.setLocation(27, 30);
    elementLabel.setSize(85, 32);

    add(hrefTF);
    hrefTF.setLocation(119, 119);
    hrefTF.setSize(379, 27);

    add(etypeTF);
    etypeTF.setLocation(120, 30);
    etypeTF.setSize(113, 30);

    add(titleLabel);
    titleLabel.setLocation(25, 80);
    titleLabel.setSize(48, 30);

    //    add(authorLabel);
    //    authorLabel.setLocation(25, 160);
    //    authorLabel.setSize(69, 30);

    //    add(authorTF);
    //    authorTF.setLocation(119, 160);
    //    authorTF.setSize(379, 27);

    add(abstTF);
    abstTF.setLocation(119, 160);
    abstTF.setSize(379, 27);

    add(abstLabel);
    abstLabel.setLocation(25, 160);
    abstLabel.setSize(93, 30);

    add(applyBtn);
    applyBtn.setLocation(119, 201);
    applyBtn.setSize(114, 42);

    add(quitBtn);
    quitBtn.setLocation(273, 201);
    quitBtn.setSize(119, 42);

    author = abst = href = tit = false;

    if (xc instanceof ProcITEM) {
      etypeTF.setText("ITEM");
    } else {
      etypeTF.setText("CHANNEL");
    }
    TXElement el = xc.getElement().getElementNamed("TITLE");
    String estr;
    if (el != null) {
      estr = el.getText();
      if (estr != null) 
    titleTF.setText(estr);
      else 
    titleTF.setText("");
    } else 
      abstTF.setText("");
    el = xc.getElement().getElementNamed("ABSTRACT");
    if (el != null) {
      estr = el.getText();
      if (estr != null) 
    abstTF.setText(estr);
      else 
    abstTF.setText("");
    } else 
      abstTF.setText("");

    Attr attr = xc.getElement().getAttributeNode("HREF");
    if (attr != null) 
      hrefTF.setText(attr.getValue());
    else 
      hrefTF.setText("");

    titleTF.addTextListener(this);
    abstTF.addTextListener(this);
    hrefTF.addTextListener(this);

  }

  /*
  public static void main(String arges[]) {
    PropertyBox f = new PropertyBox("Property Box");
    f.show();
  }
  */

  public void textValueChanged(TextEvent e) {
    if (e.getSource() == titleTF) {
      tit = true;
    }
    if (e.getSource() == abstTF) {
      abst = true;
    }
    if (e.getSource() == hrefTF) {
      href = true;
    }

  }
  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == quitBtn) {
      setVisible(false);
    } else if (e.getSource() == applyBtn) {
      if (tit) {
    modifyContent("TITLE");
    tit = false;
      }
      else if (abst) {
    modifyContent("Abstract");
    abst = false;
      }
    }
  }

  public void modifyContent(String tag) {
    if (xmlc instanceof ProcCHANNEL) {
      if (tag.equals("TITLE")) {
    ((ProcCHANNEL )xmlc).setLabel(titleTF.getText());
      }
      // else if (tag.equals("ABSTRACT")) {
      //    ((ProcCHANNEL )xmlc).setLabel(abstTF.getText());
      //       }
      TXElement ecTemp = xmlc.getElement();
      TXElement ec = ecTemp.getElementNamed(tag); 
      Child textChild[] = ec.getChildrenArray();
      // Element update
      //      System.out.println( ((TXElement )textChild[0]).getText());
      if (textChild[0] instanceof TXText) {
    if (tag.equals("TITLE")) {
      ((TXText )textChild[0]).setData(titleTF.getText());
    }
    else if (tag.equals("Abstract")) {
      ((TXText )textChild[0]).setData(abstTF.getText());
    }
      }
    } 
    else if (xmlc instanceof ProcITEM) {
      if (tag.equals("TITLE")) {
    ((ProcITEM )xmlc).setStr(titleTF.getText());
      }
      else if (tag.equals("ABSTRACT")) {
    ((ProcITEM )xmlc).setStr(abstTF.getText());
      }
      TXElement ecTemp = xmlc.getElement();
      TXElement ec = ecTemp.getElementNamed(tag);
      Child textChild[] = ec.getChildrenArray();
      if (textChild[0] instanceof TXText){
    if (tag.equals("TITLE")) {
          ((TXText )textChild[0]).setData(titleTF.getText());
    }
    else if (tag.equals("ABSTRACT")) {
      ((TXText )textChild[0]).setData(abstTF.getText());
    }
      }
    }
    //  ((ProcCHANNEL )xmlc).m_ltitle.doLayout();
    xmlc.doLayout();
    Container co = xmlc.getParent();
    while (co != null) {
      co.doLayout();
      co = co.getParent();
    }
  }
}
  




