/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfEditor;

import com.ibm.xml.parser.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import java.awt.event.*;
import org.w3c.dom.Attr;

/**
 *
 * @version Revision: 61 1.5 samples/CdfEditor/SelectMenu.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Naohiko Uramoto
 */
public class SelectMenu implements ActionListener {

    String m_title;
    TXElement element;
    XMLComponent xc;  // component in cut buffer

    static String status;
    static XMLComponentEdt selectedXc;

    public SelectMenu(String title, TXElement el, XMLComponentEdt xlc) {
        m_title = title;
        element = el;
        xc = xlc;
        selectedXc = null;
        status = "null";
    }

    public void setSelectedXc (XMLComponentEdt sxc) {
        selectedXc = sxc;
    }

    public XMLComponentEdt getSelectedXc () {
        return selectedXc;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String stat) {
        status = stat;
    }

    public void actionPerformed(ActionEvent e) {

        Container con = xc.getParent();
        Frame frm = null;
        while( (con = con.getParent()) != null) {
            if (con instanceof Frame) {
                frm = (Frame ) con; 
                frm.setCursor(new Cursor(Cursor.WAIT_CURSOR));
            }
        }
        if (e.getActionCommand().equals("copy")) {
            cdfeStatus.setStatus(cdfeStatus.SAVED);

            TXElement copiedElement = (TXElement )element.clone();
            Attr attr = copiedElement.getAttributeNode("HREF");
            try {
                String urlstr = null;
                if (attr == null) 
                    urlstr = "http://xxx.com";
                else 
                    urlstr = attr.getValue();
                
                URL u = new URL(urlstr);
                XMLComponentEdt newpc;
                if (xc instanceof ProcITEM) {
                    TXElement titlel = (TXElement)copiedElement.getElementNamed("TITLE");

                    newpc = new ProcITEM(u, titlel.getText(), copiedElement);
                    ((XMLComponentM)newpc).setGateway(((XMLComponentM )xc).getGateway());
                    setSelectedXc((XMLComponentEdt ) newpc);

                } 
                else if (xc instanceof ProcCHANNEL) {
                    Transform tf = new Transform("", CdfEditor.PROCPACKAGE);
                    XMLComponent copiedxc = tf.makeComponent(copiedElement);
                    ((XMLComponentM) copiedxc).setGateway( ((XMLComponentM )xc).getGateway());
                    setSelectedXc((XMLComponentEdt ) copiedxc);
                }
            } catch (Exception ex) {
                System.err.println("url");
                System.err.flush();
            }

        } 
        else if (e.getActionCommand().equals("new channel")) {
            TXElement newel = new TXElement("New Channel");
            ProcCHANNEL newpc;
            try {
                URL u = new URL("http://www.w3.org/pub/WWW/TR/WD-xml-lang");
                newpc = new ProcCHANNEL(u, "** New Channel. Edit Me! **", newel);
                Gateway g = new Gateway();
                ((XMLComponentM)newpc).setGateway(g);

                // add Childrenlist
                ((XMLComponentEdt )xc).addXMLComponent((XMLComponentEdt )newpc, "after");
                newpc.setTitleFgColor(Color.green);
                ((XMLComponentEdt )newpc).newBox();
                ((XMLComponentEdt )newpc).pbox.show();

                xc.doLayout();
                Container co = xc.getParent();
                do {
                    co.doLayout();
                } while (null != (co = co.getParent()));
                // reset string color to black from blue
            } catch (Exception ex) {
                System.err.println("url");
            }
        } 
        else if (e.getActionCommand().equals("new item")) {
            TXElement newel = new TXElement("New Item");
            ProcITEM newit;
            try {
                URL u = new URL("http://www.w3.org/pub/WWW/TR/WD-xml-lang");
                newit = new ProcITEM(u, "** New item Edit Me! **", newel);
                Gateway g = new Gateway();
                ((XMLComponentM)newit).setGateway(g);

                // add Childrenlist
                ((XMLComponentEdt )xc).addXMLComponent((XMLComponentEdt )newit, "after");
                //    newpc.setTitleFgColor(Color.green);
                ((XMLComponentEdt )newit).newBox();
                ((XMLComponentEdt )newit).pbox.show();
                ((XMLComponentEdt )newit).pbox.etypeTF.setText("ITEM");

                xc.doLayout();
                Container co = xc.getParent();
                do {
                    co.doLayout();
                } while (null != (co = co.getParent()));
                // reset string color to black from blue
            } catch (Exception ex) {
                System.err.println("url");
            }
        } 
        else if (e.getActionCommand().equals("view/edit")) {
            ((XMLComponentEdt )xc).newBox();
            ((XMLComponentEdt )xc).pbox.show();
        } 
        // ****** Paste Process (1) *****         
        else if (e.getActionCommand().equals("paste as last child")) {
            cdfeStatus.setStatus(cdfeStatus.UNSAVED);
            if (selectedXc != null) {
                Container co = xc.getParent();
      
                // Check if the node can move
                if (((XMLComponentEdt )xc).CanMoveToComponentP(selectedXc)) {
                    // add Childrenlist
                    ((XMLComponentEdt )xc).addXMLComponentLast(selectedXc);
                    xc.doLayout();
                    do {
                        co.doLayout();
                    } while (null != (co = co.getParent()));
                }
    
                // buffer is cleared!!
                selectedXc = null;
            }
        }
        // ****** Paste Process (2) *****         
        else if (e.getActionCommand().equals("paste after")) {
            cdfeStatus.setStatus(cdfeStatus.UNSAVED);
            if (selectedXc != null) {
                Container co = xc.getParent();

                // add Childrenlist

                ((XMLComponentEdt )xc).addXMLComponent(selectedXc, "after");
                xc.doLayout();
                do {
                    co.doLayout();
                } while (null != (co = co.getParent()));

                // buffer is cleared!!
                selectedXc = null;
            }
        }

        // ****** Paste Process (3) *****         
        else if (e.getActionCommand().equals("paste before")) {
            cdfeStatus.setStatus(cdfeStatus.UNSAVED);
            if (selectedXc != null) {
                Container co = xc.getParent();

                // add Childrenlist
                ((XMLComponentEdt )xc).addXMLComponent(selectedXc, "before");
                xc.doLayout();
                do {
                    co.doLayout();
                } while (null != (co = co.getParent()));

                // buffer is cleared!!
                selectedXc = null;
            }
        }

        // ****** Delete/Cut Process *****         
        else if (e.getActionCommand().equals("delete") || e.getActionCommand().equals("cut")) {
            cdfeStatus.setStatus(cdfeStatus.SAVED);
            // push to cut buffer
            if (e.getActionCommand().equals("cut")) {
                setSelectedXc((XMLComponentEdt )xc);
            }
            status = "done";
            Parent p = (Parent)element.getParentNode();
            if (!(p instanceof TXDocument)) { // Top channel cannot be removed
                ((TXElement )p).removeChild(element);
    
                // remove xc from parent panel
                Container co = xc.getParent();
                co.remove(xc);
                XMLComponentEdt xcm = (XMLComponentEdt )co;
                xcm.removeXMLComponent(xc);
                // re-layout tree
                do {
                    co.doLayout();
                } while (null != (co = co.getParent()));
    
            }
        }

        // reset cursor
        if (frm != null) 
            frm.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }
}
