/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfEditor;


import java.awt.*;
import java.io.*;
import java.lang.reflect.*;
import java.net.*;
import java.util.*;
import com.ibm.xml.parser.*;
//import netscape.security.PrivilegeManager;

/**
 *
 * @version Revision: 62 1.4 samples/CdfEditor/Transform.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class Transform {
    String m_base;
    /**
     * Make XMLComponent instance from specified element.
     * @return an instance or null
     */
    public XMLComponent makeComponent(TXElement el) {
        XMLComponent xc = null;
        Class cload = null;
        try {
            cload = Class.forName(m_base+el.getNodeName().toUpperCase());
        } catch (ClassNotFoundException e) {
            try {
                cload = Class.forName(m_base);
            } catch (ClassNotFoundException ex) {
                try {
                    cload = Class.forName("samples.CdfEditor.XMLComponent");
                } catch (ClassNotFoundException exc) {
                }
            }
        }
        try {
            //PrivilegeManager.enablePrivilege("Debugger"); //"UniversalMemberAccess");
            Class[] param = new Class[2];
            Class cdrv = this.getClass();
            Class cchil = Class.forName("com.ibm.xml.parser.TXElement");
            param[0] = cdrv;
            param[1] = cchil;
            //System.err.println("getmethod...");
            Method me = cload.getDeclaredMethod("newInstance", param);

            Object[] mparam = new Object[2];
            mparam[0] = this;
            mparam[1] = el;
            //System.err.println("invoke...");
            xc = (XMLComponent)me.invoke(null, mparam);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return xc;
    }

    /**
     * Make XMLComponent against all children of specified element except TXText.
     */
    public XMLComponent[] makeChildren(TXElement el) {
        Child[] ac = el.getChildrenArray();
        Vector v = new Vector(ac.length);
        for (int i = 0;  i < ac.length;  i ++) {
            if (ac[i] instanceof TXElement) {
                XMLComponent xc = makeComponent((TXElement)ac[i]);
                if (null != xc)  v.addElement(xc);
            }
        }
        XMLComponent[] ax = new XMLComponent[v.size()];
        v.copyInto(ax);
        return ax;
    }

    private Parser m_p;
    public Transform(ErrorListener el, StreamProducer sp, String basepackage) {
        m_p = new Parser("XML Parser", el, sp);
        m_base = basepackage;
    }
    public Transform(String fname, String basepackage) {
        m_p = new Parser(fname);
        m_base = basepackage;
    }
    public Parser getParser() {
        return m_p;
    }

    /**
     * @param is InputStream of XML document.  The stream is not closed in this method.
     * @return <strong>null</strong> when an error occurs
     */
    public XMLComponent readStream(InputStream is) {
        TXDocument doc = m_p.readStream(is);
        XMLComponent xc = null;
        if (null != doc && null != doc.getDocumentElement())
            xc = makeComponent((TXElement)doc.getDocumentElement());
        return xc;
    }
}
