/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfEditor;

import com.ibm.xml.parser.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import org.w3c.dom.Node;

/**
 *
 * @version Revision: 64 1.4 samples/CdfEditor/XMLComponentEdt.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author Naohiko Uramoto
 */
class XMLComponentEdt extends XMLComponentM {

  XMLComponentEdt() {
    super();
  }

  public XMLComponent[] getMChildren() {
    return m_children;
  }

  public TXElement element;

  PropertyBox pbox;

  public void newBox() {
    pbox = new PropertyBox(this);
  } 

  public TXElement getElement() {
    return element;
  }

  public void setMChildren(XMLComponent[] children) {
    m_children = children;
  }

  public int removeXMLComponent(XMLComponent xlc) throws ArrayIndexOutOfBoundsException {

    XMLComponent[] xcsnew;
    xcsnew = new XMLComponent[m_children.length-1];
      
    // set new XMLComonent list without myself
    int i, j = 0;
    try {
      for (i = 0;  i < m_children.length;  i++) {
        if (m_children[i] == xlc) {
          //          System.out.println("find!!");
     } 
    if (m_children[i] != xlc) {
      xcsnew[j++] = m_children[i]; 
    } 
      }
      // set new XMLComonent list without myself
      m_children = xcsnew;

      // repaint
      doLayout();
      Container co = getParent();
      do {
    co.doLayout();
      } while (null != (co = co.getParent()));

    } catch (Exception e) {
      return 1;
    }
    return 0;
  }

  public boolean addXMLComponentLast(XMLComponent xlc) throws ArrayIndexOutOfBoundsException {

    if (this instanceof ProcITEM) {
      return false;
    }
    XMLComponent[] xcsnew;
    xcsnew = new XMLComponent[m_children.length+1];
    int j = 0;
    try {
      for (int i = 0;  i < m_children.length;  i++) {
          xcsnew[j++] = m_children[i]; 
      } 
      xcsnew[j] = (XMLComponent )xlc;
      // set new XMLComonent list without myself
      m_children = xcsnew;
      
      // add the component in AWT tree
      add(xlc);
      // update Element tree

      TXElement fromEl = ((XMLComponentEdt )xlc).getElement();
      TXElement toEl   = ((ProcCHANNEL )this).getElement();

      //    Parent p = toEl.getParent();
      Node p2 = fromEl.getParentNode();
      p2.removeChild(fromEl);
      toEl.appendChild(fromEl);

      //      Parent p3 = fromEl.getParent();
      //      System.out.println("parent="+ ((TXElement )p3).getText());

      // repaint
      doLayout();
      Container co = getParent();
      do {
          co.doLayout();
      } while (null != (co = co.getParent()));
      
      // Print
      /*
    while (!(p instanceof Document)) {
    p = ((TXElement )p).getParent();
    }
    Document doc = (Document )p;
    doc.print(new PrintWriter(new OutputStreamWriter(System.out)));
      */
    } catch (Exception e) {
      return false;
    }
  return true;
  }
  
  /**
   * @desription add component after the node
   */
  public boolean addXMLComponent(XMLComponent xlc, String direction) throws ArrayIndexOutOfBoundsException {

    /*
    if (this instanceof ProcCHANNEL) {
      String to = ((ProcCHANNEL )this).getTitle();
      System.out.println("to:" + to);
    } else {
      String to = ((ProcITEM )this).getTitle();
      System.out.println("to:::" + to);
    }

    if (xlc instanceof ProcCHANNEL) {
      String from = ((ProcCHANNEL )xlc).getTitle();
      System.out.println("from:" + from);
    } else {
      String from = ((ProcITEM )xlc).getTitle();
      System.out.println("from:::" + from);
    }
    */
    // if this is root, do nothing
    if (element.getParentNode() instanceof TXDocument) 
      return false;

    // get parent component
    Container p = getParent();
    XMLComponentEdt parentComponent = (XMLComponentEdt )p;

    XMLComponent[] parentChildren, xcsnew;
    parentChildren = parentComponent.getMChildren();

    //  System.out.println("no="+parentChildren.length);

    xcsnew = new XMLComponent[parentChildren.length+1];
    int j = 0;
    try {
      if (direction.equals("after")) {
    for (int i = 0;  i < parentChildren.length;  i++) {
      xcsnew[j++] = parentChildren[i]; 
      if ((XMLComponent )parentChildren[i] == this) {
        //      System.out.println("after: find!");
        xcsnew[j++] = xlc;
        
      }
    }
      } else {
    for (int i = 0;  i < parentChildren.length;  i++) {
      if ((XMLComponent )parentChildren[i] == this) {
        // System.out.println("after: find!");
        xcsnew[j++] = xlc;
      }
      xcsnew[j++] = parentChildren[i]; 
    }
      } 

      // System.out.println("j="+j);
      //      System.out.println("no="+parentChildren.length);
      // set new XMLComonent list without myself
      if (j == parentChildren.length+1 ) {
    parentComponent.setMChildren(xcsnew);
      }

      // add the component in AWT tree
      parentComponent.add(xlc);
      // update Element tree

      TXElement fromEl = ((XMLComponentEdt )xlc).getElement();
      TXElement toEl   = ((XMLComponentEdt )this).getElement();

      //    Parent p = toEl.getParent();

      // remove from element
      /* [97/10/17] It is done by cut process 
      Parent p2 = fromEl.getParent();
      ((TXElement )p2).removeElement(fromEl);
      */

      Parent p2 = (Parent)toEl.getParentNode();
      if (direction.equals("after")) {
    ((TXElement )p2).insertAfter((Child )fromEl, (Child )toEl);
      } else {
    ((TXElement )p2).insertBefore((Child )fromEl, (Child )toEl);
      }
      // repaint
      doLayout();
      Container co = getParent();
      do {
    co.doLayout();
      } while (null != (co = co.getParent()));
      
      /*
      // Print
      while (!(p2 instanceof Document)) {
    p2 = ((Element )p2).getParent();
    }
    Document doc = (Document )p2;
    doc.print(new PrintWriter(new OutputStreamWriter(System.out)));
      */
    } catch (Exception e) {
      System.out.println(e.getMessage());
      return false;
    }
    return true;
  }

  
  /**
   * @param xc: source component
   * @description Check if source component can move to this 
   *              component.
   */
  public boolean CanMoveToComponentP(XMLComponent xc) {
    //    System.out.println("check");
    String to;
    String from;
    
    if (this instanceof ProcCHANNEL) {
      to = ((ProcCHANNEL )this).getTitle();
      //      System.out.println("to:" + to);
      if (xc instanceof ProcCHANNEL) {
    from = ((ProcCHANNEL )xc).getTitle();
    //  System.out.println("from:" + from);
    // xc is myself
    if (to.equals(from)) {
      System.out.println("CHECK: same");
      return false;
    }
      }
    }

    Container co = getParent();
    // xc is root
    if (co == null) return false;
    while (true) {
      if (co == null) {
    break;
      }
      if (!(co instanceof ProcCHANNEL) && !(co instanceof ProcITEM)) {
      break;
      }
      if (co == xc) {
    System.out.println("CHECK: path");
    return false;
      }
      co = co.getParent();
    } 

    return true;
  }
}





