/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

/*
 * Revision: 66 1.1 samples/CdfView/Gateway.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 */

package samples.CdfView;

import java.awt.*;
import java.applet.*;
import java.net.*;

public class Gateway extends Label {
    AppletContext m_ac;
    Main m_a;
    public Gateway(Main a) {
        super();
        setFont(new Font("monospaced", Font.BOLD, 12));
        m_a = a;
        m_ac = a.getAppletContext();
    }
    public Dimension getMinimumSize() {
        return new Dimension(16, 16);
    }
    public Dimension getMaximumSize() {
        return new Dimension(1024, 16);
    }
    public Dimension getPreferedSize() {
        return new Dimension(16, 16);
    }

    Image getOpenImage() {
        return m_a.m_imgsmall;
    }
    Image getCloseImage() {
        return m_a.m_imgbig;
    }

    FontMetrics m_fm = null;
    public void setText(String s) {
        super.setText(s);
        if (null == m_fm)  m_fm = getGraphics().getFontMetrics();
        if (getSize().width < m_fm.stringWidth(s)) {
            setAlignment(RIGHT);
        } else
            setAlignment(LEFT);
    }
                                   

    XMLComponentM m_xm = null;
    public void showDocument(XMLComponentM m, URL u) {
        if (null != m_ac)
            m_ac.showDocument(u, "content");
        if (null != m_xm)
            m_xm.select(false);
        m_xm = m;
        m_xm.select(true);
    }
}
