/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

package samples.CdfView;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TagHandler;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 *
 * @version Revision: 67 1.2 samples/CdfView/Main.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class Main extends java.applet.Applet implements java.awt.event.ActionListener {
    Image m_imgbig;
    Image m_imgsmall;

    public void init() {
        try {
            String target = getParameter("CDFURL");
            URL base = getCodeBase();
            URL u = null != base ? new URL(base, target) : new URL(target);
            m_imgbig = getImage(new URL(base, "cdfv-close.gif"));
            m_imgsmall = getImage(new URL(base, "cdfv-open.gif"));
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(m_imgbig, 0);
            mt.addImage(m_imgsmall, 1);
            mt.waitForAll();
            init0(u.openStream(), target, getParameter("MODULEPACKAGE"));
        } catch (Exception e) {
            System.err.println("Main#init(): "+e);
            e.printStackTrace();
        }
    }

    public static class CDFVFactory extends TXDocument implements TagHandler {
        String m_modprefix;
        public CDFVFactory(String prefix) {
            super();
            m_modprefix = prefix;
        }
        public Element createElement(String qname) {
            TXElement el = null;
            qname = qname.toUpperCase();
            if (qname.equals("CHANNEL")) {
                el = new ProcCHANNEL(qname);
            } else if (qname.equals("ITEM")) {
                el = new ProcITEM(qname);
            } else
                el = new TXElement(qname);
            el.setFactory(this);
            return el;
        }

        public Attr createAttribute(String name) {
            return super.createAttribute(name.toLowerCase());
        }

        public void handleStartTag(TXElement el, boolean empty) {
        }
        public void handleEndTag(TXElement el, boolean empty) {
            if (el instanceof XMLComponentM) {
                ((XMLComponentM)el).ripen();
            }
        }
    }
    public void actionPerformed(java.awt.event.ActionEvent e) {
        String com = e.getActionCommand();
        if (com.startsWith("Open")) {
            if (null != m_xm)
                ((ProcCHANNEL)m_xm).setOpenRecursive(true);
        } else if (com.startsWith("Close")) {
            if (null != m_xm)
                ((ProcCHANNEL)m_xm).setOpenRecursive(false);
        } else {
            System.err.println("Main#actionPerformed(): ??? "+com);
        }
    }

    XMLComponentM m_xm = null;

    public void init0(InputStream is, String target, String module) {
        try {
            //java.util.Locale.setDefault(new java.util.Locale("", "", ""));

            Panel m = new Panel();
            Button mi = new Button("Open all");
            m.add(mi);
            mi.addActionListener(this);
            mi = new Button("Close all");
            m.add(mi);
            mi.addActionListener(this);
            /*
            Container co = this;
            do {
                co = co.getParent();
            } while (!(co instanceof Frame));
            ((Frame)co).setMenuBar(mb);
            */
            Parser p = new Parser(target);
            CDFVFactory fact = new CDFVFactory(module);
            p.setElementFactory(fact);
            p.setTagHandler(fact);
            Document doc = p.readStream(is);

            if (null != doc && null != doc.getDocumentElement()) {
                setBackground(new Color(0xc0, 0xc0, 0xc0));
                m_xm = (XMLComponentM)doc.getDocumentElement();
                Gateway g = new Gateway(this);
                m_xm.setGateway(g);
                ScrollPane sp = new ScrollPane();
                sp.add(m_xm.getContainer());
                if (false) {
                    setLayout(new BorderLayout());
                    add(m, "North");
                    add(g, "South");
                    add(sp, "Center");
                } else {
                    GridBagLayout gbl = new GridBagLayout();
                    setLayout(gbl);
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.fill = GridBagConstraints.BOTH;
                    gbc.weightx = 1.0;
                    gbc.gridwidth = GridBagConstraints.REMAINDER;

                    gbc.gridheight = 1;
                    gbc.weighty = 0.0;
                    gbl.setConstraints(m, gbc);
                    add(m);

                    gbc.gridheight = 1;
                    gbc.weighty = 1.0;
                    gbl.setConstraints(sp, gbc);
                    add(sp);

                    gbc.gridheight = GridBagConstraints.REMAINDER;
                    gbc.weighty = 0.0;
                    gbl.setConstraints(g, gbc);
                    add(g);
                }
            } else
                System.err.println("Main: xc is null");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAppletInfo() {
        return "Browse CDF doucment.";
    }

    static String[][] s_pinfo = {
        {"CDFURL", "url", "CDF document"},
//        {"MODULEPACKAGE", "string", "Prefix of package name"},
    };
    public String[][] getParameterInfo() {
        return s_pinfo;
    }

    public static void main(String[] argv) {
        try {
            Frame f = new Frame("");
            Main a = new Main();
            a.setStub(new AppletStub() {
                public boolean isActive() {
                    return true;
                }
                public URL getDocumentBase() {
                    URL u = null;
                    try {
                        u = new URL("file:///C:/kent/j/com/ibm/xml/cdfview/");
                    } catch (Exception e) {
                    }
                    return u;
                }
                public URL getCodeBase() {
                    return null;
                }
                public String getParameter(String name) {
                    return null;
                }
                public AppletContext getAppletContext() {
                    return null;
                }
                public void appletResize(int width, int height) {
                }
            });
            f.add("Center", a);
            a.init0(new FileInputStream(argv[0]), argv[0], "samples.CdfView.Proc");
            a.start();
            f.pack();
            f.setSize(512, 240);
            f.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
