/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

/*
 * Revision: 69 1.2 samples/CdfView/ProcCHANNEL.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 */

package samples.CdfView;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class ProcCHANNEL extends XMLComponentM {
    Label m_ltitle;
    boolean m_isopen = false;
    Rectangle m_cb;

    public ProcCHANNEL(String qname) {
        super(qname);
    }
    public void ripen() {
        super.ripen();

        m_p = new ChannelPanel();
        m_p.add(m_ltitle = new Label(m_title));
        m_cb = new Rectangle();
        m_p.setBackground(new Color(192, 192, 192));
        m_p.setFont(new Font("serif", Font.BOLD, 14));
        m_p.removeMouseListener(this);
        m_ltitle.addMouseListener(this);
        m_p.addMouseListener(this);
        Enumeration en = elements();
        while (en.hasMoreElements()) {
            Object ch = en.nextElement();
            if (ch instanceof XMLComponentM)
                m_p.add(((XMLComponentM)ch).getContainer());
        }
    }

    static final int CHILD_OFFSET = 20;
    static final int SWITCH = 16;
    public int getConnectedOffset() {
        return m_cb.getSize().height/2;
    }

    class ChannelPanel extends Panel {
        Dimension m_min;

        void calcMinimum() {
            Graphics g = getGraphics();
            if (null == g) {
                m_min = new Dimension(0, 0);
            } else {
                FontMetrics fm = g.getFontMetrics();
                int thish = fm.getHeight();
                int w = SWITCH+2+m_ltitle.getPreferredSize().width;
                m_cb.setBounds(0, 0, SWITCH, thish);
                m_ltitle.setBounds(SWITCH+2, 0, m_ltitle.getPreferredSize().width, thish);

                Enumeration en = elements();
                if (m_isopen) {
                    while (en.hasMoreElements()) {
                        Object ch = en.nextElement();
                        if (ch instanceof XMLComponentM) {
                            Container con = ((XMLComponentM)ch).getContainer();
                            Dimension d = con.getMinimumSize();
                            int h = d.height;
                            con.setBounds(CHILD_OFFSET, thish, d.width, h);
                            thish += h;
                            if (w < CHILD_OFFSET+d.width)  w = CHILD_OFFSET+d.width;
                        }
                    }
                } else {
                    while (en.hasMoreElements()) {
                        Object ch = en.nextElement();
                        if (ch instanceof XMLComponentM) {
                            ((XMLComponentM)ch).getContainer().setBounds(0, 0, 0, 0);
                        }
                    }
                }
                m_min = new Dimension(w, thish);
            }
        }


        public void doLayout() {
            //System.err.println("CHANNEL#doLayout(): "+m_min);
            calcMinimum();
            repaint();
        }

        public Dimension getMinimumSize() {
            if (null == m_min)  calcMinimum();
            return m_min;
        }
        public Dimension getPreferredSize() {
            return getMinimumSize();
        }

        public void paint(Graphics g) {
            if (m_isopen && hasChildNodes()) {
                Color origc = g.getColor();
                g.setColor(Color.black);
                int h = m_cb.getSize().height;
                Rectangle r = null;
                int c = 0;
                Enumeration en = elements();
                while (en.hasMoreElements()) {
                    Object ch = en.nextElement();
                    if (ch instanceof XMLComponentM) {
                        r = ((XMLComponentM)ch).getContainer().getBounds();
                        c = ((XMLComponentM)ch).getConnectedOffset();
                        g.drawLine(SWITCH/2, r.y+c, CHILD_OFFSET, r.y+c);
                    }
                }
                if (null != r)
                    g.drawLine(SWITCH/2, h, SWITCH/2, r.y+c);
                g.setColor(origc);
            }
            if (m_isopen) {
                Image i = m_gate.getOpenImage();
                if (null != i) {
                    g.drawImage(i, m_cb.x+(m_cb.width-i.getWidth(null))/2,
                                m_cb.y+(m_cb.height-i.getHeight(null))/2, null);
                } else {
                    g.drawLine(m_cb.x+4, m_cb.y+m_cb.height/2,
                               m_cb.x+m_cb.width-4, m_cb.y+m_cb.height/2);
                    g.drawOval(m_cb.x+3, m_cb.y+3,
                               m_cb.x+m_cb.width-3*2, m_cb.y+m_cb.height-3*2);
                }
            } else {
                Image i = m_gate.getCloseImage();
                if (null != i) {
                    g.drawImage(i, m_cb.x+(m_cb.width-i.getWidth(null))/2,
                                m_cb.y+(m_cb.height-i.getHeight(null))/2, null);
                } else {
                    g.drawLine(m_cb.x+4, m_cb.y+m_cb.height/2,
                               m_cb.x+m_cb.width-4, m_cb.y+m_cb.height/2);
                    g.drawLine(m_cb.x+m_cb.width/2, m_cb.y+4,
                               m_cb.x+m_cb.width/2, m_cb.y+m_cb.height-4);
                    g.drawOval(m_cb.x+3, m_cb.y+3,
                               m_cb.x+m_cb.width-3*2, m_cb.y+m_cb.height-3*2);
                }
            }
        }
    }

    public void select(boolean f) {
        super.select(f);
        m_ltitle.setBackground(f ? SystemColor.textHighlight : new Color(192, 192, 192));
        m_ltitle.setForeground(f ? SystemColor.textHighlightText : Color.black);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == m_ltitle) {
            if (null != m_url)
                m_gate.showDocument(this, m_url);
        } else if (e.getSource() == m_p) {
            if (m_cb.contains(e.getPoint())) {
                setOpen(!m_isopen);
            }
        }
    }

    public void setOpen(boolean f) {
        m_isopen = f;
        Container co = m_p.getParent();
        m_p.doLayout();
        do {
            co.doLayout();
        } while (null != (co = co.getParent()));
    }

    public void setOpenRecursive(boolean f) {
        m_isopen = f;

        Enumeration en = elements();
        while (en.hasMoreElements()) {
            Object ch = en.nextElement();
            if (ch instanceof ProcCHANNEL)
                ((ProcCHANNEL)ch).setOpenRecursive(f);
        }

        Container co = m_p.getParent();
        m_p.doLayout();
        do {
            co.doLayout();
        } while (null != (co = co.getParent()));
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == m_ltitle) {
            super.mouseEntered(e);
            m_ltitle.setForeground(Color.red);
            m_p.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() == m_ltitle) {
            super.mouseExited(e);
            m_ltitle.setForeground(m_selected ? SystemColor.textHighlightText : Color.black);
            m_p.repaint();
        }
    }

}
