/*
 * (C) Copyright IBM Corp. 1997-1998  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

/*
 * Revision: 70 1.1 samples/CdfView/ProcITEM.java, xml4jsamples, xml4j-jtcsv, xml4j_1_1_16 
 */

package samples.CdfView;

import com.ibm.xml.parser.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

public class ProcITEM extends XMLComponentM {
    public ProcITEM(String qname) {
        super(qname);
    }

    public void ripen() {
        super.ripen();
        m_p = new ItemPanel();
        m_p.addMouseListener(this);
        m_p.setFont(new Font("serif", Font.PLAIN, 12));
    }

    static final int MARGIN = 2;
    class ItemPanel extends Panel {
        Dimension m_min;

        public void addNotify() {
            super.addNotify();
            Graphics g = getGraphics();
            if (null == g) {
                System.err.println("Bad");
            } else {
                FontMetrics fm = g.getFontMetrics();
                m_min = new Dimension(MARGIN*2+fm.stringWidth(m_title), fm.getHeight());
            }
        }        

        public Dimension getMinimumSize() {
            return m_min;
        }
        public Dimension getPreferredSize() {
            return m_min;
        }

        public void paint(Graphics g) {
            g.drawString(m_title, MARGIN, g.getFontMetrics().getAscent());
        }
    }

    public int getConnectedOffset() {
        return m_p.getSize().height/2;
    }

    public void select(boolean f) {
        super.select(f);
        m_p.setBackground(f ? SystemColor.textHighlight : new Color(192, 192, 192));
        m_p.setForeground(f ? SystemColor.textHighlightText : Color.black);
    }

    public void mouseClicked(MouseEvent e) {
        m_gate.showDocument(this, m_url);
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        m_p.setForeground(Color.red);
        m_p.repaint();
    }
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        m_p.setForeground(m_selected ? SystemColor.textHighlightText : Color.black);
        m_p.repaint();
    }
}
